/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.ReadTransformerAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class ReadTransformerAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public ReadTransformerAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestReadTransformer() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.ReadTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ReadTransformer");
            }
        });
    }

    private ICompilationUnit createTestReadTransformerWithTransformerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.ReadTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ReadTransformer(transformerClass=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestReadTransformerWithMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.ReadTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ReadTransformer(method=\"transformerMethod\")");
            }
        });
    }

    public void testReadTransformerAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformer();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ReadTransformerAnnotationTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer"));
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer"));
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer"));
    }

    public void testGetTransformerClass() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithTransformerClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"Foo", (String)readTransformer.getTransformerClass());
    }

    public void testSetTransformerClass() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithTransformerClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"Foo", (String)readTransformer.getTransformerClass());
        readTransformer.setTransformerClass("Bar");
        ReadTransformerAnnotationTests.assertEquals((String)"Bar", (String)readTransformer.getTransformerClass());
        this.assertSourceContains("@ReadTransformer(transformerClass=Bar.class)", cu);
    }

    public void testSetTransformerClassNull() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithTransformerClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"Foo", (String)readTransformer.getTransformerClass());
        readTransformer.setTransformerClass(null);
        ReadTransformerAnnotationTests.assertNull((Object)readTransformer.getTransformerClass());
        this.assertSourceContains("@ReadTransformer", cu);
        this.assertSourceDoesNotContain("transformerClass", cu);
    }

    public void testGetMethod() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithMethod();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)readTransformer.getMethod());
    }

    public void testSetMethod() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithMethod();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)readTransformer.getMethod());
        readTransformer.setMethod("foo");
        ReadTransformerAnnotationTests.assertEquals((String)"foo", (String)readTransformer.getMethod());
        this.assertSourceContains("@ReadTransformer(method=\"foo\")", cu);
    }

    public void testSetMethodNull() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithMethod();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)readTransformer.getMethod());
        readTransformer.setMethod(null);
        ReadTransformerAnnotationTests.assertNull((Object)readTransformer.getMethod());
        this.assertSourceContains("@ReadTransformer", cu);
        this.assertSourceDoesNotContain("method", cu);
    }
}

