/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Classpath;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class ClasspathTests
extends TestCase {
    private static final String JAVA_HOME = System.getProperty("java.home");

    public ClasspathTests(String name) {
        super(name);
    }

    public void testCompressed() {
        String path = "";
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;;;;C:\\jdk\\jaws.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;;;")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\..\\jdk\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
        path = new Classpath(this.morph("C:\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk1\\jdk2\\jdk3\\..\\..\\..\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\jaws.jar")).compressed().path();
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk1\\jdk2\\jdk3\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar"), (String)path);
    }

    public void testConvertToClassName() {
        String fileName = "java/lang/String.class";
        File file = new File(fileName);
        String className = Classpath.convertToClassName((File)file);
        ClasspathTests.assertEquals((String)String.class.getName(), (String)className);
    }

    public void testConvertToClass() throws ClassNotFoundException {
        String fileName = "java/lang/String.class";
        File file = new File(fileName);
        Class javaClass = Classpath.convertToClass((File)file);
        ClasspathTests.assertEquals(String.class, (Object)javaClass);
    }

    public void testConvertToArchiveClassFileEntryName() {
        String fileName = Classpath.convertToArchiveClassFileEntryName(String.class);
        ClasspathTests.assertEquals((String)"java/lang/String.class", (String)fileName);
    }

    public void testConvertToClassFileName() {
        char sc = File.separatorChar;
        String fileName = Classpath.convertToClassFileName(String.class);
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.class"), (String)fileName);
    }

    public void testConvertToJavaFileName() {
        char sc = File.separatorChar;
        String fileName = Classpath.convertToJavaFileName((String)String.class.getName());
        ClasspathTests.assertEquals((String)("java" + sc + "lang" + sc + "String.java"), (String)fileName);
    }

    public void testConvertToURLs() {
        URL[] entries = new Classpath(this.morph("C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).urls();
        int i = 0;
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/rt.jar"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/i18n.jar"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/jdk/jaws.jar"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/foo/classes"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((String)this.morphURL("/C:/bar/bar.jar"), (String)entries[i++].getPath());
        ClasspathTests.assertEquals((int)i, (int)entries.length);
    }

    public void testEntries() {
        Classpath cp = new Classpath(this.morph("C:\\jdk\\rt.jar;;.;C:\\jdk\\i18n.jar;;;C:\\jdk\\jaws.jar;;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\bar\\bar.jar;"));
        Classpath.Entry[] entries = cp.entries();
        int i = 0;
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("."), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\jaws.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\foo\\classes"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((int)i, (int)entries.length);
        cp = cp.compressed();
        entries = cp.entries();
        i = 0;
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("."), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\i18n.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\jaws.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\foo\\classes"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((String)this.morph("C:\\bar\\bar.jar"), (String)entries[i++].fileName());
        ClasspathTests.assertEquals((int)i, (int)entries.length);
    }

    public void testEntryForFileNamed() {
        Classpath.Entry entry = null;
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\rt.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;rt.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;rt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.fileName());
        entry = new Classpath(this.morph("C:\\jdk\\rt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath("rt.jar").entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"rt.jar", (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\rt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rtrtrt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)this.morph("C:\\jdk\\rt.jar"), (String)entry.fileName());
        entry = new Classpath(this.morph("rt.jar.new;C:\\jdk\\rtrtrt.jar;C:\\jdk\\i18n.jar;C:\\jdk\\jaws.jar;C:\\foo\\classes;C:\\bar\\bar.jar;C:\\jdk\\rtrtrt.jar")).entryForFileNamed("rt.jar");
        ClasspathTests.assertEquals((String)"path entry should not be found", null, (Object)entry);
    }

    public void testLocationForClass() {
        Class<Classpath> javaClass = Classpath.class;
        File entry = new File(Classpath.locationFor(javaClass));
        if (entry.isFile() || entry.isDirectory()) {
            ClasspathTests.assertTrue((boolean)entry.exists());
        }
        if (entry.isDirectory()) {
            ClasspathTests.assertTrue((boolean)new File(entry, Classpath.convertToClassFileName(javaClass)).exists());
        }
    }

    public void testRtJarName() throws IOException {
        File rtFile = new File(Classpath.rtJarName());
        ClasspathTests.assertTrue((String)"rt.jar does not exist", (boolean)rtFile.exists());
        JarFile rtJarFile = new JarFile(rtFile);
        JarEntry entry = rtJarFile.getJarEntry("java/lang/Object.class");
        rtJarFile.close();
        ClasspathTests.assertTrue((String)"bogus rt.jar", (entry != null ? 1 : 0) != 0);
    }

    public void testJREClassNames() {
        ClasspathTests.assertTrue((String)"Vector is missing from JRE class names", (boolean)CollectionTools.contains((Object[])Classpath.bootClasspath().classNames(), (Object)Vector.class.getName()));
        ClasspathTests.assertTrue((String)"File is missing from JRE class names", (boolean)CollectionTools.contains((Object[])Classpath.bootClasspath().classNames(), (Object)File.class.getName()));
    }

    public void testJavaExtensionDirectoryNames() {
        char sep = File.separatorChar;
        String stdExtDirName = String.valueOf(JAVA_HOME) + sep + "lib" + sep + "ext";
        ClasspathTests.assertTrue((String)("standard extension dir name missing: " + stdExtDirName), (boolean)CollectionTools.contains((Object[])Classpath.javaExtensionDirectoryNames(), (Object)stdExtDirName));
    }

    public void testJavaExtensionDirectories() {
        char sep = File.separatorChar;
        File stdExtDir = new File(String.valueOf(JAVA_HOME) + sep + "lib" + sep + "ext");
        ClasspathTests.assertTrue((String)("standard extension dir missing: " + stdExtDir.getParent()), (boolean)CollectionTools.contains((Object[])Classpath.javaExtensionDirectories(), (Object)stdExtDir));
    }

    public void testJavaClasspathClassNames() {
        String className = ((Object)((Object)this)).getClass().getName();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl.getClass().getName().startsWith("sun.misc")) {
            ClasspathTests.assertTrue((String)("class missing: " + className), (boolean)CollectionTools.contains((Object[])Classpath.javaClasspath().classNames(), (Object)className));
        }
    }

    private String morph(String path) {
        String result = path;
        result = result.replace('\\', File.separatorChar);
        result = result.replace(';', File.pathSeparatorChar);
        if (!CollectionTools.contains((Object[])File.listRoots(), (Object)new File("C:\\"))) {
            result = result.replaceAll("C:", "");
        }
        return result;
    }

    private String morphURL(String url) {
        String result = url;
        if (!CollectionTools.contains((Object[])File.listRoots(), (Object)new File("C:\\"))) {
            result = result.replaceAll("/C:", "");
        }
        return result;
    }
}

