/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterables;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterableTests
extends TestCase {
    public ArrayIterableTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ArrayIterableTests.assertEquals((int)this.buildArray().length, (int)i);
    }

    public void testNext() {
        int i = 0;
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            ArrayIterableTests.assertEquals((String)"bogus element", (int)(++i), (int)Integer.parseInt(stream.next()));
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ArrayIterableTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("3")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ArrayIterableTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testIllegalArgumentException() {
        this.triggerIllegalArgumentException(-1, 1);
        this.triggerIllegalArgumentException(8, 1);
        this.triggerIllegalArgumentException(0, -1);
        this.triggerIllegalArgumentException(0, 9);
    }

    public void testGenerics() {
        Object[] integers = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
        int i = 0;
        ArrayIterator stream = new ArrayIterator(integers);
        while (stream.hasNext()) {
            ArrayIterableTests.assertEquals((int)i++, (int)((Number)stream.next()).intValue());
        }
        ArrayIterableTests.assertEquals((int)integers.length, (int)i);
    }

    public void testVarargs() {
        int i = 0;
        ArrayIterator stream = new ArrayIterator((Object[])new Number[]{new Integer(0), new Integer(1), new Integer(2)});
        while (stream.hasNext()) {
            ArrayIterableTests.assertEquals((int)i++, (int)((Number)stream.next()).intValue());
        }
        ArrayIterableTests.assertEquals((int)3, (int)i);
    }

    public void triggerIllegalArgumentException(int start, int length) {
        boolean exCaught = false;
        Iterator<String> stream = null;
        try {
            stream = this.buildIterator(start, length);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayIterableTests.assertTrue((String)("IllegalArgumentException not thrown: " + stream), (boolean)exCaught);
    }

    Iterator<String> buildIterator() {
        return this.buildIterable(this.buildArray()).iterator();
    }

    Iterable<String> buildIterable(String[] array) {
        return new ArrayIterable((Object[])array);
    }

    Iterator<String> buildIterator(int start, int length) {
        return this.buildIterable(this.buildArray(), start, length).iterator();
    }

    Iterable<String> buildIterable(String[] array, int start, int length) {
        return new ArrayIterable((Object[])array, start, length);
    }

    String[] buildArray() {
        return new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    }
}

