/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.data;

import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.performance.Dimension;

public class Sample {
    String fScenarioID;
    long fStartTime;
    Map fProperties;
    DataPoint[] fDataPoints;
    boolean fIsSummary;
    boolean fSummaryIsGlobal;
    String fShortName;
    Dimension[] fSummaryDimensions;
    int fCommentType;
    String fComment;

    public Sample(String scenarioID, long starttime, Map properties, DataPoint[] dataPoints) {
        Assert.assertTrue((String)"scenarioID is null", (scenarioID != null ? 1 : 0) != 0);
        this.fScenarioID = scenarioID;
        this.fStartTime = starttime;
        this.fProperties = properties;
        this.fDataPoints = dataPoints;
    }

    public Sample(DataPoint[] dataPoints) {
        this.fDataPoints = dataPoints;
    }

    public void setComment(int commentType, String comment) {
        this.fCommentType = commentType;
        this.fComment = comment;
    }

    public void tagAsSummary(boolean global, String shortName, Dimension[] summaryDimensions, int commentType, String comment) {
        this.fIsSummary = true;
        this.fSummaryIsGlobal = global;
        this.fShortName = shortName;
        this.fSummaryDimensions = summaryDimensions;
        this.fCommentType = commentType;
        this.fComment = comment;
    }

    public String getScenarioID() {
        return this.fScenarioID;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public String getProperty(String name) {
        return (String)this.fProperties.get(name);
    }

    public String[] getPropertyKeys() {
        if (this.fProperties == null) {
            return new String[0];
        }
        Set set = this.fProperties.keySet();
        return set.toArray(new String[set.size()]);
    }

    public DataPoint[] getDataPoints() {
        DataPoint[] dataPoints = new DataPoint[this.fDataPoints.length];
        System.arraycopy(this.fDataPoints, 0, dataPoints, 0, this.fDataPoints.length);
        return dataPoints;
    }

    public String toString() {
        return "MeteringSession [scenarioID= " + this.fScenarioID + ", #datapoints: " + this.fDataPoints.length + "]";
    }

    public boolean isSummary() {
        return this.fIsSummary;
    }

    public boolean isGlobal() {
        return this.fSummaryIsGlobal;
    }

    public String getShortname() {
        return this.fShortName;
    }

    public Dimension[] getSummaryDimensions() {
        return this.fSummaryDimensions;
    }

    public int getCommentType() {
        return this.fCommentType;
    }

    public String getComment() {
        return this.fComment;
    }
}

