/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.projection.ProjectionDocument;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.wst.sse.core.internal.cleanup.StructuredContentCleanupHandler;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IDocumentSelectionMediator;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.undo.UndoDocumentEvent;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.CompatibleHighlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.ReconcilerHighlighter;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredRegionProcessor;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public class StructuredTextViewer
extends ProjectionViewer
implements IDocumentSelectionMediator {
    private static final int BASE = 21;
    private static final int CLEANUP_DOCUMENT = 25;
    public static final int FORMAT_ACTIVE_ELEMENTS = 24;
    private static final String FORMAT_ACTIVE_ELEMENTS_TEXT = SSEUIMessages.Format_Active_Elements_UI_;
    public static final int FORMAT_DOCUMENT = 23;
    private static final String FORMAT_DOCUMENT_TEXT = SSEUIMessages.Format_Document_UI_;
    private static final String TEXT_CUT = SSEUIMessages.Text_Cut_UI_;
    private static final String TEXT_PASTE = SSEUIMessages.Text_Paste_UI_;
    private static final String TEXT_SHIFT_LEFT = SSEUIMessages.Text_Shift_Left_UI_;
    private static final String TEXT_SHIFT_RIGHT = SSEUIMessages.Text_Shift_Right_UI_;
    private static final boolean TRACE_EXCEPTIONS = true;
    private final int MAX_SMALL_FORMAT_LENGTH = 1000;
    private boolean fBackgroundupdateInProgress;
    private StructuredContentCleanupHandler fContentCleanupHandler = null;
    private Highlighter fHighlighter;
    private ReconcilerHighlighter fRecHighlighter = null;
    private SourceViewerConfiguration fConfiguration;
    private boolean fFormatterSet = false;
    static /* synthetic */ Class class$0;

    public StructuredTextViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    private void beep() {
        this.getTextWidget().getDisplay().beep();
    }

    public void beginBackgroundUpdate() {
        this.fBackgroundupdateInProgress = true;
        this.setRedraw(false);
    }

    public boolean canDoOperation(int operation) {
        if (this.fBackgroundupdateInProgress) {
            return false;
        }
        switch (operation) {
            case 13: {
                IDocument doc = this.getDocument();
                if (doc == null || !(doc instanceof IStructuredDocument)) break;
                return this.isEditable() && !((IStructuredDocument)doc).containsReadOnly(this.getSelectedRange().x, 0);
            }
            case 25: {
                return this.fContentCleanupHandler != null && this.isEditable();
            }
            case 23: 
            case 24: {
                return (this.fContentFormatter != null || !this.fFormatterSet) && this.isEditable();
            }
        }
        return super.canDoOperation(operation);
    }

    public void configure(SourceViewerConfiguration configuration) {
        IQuickAssistAssistant quickAssistant;
        IContentAssistant newAssistant;
        IReconciler newReconciler;
        if (this.getTextWidget() == null) {
            return;
        }
        this.setDocumentPartitioning(configuration.getConfiguredDocumentPartitioning((ISourceViewer)this));
        if (this.fHighlighter != null) {
            this.fHighlighter.uninstall();
            this.fHighlighter = null;
        }
        if (this.fRecHighlighter != null) {
            this.fRecHighlighter.uninstall();
            this.fRecHighlighter = null;
        }
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.uninstall();
            this.fPresentationReconciler = null;
        }
        if ((newReconciler = configuration.getReconciler((ISourceViewer)this)) != this.fReconciler || newReconciler == null || this.fReconciler == null) {
            if (this.fReconciler != null) {
                this.fReconciler.uninstall();
            }
            this.fReconciler = newReconciler;
            if (this.fReconciler != null) {
                this.fReconciler.install((ITextViewer)this);
                if (this.fReconciler instanceof StructuredRegionProcessor) {
                    ((StructuredRegionProcessor)this.fReconciler).setDocument(this.getDocument());
                }
            }
        }
        if ((newAssistant = configuration.getContentAssistant((ISourceViewer)this)) != this.fContentAssistant || newAssistant == null || this.fContentAssistant == null) {
            if (this.fContentAssistant != null) {
                this.fContentAssistant.uninstall();
            }
            this.fContentAssistant = newAssistant;
            if (this.fContentAssistant != null) {
                this.fContentAssistant.install((ITextViewer)this);
                this.fContentAssistantInstalled = true;
            } else {
                this.enableOperation(13, false);
            }
        }
        if ((quickAssistant = configuration.getQuickAssistAssistant((ISourceViewer)this)) != this.fQuickAssistAssistant || quickAssistant == null || this.fQuickAssistAssistant == null) {
            if (this.fQuickAssistAssistant != null) {
                this.fQuickAssistAssistant.uninstall();
            }
            this.fQuickAssistAssistant = quickAssistant;
            if (this.fQuickAssistAssistant != null) {
                this.fQuickAssistAssistant.install((ISourceViewer)this);
                this.fQuickAssistAssistantInstalled = true;
            } else {
                this.enableOperation(22, false);
            }
        }
        this.fContentFormatter = configuration.getContentFormatter((ISourceViewer)this);
        IInformationPresenter newInformationPresenter = configuration.getInformationPresenter((ISourceViewer)this);
        if (newInformationPresenter == null || this.fInformationPresenter == null || !newInformationPresenter.equals(this.fInformationPresenter)) {
            if (this.fInformationPresenter != null) {
                this.fInformationPresenter.uninstall();
            }
            this.fInformationPresenter = newInformationPresenter;
            if (this.fInformationPresenter != null) {
                this.fInformationPresenter.install((ITextViewer)this);
            }
        }
        if (this.fUndoManager != null) {
            this.fUndoManager.disconnect();
        }
        this.setUndoManager(configuration.getUndoManager((ISourceViewer)this));
        if (this.fAnnotationHover instanceof StructuredTextAnnotationHover) {
            ((StructuredTextAnnotationHover)this.fAnnotationHover).release();
        }
        this.setAnnotationHover(configuration.getAnnotationHover((ISourceViewer)this));
        if (this.fOverviewRulerAnnotationHover instanceof StructuredTextAnnotationHover) {
            ((StructuredTextAnnotationHover)this.fOverviewRulerAnnotationHover).release();
        }
        this.setOverviewRulerAnnotationHover(configuration.getOverviewRulerAnnotationHover((ISourceViewer)this));
        this.getTextWidget().setTabs(configuration.getTabWidth((ISourceViewer)this));
        this.setHoverControlCreator(configuration.getInformationControlCreator((ISourceViewer)this));
        if (this.fHyperlinkManager != null) {
            this.setHyperlinkDetectors(null, 0);
        }
        this.setHyperlinkPresenter(configuration.getHyperlinkPresenter((ISourceViewer)this));
        IHyperlinkDetector[] hyperlinkDetectors = configuration.getHyperlinkDetectors((ISourceViewer)this);
        int eventStateMask = configuration.getHyperlinkStateMask((ISourceViewer)this);
        this.setHyperlinkDetectors(hyperlinkDetectors, eventStateMask);
        String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
        this.fAutoIndentStrategies = null;
        int i = 0;
        while (i < types.length) {
            LineStyleProvider[] providers;
            String t = types[i];
            this.setAutoEditStrategies(configuration.getAutoEditStrategies((ISourceViewer)this, t), t);
            this.setTextDoubleClickStrategy(configuration.getDoubleClickStrategy((ISourceViewer)this, t), t);
            int[] stateMasks = configuration.getConfiguredTextHoverStateMasks((ISourceViewer)this, t);
            if (stateMasks != null) {
                int j = 0;
                while (j < stateMasks.length) {
                    int stateMask = stateMasks[j];
                    this.setTextHover(configuration.getTextHover((ISourceViewer)this, t, stateMask), t, stateMask);
                    ++j;
                }
            } else {
                this.setTextHover(configuration.getTextHover((ISourceViewer)this, t), t, 255);
            }
            String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, t);
            if (prefixes != null && prefixes.length > 0) {
                this.setIndentPrefixes(prefixes, t);
            }
            if ((prefixes = configuration.getDefaultPrefixes((ISourceViewer)this, t)) != null && prefixes.length > 0) {
                this.setDefaultPrefixes(prefixes, t);
            }
            if (this.getDocument() != null && (providers = ((StructuredTextViewerConfiguration)configuration).getLineStyleProviders((ISourceViewer)this, t)) != null) {
                int j = 0;
                while (j < providers.length) {
                    if (this.fRecHighlighter == null) {
                        this.fRecHighlighter = new ReconcilerHighlighter();
                        ((StructuredTextViewerConfiguration)configuration).setHighlighter(this.fRecHighlighter);
                    }
                    if (providers[j] instanceof AbstractLineStyleProvider) {
                        ((AbstractLineStyleProvider)((Object)providers[j])).init((IStructuredDocument)this.getDocument(), this.fRecHighlighter);
                        this.fRecHighlighter.addProvider(t, providers[j]);
                    } else {
                        if (this.fHighlighter == null) {
                            this.fHighlighter = new CompatibleHighlighter();
                        }
                        Logger.log(201, "CompatibleHighlighter installing compatibility for " + providers[j].getClass());
                        providers[j].init((IStructuredDocument)this.getDocument(), this.fHighlighter);
                        this.fHighlighter.addProvider(t, providers[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.fHighlighter != null) {
            this.fHighlighter.setDocumentPartitioning(configuration.getConfiguredDocumentPartitioning((ISourceViewer)this));
            this.fHighlighter.setDocument((IStructuredDocument)this.getDocument());
            this.fHighlighter.install((ITextViewer)this);
        }
        if (this.fRecHighlighter != null) {
            this.fRecHighlighter.install((ITextViewer)this);
        }
        this.activatePlugins();
        this.fConfiguration = configuration;
        this.fPresentationReconciler = configuration.getPresentationReconciler((ISourceViewer)this);
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install((ITextViewer)this);
        }
    }

    private boolean containsReadOnly(IDocument document, int startOffset, int endOffset) {
        IDocument doc;
        int start = startOffset;
        int end = endOffset;
        IStructuredDocument structuredDocument = null;
        if (document instanceof IStructuredDocument) {
            structuredDocument = (IStructuredDocument)document;
        } else if (document instanceof ProjectionDocument && (doc = ((ProjectionDocument)document).getMasterDocument()) instanceof IStructuredDocument) {
            structuredDocument = (IStructuredDocument)doc;
            int adjust = ((ProjectionDocument)document).getProjectionMapping().getCoverage().getOffset();
            start = adjust + start;
            end = adjust + end;
        }
        if (structuredDocument == null) {
            return false;
        }
        int length = end - start;
        return structuredDocument.containsReadOnly(start, length);
    }

    protected IDocumentAdapter createDocumentAdapter() {
        return super.createDocumentAdapter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void doOperation(int operation) {
        Point selection = this.getTextWidget().getSelection();
        int cursorPosition = selection.x;
        int selectionLength = selection.y - selection.x;
        switch (operation) {
            case 3: {
                this.beginRecording(TEXT_CUT, TEXT_CUT, cursorPosition, selectionLength);
                super.doOperation(operation);
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 5: {
                this.beginRecording(TEXT_PASTE, TEXT_PASTE, cursorPosition, selectionLength);
                super.doOperation(operation);
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 13: {
                if (this.fContentAssistant == null) return;
                if (!this.isEditable()) return;
                if (!this.canDoOperation(13)) {
                    this.beep();
                    return;
                }
                String err = this.fContentAssistant.showPossibleCompletions();
                if (err != null) {
                    PlatformStatusLineUtil.displayErrorMessage(err);
                }
                PlatformStatusLineUtil.addOneTimeClearListener();
                return;
            }
            case 14: {
                if (this.fContentAssistant == null) return;
                String err = this.fContentAssistant.showContextInformation();
                if (err != null) {
                    PlatformStatusLineUtil.displayErrorMessage(err);
                }
                PlatformStatusLineUtil.addOneTimeClearListener();
                return;
            }
            case 8: {
                this.beginRecording(TEXT_SHIFT_RIGHT, TEXT_SHIFT_RIGHT, cursorPosition, selectionLength);
                this.updateIndentationPrefixes();
                super.doOperation(8);
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 9: {
                this.beginRecording(TEXT_SHIFT_LEFT, TEXT_SHIFT_LEFT, cursorPosition, selectionLength);
                this.updateIndentationPrefixes();
                super.doOperation(9);
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 23: {
                DocumentRewriteSession rewriteSession = null;
                IDocument document = this.getDocument();
                try {
                    IDocumentExtension4 extension;
                    this.beginRecording(FORMAT_DOCUMENT_TEXT, FORMAT_DOCUMENT_TEXT, cursorPosition, selectionLength);
                    boolean formatDocument = false;
                    IRegion region = null;
                    Point s = this.getSelectedRange();
                    if (s.y > 0) {
                        region = new Region(s.x, s.y);
                    } else {
                        region = this.getModelCoverage();
                        formatDocument = true;
                    }
                    if (document instanceof IDocumentExtension4) {
                        extension = (IDocumentExtension4)document;
                        DocumentRewriteSessionType type = selection.y == 0 || selection.y > 1000 ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
                        rewriteSession = extension.getActiveRewriteSession() != null ? null : extension.startRewriteSession(type);
                    } else {
                        this.setRedraw(false);
                    }
                    if (this.fContentFormatter instanceof IContentFormatterExtension) {
                        extension = (IContentFormatterExtension)this.fContentFormatter;
                        FormattingContext context = new FormattingContext();
                        context.setProperty((Object)"formatting.context.document", (Object)formatDocument);
                        context.setProperty((Object)"formatting.context.region", (Object)region);
                        extension.format(document, (IFormattingContext)context);
                    } else {
                        this.fContentFormatter.format(document, region);
                    }
                    Object var12_26 = null;
                }
                catch (Throwable throwable) {
                    Object var12_25 = null;
                    try {
                        if (rewriteSession != null) {
                            IDocumentExtension4 extension = (IDocumentExtension4)document;
                            extension.stopRewriteSession(rewriteSession);
                        } else {
                            this.setRedraw(true);
                        }
                        Object var15_37 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var15_36 = null;
                        selection = this.getTextWidget().getSelection();
                        cursorPosition = selection.x;
                        selectionLength = selection.y - selection.x;
                        this.endRecording(cursorPosition, selectionLength);
                        throw throwable2;
                    }
                    selection = this.getTextWidget().getSelection();
                    cursorPosition = selection.x;
                    selectionLength = selection.y - selection.x;
                    this.endRecording(cursorPosition, selectionLength);
                    throw throwable;
                }
                try {}
                catch (Throwable throwable) {
                    Object var15_38 = null;
                    selection = this.getTextWidget().getSelection();
                    cursorPosition = selection.x;
                    selectionLength = selection.y - selection.x;
                    this.endRecording(cursorPosition, selectionLength);
                    throw throwable;
                }
                if (rewriteSession != null) {
                    IDocumentExtension4 extension = (IDocumentExtension4)document;
                    extension.stopRewriteSession(rewriteSession);
                } else {
                    this.setRedraw(true);
                }
                Object var15_39 = null;
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 24: {
                DocumentRewriteSession rewriteSession = null;
                IDocument document = this.getDocument();
                try {
                    IDocumentExtension4 extension;
                    this.beginRecording(FORMAT_ACTIVE_ELEMENTS_TEXT, FORMAT_ACTIVE_ELEMENTS_TEXT, cursorPosition, selectionLength);
                    Region region = null;
                    Point s = this.getSelectedRange();
                    if (s.y > -1) {
                        region = new Region(s.x, s.y);
                    }
                    if (document instanceof IDocumentExtension4) {
                        extension = (IDocumentExtension4)document;
                        DocumentRewriteSessionType type = selection.y == 0 || selection.y > 1000 ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
                        rewriteSession = extension.getActiveRewriteSession() != null ? null : extension.startRewriteSession(type);
                    } else {
                        this.setRedraw(false);
                    }
                    if (this.fContentFormatter instanceof IContentFormatterExtension) {
                        extension = (IContentFormatterExtension)this.fContentFormatter;
                        FormattingContext context = new FormattingContext();
                        context.setProperty((Object)"formatting.context.document", (Object)Boolean.FALSE);
                        context.setProperty((Object)"formatting.context.region", (Object)region);
                        extension.format(this.getDocument(), (IFormattingContext)context);
                    } else {
                        this.fContentFormatter.format(this.getDocument(), (IRegion)region);
                    }
                    Object var11_21 = null;
                }
                catch (Throwable throwable) {
                    Object var11_20 = null;
                    try {
                        if (rewriteSession != null) {
                            IDocumentExtension4 extension = (IDocumentExtension4)document;
                            extension.stopRewriteSession(rewriteSession);
                        } else {
                            this.setRedraw(true);
                        }
                        Object var14_31 = null;
                    }
                    catch (Throwable throwable3) {
                        Object var14_30 = null;
                        selection = this.getTextWidget().getSelection();
                        cursorPosition = selection.x;
                        selectionLength = selection.y - selection.x;
                        this.endRecording(cursorPosition, selectionLength);
                        throw throwable3;
                    }
                    selection = this.getTextWidget().getSelection();
                    cursorPosition = selection.x;
                    selectionLength = selection.y - selection.x;
                    this.endRecording(cursorPosition, selectionLength);
                    throw throwable;
                }
                try {}
                catch (Throwable throwable) {
                    Object var14_32 = null;
                    selection = this.getTextWidget().getSelection();
                    cursorPosition = selection.x;
                    selectionLength = selection.y - selection.x;
                    this.endRecording(cursorPosition, selectionLength);
                    throw throwable;
                }
                if (rewriteSession != null) {
                    IDocumentExtension4 extension = (IDocumentExtension4)document;
                    extension.stopRewriteSession(rewriteSession);
                } else {
                    this.setRedraw(true);
                }
                Object var14_33 = null;
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
        }
        super.doOperation(operation);
    }

    private void endRecording(int cursorPosition, int selectionLength) {
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            IStructuredTextUndoManager undoManager = structuredDocument.getUndoManager();
            Region widgetSelection = new Region(cursorPosition, selectionLength);
            IRegion documentSelection = this.widgetRange2ModelRange((IRegion)widgetSelection);
            if (documentSelection == null) {
                documentSelection = widgetSelection;
            }
            undoManager.endRecording((Object)this, documentSelection.getOffset(), documentSelection.getLength());
        }
    }

    private void beginRecording(String label, String description, int cursorPosition, int selectionLength) {
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            IStructuredTextUndoManager undoManager = structuredDocument.getUndoManager();
            Region widgetSelection = new Region(cursorPosition, selectionLength);
            IRegion documentSelection = this.widgetRange2ModelRange((IRegion)widgetSelection);
            if (documentSelection == null) {
                documentSelection = widgetSelection;
            }
            undoManager.beginRecording((Object)this, label, description, documentSelection.getOffset(), documentSelection.getLength());
        }
    }

    public void endBackgroundUpdate() {
        this.fBackgroundupdateInProgress = false;
        this.setRedraw(true);
    }

    protected void handleDispose() {
        Logger.trace("Source Editor", "StructuredTextViewer::handleDispose entry");
        this.setSelection((ISelection)TextSelection.emptySelection());
        if (this.fHighlighter != null) {
            this.fHighlighter.uninstall();
            this.fHighlighter = null;
        }
        if (this.fRecHighlighter != null) {
            this.fRecHighlighter.uninstall();
            this.fRecHighlighter = null;
        }
        super.handleDispose();
        Logger.trace("Source Editor", "StructuredTextViewer::handleDispose exit");
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        IRegion modelRange = this.event2ModelRange(e);
        if (this.exposeModelRange(modelRange)) {
            e.doit = false;
            return;
        }
        if (this.fEventConsumer != null) {
            this.fEventConsumer.processEvent(e);
            if (!e.doit) {
                return;
            }
        }
        if (this.fBackgroundupdateInProgress) {
            e.doit = false;
            this.beep();
            return;
        }
        if (this.containsReadOnly(this.getVisibleDocument(), e.start, e.end)) {
            e.doit = false;
            this.beep();
            return;
        }
        try {
            super.handleVerifyEvent(e);
        }
        catch (Exception x) {
            Logger.logException("StructuredTextViewer.exception.verifyText", x);
        }
    }

    public int modelLine2WidgetLine(int modelLine) {
        IDocument document;
        if (this.fInformationMapping == null && (document = this.getDocument()) != null) {
            try {
                IRegion modelLineRegion = this.getDocument().getLineInformation(modelLine);
                IRegion region = this.getModelCoverage();
                if (modelLineRegion != null && region != null) {
                    int modelEnd = modelLineRegion.getOffset() + modelLineRegion.getLength();
                    int regionEnd = region.getOffset() + region.getLength();
                    if (modelLineRegion.getOffset() < region.getOffset() || modelEnd > regionEnd) {
                        return -1;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return super.modelLine2WidgetLine(modelLine);
    }

    public int modelOffset2WidgetOffset(int modelOffset) {
        IRegion region;
        if (this.fInformationMapping == null && (region = this.getModelCoverage()) != null && (modelOffset < region.getOffset() || modelOffset > region.getOffset() + region.getLength())) {
            return -1;
        }
        return super.modelOffset2WidgetOffset(modelOffset);
    }

    public IRegion modelRange2WidgetRange(IRegion modelRange) {
        IRegion region;
        if (this.fInformationMapping == null && (region = this.getModelCoverage()) != null && modelRange != null) {
            int modelEnd = modelRange.getOffset() + modelRange.getLength();
            int regionEnd = region.getOffset() + region.getLength();
            if (modelRange.getOffset() < region.getOffset() || modelEnd > regionEnd) {
                return null;
            }
        }
        return super.modelRange2WidgetRange(modelRange);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        if (document == null && this.fReconciler != null) {
            this.fReconciler.uninstall();
        }
        super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
        if (document instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)document;
            this.updateHighlighter(structuredDocument);
            if (!this.fFormatterSet && this.fConfiguration != null) {
                this.fContentFormatter = this.fConfiguration.getContentFormatter((ISourceViewer)this);
                this.fFormatterSet = true;
            }
            if (this.fUndoManager != null) {
                this.fUndoManager.disconnect();
                this.fUndoManager.connect((ITextViewer)this);
            }
        }
    }

    private void setErrorMessage(String msg) {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null) {
            IEditorStatusLine statusLine;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((statusLine = (IEditorStatusLine)editor.getAdapter((Class)clazz)) != null) {
                statusLine.setMessage(true, msg, null);
            }
        }
    }

    public void unconfigure() {
        Logger.trace("Source Editor", "StructuredTextViewer::unconfigure entry");
        if (this.fHighlighter != null) {
            this.fHighlighter.uninstall();
            this.fHighlighter = null;
        }
        if (this.fRecHighlighter != null) {
            this.fRecHighlighter.uninstall();
            this.fRecHighlighter = null;
        }
        if (this.fAnnotationHover instanceof StructuredTextAnnotationHover) {
            ((StructuredTextAnnotationHover)this.fAnnotationHover).release();
        }
        if (this.fOverviewRulerAnnotationHover instanceof StructuredTextAnnotationHover) {
            ((StructuredTextAnnotationHover)this.fOverviewRulerAnnotationHover).release();
        }
        this.setErrorMessage(null);
        super.unconfigure();
        this.fConfiguration = null;
        Logger.trace("Source Editor", "StructuredTextViewer::unconfigure exit");
    }

    public void undoOperationSelectionChanged(UndoDocumentEvent event) {
        if (event.getRequester() != null && event.getRequester().equals((Object)this) && event.getDocument().equals(this.getDocument())) {
            TextSelection selection = new TextSelection(event.getOffset(), event.getLength());
            this.setSelection((ISelection)selection, true);
        }
    }

    private void updateHighlighter(IStructuredDocument document) {
        boolean documentSet = false;
        if (this.fRecHighlighter == null && this.fConfiguration instanceof StructuredTextViewerConfiguration) {
            String[] types = this.fConfiguration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String t = types[i];
                LineStyleProvider[] providers = ((StructuredTextViewerConfiguration)this.fConfiguration).getLineStyleProviders((ISourceViewer)this, t);
                if (providers != null) {
                    int j = 0;
                    while (j < providers.length) {
                        if (this.fRecHighlighter == null) {
                            this.fRecHighlighter = new ReconcilerHighlighter();
                            ((StructuredTextViewerConfiguration)this.fConfiguration).setHighlighter(this.fRecHighlighter);
                        }
                        if (providers[j] instanceof AbstractLineStyleProvider) {
                            ((AbstractLineStyleProvider)((Object)providers[j])).init(document, this.fRecHighlighter);
                            this.fRecHighlighter.addProvider(t, providers[j]);
                        } else {
                            if (this.fHighlighter == null) {
                                this.fHighlighter = new CompatibleHighlighter();
                            }
                            Logger.log(201, "CompatibleHighlighter installing compatibility for " + providers[j].getClass());
                            providers[j].init(document, this.fHighlighter);
                            this.fHighlighter.addProvider(t, providers[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (this.fRecHighlighter != null) {
                this.fRecHighlighter.install((ITextViewer)this);
            }
            if (this.fHighlighter != null) {
                this.fHighlighter.setDocumentPartitioning(this.fConfiguration.getConfiguredDocumentPartitioning((ISourceViewer)this));
                this.fHighlighter.setDocument(document);
                this.fHighlighter.install((ITextViewer)this);
                documentSet = true;
            }
        }
        if (this.fHighlighter != null && !documentSet) {
            this.fHighlighter.setDocument(document);
        }
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.uninstall();
        }
        if (this.fConfiguration != null) {
            this.fPresentationReconciler = this.fConfiguration.getPresentationReconciler((ISourceViewer)this);
        }
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install((ITextViewer)this);
        }
    }

    private void updateIndentationPrefixes() {
        SourceViewerConfiguration configuration = this.fConfiguration;
        if (this.fConfiguration != null) {
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes != null && prefixes.length > 0) {
                    this.setIndentPrefixes(prefixes, types[i]);
                }
                ++i;
            }
        }
    }

    public void prependTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        this.fTextPresentationListeners.remove(listener);
        this.fTextPresentationListeners.add(0, listener);
    }
}

