/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.projection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.TopLevelNode;
import org.eclipse.wst.dtd.core.internal.event.IDTDFileListener;
import org.eclipse.wst.dtd.core.internal.event.NodesEvent;
import org.eclipse.wst.dtd.ui.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderDTD
implements IStructuredTextFoldingProvider,
IProjectionListener,
IDTDFileListener,
ITextInputListener {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.dtd.ui/projectionperf"));
    IDocument fDocument;
    ProjectionViewer fViewer;
    private boolean fProjectionNeedsToBeEnabled = false;
    private IDocumentListener fDocumentListener;
    boolean fIsDocumentChanging = false;
    List fQueuedNodeChanges = null;

    void applyAnnotationModelChanges() {
        if (this.fViewer != null && this.fQueuedNodeChanges != null && !this.fQueuedNodeChanges.isEmpty()) {
            ProjectionAnnotationModel annotationModel = this.fViewer.getProjectionAnnotationModel();
            while (!this.fQueuedNodeChanges.isEmpty()) {
                TagProjectionAnnotation anno;
                Node node;
                NodeChange changes = (NodeChange)this.fQueuedNodeChanges.remove(0);
                if (changes.getChangeType() == 1) {
                    node = changes.getNode();
                    Position newPos = this.createProjectionPosition(node);
                    if (newPos == null) continue;
                    TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation(node, false);
                    try {
                        annotationModel.addAnnotation((Annotation)newAnnotation, newPos);
                    }
                    catch (Exception e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                    continue;
                }
                if (changes.getChangeType() != 2 || (anno = this.findExistingAnnotation(node = changes.getNode())) == null) continue;
                try {
                    annotationModel.removeAnnotation((Annotation)anno);
                }
                catch (Exception e) {
                    Logger.log(202, e.getMessage(), e);
                }
            }
            this.fQueuedNodeChanges = null;
        }
    }

    private void addAllAnnotations(DTDFile file) {
        long start = System.currentTimeMillis();
        List nodes = file.getNodes();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            DTDNode node = (DTDNode)it.next();
            Position newPos = this.createProjectionPosition((Node)node);
            if (newPos == null) continue;
            TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation((Node)node, false);
            this.fViewer.getProjectionAnnotationModel().addAnnotation((Annotation)newAnnotation, newPos);
        }
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderDTD.addAllAnnotations: " + (end - start));
        }
    }

    private Position createProjectionPosition(Node node) {
        IDocument document;
        Position pos = null;
        if (this.isNodeProjectable(node) && node instanceof IndexedRegion && (document = this.fViewer.getDocument()) != null) {
            IndexedRegion inode = (IndexedRegion)node;
            int start = inode.getStartOffset();
            int end = inode.getEndOffset();
            if (start >= 0 && start < end) {
                pos = new Position(start, end - start);
            }
        }
        return pos;
    }

    private TagProjectionAnnotation findExistingAnnotation(Node node) {
        TagProjectionAnnotation anno = null;
        if (node != null) {
            Iterator it = this.fViewer.getProjectionAnnotationModel().getAnnotationIterator();
            while (it.hasNext() && anno == null) {
                TagProjectionAnnotation a = (TagProjectionAnnotation)((Object)it.next());
                if (!node.equals(a.getNode())) continue;
                anno = a;
            }
        }
        return anno;
    }

    /*
     * Exception decompiling
     */
    private DTDFile getDTDFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 63->66)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        long start = System.currentTimeMillis();
        this.projectionDisabled();
        this.fDocument = this.fViewer.getDocument();
        DTDFile file = this.getDTDFile();
        if (this.fDocument != null && file != null && this.fViewer.getProjectionAnnotationModel() != null) {
            if (this.fDocumentListener == null) {
                this.fDocumentListener = new DocumentListener();
            }
            this.fDocument.addDocumentListener(this.fDocumentListener);
            file.addDTDFileListener((IDTDFileListener)this);
            try {
                this.fViewer.setRedraw(false);
                this.addAllAnnotations(file);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.fViewer.setRedraw(true);
                throw throwable;
            }
            {
                Object var4_5 = null;
            }
            this.fViewer.setRedraw(true);
        }
        this.fProjectionNeedsToBeEnabled = false;
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderDTD.initialize: " + (end - start));
        }
    }

    public void install(ProjectionViewer viewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.fViewer = viewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
        this.fViewer.addTextInputListener((ITextInputListener)this);
    }

    private boolean isInstalled() {
        return this.fViewer != null;
    }

    private boolean isNodeProjectable(Node node) {
        return node != null && node instanceof TopLevelNode;
    }

    public void nodeChanged(DTDNode node) {
    }

    public void nodesAdded(NodesEvent event) {
        long start = System.currentTimeMillis();
        this.processNodesEvent(event, 1);
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderDTD.nodesAdded: " + (end - start));
        }
    }

    private void processNodesEvent(NodesEvent event, int changeType) {
        List nodes = event.getNodes();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            int existingIndex;
            DTDNode node = (DTDNode)it.next();
            if (!this.isNodeProjectable((Node)node)) continue;
            if (this.fQueuedNodeChanges == null) {
                this.fQueuedNodeChanges = new ArrayList();
            }
            if ((existingIndex = this.fQueuedNodeChanges.indexOf(node)) > -1) {
                NodeChange existingChange = (NodeChange)this.fQueuedNodeChanges.remove(existingIndex);
                if (existingChange.getChangeType() != changeType) continue;
                NodeChange newChange = new NodeChange((Node)node, changeType);
                this.fQueuedNodeChanges.add(newChange);
                continue;
            }
            NodeChange newChange = new NodeChange((Node)node, changeType);
            this.fQueuedNodeChanges.add(newChange);
        }
        if (!this.fIsDocumentChanging) {
            this.applyAnnotationModelChanges();
        }
    }

    public void nodesRemoved(NodesEvent event) {
        long start = System.currentTimeMillis();
        this.processNodesEvent(event, 2);
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            System.out.println("StructuredTextFoldingProviderDTD.nodesRemoved: " + (end - start));
        }
    }

    public void projectionDisabled() {
        DTDFile file = this.getDTDFile();
        if (file != null) {
            file.removeDTDFileListener((IDTDFileListener)this);
        }
        if (this.fDocumentListener != null && this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
            this.fDocument = null;
            if (this.fQueuedNodeChanges != null) {
                this.fQueuedNodeChanges.clear();
                this.fQueuedNodeChanges = null;
            }
        }
        this.fDocument = null;
        this.fProjectionNeedsToBeEnabled = false;
    }

    public void projectionEnabled() {
        this.initialize();
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (this.fDocument != null && this.fDocument != newInput) {
            this.projectionDisabled();
            this.fProjectionNeedsToBeEnabled = true;
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (this.fProjectionNeedsToBeEnabled && this.fDocument == null && newInput != null) {
            this.projectionEnabled();
            this.fProjectionNeedsToBeEnabled = false;
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer.addTextInputListener((ITextInputListener)this);
            this.fViewer = null;
        }
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (StructuredTextFoldingProviderDTD.this.fDocument == event.getDocument()) {
                StructuredTextFoldingProviderDTD.this.fIsDocumentChanging = true;
            }
        }

        public void documentChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (document instanceof IDocumentExtension && StructuredTextFoldingProviderDTD.this.fDocument == document && StructuredTextFoldingProviderDTD.this.fViewer != null && StructuredTextFoldingProviderDTD.this.fQueuedNodeChanges != null && !StructuredTextFoldingProviderDTD.this.fQueuedNodeChanges.isEmpty()) {
                ((IDocumentExtension)document).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)new PostDocumentChangedListener());
            }
        }
    }

    class NodeChange {
        static final int ADD = 1;
        static final int REMOVE = 2;
        private Node fNode;
        private int fChangeType;

        public NodeChange(Node node, int changeType) {
            this.fNode = node;
            this.fChangeType = changeType;
        }

        public Node getNode() {
            return this.fNode;
        }

        public int getChangeType() {
            return this.fChangeType;
        }
    }

    class PostDocumentChangedListener
    implements IDocumentExtension.IReplace {
        PostDocumentChangedListener() {
        }

        public void perform(IDocument document, IDocumentListener owner) {
            StructuredTextFoldingProviderDTD.this.applyAnnotationModelChanges();
            StructuredTextFoldingProviderDTD.this.fIsDocumentChanging = false;
        }
    }

    private class TagProjectionAnnotation
    extends ProjectionAnnotation {
        private boolean fIsVisible = false;
        private Node fNode;

        public TagProjectionAnnotation(Node node, boolean isCollapsed) {
            super(isCollapsed);
            this.fNode = node;
        }

        public Node getNode() {
            return this.fNode;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.fIsVisible = false;
                return;
            }
            this.fIsVisible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.fIsVisible) {
                super.markCollapsed();
            }
        }
    }
}

