/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;

public class MethodVerifyTest
extends AbstractComparableTest {
    static /* synthetic */ Class class$0;

    public MethodVerifyTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MethodVerifyTest.buildComparableTestSuite(MethodVerifyTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.MethodVerifyTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y<T> extends X<A> { public void foo(T t) {} }\nclass X<U> { public void foo(U u) {} }\nclass A {}\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y<T> extends X<A> { public void foo(T t) {} }\n\t                                             ^^^^^^^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(U) of type X<U> but does not override it\n----------\n");
    }

    public void test001a() {
        this.runNegativeTest(new String[]{"J.java", "public class J<T> implements I<A> { public void foo(T t) {} }\ninterface I<U> { public void foo(U u); }\nclass A {}\n"}, "----------\n1. ERROR in J.java (at line 1)\r\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\r\n\t             ^\nThe type J<T> must implement the inherited abstract method I<A>.foo(A)\n----------\n2. ERROR in J.java (at line 1)\r\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\r\n\t                                                ^^^^^^^^\nName clash: The method foo(T) of type J<T> has the same erasure as foo(U) of type I<U> but does not override it\n----------\n");
    }

    public void test001b() {
        this.runNegativeTest(new String[]{"YY.java", "public class YY<T> extends X { public void foo(T t) {} }\nclass X<U> { public void foo(U u) {} }\n"}, "----------\n1. WARNING in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                           ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                                           ^^^^^^^^\nName clash: The method foo(T) of type YY<T> has the same erasure as foo(Object) of type X but does not override it\n----------\n");
    }

    public void test001c() {
        this.runNegativeTest(new String[]{"JJ.java", "public class JJ<T> implements I { public void foo(T t) {} }\ninterface I<U> { public void foo(U u); }\n"}, "----------\n1. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t             ^^\nThe type JJ<T> must implement the inherited abstract method I.foo(Object)\n----------\n2. WARNING in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                              ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n3. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                                              ^^^^^^^^\nName clash: The method foo(T) of type JJ<T> has the same erasure as foo(Object) of type I but does not override it\n----------\n");
    }

    public void test001d() {
        this.runConformTest(new String[]{"YYY.java", "public class YYY<T> extends X<T> { public void foo(T t) {} }\nclass X<U> { public void foo(U u) {} }\n"}, "");
    }

    public void test001e() {
        this.runConformTest(new String[]{"JJJ.java", "public class JJJ<T> implements I<T> { public void foo(T t) {} }\ninterface I<U> { public void foo(U u); }\n"}, "");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y<T> extends X<A> { public void foo(T t) {} }\nclass A {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y<T> extends X<A> { public void foo(T t) {} }\n\t                                             ^^^^^^^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(U) of type X<U> but does not override it\n----------\n");
    }

    public void test002a() {
        this.runNegativeTest(new String[]{"J.java", "public class J<T> implements I<A> { public void foo(T t) {} }\nclass A {}\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "----------\n1. ERROR in J.java (at line 1)\r\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\r\n\t             ^\nThe type J<T> must implement the inherited abstract method I<A>.foo(A)\n----------\n2. ERROR in J.java (at line 1)\r\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\r\n\t                                                ^^^^^^^^\nName clash: The method foo(T) of type J<T> has the same erasure as foo(U) of type I<U> but does not override it\n----------\n");
    }

    public void test002b() {
        this.runNegativeTest(new String[]{"YY.java", "public class YY<T> extends X { public void foo(T t) {} }\n", "X.java", "class X<U> { public void foo(U u) {} }\n"}, "----------\n1. WARNING in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                           ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                                           ^^^^^^^^\nName clash: The method foo(T) of type YY<T> has the same erasure as foo(Object) of type X but does not override it\n----------\n");
    }

    public void test002c() {
        this.runNegativeTest(new String[]{"JJ.java", "public class JJ<T> implements I { public void foo(T t) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "----------\n1. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t             ^^\nThe type JJ<T> must implement the inherited abstract method I.foo(Object)\n----------\n2. WARNING in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                              ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n3. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                                              ^^^^^^^^\nName clash: The method foo(T) of type JJ<T> has the same erasure as foo(Object) of type I but does not override it\n----------\n");
    }

    public void test002d() {
        this.runConformTest(new String[]{"YYY.java", "public class YYY<T> extends X<T> { public void foo(T t) {} }\n", "X.java", "class X<U> { public void foo(U u) {} }\n"}, "");
    }

    public void test002e() {
        this.runConformTest(new String[]{"JJJ.java", "public class JJJ<T> implements I<T> { public void foo(T t) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
    }

    public void test003() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runNegativeTest(new String[]{"Y.java", "public class Y<T> extends X<A> { public void foo(T t) {} }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y<T> extends X<A> { public void foo(T t) {} }\n\t                                             ^^^^^^^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(U) of type X<U> but does not override it\n----------\n", null, false, null);
    }

    public void test003a() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runNegativeTest(new String[]{"J.java", "public class J<T> implements I<A> { public void foo(T t) {} }\n"}, "----------\n1. ERROR in J.java (at line 1)\r\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\r\n\t             ^\nThe type J<T> must implement the inherited abstract method I<A>.foo(A)\n----------\n2. ERROR in J.java (at line 1)\r\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\r\n\t                                                ^^^^^^^^\nName clash: The method foo(T) of type J<T> has the same erasure as foo(U) of type I<U> but does not override it\n----------\n", null, false, null);
    }

    public void test003b() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runNegativeTest(new String[]{"YY.java", "public class YY<T> extends X { public void foo(T t) {} }\n"}, "----------\n1. WARNING in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                           ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                                           ^^^^^^^^\nName clash: The method foo(T) of type YY<T> has the same erasure as foo(Object) of type X but does not override it\n----------\n", null, false, null);
    }

    public void test003c() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runNegativeTest(new String[]{"JJ.java", "public class JJ<T> implements I { public void foo(T t) {} }\n"}, "----------\n1. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t             ^^\nThe type JJ<T> must implement the inherited abstract method I.foo(Object)\n----------\n2. WARNING in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                              ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n3. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                                              ^^^^^^^^\nName clash: The method foo(T) of type JJ<T> has the same erasure as foo(Object) of type I but does not override it\n----------\n", null, false, null);
    }

    public void test003d() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runConformTest(new String[]{"YYY.java", "public class YYY<T> extends X<T> { public void foo(T t) {} }\n"}, "", null, false, null);
    }

    public void test003e() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runConformTest(new String[]{"JJJ.java", "public class JJJ<T> implements I<T> { public void foo(T t) {} }\n"}, "", null, false, null);
    }

    public void test004() {
        this.runNegativeTest(new String[]{"ALL.java", "class A {}\nclass B {}\nclass X<U> { public U foo() {return null;} }\ninterface I<U> { public U foo(); }\nclass J<T> implements I<B> { public T foo() {return null;} }\nclass K<T> implements I<T> { public T foo() {return null;} }\nclass L<T> implements I { public T foo() {return null;} }\nclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\nclass Z<T> extends X<T> { @Override public T foo() { return super.foo(); } }\nclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n"}, "----------\n1. ERROR in ALL.java (at line 5)\n\tclass J<T> implements I<B> { public T foo() {return null;} }\n\t                                    ^\nThe return type is incompatible with I<B>.foo()\n----------\n2. WARNING in ALL.java (at line 7)\n\tclass L<T> implements I { public T foo() {return null;} }\n\t                      ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n3. ERROR in ALL.java (at line 8)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                           ^\nThe return type is incompatible with X<A>.foo()\n----------\n4. ERROR in ALL.java (at line 8)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                                            ^^^^^^^^^^^\nType mismatch: cannot convert from A to T\n----------\n5. WARNING in ALL.java (at line 10)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                   ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n6. ERROR in ALL.java (at line 10)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                                                         ^^^^^^^^^^^\nType mismatch: cannot convert from Object to T\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public U foo() {return null;} }\n", "I.java", "interface I<U> { public U foo(); }\n", "J.java", "class J<T> implements I<B> { public T foo() {return null;} }\n", "K.java", "class K<T> implements I<T> { public T foo() {return null;} }\n", "L.java", "class L<T> implements I { public T foo() {return null;} }\n", "Y.java", "class Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n", "Z.java", "class Z<T> extends X<T> { @Override public T foo() { return super.foo(); } }\n", "W.java", "class W<T> extends X { @Override public T foo() { return super.foo(); } }\n"}, "----------\n1. ERROR in J.java (at line 1)\n\tclass J<T> implements I<B> { public T foo() {return null;} }\n\t                                    ^\nThe return type is incompatible with I<B>.foo()\n----------\n----------\n1. WARNING in L.java (at line 1)\n\tclass L<T> implements I { public T foo() {return null;} }\n\t                      ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n----------\n1. ERROR in Y.java (at line 1)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                           ^\nThe return type is incompatible with X<A>.foo()\n----------\n2. ERROR in Y.java (at line 1)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                                            ^^^^^^^^^^^\nType mismatch: cannot convert from A to T\n----------\n----------\n1. WARNING in W.java (at line 1)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                   ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in W.java (at line 1)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                                                         ^^^^^^^^^^^\nType mismatch: cannot convert from Object to T\n----------\n");
    }

    public void test006() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public U foo() {return null;} }\n", "I.java", "interface I<U> { public U foo(); }\n"}, "");
        this.runNegativeTest(new String[]{"J.java", "class J<T> implements I<B> { public T foo() {return null;} }\n", "K.java", "class K<T> implements I<T> { public T foo() {return null;} }\n", "L.java", "class L<T> implements I { public T foo() {return null;} }\n", "Y.java", "class Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n", "Z.java", "class Z<T> extends X<T> { @Override public T foo() { return super.foo(); } }\n", "W.java", "class W<T> extends X { @Override public T foo() { return super.foo(); } }\n"}, "----------\n1. ERROR in J.java (at line 1)\n\tclass J<T> implements I<B> { public T foo() {return null;} }\n\t                                    ^\nThe return type is incompatible with I<B>.foo()\n----------\n----------\n1. WARNING in L.java (at line 1)\n\tclass L<T> implements I { public T foo() {return null;} }\n\t                      ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n----------\n1. ERROR in Y.java (at line 1)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                           ^\nThe return type is incompatible with X<A>.foo()\n----------\n2. ERROR in Y.java (at line 1)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                                            ^^^^^^^^^^^\nType mismatch: cannot convert from A to T\n----------\n----------\n1. WARNING in W.java (at line 1)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                   ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in W.java (at line 1)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                                                         ^^^^^^^^^^^\nType mismatch: cannot convert from Object to T\n----------\n", null, false, null);
    }

    public void test007() {
        this.runConformTest(new String[]{"A.java", "abstract class A implements I {}\ninterface I extends J { String foo(); }\ninterface J { Object foo(); }\n", "X.java", "abstract class X1 extends A implements J {}\n"}, "");
    }

    public void test007a() {
        this.runNegativeTest(new String[]{"A.java", "abstract class A implements I {}\ninterface I extends J { Object foo(); }\ninterface J { String foo(); }\n", "X.java", "abstract class X2 extends A implements J {}\n"}, "----------\n1. ERROR in A.java (at line 1)\n\tabstract class A implements I {}\n\t               ^\nThe return type is incompatible with J.foo(), I.foo()\n----------\n2. ERROR in A.java (at line 2)\n\tinterface I extends J { Object foo(); }\n\t                        ^^^^^^\nThe return type is incompatible with J.foo()\n----------\n----------\n1. ERROR in X.java (at line 1)\n\tabstract class X2 extends A implements J {}\n\t               ^^\nThe return type is incompatible with I.foo(), J.foo()\n----------\n");
    }

    public void test007b() {
        this.runConformTest(new String[]{"A.java", "abstract class A implements I {}\ninterface I { String foo(); }\n", "X.java", "abstract class X3 extends A implements J {}\ninterface J { Object foo(); }\n"}, "");
    }

    public void test007c() {
        this.runConformTest(new String[]{"A.java", "abstract class A implements I {}\ninterface I { Object foo(); }\n", "X.java", "abstract class X4 extends A implements J {}\ninterface J { String foo(); }\n"}, "");
    }

    public void test007d() {
        this.runConformTest(new String[]{"A.java", "class A { public String foo() { return null; } }\ninterface I { Object foo(); }\n", "X.java", "abstract class X5 extends A implements I {}\n"}, "");
    }

    public void test007e() {
        this.runNegativeTest(new String[]{"A.java", "class A { public Object foo() { return null; } }\ninterface I { String foo(); }\n", "X.java", "abstract class X6 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tabstract class X6 extends A implements I {}\r\n\t               ^^\nThe return type is incompatible with I.foo(), A.foo()\n----------\n");
    }

    public void test007f() {
        this.runNegativeTest(new String[]{"A.java", "class A { int get(short i, short s) { return i; } }\nclass B extends A { @Override short get(short i, short s) {return i; } }\n"}, "----------\n1. ERROR in A.java (at line 2)\r\n\tclass B extends A { @Override short get(short i, short s) {return i; } }\r\n\t                              ^^^^^\nThe return type is incompatible with A.get(short, short)\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"ALL.java", "interface I { I foo(); }\nclass A implements I { public A foo() { return null; } }\nclass B extends A { @Override public B foo() { return null; } }\nclass C extends B { @Override public A foo() { return null; } }\nclass D extends B implements I {}\n"}, "----------\n1. ERROR in ALL.java (at line 4)\r\n\tclass C extends B { @Override public A foo() { return null; } }\r\n\t                                     ^\nThe return type is incompatible with B.foo()\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"A.java", "class G<T> {}\ninterface I { void foo(G<I> x); }\nabstract class A implements I { void foo(G<A> x) {} }\n"}, "----------\n1. ERROR in A.java (at line 3)\r\n\tabstract class A implements I { void foo(G<A> x) {} }\r\n\t                                     ^^^^^^^^^^^\nName clash: The method foo(G<A>) of type A has the same erasure as foo(G<I>) of type I but does not override it\n----------\n");
    }

    public void test009a() {
        this.runNegativeTest(new String[]{"A.java", "class G<T> {}\ninterface I { I foo(G<I> x); }\nabstract class A implements I { I foo(G<A> x) { return null; } }\n"}, "----------\n1. ERROR in A.java (at line 3)\r\n\tabstract class A implements I { I foo(G<A> x) { return null; } }\r\n\t                                  ^^^^^^^^^^^\nName clash: The method foo(G<A>) of type A has the same erasure as foo(G<I>) of type I but does not override it\n----------\n");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public X foo() {\n        System.out.println(\"Did NOT add bridge method\");\n        return this;\n    }\n    public static void main(String[] args) throws Exception {\n        X x = new A();\n        x.foo();\n        System.out.print(\" + \");\n        I i = new A();\n        i.foo();\n    }\n}\ninterface I {\n    public I foo();\n}\nclass A extends X implements I {\n    public A foo() {\n        System.out.print(\"Added bridge method\");\n        return this;\n    }\n}\n"}, "Added bridge method + Added bridge method");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T> void foo(T t) {} }\ninterface I { <T> void foo(T t); }\n", "X.java", "abstract class X1 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tabstract class X1 extends A implements I {}\r\n\t               ^^\nThe inherited method A.foo(T) cannot hide the public abstract method in I\n----------\n");
    }

    public void test011a() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T, S> void foo(T t) {} }\ninterface I { <T> void foo(T t); }\n", "X.java", "abstract class X2 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X2 extends A implements I {}\n\t               ^^\nName clash: The method foo(T) of type A has the same erasure as foo(T) of type I but does not override it\n----------\n");
    }

    public void test011b() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T> void foo(T t) {} }\ninterface I { <T, S> void foo(T t); }\n", "X.java", "abstract class X3 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X3 extends A implements I {}\n\t               ^^\nName clash: The method foo(T) of type A has the same erasure as foo(T) of type I but does not override it\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"A.java", "class A { public <T> void foo(T s) {} }\nclass Y1 extends A { @Override void foo(Object s) {} }\n"}, "----------\n1. ERROR in A.java (at line 2)\n\tclass Y1 extends A { @Override void foo(Object s) {} }\n\t                                    ^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n");
    }

    public void test012a() {
        this.runNegativeTest(new String[]{"A.java", "class A { public <T> void foo(T[] s) {} }\nclass Y2 extends A { @Override void foo(Object[] s) {} }\n"}, "----------\n1. ERROR in A.java (at line 2)\n\tclass Y2 extends A { @Override void foo(Object[] s) {} }\n\t                                    ^^^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n");
    }

    public void test012b() {
        this.runNegativeTest(new String[]{"A.java", "class A { public void foo(Class<Object> s) {} }\nclass Y3 extends A { @Override void foo(Class<Object> s) {} }\n"}, "----------\n1. ERROR in A.java (at line 2)\r\n\tclass Y3 extends A { @Override void foo(Class<Object> s) {} }\r\n\t                                    ^^^^^^^^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"A.java", "class A { public <T> void foo(Class<T> s) {} }\ninterface I { <T> void foo(Class<T> s); }\n", "X.java", "abstract class X0 extends A implements I {}\n"}, "");
    }

    public void test013a() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T, S> void foo(Class<T> s) {} }\ninterface I { <T> void foo(Class<T> s); }\n", "X.java", "abstract class X1 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tabstract class X1 extends A implements I {}\r\n\t               ^^\nName clash: The method foo(Class<T>) of type A has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test013b() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T> void foo(Class<T> s) {} }\ninterface I { <T, S> void foo(Class<T> s); }\n", "X.java", "abstract class X2 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tabstract class X2 extends A implements I {}\r\n\t               ^^\nName clash: The method foo(Class<T>) of type A has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test013c() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T, S> S foo(Class<T> s) { return null; } }\ninterface I { <T> Object foo(Class<T> s); }\n", "X.java", "abstract class X3 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tabstract class X3 extends A implements I {}\r\n\t               ^^\nName clash: The method foo(Class<T>) of type A has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test013d() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T> Object foo(Class<T> s) { return null; } }\ninterface I { <T, S> S foo(Class<T> s); }\n", "X.java", "abstract class X4 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tabstract class X4 extends A implements I {}\r\n\t               ^^\nName clash: The method foo(Class<T>) of type A has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test013e() {
        this.runNegativeTest(new String[]{"A.java", "class A { public <T, S> void foo(Class<T> s) {} }\ninterface I { <T> void foo(Class<T> s); }\n", "X.java", "class X5 extends A implements I { public <T> void foo(Class<T> s) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tclass X5 extends A implements I { public <T> void foo(Class<T> s) {} }\r\n\t                                                  ^^^^^^^^^^^^^^^\nName clash: The method foo(Class<T>) of type X5 has the same erasure as foo(Class<T>) of type A but does not override it\n----------\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "class X { void foo(A a) {} }\nclass Y extends X { void foo(A a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test014a() {
        this.runConformTest(new String[]{"X.java", "class X { void foo(A[] a) {} }\nclass Y extends X { void foo(A[] a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test014b() {
        this.runConformTest(new String[]{"X.java", "class X { void foo(A<String>[] a) {} }\nclass Y extends X { void foo(A[] a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test014c() {
        this.runConformTest(new String[]{"X.java", "class X { void foo(A<String> a) {} }\nclass Y extends X { void foo(A a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test014d() {
        this.runNegativeTest(new String[]{"X.java", "class X { void foo(A a) {} }\nclass Y extends X { void foo(A<String> a) {} }\nclass A<T> {}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tclass X { void foo(A a) {} }\n\t                   ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tclass Y extends X { void foo(A<String> a) {} }\n\t                         ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type Y has the same erasure as foo(A) of type X but does not override it\n----------\n");
    }

    public void test014e() {
        this.runNegativeTest(new String[]{"X.java", "class X { void foo(A[] a) {} }\nclass Y extends X { void foo(A<String>[] a) {} }\nclass A<T> {}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tclass X { void foo(A[] a) {} }\n\t                   ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tclass Y extends X { void foo(A<String>[] a) {} }\n\t                         ^^^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>[]) of type Y has the same erasure as foo(A[]) of type X but does not override it\n----------\n");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A a); }\nclass Y { public void foo(A a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test015a() {
        this.runConformTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A[] a); }\nclass Y { public void foo(A[] a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test015b() {
        this.runConformTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A<String>[] a); }\nclass Y { public void foo(A[] a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test015c() {
        this.runConformTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A<String> a); }\nclass Y { public void foo(A a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test015d() {
        this.runNegativeTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A a); }\nclass Y { public void foo(A<String> a) {} }\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X extends Y implements I { }\n\t               ^\nName clash: The method foo(A<String>) of type Y has the same erasure as foo(A) of type I but does not override it\n----------\n2. WARNING in X.java (at line 2)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test015e() {
        this.runNegativeTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A[] a); }\nclass Y { public void foo(A<String>[] a) {} }\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X extends Y implements I { }\n\t               ^\nName clash: The method foo(A<String>[]) of type Y has the same erasure as foo(A[]) of type I but does not override it\n----------\n2. WARNING in X.java (at line 2)\n\tinterface I { void foo(A[] a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t<E extends A> void m(E e) { System.out.print(\"A=\"+e.getClass()); }\n\t<E extends B> void m(E e) { System.out.print(\"B=\"+e.getClass()); }\n\tpublic static void main(String[] args) {\n\t\tnew X().m(new A());\n\t\tnew X().m(new B());\n\t}\n}\nclass A {}\nclass B extends A {}\n"}, "A=class AB=class B");
    }

    public void test016b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <E extends A> void m(E e) { System.out.print(\"A=\"+e.getClass()); }\n\tstatic <E extends B> void m(E e) { System.out.print(\"B=\"+e.getClass()); }\n\tpublic static void main(String[] args) {\n\t\tm(new A());\n\t\tm(new B());\n\t}\n}\nclass A {}\nclass B extends A {}\n"}, "A=class AB=class B");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {}\nclass Y { void test(X<? extends Number> a) {} }\nclass Z extends Y { void test(X<Number> a) {} }\n"}, "----------\n1. ERROR in X.java (at line 3)\r\n\tclass Z extends Y { void test(X<Number> a) {} }\r\n\t                         ^^^^^^^^^^^^^^^^^\nName clash: The method test(X<Number>) of type Z has the same erasure as test(X<? extends Number>) of type Y but does not override it\n----------\n");
    }

    public void test017a() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {}\nclass Y { void test(X<Number> a) {} }\nclass Z extends Y { void test(X<? extends Number> a) {} }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass Z extends Y { void test(X<? extends Number> a) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method test(X<? extends Number>) of type Z has the same erasure as test(X<Number>) of type Y but does not override it\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "class X implements Comparable<X> {\n\tpublic int compareTo(Object o) { return 0; }\n\tpublic int compareTo(X o) { return 1; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic int compareTo(Object o) { return 0; }\n\t           ^^^^^^^^^^^^^^^^^^^\nName clash: The method compareTo(Object) of type X has the same erasure as compareTo(T) of type Comparable<T> but does not override it\n----------\n");
    }

    public void test019() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\t<T> T get() { return null; } \n}\nclass B extends A {\n\t<T> T get() { return null; } \n}\n"}, "");
    }

    public void test020() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tpublic static void main(String[] args) {\n\t\tAbstractBase ab = new AbstractBase();\n\t\tDerived d = new Derived();\n\t\tAbstractBase ab2 = new Derived();\n\t\tVisitor<String, String> v = new MyVisitor();\n\t\tSystem.out.print(ab.accept(v, ab.getClass().getName()));\n\t\tSystem.out.print('+');\n\t\tSystem.out.print(d.accept(v, d.getClass().getName()));\n\t\tSystem.out.print('+');\n\t\tSystem.out.print(ab2.accept(v, ab2.getClass().getName()));\n\t}\n\tstatic class MyVisitor implements Visitor<String, String> {\n\t\tpublic String visitBase(AbstractBase ab, String obj) { return \"Visited base: \" + obj; }\n\t\tpublic String visitDerived(Derived d, String obj) { return \"Visited derived: \" + obj; }\n\t}\n}\ninterface Visitor<R, T> {\n\tR visitBase(AbstractBase ab, T obj);\n\tR visitDerived(Derived d, T obj);\n}\ninterface Visitable {\n\t<R, T> R accept(Visitor<R, T> v, T obj);\n}\nclass AbstractBase implements Visitable {\n\tpublic <R, T> R accept(Visitor<R, T> v, T obj) { return v.visitBase(this, obj); }\n}\nclass Derived extends AbstractBase implements Visitable {\n\tpublic <R, T> R accept(Visitor<R, T> v, T obj) { return v.visitDerived(this, obj); }\n}\n"}, "Visited base: AbstractBase+Visited derived: Derived+Visited derived: Derived");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic void foo(java.util.Map<String, Class<?>> m) { } \n}\n", "B.java", "class B extends A {\n\t@Override void foo(java.util.Map<String, Class<?>> m) { } \n}\n"}, "----------\n1. ERROR in B.java (at line 2)\r\n\t@Override void foo(java.util.Map<String, Class<?>> m) { } \r\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n");
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic void foo(java.util.Map<String, Class<?>> m) { } \n}\n"}, "");
        this.runNegativeTest(new String[]{"B.java", "class B extends A {\n\t@Override void foo(java.util.Map<String, Class<?>> m) { } \n}\n"}, "----------\n1. ERROR in B.java (at line 2)\r\n\t@Override void foo(java.util.Map<String, Class<?>> m) { } \r\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n", null, false, null);
    }

    public void test022() {
        this.runConformTest(new String[]{"A.java", "import java.util.*;\nclass A { List getList() { return null; } }\nclass B extends A { @Override List<String> getList() { return null; } }\n"}, "");
    }

    public void test022a() {
        this.runNegativeTest(new String[]{"A.java", "import java.util.*;\nclass A { List<String> getList() { return null; } }\nclass B extends A { @Override List getList() { return null; } }\n"}, "----------\n1. WARNING in A.java (at line 3)\n\tclass B extends A { @Override List getList() { return null; } }\n\t                              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in A.java (at line 3)\n\tclass B extends A { @Override List getList() { return null; } }\n\t                              ^^^^\nType safety: The return type List for getList() from the type B needs unchecked conversion to conform to List<String> from the type A\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"A.java", "class A<T> {\n\tvoid foo(T t) {}\n\tvoid foo(String i) {}\n}\nclass B extends A<String> {}\n"}, "----------\n1. ERROR in A.java (at line 5)\r\n\tclass B extends A<String> {}\r\n\t      ^\nDuplicate methods named foo with the parameters (String) and (T) are defined by the type A<String>\n----------\n");
    }

    public void test024() {
        this.runConformTest(new String[]{"A.java", "class A {\n\tpublic <E extends Object> void m(E e) {}\n}\nclass B extends A {\n\tpublic void m(Object e) {}\n}\n"}, "");
    }

    public void test024a() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\tpublic void m(Object e) {}\n}\nclass B extends A {\n\tpublic <E extends Object> void m(E e) {}\n}\n"}, "----------\n1. ERROR in A.java (at line 5)\r\n\tpublic <E extends Object> void m(E e) {}\r\n\t                               ^^^^^^\nName clash: The method m(E) of type B has the same erasure as m(Object) of type A but does not override it\n----------\n");
    }

    public void test024b() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\tpublic <E extends Object> void m(E e) {}\n}\nclass B extends A {\n\t@Override public void m(Object e) {}\n}\nclass C extends B {\n\tpublic <E extends Object> void m(E e) {}\n}\n"}, "----------\n1. ERROR in A.java (at line 8)\r\n\tpublic <E extends Object> void m(E e) {}\r\n\t                               ^^^^^^\nName clash: The method m(E) of type C has the same erasure as m(Object) of type B but does not override it\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew B().test();\n\t}\n}\nclass A {\n\t<T extends Number> T test() { return null; }\n}\nclass B extends A {\n\t@Override Integer test() { return 1; }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\t@Override Integer test() { return 1; }\n\t          ^^^^^^^\nType safety: The return type Integer for test() from the type B needs unchecked conversion to conform to T from the type A\n----------\n");
    }

    public void test025a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew B().test();\n\t}\n}\nclass A {\n\t<T extends Number> T[] test() { return null; }\n}\nclass B extends A {\n\t@Override Integer[] test() { return new Integer[] {2}; }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\t@Override Integer[] test() { return new Integer[] {2}; }\n\t          ^^^^^^^^^\nType safety: The return type Integer[] for test() from the type B needs unchecked conversion to conform to T[] from the type A\n----------\n");
    }

    public void test025b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new B().<Integer>test(new Integer(1)));\n\t}\n}\nclass A {\n\t<T> T test(T t) { return null; }\n}\nclass B extends A {\n\t@Override <T> T test(T t) { return t; }\n}\n"}, "1");
    }

    public void test025c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new B().<Number>test(1));\n\t}\n}\nclass A<T> {\n\t<U> T test(U u) { return null; }\n}\nclass B extends A<Integer> {\n\t@Override <U> Integer test(U u) { return 1; }\n}\n"}, "1");
    }

    public void test025d() {
        this.runConformTest(new String[]{"A.java", "import java.util.concurrent.Callable;\npublic class A {\n\tpublic static void main(String[] args) throws Exception {\n\t\tCallable<Integer> integerCallable = new Callable<Integer>() {\n\t\t\tpublic Integer call() { return new Integer(1); }\n\t\t};\n\t\tSystem.out.println(integerCallable.call());\n\t}\n}\n"}, "1");
    }

    public void test025e() {
        this.runNegativeTest(new String[]{"X.java", "interface X<T extends X> { T x(); }\nabstract class Y<S extends X> implements X<S> { public abstract S x(); }\nabstract class Z implements X { public abstract X x(); }\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tinterface X<T extends X> { T x(); }\n\t                      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tabstract class Y<S extends X> implements X<S> { public abstract S x(); }\n\t                           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X x(); }\n\t                            ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X x(); }\n\t                                                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test025f() {
        this.runNegativeTest(new String[]{"X.java", "interface X<T extends X> { T[] x(); }\nabstract class Y<S extends X> implements X<S> { public abstract S[] x(); }\nabstract class Z implements X { public abstract X[] x(); }\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tinterface X<T extends X> { T[] x(); }\n\t                      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tabstract class Y<S extends X> implements X<S> { public abstract S[] x(); }\n\t                           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X[] x(); }\n\t                            ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X[] x(); }\n\t                                                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\n\t\t\tnew B().test().getClass() + \" & \"\n\t\t\t+ new C().test().getClass() + \" & \"\n\t\t\t+ new D().test().getClass());\n\t}\n}\nclass A<T extends Number> {\n\tA<T> test() { return this; }\n}\nclass B extends A {\n\tA test() { return super.test(); }\n}\nclass C extends A<Integer> {\n\tA<Integer> test() { return super.test(); }\n}\nclass D<U, V extends Number> extends A<V> {\n\tA<V> test() { return super.test(); }\n}\n"}, "class B & class C & class D");
    }

    public void test026a() {
        this.runConformTest(new String[]{"A.java", "public abstract class A<E> {\n\tpublic abstract A<E> test();\n}\nclass H<K,V> {\n\tclass M extends A<K> {\n\t\tpublic A<K> test() { return null; }\n\t}\n}\n"}, "");
    }

    public void test026b() {
        this.runConformTest(new String[]{"X.java", "public class X extends java.util.AbstractMap {\n\tpublic java.util.Set entrySet() { return null; }\n}\n"}, "");
    }

    public void test026c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(new C().test().getClass());\n\t}\n}\nclass A<T extends Number> {\n\tA<T> test() { return this; }\n}\nclass C extends A<Integer> {\n\t@Override A test() { return super.test(); }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\t@Override A test() { return super.test(); }\n\t          ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\t@Override A test() { return super.test(); }\n\t          ^\nType safety: The return type A for test() from the type C needs unchecked conversion to conform to A<T> from the type A<T>\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X { <T> void test() {} }\nclass Y extends X { void test() {} }\n"}, "");
    }

    public void test027a() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test() {} }\nclass Y extends X { <T> void test() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends X { <T> void test() {} }\n\t                             ^^^^^^\nName clash: The method test() of type Y has the same erasure as test() of type X but does not override it\n----------\n");
    }

    public void test027b() {
        this.runConformTest(new String[]{"X.java", "public class X<T> { void test(T o) {} }\nclass Y<T> extends X<T> { void test(Object o) {} }\n"}, "");
    }

    public void test027c() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> { void test(T o, T t) {} }\nclass Y<T> extends X<T> { void test(Object o, T t) {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\tclass Y<T> extends X<T> { void test(Object o, T t) {} }\r\n\t                               ^^^^^^^^^^^^^^^^^^^\nName clash: The method test(Object, T) of type Y<T> has the same erasure as test(T, T) of type X<T> but does not override it\n----------\n");
    }

    public void test027d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test() {\n\t\tPair<Double, Integer> p = new InvertedPair<Integer, Double>();\n\t\tp.setA(new Double(1.1));\n\t}\n}\nclass Pair<A, B> {\n\tpublic void setA(A a) {}\n}\nclass InvertedPair<A, B> extends Pair<B, A> {\n\tpublic void setA(A a) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tpublic void setA(A a) {}\n\t            ^^^^^^^^^\nName clash: The method setA(A) of type InvertedPair<A,B> has the same erasure as setA(A) of type Pair<A,B> but does not override it\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X implements I<X>{\n\tpublic X foo() { return null; }\n}\ninterface I<T extends I> { T foo(); }\n"}, "");
    }

    public void test029() {
        this.runConformTest(new String[]{"I.java", "public interface I {\n\tpublic I clone();\n}\ninterface J extends I {}\n"}, "");
    }

    public void test030() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.4");
        this.runConformTest(new String[]{"X.java", "import java.io.OutputStreamWriter;\nimport java.io.PrintWriter;\npublic class X extends PrintWriter implements Runnable {\n\tpublic X(OutputStreamWriter out, boolean flag) { super(out, flag); }\n\tpublic void run() {}\n}\n"}, "", null, false, null, options, null);
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.java", "interface X { long hashCode(); }\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tinterface X { long hashCode(); }\r\n\t              ^^^^\nThe return type is incompatible with Object.hashCode()\n----------\n");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "interface I { Integer foo(); }\ninterface J { Integer foo(); }\npublic class X<T extends I&J> implements I {\n\tpublic Integer foo() { return null; }\n}"}, "");
    }

    public void test032a() {
        this.runNegativeTest(new String[]{"X.java", "interface I { Float foo(); }\ninterface J { Integer foo(); }\npublic class X<T extends I&J> {}\n"}, "----------\n1. ERROR in X.java (at line 3)\r\n\tpublic class X<T extends I&J> {}\r\n\t               ^\nThe return type is incompatible with J.foo(), I.foo()\n----------\n");
    }

    public void test032b() {
        this.runNegativeTest(new String[]{"X.java", "interface I { String foo(); }\nclass A { public Object foo() { return null; } }public class X<T extends A&I> {}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\tclass A { public Object foo() { return null; } }public class X<T extends A&I> {}\r\n\t                                                               ^\nThe return type is incompatible with I.foo(), A.foo()\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "interface I { Number foo(); }\ninterface J { Integer foo(); }\npublic class X implements I, J {\n\tpublic Integer foo() {return 1;}\n\tpublic static void main(String argv[]) {\n\t\tI i = null;\n\t\tJ j = null;\n\t\tSystem.out.print(i instanceof J);\n\t\tSystem.out.print('=');\n\t\tSystem.out.print(j instanceof I);\n\t}\n}\n"}, "false=false");
    }

    public void test033a() {
        this.runConformTest(new String[]{"X.java", "interface I { Number foo(A a); }\ninterface J<T> { Integer foo(A<T> a); }\nclass A<T>{}\npublic class X implements I, J {\n\tpublic Integer foo(A a) {return 1;}\n\tpublic static void main(String argv[]) {\n\t\tI i = null;\n\t\tJ j = null;\n\t\tSystem.out.print(i instanceof J);\n\t\tSystem.out.print('=');\n\t\tSystem.out.print(j instanceof I);\n\t}\n}\n"}, "false=false");
    }

    public void test034() {
        this.runConformTest(new String[]{"B.java", "interface I<E extends Comparable<E>> { void test(E element); }\nclass A implements I<Integer> { public void test(Integer i) {} }\npublic class B extends A { public void test(String i) {} }\n"}, "");
    }

    public void test034a() {
        this.runConformTest(new String[]{"B.java", "interface I<E extends Comparable> { void test(E element); }\nclass A { public void test(Integer i) {} }\npublic class B extends A implements I<Integer> {}\nclass C extends B { public void test(Object i) {} }\n"}, "");
    }

    public void test034b() {
        this.runNegativeTest(new String[]{"B.java", "interface I<E extends Comparable> { void test(E element); }\nclass A { public void test(Integer i) {} }\npublic class B extends A implements I<Integer> { public void test(Comparable i) {} }\n"}, "----------\n1. WARNING in B.java (at line 1)\n\tinterface I<E extends Comparable> { void test(E element); }\n\t                      ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. ERROR in B.java (at line 3)\n\tpublic class B extends A implements I<Integer> { public void test(Comparable i) {} }\n\t                                                             ^^^^^^^^^^^^^^^^^^\nName clash: The method test(Comparable) of type B has the same erasure as test(E) of type I<E> but does not override it\n----------\n3. WARNING in B.java (at line 3)\n\tpublic class B extends A implements I<Integer> { public void test(Comparable i) {} }\n\t                                                                  ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test034c() {
        this.runNegativeTest(new String[]{"B.java", "interface I<E extends Comparable<E>> { void test(E element); }\nclass A implements I<Integer> { public void test(Integer i) {} }\npublic class B extends A { public void test(Comparable i) {} }\n"}, "----------\n1. ERROR in B.java (at line 3)\n\tpublic class B extends A { public void test(Comparable i) {} }\n\t                                       ^^^^^^^^^^^^^^^^^^\nName clash: The method test(Comparable) of type B has the same erasure as test(E) of type I<E> but does not override it\n----------\n2. WARNING in B.java (at line 3)\n\tpublic class B extends A { public void test(Comparable i) {} }\n\t                                            ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test034d() {
        this.runNegativeTest(new String[]{"B.java", "abstract class AA<E extends Comparable> { abstract void test(E element); }\nclass A extends AA<Integer> { @Override public void test(Integer i) {} }\npublic class B extends A { public void test(Comparable i) {} }\n"}, "----------\n1. WARNING in B.java (at line 1)\n\tabstract class AA<E extends Comparable> { abstract void test(E element); }\n\t                            ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. ERROR in B.java (at line 3)\n\tpublic class B extends A { public void test(Comparable i) {} }\n\t                                       ^^^^^^^^^^^^^^^^^^\nName clash: The method test(Comparable) of type B has the same erasure as test(E) of type AA<E> but does not override it\n----------\n3. WARNING in B.java (at line 3)\n\tpublic class B extends A { public void test(Comparable i) {} }\n\t                                            ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"E.java", "interface I<U>{ int compareTo(U o); }\nabstract class F<T extends F<T>> implements I<T>{ public final int compareTo(T o) { return 0; } }\npublic class E extends F<E> { public int compareTo(Object o) { return 0; } }\n"}, "----------\n1. ERROR in E.java (at line 3)\n\tpublic class E extends F<E> { public int compareTo(Object o) { return 0; } }\n\t                                         ^^^^^^^^^^^^^^^^^^^\nName clash: The method compareTo(Object) of type E has the same erasure as compareTo(U) of type I<U> but does not override it\n----------\n");
    }

    public void test035a() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\t;\n\tpublic int compareTo(Object o) { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic int compareTo(Object o) { return 0; }\n\t           ^^^^^^^^^^^^^^^^^^^\nName clash: The method compareTo(Object) of type X has the same erasure as compareTo(T) of type Comparable<T> but does not override it\n----------\n");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "class X implements Equivalent, EqualityComparable {\n\tpublic boolean equalTo(Object other) { return true; }\n}\nabstract class Y implements Equivalent, EqualityComparable {}\nclass Z extends Y {\n\tpublic boolean equalTo(Object other) { return true; }\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "");
    }

    public void test036a() {
        this.runConformTest(new String[]{"X.java", "class X implements Equivalent, EqualityComparable {\n\tpublic boolean equalTo(Comparable other) { return true; }\n\tpublic boolean equalTo(Number other) { return true; }\n}\nabstract class Y implements Equivalent, EqualityComparable {}\nclass Z extends Y {\n\tpublic boolean equalTo(Comparable other) { return true; }\n\tpublic boolean equalTo(Number other) { return true; }\n}\ninterface Equivalent<T extends Comparable> { boolean equalTo(T other); }\ninterface EqualityComparable<T extends Number> { boolean equalTo(T other); }\n"}, "");
    }

    public void test036b() {
        this.runConformTest(new String[]{"X.java", "class X<S> implements Equivalent<S>, EqualityComparable<S> {\n\tpublic boolean equalTo(S other) { return true; }\n}\nabstract class Y<S> implements Equivalent<S>, EqualityComparable<S> {}\nclass Z<U> extends Y<U> {\n\tpublic boolean equalTo(U other) { return true; }\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "");
    }

    public void test036c() {
        this.runConformTest(new String[]{"X.java", "class X<T extends Comparable, S extends Number> implements Equivalent<T>, EqualityComparable<S> {\n\tpublic boolean equalTo(T other) { return true; }\n\tpublic boolean equalTo(S other) { return true; }\n}\nabstract class Y<T extends Comparable, S extends Number> implements Equivalent<T>, EqualityComparable<S> {}\nclass Z<U extends Comparable, V extends Number> extends Y<U, V> {\n\tpublic boolean equalTo(U other) { return true; }\n\tpublic boolean equalTo(V other) { return true; }\n}\ninterface Equivalent<T extends Comparable> { boolean equalTo(T other); }\ninterface EqualityComparable<S extends Number> { boolean equalTo(S other); }\n"}, "");
    }

    public void test036d() {
        this.runConformTest(new String[]{"Y.java", "abstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\tpublic abstract boolean equalTo(Number other);\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "");
    }

    public void test036e() {
        this.runNegativeTest(new String[]{"Y.java", "abstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\tpublic abstract boolean equalTo(Object other);\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "----------\n1. ERROR in Y.java (at line 2)\n\tpublic abstract boolean equalTo(Object other);\n\t                        ^^^^^^^^^^^^^^^^^^^^^\nName clash: The method equalTo(Object) of type Y has the same erasure as equalTo(T) of type Equivalent<T> but does not override it\n----------\n2. ERROR in Y.java (at line 2)\n\tpublic abstract boolean equalTo(Object other);\n\t                        ^^^^^^^^^^^^^^^^^^^^^\nName clash: The method equalTo(Object) of type Y has the same erasure as equalTo(T) of type EqualityComparable<T> but does not override it\n----------\n");
    }

    public void test036f() {
        this.runNegativeTest(new String[]{"Y.java", "abstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\tpublic abstract boolean equalTo(String other);\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tabstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\t               ^\nName clash: The method equalTo(T) of type Equivalent<T> has the same erasure as equalTo(T) of type EqualityComparable<T> but does not override it\n----------\n");
    }

    public void test036g() {
        this.runNegativeTest(new String[]{"Y.java", "abstract class Y implements EqualityComparable<Integer>, Equivalent<String> {\n\tpublic boolean equalTo(Integer other) { return true; }\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tabstract class Y implements EqualityComparable<Integer>, Equivalent<String> {\n\t               ^\nName clash: The method equalTo(T) of type EqualityComparable<T> has the same erasure as equalTo(T) of type Equivalent<T> but does not override it\n----------\n");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "public abstract class X implements I, J { }\nabstract class Y implements J, I { }\nabstract class Z implements K { }\nclass YYY implements J, I { public void foo(A a) {} }\nclass XXX implements I, J { public void foo(A a) {} }\nclass ZZZ implements K { public void foo(A a) {} }\ninterface I { void foo(A a); }\ninterface J { void foo(A<String> a); }\ninterface K extends I { void foo(A<String> a); }\nclass A<T> {}"}, "");
    }

    public void test037a() {
        this.runNegativeTest(new String[]{"XX.java", "public abstract class XX implements I, J { public abstract void foo(A<String> a); }\ninterface I { void foo(A a); }\ninterface J { void foo(A<String> a); }\nclass A<T> {}"}, "----------\n1. ERROR in XX.java (at line 1)\n\tpublic abstract class XX implements I, J { public abstract void foo(A<String> a); }\n\t                                                                ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type XX has the same erasure as foo(A) of type I but does not override it\n----------\n2. WARNING in XX.java (at line 2)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test037b() {
        this.runNegativeTest(new String[]{"XX.java", "public class XX implements I, J { public void foo(A<String> a) {} }\nclass YY implements J, I { public void foo(A<String> a) {} }\nclass ZZ implements K { public void foo(A<String> a) {} }\ninterface I { void foo(A a); }\ninterface J { void foo(A<String> a); }\ninterface K extends I { void foo(A<String> a); }\nclass A<T> {}"}, "----------\n1. ERROR in XX.java (at line 1)\n\tpublic class XX implements I, J { public void foo(A<String> a) {} }\n\t             ^^\nThe type XX must implement the inherited abstract method I.foo(A)\n----------\n2. ERROR in XX.java (at line 1)\n\tpublic class XX implements I, J { public void foo(A<String> a) {} }\n\t                                              ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type XX has the same erasure as foo(A) of type I but does not override it\n----------\n3. ERROR in XX.java (at line 2)\n\tclass YY implements J, I { public void foo(A<String> a) {} }\n\t      ^^\nThe type YY must implement the inherited abstract method I.foo(A)\n----------\n4. ERROR in XX.java (at line 2)\n\tclass YY implements J, I { public void foo(A<String> a) {} }\n\t                                       ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type YY has the same erasure as foo(A) of type I but does not override it\n----------\n5. ERROR in XX.java (at line 3)\n\tclass ZZ implements K { public void foo(A<String> a) {} }\n\t      ^^\nThe type ZZ must implement the inherited abstract method I.foo(A)\n----------\n6. ERROR in XX.java (at line 3)\n\tclass ZZ implements K { public void foo(A<String> a) {} }\n\t                                    ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type ZZ has the same erasure as foo(A) of type I but does not override it\n----------\n7. WARNING in XX.java (at line 4)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test037c() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends Y implements I { }\ninterface I { void foo(A a); }\nclass Y { void foo(A<String> a) {} }\nclass A<T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X extends Y implements I { }\n\t                      ^\nName clash: The method foo(A<String>) of type Y has the same erasure as foo(A) of type I but does not override it\n----------\n2. WARNING in X.java (at line 2)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test037d() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends Y implements I { }\ninterface I { void foo(A<String> a); }\nclass Y { void foo(A a) {} }\nclass A<T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X extends Y implements I { }\n\t                      ^\nThe inherited method Y.foo(A) cannot hide the public abstract method in I\n----------\n2. WARNING in X.java (at line 3)\n\tclass Y { void foo(A a) {} }\n\t                   ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test037e() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends Y implements I { }\ninterface I { <T, S> void foo(T t); }\nclass Y { <T> void foo(T t) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tpublic abstract class X extends Y implements I { }\r\n\t                      ^\nName clash: The method foo(T) of type Y has the same erasure as foo(T) of type I but does not override it\n----------\n");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X extends H<Object> { void foo(A<?> a) { super.foo(a); } }\nclass H<T extends Object> { void foo(A<? extends T> a) {} }\nclass A<T> {}"}, "");
    }

    public void test038a() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends H<Number> { void foo(A<?> a) {} }\nclass H<T extends Number> { void foo(A<? extends T> a) {} }\nclass A<T> {}"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tpublic class X extends H<Number> { void foo(A<?> a) {} }\r\n\t                                        ^^^^^^^^^^^\nName clash: The method foo(A<?>) of type X has the same erasure as foo(A<? extends T>) of type H<T> but does not override it\n----------\n");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      Test test = new Test();\n      This test2 = new Test();\n      System.out.println(test.get());\n   }\n   interface This {\n      public Object get();\n   }\n \n   interface That extends This {\n      public String get();\n \n   }\n \n   static class Test implements That {\n \n      public String get() {\n         return \"That\";\n \n      }\n   }\n}\n"}, "That");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"Base.java", "interface Base<E> { Base<E> proc(); }\nabstract class Derived<D> implements Base<D> { public abstract Derived<D> proc(); }\n"}, "");
    }

    public void test040a() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T extends Number> T test() { return null; } }\nclass B extends A { @Override Integer test() { return 1; } }\n"}, "----------\n1. WARNING in A.java (at line 2)\n\tclass B extends A { @Override Integer test() { return 1; } }\n\t                              ^^^^^^^\nType safety: The return type Integer for test() from the type B needs unchecked conversion to conform to T from the type A\n----------\n");
    }

    public void test040b() {
        this.runNegativeTest(new String[]{"A.java", "import java.util.*;\nclass A { List<String> getList() { return null; } }\nclass B extends A { @Override List getList() { return null; } }\n"}, "----------\n1. WARNING in A.java (at line 3)\n\tclass B extends A { @Override List getList() { return null; } }\n\t                              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in A.java (at line 3)\n\tclass B extends A { @Override List getList() { return null; } }\n\t                              ^^^^\nType safety: The return type List for getList() from the type B needs unchecked conversion to conform to List<String> from the type A\n----------\n");
    }

    public void test040c() {
        this.runNegativeTest(new String[]{"X.java", "interface X<T> { X<T> x(); }\nabstract class Y<S> implements X<S> { public abstract X x(); }\nabstract class Z implements X { public abstract X x(); }\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tabstract class Y<S> implements X<S> { public abstract X x(); }\n\t                                                      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tabstract class Y<S> implements X<S> { public abstract X x(); }\n\t                                                      ^\nType safety: The return type X for x() from the type Y<S> needs unchecked conversion to conform to X<T> from the type X<T>\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X x(); }\n\t                            ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X x(); }\n\t                                                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test040d() {
        this.runNegativeTest(new String[]{"X.java", "interface X<T> { X<T>[] x(); }\nabstract class Y<S> implements X<S> { public abstract X[] x(); }\nabstract class Z implements X { public abstract X[] x(); }\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tabstract class Y<S> implements X<S> { public abstract X[] x(); }\n\t                                                      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tabstract class Y<S> implements X<S> { public abstract X[] x(); }\n\t                                                      ^^^\nType safety: The return type X[] for x() from the type Y<S> needs unchecked conversion to conform to X<T>[] from the type X<T>\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X[] x(); }\n\t                            ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X[] x(); }\n\t                                                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "public class X { public void foo(String... n) {} }\ninterface I { void foo(String[] n); }\nclass Y extends X implements I { }\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Y extends X implements I { }\n\t      ^\nVarargs methods should only override or be overridden by other varargs methods unlike X.foo(String...) and I.foo(String[])\n----------\n");
    }

    public void test041a() {
        this.runNegativeTest(new String[]{"X.java", "public class X { public void foo(String[] n) {} }\ninterface I { void foo(String... n); }\nclass Y extends X implements I { }\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Y extends X implements I { }\n\t      ^\nVarargs methods should only override or be overridden by other varargs methods unlike X.foo(String[]) and I.foo(String...)\n----------\n");
    }

    public void test041b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic Y foo() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\t((I) new Y()).foo();\n\t}\n}\ninterface I { X foo(); }\nclass Y extends X implements I { }\n"}, "SUCCESS");
    }

    public void test041c() {
        this.runNegativeTest(new String[]{"X.java", "public class X { public A foo() { return null; } }\ninterface I { A<String> foo(); }\nclass Y extends X implements I { }\nclass A<T> { }\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X { public A foo() { return null; } }\n\t                        ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tclass Y extends X implements I { }\n\t      ^\nType safety: The return type A for foo() from the type X needs unchecked conversion to conform to A<String> from the type I\n----------\n");
    }

    public void test041d() {
        this.runNegativeTest(new String[]{"X.java", "public class X { public Object foo() { return null; } }\ninterface I { <T> T foo(); }\nclass Y extends X implements I { }\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Y extends X implements I { }\n\t      ^\nType safety: The return type Object for foo() from the type X needs unchecked conversion to conform to T from the type I\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "interface Callable<T>\n{\n    public enum Result { GOOD, BAD };\n    public Result call(T arg);\n}\n\npublic class X implements Callable<String>\n{\n    public Result call(String arg) { return Result.GOOD; } // Warning line\n}\n"}, "");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test(E<Integer,Integer> e) { e.id(new Integer(1)); } }\nabstract class C<A> { public abstract void id(A x); }\ninterface I<B> { void id(B x); }\nabstract class E<A, B> extends C<A> implements I<B> {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tabstract class E<A, B> extends C<A> implements I<B> {}\n\t               ^\nName clash: The method id(A) of type C<A> has the same erasure as id(B) of type I<B> but does not override it\n----------\n");
    }

    public void test043a() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test(E<Integer,Integer> e) { e.id(new Integer(2)); } }\nabstract class C<A extends Number> { public abstract void id(A x); }\ninterface I<B> { void id(B x); }\nabstract class E<A extends Number, B> extends C<A> implements I<B> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tpublic class X { void test(E<Integer,Integer> e) { e.id(new Integer(2)); } }\r\n\t                                                     ^^\nThe method id(Integer) is ambiguous for the type E<Integer,Integer>\n----------\n");
    }

    public void test043b() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test(E<Integer,Integer> e) { e.id(new Integer(111)); } }\nabstract class C<A extends Number> { public void id(A x) {} }\ninterface I<B> { void id(B x); }\nclass E<A extends Number, B> extends C<A> implements I<B> { public void id(B b) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tpublic class X { void test(E<Integer,Integer> e) { e.id(new Integer(111)); } }\r\n\t                                                     ^^\nThe method id(Integer) is ambiguous for the type E<Integer,Integer>\n----------\n");
    }

    public void test043c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test(E<Integer,Integer> e) { e.id(new Integer(111)); }\n\tvoid test(M<Integer,Integer> m) {\n\t\tm.id(new Integer(111));\n\t\t((E<Integer, Integer>) m).id(new Integer(111));\n\t}\n\tvoid test(N<Integer> n) { n.id(new Integer(111)); }\n}\nabstract class C<A extends Number> { public void id(A x) {} }\ninterface I<B> { void id(B x); }\nabstract class E<A extends Number, B> extends C<A> implements I<B> {}\nclass M<A extends Number, B> extends E<A, B> { public void id(B b) {} }\nabstract class N<T extends Number> extends E<T, Number> { @Override public void id(T n) {} }\n"}, "----------\n1. ERROR in X.java (at line 4)\r\n\tm.id(new Integer(111));\r\n\t  ^^\nThe method id(Integer) is ambiguous for the type M<Integer,Integer>\n----------\n");
    }

    public void test043d() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.Y.*;\nimport static p.Z.*;\npublic class X {\n\tY data = null;\n\tpublic X() { foo(data.l); }\n}\n", "p/Y.java", "package p;\nimport java.util.List;\npublic class Y {\n\tList l = null;\n\tpublic static <T> void foo(T... e) {}\n}\n", "p/Z.java", "package p;\nimport java.util.List;\npublic class Z {\n\tpublic static <T> void foo(List<T>... e) {}\n}\n"}, "----------\n1. WARNING in p\\X.java (at line 6)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: Unchecked invocation foo(List...) of the generic method foo(List<T>...) of type Z\n----------\n2. WARNING in p\\X.java (at line 6)\n\tpublic X() { foo(data.l); }\n\t                 ^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<T>\n----------\n----------\n1. WARNING in p\\Y.java (at line 4)\n\tList l = null;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test043e() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.Y.*;\npublic class X {\n\tY data = null;\n\tpublic X() { foo(data.l); }\n}\n", "p/Y.java", "package p;\nimport java.util.List;\npublic class Y {\n\tList l = null;\n\tpublic static <T> void foo(T... e) {}\n\tpublic static <T> void foo(List<T>... e) {}\n}\n"}, "----------\n1. WARNING in p\\X.java (at line 5)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: Unchecked invocation foo(List...) of the generic method foo(List<T>...) of type Y\n----------\n2. WARNING in p\\X.java (at line 5)\n\tpublic X() { foo(data.l); }\n\t                 ^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<T>\n----------\n----------\n1. WARNING in p\\Y.java (at line 4)\n\tList l = null;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test043f() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid test(M<Integer,Integer> m) {\n\t\tm.id(new Integer(111), new Integer(112));\n\t}\n}\nabstract class C<T1 extends Number> { public <U1 extends Number> void id(T1 x, U1 u) {} }\ninterface I<T2> { }\nabstract class E<T3 extends Number, T4> extends C<T3> implements I<T4> {}\nclass M<T5 extends Number, T6> extends E<T5, T6> { public <U2 extends Number> void id(T5 b, U2 u) {} }\n"}, "");
    }

    public void test043g() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test(M<Integer,Integer> m) {\n\t\tm.id(new Integer(111));\n\t}\n}\nabstract class C<T1 extends Number> { public void id(T1 x) {} }\ninterface I<T2> { void id(T2 x); }\nabstract class E<T3 extends Number, T4> extends C<T3> implements I<T4> {}\nclass M<T5 extends Number, T6> extends E<T5, T6> { public void id(T6 b) {} }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tm.id(new Integer(111));\n\t  ^^\nThe method id(Integer) is ambiguous for the type M<Integer,Integer>\n----------\n");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public class X { final void foo() {} }\nclass XS extends X { @Override void foo() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass XS extends X { @Override void foo() {} }\n\t                                    ^^^^^\nCannot override the final method from X\n----------\n");
    }

    public void test044a() {
        this.runNegativeTest(new String[]{"X.java", "public class X { public void foo() {} }\nclass XS extends X { @Override void foo() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass XS extends X { @Override void foo() {} }\n\t                                    ^^^^^\nCannot reduce the visibility of the inherited method from X\n----------\n");
    }

    public void test044b() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void foo() {} }\nclass XS extends X { @Override void foo() throws ClassNotFoundException {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass XS extends X { @Override void foo() throws ClassNotFoundException {} }\n\t                                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nException ClassNotFoundException is not compatible with throws clause in X.foo()\n----------\n");
    }

    public void test044c() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void foo() {} }\nclass XS extends X { @Override int foo() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass XS extends X { @Override int foo() {} }\n\t                               ^^^\nThe return type is incompatible with X.foo()\n----------\n");
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "class Foo {}\n\ninterface Bar {\n  Foo get(Class<?> c);\n}\npublic class X implements Bar {\n  public Foo get(Class c) { return null; }\n}\n"}, "");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "interface IX <T> {\n\tpublic T doSomething();\n}\npublic class X implements IX<Integer> {\n   Zork z;\n\tpublic Integer doSomething() {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "interface Interface {\n    Number getValue();\n}\nclass C1 {\n    public Double getValue() {\n        return 0.0;\n    }\n}\npublic class X extends C1 implements Interface{\n    public static void main(String[] args) {\n        Interface i=new X();\n        System.out.println(i.getValue());\n    }\n}\n"}, "0.0");
    }

    public void test048() {
        this.runConformTest(new String[]{"X1.java", "import java.util.*;\npublic class X1 extends LinkedHashMap<String, String> {\n    public Object putAll(Map<String,String> a) { return null; }\n}\n"}, "");
    }

    public void test048a() {
        this.runConformTest(new String[]{"X2.java", "public class X2 extends Y<String> {\n    public Object foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public void foo(I<? extends T> a) {}\n}\ninterface I<T> {\n    public void foo(I<? extends T> a);\n}\n"}, "");
    }

    public void test048b() {
        this.runNegativeTest(new String[]{"X3.java", "public class X3 extends Y<String> {\n    public void foo(I<String> z) {}\n}\nclass Y<T> implements I<T> {\n    public void foo(I<? extends T> a) {}\n}\ninterface I<T> {\n    public void foo(I<? extends T> a);\n}\n"}, "----------\n1. ERROR in X3.java (at line 2)\r\n\tpublic void foo(I<String> z) {}\r\n\t            ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X3 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n");
    }

    public void test048c() {
        this.runConformTest(new String[]{"X4.java", "public class X4 extends Y<String> {\n    public String foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public Object foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public Object foo(I<? extends T> a);\n}\n"}, "");
    }

    public void test048d() {
        this.runConformTest(new String[]{"X5.java", "public class X5 extends Y<String> {\n    public Object foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public String foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public String foo(I<? extends T> a);\n}\n"}, "");
    }

    public void test048e() {
        this.runConformTest(new String[]{"X6.java", "public class X6 extends Y<String> {\n    public void foo(I<String> z) {}\n}\nclass Y<T> implements I<T> {\n    public Object foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public Object foo(I<? extends T> a);\n}\n"}, "");
    }

    public void test048f() {
        this.runConformTest(new String[]{"X7.java", "public class X7 extends Y<String> {\n    public String foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public T foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public T foo(I<? extends T> a);\n}\n"}, "");
    }

    public void test048g() {
        this.runNegativeTest(new String[]{"X8.java", "public class X8 extends Y<String> {\n    public Object foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public T foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public T foo(I<? extends T> a);\n}\n"}, "----------\n1. ERROR in X8.java (at line 2)\r\n\tpublic Object foo(I<String> z) { return null; }\r\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X8 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tT id(T x) { return x; }\n\tA id(A x) { return x; }\n}\nclass Y<T extends A> extends X<T> {\n\t@Override T id(T x) { return x; }\n\t@Override A id(A x) { return x; }\n}\nclass A {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tclass Y<T extends A> extends X<T> {\n\t      ^\nName clash: The method id(A) of type X<T> has the same erasure as id(T) of type X<T> but does not override it\n----------\n2. ERROR in X.java (at line 6)\n\t@Override T id(T x) { return x; }\n\t            ^^^^^^^\nMethod id(T) has the same erasure id(A) as another method in type Y<T>\n----------\n3. ERROR in X.java (at line 7)\n\t@Override A id(A x) { return x; }\n\t            ^^^^^^^\nDuplicate method id(A) in type Y<T>\n----------\n");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\t public static <S extends A> S foo() { System.out.print(\"A\"); return null; }\n\t\t public static <N extends B> N foo() { System.out.print(\"B\"); return null; }\n\t\t public static void main(String[] args) {\n\t\t \tX.<A>foo();\n\t\t \tX.<B>foo();\n\t\t \tnew X().<B>foo();\n\t\t }\n}\nclass A {}\nclass B {}\n"}, "ABB");
    }

    public void test050a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t public static <S extends A> void foo() { System.out.print(\"A\"); }\n\t\t public static <N extends B> N foo() { System.out.print(\"B\"); return null; }\n\t\t static void test () {\n\t\t \tX.foo();\n\t\t \tfoo();\n\t\t }\n}\nclass A {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 5)\r\n\tX.foo();\r\n\t  ^^^\nThe method foo() is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 6)\r\n\tfoo();\r\n\t^^^\nThe method foo() is ambiguous for the type X\n----------\n");
    }

    public void test050b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass C1 {\n\t\tY foo(Object o) {  return null; } // duplicate\n\t\tZ foo(Object o) {  return null; } // duplicate\n\t}\n\tclass C2 {\n\t\t<T extends Y> T foo(Object o) {  return null; } // ok\n\t\t<T extends Z> T foo(Object o) {  return null; } // ok\n\t}\n\tclass C3 {\n\t\tA<Y> foo(Object o) {  return null; } // duplicate\n\t\tA<Z> foo(Object o) {  return null; } // duplicate\n\t}\n\tclass C4 {\n\t\tY foo(Object o) {  return null; } // duplicate\n\t\t<T extends Z> T foo(Object o) {  return null; } // duplicate\n\t}\n}\nclass A<T> {}class Y {}class Z {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tY foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C1\n----------\n2. ERROR in X.java (at line 4)\n\tZ foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C1\n----------\n3. ERROR in X.java (at line 11)\n\tA<Y> foo(Object o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C3\n----------\n4. ERROR in X.java (at line 12)\n\tA<Z> foo(Object o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C3\n----------\n5. ERROR in X.java (at line 15)\n\tY foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C4\n----------\n6. ERROR in X.java (at line 16)\n\t<T extends Z> T foo(Object o) {  return null; } // duplicate\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C4\n----------\n");
    }

    public void test050c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass C5 {\n\t\tA<Y> foo(A<Y> o) {  return null; } // duplicate\n\t\tA<Z> foo(A<Z> o) {  return null; } // duplicate\n\t}\n\tclass C6 {\n\t\t<T extends Y> T foo(A<Y> o) {  return null; } // ok\n\t\t<T extends Z> T foo(A<Z> o) {  return null; } // ok\n\t}\n}\nclass A<T> {}class Y {}class Z {}"}, "----------\n1. ERROR in X.java (at line 3)\r\n\tA<Y> foo(A<Y> o) {  return null; } // duplicate\r\n\t     ^^^^^^^^^^^\nDuplicate method foo(A<Y>) in type X.C5\n----------\n2. ERROR in X.java (at line 4)\r\n\tA<Z> foo(A<Z> o) {  return null; } // duplicate\r\n\t     ^^^^^^^^^^^\nDuplicate method foo(A<Z>) in type X.C5\n----------\n");
    }

    public void test050d() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tclass C7 {\n\t\t<T extends Y, U> T foo(Object o) {  return null; } // ok\n\t\t<T extends Z> T foo(Object o) {  return null; } // ok\n\t}\n}\nclass A<T> {}class Y {}class Z {}"}, "");
    }

    public void test050e() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N a(A<String> s) { return null; }\n\t\t <N> Object a(A<Number> n) { return null; }\n\t\t <N extends B> void b(A<String> s) {}\n\t\t <N extends B> B b(A<Number> n) { return null; }\n\t\t void c(A<String> s) {}\n\t\t B c(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "");
    }

    public void test050f() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N a(A<String> s) { return null; }\n\t\t <N> B a(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<N extends B> N a(A<String> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nDuplicate method a(A<String>) in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N> B a(A<Number> n) { return null; }\n\t      ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n");
    }

    public void test050g() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N b(A<String> s) { return null; }\n\t\t <N extends B> B b(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\t<N extends B> N b(A<String> s) { return null; }\r\n\t                ^^^^^^^^^^^^^^\nDuplicate method b(A<String>) in type X\n----------\n2. ERROR in X.java (at line 3)\r\n\t<N extends B> B b(A<Number> n) { return null; }\r\n\t                ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n");
    }

    public void test050h() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t B c(A<String> s) { return null; }\n\t\t B c(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\tB c(A<String> s) { return null; }\r\n\t  ^^^^^^^^^^^^^^\nDuplicate method c(A<String>) in type X\n----------\n2. ERROR in X.java (at line 3)\r\n\tB c(A<Number> n) { return null; }\r\n\t  ^^^^^^^^^^^^^^\nDuplicate method c(A<Number>) in type X\n----------\n");
    }

    public void test050i() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N a(A<Number> s) { return null; }\n\t\t <N> Object a(A<Number> n) { return null; }\n\t\t <N extends B> N b(A<Number> s) { return null; }\n\t\t <N> Object b(A<String> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "");
    }

    public void test050j() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N a(A<Number> s) { return null; }\n\t\t <N> B a(A<Number> n) { return null; }\n\t\t <N extends B> N b(A<Number> s) { return null; }\n\t\t <N> B b(A<String> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\t<N extends B> N a(A<Number> s) { return null; }\r\n\t                ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n2. ERROR in X.java (at line 3)\r\n\t<N> B a(A<Number> n) { return null; }\r\n\t      ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n3. ERROR in X.java (at line 4)\r\n\t<N extends B> N b(A<Number> s) { return null; }\r\n\t                ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n4. ERROR in X.java (at line 5)\r\n\t<N> B b(A<String> n) { return null; }\r\n\t      ^^^^^^^^^^^^^^\nDuplicate method b(A<String>) in type X\n----------\n");
    }

    public void test050k() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> void a(A<Number> s) {}\n\t\t <N extends B> B a(A<Number> n) { return null; }\n\t\t <N extends B> Object b(A<Number> s) { return null; }\n\t\t <N extends B> B b(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<N extends B> void a(A<Number> s) {}\n\t                   ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N extends B> B a(A<Number> n) { return null; }\n\t                ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n3. ERROR in X.java (at line 4)\n\t<N extends B> Object b(A<Number> s) { return null; }\n\t                     ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n4. ERROR in X.java (at line 5)\n\t<N extends B> B b(A<Number> n) { return null; }\n\t                ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n");
    }

    public void test050l() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t void a(A<Number> s) {}\n\t\t B a(A<Number> n) { return null; }\n\t\t Object b(A<Number> s) {}\n\t\t B b(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\tvoid a(A<Number> s) {}\r\n\t     ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n2. ERROR in X.java (at line 3)\r\n\tB a(A<Number> n) { return null; }\r\n\t  ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n3. ERROR in X.java (at line 4)\r\n\tObject b(A<Number> s) {}\r\n\t       ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n4. ERROR in X.java (at line 5)\r\n\tB b(A<Number> n) { return null; }\r\n\t  ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements I {\n\t\t public <T extends I> void foo(T t) {}\n}\ninterface I {\n\t\t <T> void foo(T t);\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tpublic class X implements I {\r\n\t             ^\nThe type X must implement the inherited abstract method I.foo(T)\n----------\n");
    }

    public void test051a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(A<String> a) {}\n\tvoid foo(A<Integer> a) {}\n}\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\tvoid foo(A<String> a) {}\r\n\t     ^^^^^^^^^^^^^^^^\nDuplicate method foo(A<String>) in type X\n----------\n2. ERROR in X.java (at line 3)\r\n\tvoid foo(A<Integer> a) {}\r\n\t     ^^^^^^^^^^^^^^^^^\nDuplicate method foo(A<Integer>) in type X\n----------\n");
    }

    public void test051b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(A<String> a) {}\n\tObject foo(A<Integer> a) { return null; }\n}\nclass A<T> {}\n"}, "");
    }

    public void test052() {
        this.runConformTest(new String[]{"A.java", "public class A<T> {\n\tpublic A test() { return null; }\n\tpublic A<T> test2() { return null; }\n\tpublic A<X> test3() { return null; }\n\tpublic <U> A<U> test4() { return null; }\n}\nclass B extends A<X> {\n\t@Override public B test() { return null; }\n\t@Override public B test2() { return null; }\n\t@Override public B test3() { return null; }\n\t@Override public <U> A<U> test4() { return null; }\n}\nclass X{}\n"}, "");
    }

    public void test052a() {
        this.runNegativeTest(new String[]{"A.java", "public class A<T> {\n\tpublic <U> A<U> test() { return null; }\n\tpublic <U> A<U> test2() { return null; }\n\tpublic <U> A<U> test3() { return null; }\n}\nclass B extends A<X> {\n\t@Override public B test() { return null; }\n\t@Override public A test2() { return null; }\n\t@Override public A<X> test3() { return null; }\n}\nclass X{}\n"}, "----------\n1. WARNING in A.java (at line 7)\n\t@Override public B test() { return null; }\n\t                 ^\nType safety: The return type B for test() from the type B needs unchecked conversion to conform to A<Object> from the type A<X>\n----------\n2. WARNING in A.java (at line 8)\n\t@Override public A test2() { return null; }\n\t                 ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n3. WARNING in A.java (at line 8)\n\t@Override public A test2() { return null; }\n\t                 ^\nType safety: The return type A for test2() from the type B needs unchecked conversion to conform to A<U> from the type A<T>\n----------\n4. WARNING in A.java (at line 9)\n\t@Override public A<X> test3() { return null; }\n\t                 ^\nType safety: The return type A<X> for test3() from the type B needs unchecked conversion to conform to A<Object> from the type A<X>\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tvoid test(A a) { B b = a.foo(); }\n\tvoid test2(A<X> a) { B b = a.foo(); }\n\tvoid test3(B b) { B bb = b.foo(); }\n}\nclass A<T> {\n\t<U> A<U> foo() { return null; }\n}\nclass B extends A<X> {\n\t@Override B foo() { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid test(A a) { B b = a.foo(); }\n\t          ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tvoid test(A a) { B b = a.foo(); }\n\t                       ^^^^^^^\nType mismatch: cannot convert from A to B\n----------\n3. ERROR in X.java (at line 3)\n\tvoid test2(A<X> a) { B b = a.foo(); }\n\t                           ^^^^^^^\nType mismatch: cannot convert from A<Object> to B\n----------\n4. WARNING in X.java (at line 10)\n\t@Override B foo() { return null; }\n\t          ^\nType safety: The return type B for foo() from the type B needs unchecked conversion to conform to A<Object> from the type A<X>\n----------\n");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid a(Object x) {}\n\t<T> T a(T x) {  return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid a(Object x) {}\n\t     ^^^^^^^^^^^\nDuplicate method a(Object) in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<T> T a(T x) {  return null; }\n\t      ^^^^^^\nMethod a(T) has the same erasure a(Object) as another method in type X\n----------\n");
    }

    public void test054a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T1, T2> String aaa(X x) {  return null; }\n\t<T extends X> T aaa(T x) {  return null; }\n\t<T> String aa(X x) {  return null; }\n\t<T extends X> T aa(T x) {  return null; }\n\tString a(X x) {  return null; }\n\t<T extends X> T a(T x) {  return null; }\n\t<T> String z(X x) { return null; }\n\t<T, S> Object z(X x) { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\r\n\tString a(X x) {  return null; }\r\n\t       ^^^^^^\nDuplicate method a(X) in type X\n----------\n2. ERROR in X.java (at line 7)\r\n\t<T extends X> T a(T x) {  return null; }\r\n\t                ^^^^^^\nMethod a(T) has the same erasure a(X) as another method in type X\n----------\n");
    }

    public void test054b() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\t\t Object foo(X<T> t) { return null; }\n\t\t <S> String foo(X<T> s) { return null; }\n}\n"}, "");
    }

    public void test054c() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\t\t<T1 extends X<T1>> void dupT() {}\n\t\t<T2 extends X<T2>> Object dupT() {return null;}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\t<T1 extends X<T1>> void dupT() {}\r\n\t                        ^^^^^^\nDuplicate method dupT() in type X<T>\n----------\n2. ERROR in X.java (at line 3)\r\n\t<T2 extends X<T2>> Object dupT() {return null;}\r\n\t                          ^^^^^^\nDuplicate method dupT() in type X<T>\n----------\n");
    }

    public void test054d() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t<T> T a(A<T> t) {return null;}\n\t<T> String a(A<Object> o) {return null;}\n\t<T> T aa(A<T> t) {return null;}\n\tString aa(A<Object> o) {return null;}\n}\nclass A<T> {}\n"}, "");
    }

    public void test055() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tA a = new C();\n\t\ttry { a.f(new Object()); } catch (ClassCastException e) {\n\t\t\tSystem.out.println(1);\n\t\t}\n\t}\n}\ninterface A<T> { void f(T x); }\ninterface B extends A<String> { void f(String x); }\nclass C implements B { public void f(String x) {} }\n"}, "1");
    }

    public void test056() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static String bind(String message, Object binding) { return null; }\n   public static String bind(String message, Object[] bindings) { return null; }\n}\nclass Y extends X {\n   public static String bind(String message, Object binding) { return null; }\n   public static String bind(String message, Object[] bindings) { return null; }\n}\nclass Z {\n   void bar() { Y.bind(\"\", new String[] {\"\"}); }\n}\n"}, "");
    }

    public void test057() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n   \tA<Integer> x = new A<Integer>();\n   \tB<Integer> y = new B<Integer>();\n   \tnew X().print(x);\n   \tnew X().print(y);\n\t}\n\tpublic <T extends IA<?>> void print(T a) { System.out.print(1); }\n\tpublic <T extends IB<?>> void print(T a) { System.out.print(2); }\n}\ninterface IA<E> {}\ninterface IB<E> extends IA<E> {}\nclass A<E> implements IA<E> {}\nclass B<E> implements IB<E> {}\n"}, "12");
    }

    public void test057a() {
        this.runConformTest(new String[]{"XX.java", "public class XX {\n   public static void main(String[] args) {\n   \tA<Integer> x = new A<Integer>();\n   \tB<Integer> y = new B<Integer>();\n   \tprint(x);\n   \tprint(y);\n\t}\n\tpublic static <T extends IA<?>> void print(T a) { System.out.print(3); }\n\tpublic static <T extends IB<?>> void print(T a) { System.out.print(4); }\n}\ninterface IA<E> {}\ninterface IB<E> extends IA<E> {}\nclass A<E> implements IA<E> {}\nclass B<E> implements IB<E> {}\n"}, "34");
    }

    public void test058() {
        this.runConformTest(new String[]{"X.java", "public class X <B extends Number> {\n   public static void main(String[] args) {\n   \tX<Integer> x = new X<Integer>();\n   \tx.aaa(null);\n   \tx.aaa(15);\n\t}\n\t<T> T aaa(T t) { System.out.print('T'); return null; }\n\tvoid aaa(B b) { System.out.print('B'); }\n}\n"}, "BB");
    }

    public void test058a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n   void test() {\n   \tnew X<Object>().foo(\"X\");\n   \tnew X<Object>().foo2(\"X\");\n   }\n\t<T> T foo(T t) {return null;}\n\tvoid foo(A a) {}\n\t<T> T foo2(T t) {return null;}\n\t<T> void foo2(A a) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\r\n\tnew X<Object>().foo(\"X\");\r\n\t                ^^^\nThe method foo(String) is ambiguous for the type X<Object>\n----------\n2. ERROR in X.java (at line 4)\r\n\tnew X<Object>().foo2(\"X\");\r\n\t                ^^^^\nThe method foo2(String) is ambiguous for the type X<Object>\n----------\n");
    }

    public void test058b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> extends Y<A> {\n   void test() {\n   \tnew X<Object>().foo(\"X\");\n   \tnew X<Object>().foo2(\"X\");\n   }\n\t<T> T foo(T t) {return null;}\n\t<T> T foo2(T t) {return null;}\n}\nclass Y<A> {\n\tvoid foo(A a) {}\n\t<T> void foo2(A a) {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\r\n\tnew X<Object>().foo(\"X\");\r\n\t                ^^^\nThe method foo(String) is ambiguous for the type X<Object>\n----------\n2. ERROR in X.java (at line 4)\r\n\tnew X<Object>().foo2(\"X\");\r\n\t                ^^^^\nThe method foo2(String) is ambiguous for the type X<Object>\n----------\n");
    }

    public void test059() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {new B().foo(\"aa\");}\n}\nclass A { <U> void foo(U u) {System.out.print(false);} }\nclass B extends A { <V> void foo(String s) {System.out.print(true);} }\n"}, "true");
    }

    public void test059a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {new B().foo(\"aa\");}\n}\nclass A { <U> void foo(String s) {System.out.print(true);} }\nclass B extends A { <V> void foo(V v) {System.out.print(false);} }\n"}, "true");
    }

    public void test060() {
        this.runConformTest(new String[]{"I.java", "import java.util.Iterator;\npublic interface I {\n\tvoid method(Iterator<Object> iter);\n\tpublic static class TestClass implements I {\n\t\tpublic void method(Iterator iter) {}\n\t}\n}"}, "");
    }

    public void test060b() {
        this.runConformTest(new String[]{"I2.java", "import java.util.Iterator;\npublic interface I2 {\n\tvoid method(Iterator<Object>[] iter);\n\tpublic static class TestClass implements I2 {\n\t\tpublic void method(Iterator[] iter) {}\n\t}\n}"}, "");
    }

    public void test060c() {
        this.runNegativeTest(new String[]{"I3.java", "import java.util.Iterator;\npublic interface I3 {\n\tvoid method(Iterator<Object>[] iter);\n\tpublic static class TestClass implements I3 {\n\t\tpublic void method(Iterator[][] iter) {}\n\t}\n}"}, "----------\n1. ERROR in I3.java (at line 4)\n\tpublic static class TestClass implements I3 {\n\t                    ^^^^^^^^^\nThe type I3.TestClass must implement the inherited abstract method I3.method(Iterator<Object>[])\n----------\n2. WARNING in I3.java (at line 5)\n\tpublic void method(Iterator[][] iter) {}\n\t                   ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"Try.java", "public class Try {\n\tpublic static void main(String[] args) {\n\t\tEx<String> ex = new Ex<String>();\n\t\tex.one(\"eclipse\", new Integer(1));\n\t\tex.two(new Integer(1));\n\t\tex.three(\"eclipse\");\n\t\tex.four(\"eclipse\");\n\t\tSystem.out.print(',');\n\t\tEx ex2 = ex;\n\t\tex2.one(\"eclipse\", new Integer(1));\n\t\tex2.two(new Integer(1));\n\t\tex2.three(\"eclipse\");\n\t\tex2.four(\"eclipse\");\n\t}\n}\nclass Top<TC> {\n\t<TM> void one(TC cTop, TM mTop) { System.out.print(-1); }\n\t<TM> void two(TM mTop) { System.out.print(-2); }\n\tvoid three(TC cTop) { System.out.print(-3); }\n\t<TM> void four(TC cTop) { System.out.print(-4); }\n}\nclass Ex<C> extends Top<C> {\n\t@Override <M> void one(C cEx, M mEx) { System.out.print(1); }\n\t@Override <M> void two(M mEx) { System.out.print(2); }\n\t@Override void three(C cEx) { System.out.print(3); }\n\t@Override <M> void four(C cEx) { System.out.print(4); }\n}"}, "----------\n1. WARNING in Try.java (at line 9)\n\tEx ex2 = ex;\n\t^^\nEx is a raw type. References to generic type Ex<C> should be parameterized\n----------\n2. WARNING in Try.java (at line 10)\n\tex2.one(\"eclipse\", new Integer(1));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method one(Object, Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n3. WARNING in Try.java (at line 11)\n\tex2.two(new Integer(1));\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method two(Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n4. WARNING in Try.java (at line 12)\n\tex2.three(\"eclipse\");\n\t^^^^^^^^^^^^^^^^^^^^\nType safety: The method three(Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n5. WARNING in Try.java (at line 13)\n\tex2.four(\"eclipse\");\n\t^^^^^^^^^^^^^^^^^^^\nType safety: The method four(Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n");
    }

    public void test062() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in Errors.java (at line 6)\n\tex.six(\"eclipse\");\n\t   ^^^\nThe method six(String) is ambiguous for the type Ex<String>\n----------\n2. WARNING in Errors.java (at line 7)\n\tEx ex2 = ex;\n\t^^\nEx is a raw type. References to generic type Ex<C> should be parameterized\n----------\n3. WARNING in Errors.java (at line 9)\n\tex2.five(\"eclipse\");\n\t^^^^^^^^^^^^^^^^^^^\nType safety: The method five(Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n4. ERROR in Errors.java (at line 10)\n\tex2.six(\"eclipse\");\n\t    ^^^\nThe method six(Object) is ambiguous for the type Ex\n----------\n5. ERROR in Errors.java (at line 21)\n\t@Override <M> void six(C cEx) {}\n\t                   ^^^^^^^^^^\nName clash: The method six(C) of type Ex<C> has the same erasure as six(TC) of type Top<TC> but does not override it\n----------\n6. ERROR in Errors.java (at line 21)\n\t@Override <M> void six(C cEx) {}\n\t                   ^^^^^^^^^^\nThe method six(C) of type Ex<C> must override a superclass method\n----------\n" : "----------\n1. ERROR in Errors.java (at line 6)\n\tex.six(\"eclipse\");\n\t   ^^^\nThe method six(String) is ambiguous for the type Ex<String>\n----------\n2. WARNING in Errors.java (at line 7)\n\tEx ex2 = ex;\n\t^^\nEx is a raw type. References to generic type Ex<C> should be parameterized\n----------\n3. WARNING in Errors.java (at line 9)\n\tex2.five(\"eclipse\");\n\t^^^^^^^^^^^^^^^^^^^\nType safety: The method five(Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n4. ERROR in Errors.java (at line 10)\n\tex2.six(\"eclipse\");\n\t    ^^^\nThe method six(Object) is ambiguous for the type Ex\n----------\n5. ERROR in Errors.java (at line 21)\n\t@Override <M> void six(C cEx) {}\n\t                   ^^^^^^^^^^\nName clash: The method six(C) of type Ex<C> has the same erasure as six(TC) of type Top<TC> but does not override it\n----------\n6. ERROR in Errors.java (at line 21)\n\t@Override <M> void six(C cEx) {}\n\t                   ^^^^^^^^^^\nThe method six(C) of type Ex<C> must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"Errors.java", "public class Errors {\n\tvoid foo() {\n\t\tEx<String> ex = new Ex<String>();\n\t\tex.proof(\"eclipse\");\n\t\tex.five(\"eclipse\");\n\t\tex.six(\"eclipse\");\n\t\tEx ex2 = ex;\n\t\tex2.proof(\"eclipse\");\n\t\tex2.five(\"eclipse\");\n\t\tex2.six(\"eclipse\");\n\t}\n}\nclass Top<TC> {\n\t<TM> void proof(Object cTop) {}\n\t<TM> void five(TC cTop) {}\n\tvoid six(TC cTop) {}\n}\nclass Ex<C> extends Top<C> {\n\t@Override void proof(Object cTop) {}\n\t@Override void five(C cEx) {}\n\t@Override <M> void six(C cEx) {}\n}"}, expectedOutput);
    }

    public void test063() {
        this.runConformTest(new String[]{"X.java", "interface IStructuredContentProvider<I, E extends I> {\n    public E[] getElements(I inputElement);\n    public E[] getChildren(E parent);\n}\n\npublic class X implements IStructuredContentProvider {\n// eclipse error: The type X must implement the inherited\n// abstract method IStructuredContentProvider.getChildren(I)\n\n    public Object[] getElements(Object inputElement) {\n        // eclipse error: The return type is incompatible with\n        // IStructuredContentProvider.getElements(Object)\n        return null;\n    }\n\n    public Object[] getChildren(Object parent) {\n        // eclipse error: Name clash: The method getChildren(Object) of type\n        // X has the same erasure as getChildren(E) of type\n        // IStructuredContentProvider<I,E> but does not override it\n        return null;\n    }\n}\n"}, "");
    }

    public void test064() {
        this.runConformTest(new String[]{"X.java", "interface IStructuredContentProvider<I, E extends I> {\n    public E[] getElements(I inputElement);\n    public E[] getChildren(E parent);\n}\n\npublic class X implements IStructuredContentProvider<Object,Object> {\n// eclipse error: The type X must implement the inherited\n// abstract method IStructuredContentProvider.getChildren(I)\n\n    public Object[] getElements(Object inputElement) {\n        // eclipse error: The return type is incompatible with\n        // IStructuredContentProvider.getElements(Object)\n        return null;\n    }\n\n    public Object[] getChildren(Object parent) {\n        // eclipse error: Name clash: The method getChildren(Object) of type\n        // X has the same erasure as getChildren(E) of type\n        // IStructuredContentProvider<I,E> but does not override it\n        return null;\n    }\n}\n"}, "");
    }

    public void test065() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\ninterface IStructuredContentProvider<I, E extends List<String>> {\n    public E[] getElements(I inputElement);\n    public E[] getChildren(E parent);\n}\n\npublic class X implements IStructuredContentProvider {\n// eclipse error: The type X must implement the inherited\n// abstract method IStructuredContentProvider.getChildren(I)\n\n    public List[] getElements(Object inputElement) {\n        // eclipse error: The return type is incompatible with\n        // IStructuredContentProvider.getElements(Object)\n        return null;\n    }\n\n    public List[] getChildren(List parent) {\n        // eclipse error: Name clash: The method getChildren(Object) of type\n        // X has the same erasure as getChildren(E) of type\n        // IStructuredContentProvider<I,E> but does not override it\n        return null;\n    }\n}\n"}, "");
    }

    public void test066() {
        this.runConformTest(new String[]{"JukeboxImpl.java", "public class JukeboxImpl implements Jukebox {\n    public <M extends Music,A extends Artist<M>> A getArtist (M music){return null;}\n    void test () { getArtist(new Rock()); }\n}\ninterface Jukebox {\n\t<M extends Music, A extends Artist<M>> A getArtist (M music);\n}\ninterface Music {}\nclass Rock implements Music {}\ninterface Artist<M extends Music> {}\n"}, "");
    }

    public void test067() {
        this.runConformTest(new String[]{"NoErrors.java", "public class NoErrors {\n    public static void main(String[] args) { new B().foo2(1, 10); }\n}\nclass A<T> {\n\t<S1 extends T> void foo2(Number t, S1 s) { System.out.print(false); }\n}\nclass B extends A<Number> {\n\t<S2 extends Number> void foo2(Number t, S2 s) { System.out.print(true); }\n}\n"}, "true");
    }

    public void test068() {
        this.runConformTest(new String[]{"ReflectionNavigator.java", "import java.lang.reflect.Type;\npublic class ReflectionNavigator implements Navigator<Type> {\n    public <T> Class<T> erasure(Type t) { return null; }\n}\ninterface Navigator<TypeT> {\n\t<T> TypeT erasure(TypeT x);\n}\nclass Usage {\n\tpublic void foo(ReflectionNavigator r, Type t) { r.erasure(t); }\n}\n"}, "");
    }

    public void test069() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.reflect.Type;\npublic class X implements I<A> {\n    public <N extends A> void x1() {}\n    public <N extends Number> void x2() {}\n    public <N extends Number> void x3() {}\n}\ninterface I<V> {\n\t<N extends V> void x1();\n\t<N extends String> void x2();\n\t<N extends Object> void x3();\n}\nclass A {}\nclass B<T> {}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\tpublic class X implements I<A> {\r\n\t             ^\nThe type X must implement the inherited abstract method I<A>.x3()\n----------\n2. ERROR in X.java (at line 2)\r\n\tpublic class X implements I<A> {\r\n\t             ^\nThe type X must implement the inherited abstract method I<A>.x2()\n----------\n3. ERROR in X.java (at line 4)\r\n\tpublic <N extends Number> void x2() {}\r\n\t                               ^^^^\nName clash: The method x2() of type X has the same erasure as x2() of type I<V> but does not override it\n----------\n4. ERROR in X.java (at line 5)\r\n\tpublic <N extends Number> void x3() {}\r\n\t                               ^^^^\nName clash: The method x3() of type X has the same erasure as x3() of type I<V> but does not override it\n----------\n5. WARNING in X.java (at line 9)\r\n\t<N extends String> void x2();\r\n\t           ^^^^^^\nThe type parameter N should not be bounded by the final type String. Final types cannot be further extended\n----------\n");
    }

    public void test070() {
        this.runNegativeTest(new String[]{"BooleanFactory.java", "interface Factory<T> {\n\t<U extends T> U create(Class<U> c);\n}\npublic class BooleanFactory implements Factory<Boolean> {\n\tpublic <U extends Boolean> U create(Class<U> c) {\n\t\ttry { return c.newInstance(); } catch(Exception e) { return null; }\n\t}\n}\n"}, "----------\n1. WARNING in BooleanFactory.java (at line 5)\n\tpublic <U extends Boolean> U create(Class<U> c) {\n\t                  ^^^^^^^\nThe type parameter U should not be bounded by the final type Boolean. Final types cannot be further extended\n----------\n");
    }

    public void test071() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in D.java (at line 2)\r\n\t@Override void m(Number t) {}\r\n\t               ^^^^^^^^^^^\nName clash: The method m(Number) of type D has the same erasure as m(T) of type A<T> but does not override it\n----------\n2. ERROR in D.java (at line 2)\r\n\t@Override void m(Number t) {}\r\n\t               ^^^^^^^^^^^\nThe method m(Number) of type D must override a superclass method\n----------\n3. WARNING in D.java (at line 6)\r\n\tclass B<S extends Integer> extends A<S> { @Override void m(S t) {} }\r\n\t                  ^^^^^^^\nThe type parameter S should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n" : "----------\n1. ERROR in D.java (at line 2)\n\t@Override void m(Number t) {}\n\t               ^^^^^^^^^^^\nName clash: The method m(Number) of type D has the same erasure as m(T) of type A<T> but does not override it\n----------\n2. ERROR in D.java (at line 2)\n\t@Override void m(Number t) {}\n\t               ^^^^^^^^^^^\nThe method m(Number) of type D must override or implement a supertype method\n----------\n3. WARNING in D.java (at line 6)\n\tclass B<S extends Integer> extends A<S> { @Override void m(S t) {} }\n\t                  ^^^^^^^\nThe type parameter S should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n";
        this.runNegativeTest(new String[]{"D.java", "class D extends B<Integer> {\n\t@Override void m(Number t) {}\n\t@Override void m(Integer t) {}\n}\nclass A<T extends Number> { void m(T t) {} }\nclass B<S extends Integer> extends A<S> { @Override void m(S t) {} }"}, expectedOutput);
    }

    public void test072() {
        this.runConformTest(new String[]{"B.java", "class A<E> { E foo(E e) { return null; } }\nclass B<T> extends A<T> {\n\t@Override T foo(Object arg0) { return null; }\n}"}, "");
    }

    public void test073() {
        this.runConformTest(new String[]{"NumericArray.java", "class Array<T> {\n\tpublic void add(T t) { System.out.println(false); }\n}\npublic class NumericArray<T extends Number> extends Array<T> {\n\tpublic static void main(String[] s) { new NumericArray<Integer>().add(1); }\n\t@Override public void add(Number n) { System.out.println(true); }\n}"}, "true");
    }

    public void test073a() {
        this.runConformTest(new String[]{"NumericArray2.java", "class Array<T> {\n\tpublic T add(T t) { System.out.println(false); return null; }\n}\npublic class NumericArray2<T extends Number> extends Array<T> {\n\tpublic static void main(String[] s) { new NumericArray2<Integer>().add(1); }\n\t@Override public T add(Number n) { System.out.println(true); return null; }\n}"}, "true");
    }

    public void test073b() {
        this.runConformTest(new String[]{"NumericArray3.java", "class Array<T> {\n\tpublic <U extends Number> void add(U u) {}\n}\npublic class NumericArray3<T extends Number> extends Array<T> {\n\tpublic static void main(String[] s) { new NumericArray3<Integer>().add(1); }\n\t@Override public void add(Number n) { System.out.println(true); }\n}"}, "true");
    }

    public void test073c() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in NumericArray4.java (at line 5)\r\n\t@Override public <U> void add(Number n) {}\r\n\t                          ^^^^^^^^^^^^^\nThe method add(Number) of type NumericArray4<T> must override a superclass method\n----------\n" : "----------\n1. ERROR in NumericArray4.java (at line 5)\n\t@Override public <U> void add(Number n) {}\n\t                          ^^^^^^^^^^^^^\nThe method add(Number) of type NumericArray4<T> must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"NumericArray4.java", "class Array<T> {\n\tpublic <U> void add(T t) {}\n}\npublic class NumericArray4<T extends Number> extends Array<T> {\n\t@Override public <U> void add(Number n) {}\n}"}, expectedOutput);
    }

    public void test073d() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in NumericArray5.java (at line 5)\r\n\t@Override public void add(Number n, Integer i) {}\r\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^\nThe method add(Number, Integer) of type NumericArray5<T> must override a superclass method\n----------\n" : "----------\n1. ERROR in NumericArray5.java (at line 5)\n\t@Override public void add(Number n, Integer i) {}\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^\nThe method add(Number, Integer) of type NumericArray5<T> must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"NumericArray5.java", "class Array<T> {\n\tpublic <U> void add(T t, U u) {}\n}\npublic class NumericArray5<T extends Number> extends Array<T> {\n\t@Override public void add(Number n, Integer i) {}\n}"}, expectedOutput);
    }

    public void test074() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. WARNING in I.java (at line 2)\n\tinterface J extends I { @Override void clone(); }\n\t                                  ^^^^\nThe return type is incompatible with Object.clone(), thus this interface cannot be implemented\n----------\n2. ERROR in I.java (at line 2)\n\tinterface J extends I { @Override void clone(); }\n\t                                       ^^^^^^^\nThe method clone() of type J must override a superclass method\n----------\n" : "----------\n1. WARNING in I.java (at line 2)\n\tinterface J extends I { @Override void clone(); }\n\t                                  ^^^^\nThe return type is incompatible with Object.clone(), thus this interface cannot be implemented\n----------\n2. ERROR in I.java (at line 2)\n\tinterface J extends I { @Override void clone(); }\n\t                                       ^^^^^^^\nThe method clone() of type J must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"I.java", "interface I {}\ninterface J extends I { @Override void clone(); }"}, expectedOutput);
    }

    public void test074a() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. WARNING in I.java (at line 1)\n\tinterface I { @Override void clone(); }\n\t                        ^^^^\nThe return type is incompatible with Object.clone(), thus this interface cannot be implemented\n----------\n2. ERROR in I.java (at line 1)\n\tinterface I { @Override void clone(); }\n\t                             ^^^^^^^\nThe method clone() of type I must override a superclass method\n----------\n" : "----------\n1. WARNING in I.java (at line 1)\n\tinterface I { @Override void clone(); }\n\t                        ^^^^\nThe return type is incompatible with Object.clone(), thus this interface cannot be implemented\n----------\n2. ERROR in I.java (at line 1)\n\tinterface I { @Override void clone(); }\n\t                             ^^^^^^^\nThe method clone() of type I must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"I.java", "interface I { @Override void clone(); }\ninterface J extends I {}"}, expectedOutput);
    }

    public void test074b() {
        this.runNegativeTest(new String[]{"A.java", "interface I {\n\tint finalize();\n\tfloat hashCode();\n}\ninterface J extends I {}\nabstract class A implements J {}"}, "----------\n1. WARNING in A.java (at line 2)\n\tint finalize();\n\t^^^\nThe return type is incompatible with Object.finalize(), thus this interface cannot be implemented\n----------\n2. ERROR in A.java (at line 3)\n\tfloat hashCode();\n\t^^^^^\nThe return type is incompatible with Object.hashCode()\n----------\n3. ERROR in A.java (at line 6)\n\tabstract class A implements J {}\n\t               ^\nThe return type is incompatible with I.finalize(), Object.finalize()\n----------\n4. ERROR in A.java (at line 6)\n\tabstract class A implements J {}\n\t               ^\nThe return type is incompatible with I.hashCode(), Object.hashCode()\n----------\n");
    }

    public void test075() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in A.java (at line 2)\n\tclass B extends A { @Override <T1, S1 extends J & I<S1>> void foo() { } }\n\t                                                              ^^^^^\nName clash: The method foo() of type B has the same erasure as foo() of type A but does not override it\n----------\n2. ERROR in A.java (at line 2)\n\tclass B extends A { @Override <T1, S1 extends J & I<S1>> void foo() { } }\n\t                                                              ^^^^^\nThe method foo() of type B must override a superclass method\n----------\n3. WARNING in A.java (at line 3)\n\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n\t                                                  ^\nI is a raw type. References to generic type I<TT> should be parameterized\n----------\n4. ERROR in A.java (at line 3)\n\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n\t                                                          ^^^^^\nName clash: The method foo() of type C has the same erasure as foo() of type A but does not override it\n----------\n5. ERROR in A.java (at line 3)\n\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n\t                                                          ^^^^^\nThe method foo() of type C must override a superclass method\n----------\n" : "----------\n1. ERROR in A.java (at line 2)\n\tclass B extends A { @Override <T1, S1 extends J & I<S1>> void foo() { } }\n\t                                                              ^^^^^\nName clash: The method foo() of type B has the same erasure as foo() of type A but does not override it\n----------\n2. ERROR in A.java (at line 2)\n\tclass B extends A { @Override <T1, S1 extends J & I<S1>> void foo() { } }\n\t                                                              ^^^^^\nThe method foo() of type B must override or implement a supertype method\n----------\n3. WARNING in A.java (at line 3)\n\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n\t                                                  ^\nI is a raw type. References to generic type I<TT> should be parameterized\n----------\n4. ERROR in A.java (at line 3)\n\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n\t                                                          ^^^^^\nName clash: The method foo() of type C has the same erasure as foo() of type A but does not override it\n----------\n5. ERROR in A.java (at line 3)\n\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n\t                                                          ^^^^^\nThe method foo() of type C must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"A.java", "class A { <T, S extends J & I<T>> void foo() { } }\nclass B extends A { @Override <T1, S1 extends J & I<S1>> void foo() { } }\nclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\nclass D extends A { @Override <T3, S3 extends J & I<T3>> void foo() { } }\nclass E extends A { @Override <T4, S4 extends I<T4> & J> void foo() { } }\ninterface I<TT> {}\ninterface J {}"}, expectedOutput);
    }

    public void test075a() {
        this.runConformTest(new String[]{"A.java", "class A<U> { <S extends J> void foo(U u, S s) { } }\nclass B<V> extends A<V> { <S1 extends K> void foo(V v, S1 s) { } }\ninterface J {}\ninterface K extends J {}"}, "");
    }

    public void test075b() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in A.java (at line 2)\r\n\tclass B<V> extends A<V> { @Override <T1, S1 extends K & I<T1>> void foo(V v, T1 t, S1 s) { } }\r\n\t                                                                    ^^^^^^^^^^^^^^^^^^^^\nThe method foo(V, T1, S1) of type B<V> must override a superclass method\n----------\n" : "----------\n1. ERROR in A.java (at line 2)\n\tclass B<V> extends A<V> { @Override <T1, S1 extends K & I<T1>> void foo(V v, T1 t, S1 s) { } }\n\t                                                                    ^^^^^^^^^^^^^^^^^^^^\nThe method foo(V, T1, S1) of type B<V> must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"A.java", "class A<U> { <T, S extends J & I<T>> void foo(U u, T t, S s) { } }\nclass B<V> extends A<V> { @Override <T1, S1 extends K & I<T1>> void foo(V v, T1 t, S1 s) { } }\ninterface I<TT> {}\ninterface J {}\ninterface K extends J {}"}, expectedOutput);
    }

    public void test076() {
        this.runConformTest(new String[]{"A.java", "class A {\n\t<T, S extends J & I<S>> void foo(S s) { }\n\t<T, S extends I<T> & J > void foo(S s) { }\n}\ninterface I<TT> {}\ninterface J {}\n"}, "");
    }

    public void test076a() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\t<T, S extends J & I<T>> void foo() { }\n\t<T, S extends I<T> & J> void foo() { }\n}\ninterface I<TT> {}\ninterface J {}\n"}, "----------\n1. ERROR in A.java (at line 2)\r\n\t<T, S extends J & I<T>> void foo() { }\r\n\t                             ^^^^^\nDuplicate method foo() in type A\n----------\n2. ERROR in A.java (at line 3)\r\n\t<T, S extends I<T> & J> void foo() { }\r\n\t                             ^^^^^\nDuplicate method foo() in type A\n----------\n");
    }

    public void test076b() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\t<T, S extends J & I<T>> void foo() { }\n\t<T, S extends I<T> & K> void foo() { }\n}\ninterface I<TT> {}\ninterface J {}\ninterface K extends J {}"}, "----------\n1. ERROR in A.java (at line 2)\r\n\t<T, S extends J & I<T>> void foo() { }\r\n\t                             ^^^^^\nDuplicate method foo() in type A\n----------\n2. ERROR in A.java (at line 3)\r\n\t<T, S extends I<T> & K> void foo() { }\r\n\t                             ^^^^^\nDuplicate method foo() in type A\n----------\n");
    }

    public void test077() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tObject o = new A<Integer>().foo(new Integer(1));\n}\ninterface I<T1> { I<T1> foo(T1 t); }\ninterface J<T2> { J<T2> foo(T2 t); }\nclass B<T> { public A<T> foo(T t) { return new A<T>(); } }\nclass A<S> extends B<S> implements I<S>, J<S> {}"}, "");
    }

    public void test077a() {
        this.runNegativeTest(new String[]{"I.java", "public interface I { I foo(); }\ninterface J { J foo(); }\ninterface K extends I, J { K foo(); }\ninterface L { K getI(); }\ninterface M { I getI(); }\ninterface N { J getI(); }\ninterface O extends L, M, N { K getI(); }\ninterface P extends L, M, N {}\nclass X implements L, M, N { public K getI() { return null; } }\nabstract class Y implements L, M, N {}\nabstract class Z implements L, M, N { public K getI() { return null; } }\n"}, "----------\n1. ERROR in I.java (at line 8)\n\tinterface P extends L, M, N {}\n\t          ^\nThe return type is incompatible with N.getI(), M.getI(), L.getI()\n----------\n2. ERROR in I.java (at line 10)\n\tabstract class Y implements L, M, N {}\n\t               ^\nThe return type is incompatible with N.getI(), M.getI(), L.getI()\n----------\n");
    }

    public void test078() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.4");
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.4");
        this.runNegativeTest(new String[]{"X.java", "public abstract class X implements IAppendable {\n    public X append(char c) {\n        return null;\n    }\n}\n\ninterface IAppendable {\n\tIAppendable append(char c);\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic X append(char c) {\n\t       ^\nThe return type is incompatible with IAppendable.append(char)\n----------\n", null, true, customOptions);
    }

    public void test079() {
        this.runNegativeTest(new String[]{"A.java", "class A<E> { void x(A<String> s) {} }\nclass B extends A { void x(A<String> s) {} }\nclass C extends A { @Override void x(A s) {} }\nclass D extends A { void x(A<Object> s) {} }"}, "----------\n1. WARNING in A.java (at line 2)\r\n\tclass B extends A { void x(A<String> s) {} }\r\n\t                ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n2. ERROR in A.java (at line 2)\r\n\tclass B extends A { void x(A<String> s) {} }\r\n\t                         ^^^^^^^^^^^^^^\nName clash: The method x(A<String>) of type B has the same erasure as x(A) of type A but does not override it\n----------\n3. WARNING in A.java (at line 3)\r\n\tclass C extends A { @Override void x(A s) {} }\r\n\t                ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n4. WARNING in A.java (at line 3)\r\n\tclass C extends A { @Override void x(A s) {} }\r\n\t                                     ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n5. WARNING in A.java (at line 4)\r\n\tclass D extends A { void x(A<Object> s) {} }\r\n\t                ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n6. ERROR in A.java (at line 4)\r\n\tclass D extends A { void x(A<Object> s) {} }\r\n\t                         ^^^^^^^^^^^^^^\nName clash: The method x(A<Object>) of type D has the same erasure as x(A) of type A but does not override it\n----------\n");
    }

    public void test080() {
        this.runNegativeTest(new String[]{"HashOrder.java", "public class HashOrder extends DoubleHash<String> {\n\tpublic static HashOrder create() { return null; }\n}\nclass DoubleHash<T> {\n\tpublic static <U> DoubleHash<U> create() { return null; }\n}"}, "----------\n1. WARNING in HashOrder.java (at line 2)\n\tpublic static HashOrder create() { return null; }\n\t              ^^^^^^^^^\nType safety: The return type HashOrder for create() from the type HashOrder needs unchecked conversion to conform to DoubleHash<Object> from the type DoubleHash<String>\n----------\n");
    }

    public void test081() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X<U> implements I {\n\tpublic A<String> foo() { return null; }\n\tpublic <S> A<U> bar() { return null; }\n}\ninterface I {\n\t<T> A<T> foo();\n\t<S> A<S> bar();\n}\nclass A<V> {}"}, "----------\n1. WARNING in X.java (at line 2)\r\n\tpublic A<String> foo() { return null; }\r\n\t       ^\nType safety: The return type A<String> for foo() from the type X<U> needs unchecked conversion to conform to A<Object> from the type I\n----------\n2. ERROR in X.java (at line 3)\r\n\tpublic <S> A<U> bar() { return null; }\r\n\t           ^^^^\nThe return type is incompatible with I.bar()\n----------\n");
    }

    public void test082() {
        this.runNegativeTest(new String[]{"V.java", "public class V extends U { @Override public C<B> foo() { return null; } }\nclass U { public <T extends A> C<T> foo() { return null; } }\nclass A {}\nclass B extends A {}\nclass C<T> {}"}, "----------\n1. WARNING in V.java (at line 1)\n\tpublic class V extends U { @Override public C<B> foo() { return null; } }\n\t                                            ^\nType safety: The return type C<B> for foo() from the type V needs unchecked conversion to conform to C<A> from the type U\n----------\n");
    }

    public void test083() {
        this.runConformTest(new String[]{"C.java", "public class C extends p.B {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(((p.I) new C()).m() == null);\n\t}\n}", "p/B.java", "package p;\npublic abstract class B extends A {}\nabstract class A implements I {\n\tpublic A m() { return null; }\n}", "p/I.java", "package p;\npublic interface I { I m(); }\n"}, "true");
    }

    public void test084() {
        this.runConformTest(new String[]{"A.java", "public class A<T1 extends A.M> implements I<T1> {\n\tpublic java.util.List<T1> f(M n) { return null; }\n\tstatic class M {}\n}\ninterface I<T2> {\n\tjava.util.List<T2> f(T2 t);\n}"}, "");
    }

    public void test084a() {
        this.runConformTest(new String[]{"A.java", "public class A<T1 extends A.M> implements I<T1> {\n\tpublic void foo(Number n, M m) {}\n\tpublic void foo2(Number n, M m) {}\n\tpublic void foo3(Number n, M m) {}\n\tstatic class M {}\n}\ninterface I<T2> {\n\t<U extends Number> void foo(U u, T2 t);\n\tvoid foo2(Number n, T2 t);\n\t<U extends Number> void foo3(U u, A.M m);\n}"}, "");
    }

    public void test084b() {
        this.runNegativeTest(new String[]{"A.java", "public class A<T1 extends A.M> implements I<T1> {\n\tpublic void foo4(Number n, T1 m) {}\n\tstatic class M {}\n}\ninterface I<T2> {\n\t<U extends Number> void foo4(U u, A.M m);\n}"}, "----------\n1. ERROR in A.java (at line 1)\r\n\tpublic class A<T1 extends A.M> implements I<T1> {\r\n\t             ^\nThe type A<T1> must implement the inherited abstract method I<T1>.foo4(U, A.M)\n----------\n2. ERROR in A.java (at line 2)\r\n\tpublic void foo4(Number n, T1 m) {}\r\n\t            ^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo4(Number, T1) of type A<T1> has the same erasure as foo4(U, A.M) of type I<T2> but does not override it\n----------\n");
    }

    public void test085() {
        this.runNegativeTest(new String[]{"Parent.java", "import java.util.Collection;\npublic class Parent {\n\tstatic void staticCase1(Collection c) {}\n\tstatic void staticCase2(Collection<String> c) {}\n\tvoid instanceCase1(Collection c) {}\n\tvoid instanceCase2(Collection<String> c) {}\n}\nclass Child extends Parent {\n\tstatic void staticCase1(Collection<String> c) {}\n\tstatic void staticCase2(Collection c) {}\n\tvoid instanceCase1(Collection<String> c) {}\n\t@Override void instanceCase2(Collection c) {}\n}"}, "----------\n1. WARNING in Parent.java (at line 3)\n\tstatic void staticCase1(Collection c) {}\n\t                        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in Parent.java (at line 5)\n\tvoid instanceCase1(Collection c) {}\n\t                   ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. WARNING in Parent.java (at line 10)\n\tstatic void staticCase2(Collection c) {}\n\t                        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n4. ERROR in Parent.java (at line 11)\n\tvoid instanceCase1(Collection<String> c) {}\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method instanceCase1(Collection<String>) of type Child has the same erasure as instanceCase1(Collection) of type Parent but does not override it\n----------\n5. WARNING in Parent.java (at line 12)\n\t@Override void instanceCase2(Collection c) {}\n\t                             ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n");
    }

    public void test085b() {
        this.runNegativeTest(new String[]{"Parent.java", "import java.util.Collection;\npublic class Parent {\n\tstatic void staticMismatchCase1(Collection c) {}\n\tstatic void staticMismatchCase2(Collection<String> c) {}\n\tvoid mismatchCase1(Collection c) {}\n\tvoid mismatchCase2(Collection<String> c) {}\n}\nclass Child extends Parent {\n\tvoid staticMismatchCase1(Collection c) {}\n\tvoid staticMismatchCase2(Collection<String> c) {}\n\tstatic void mismatchCase1(Collection c) {}\n\tstatic void mismatchCase2(Collection<String> c) {}\n}"}, "----------\n1. WARNING in Parent.java (at line 3)\r\n\tstatic void staticMismatchCase1(Collection c) {}\r\n\t                                ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in Parent.java (at line 5)\r\n\tvoid mismatchCase1(Collection c) {}\r\n\t                   ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in Parent.java (at line 9)\r\n\tvoid staticMismatchCase1(Collection c) {}\r\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis instance method cannot override the static method from Parent\n----------\n4. WARNING in Parent.java (at line 9)\r\n\tvoid staticMismatchCase1(Collection c) {}\r\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n5. ERROR in Parent.java (at line 10)\r\n\tvoid staticMismatchCase2(Collection<String> c) {}\r\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis instance method cannot override the static method from Parent\n----------\n6. ERROR in Parent.java (at line 11)\r\n\tstatic void mismatchCase1(Collection c) {}\r\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis static method cannot hide the instance method from Parent\n----------\n7. WARNING in Parent.java (at line 11)\r\n\tstatic void mismatchCase1(Collection c) {}\r\n\t                          ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. ERROR in Parent.java (at line 12)\r\n\tstatic void mismatchCase2(Collection<String> c) {}\r\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis static method cannot hide the instance method from Parent\n----------\n");
    }

    public void test085c() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X<V> extends CX<V> implements IX<V> {}\nclass CX<T> { public static void foo(Object o) {} }\nabstract class X2 extends CX implements IX {}\ninterface IX<U> { void foo(U u); }"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X<V> extends CX<V> implements IX<V> {}\n\t                      ^\nThe static method foo(Object) conflicts with the abstract method in IX<V>\n----------\n2. ERROR in X.java (at line 3)\r\n\tabstract class X2 extends CX implements IX {}\r\n\t               ^^\nThe static method foo(Object) conflicts with the abstract method in IX\n----------\n3. WARNING in X.java (at line 3)\r\n\tabstract class X2 extends CX implements IX {}\r\n\t                          ^^\nCX is a raw type. References to generic type CX<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\r\n\tabstract class X2 extends CX implements IX {}\r\n\t                                        ^^\nIX is a raw type. References to generic type IX<U> should be parameterized\n----------\n");
    }

    public void test086() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements I { public <T extends Object & Data> void copyData(T data) {} }\ninterface I { <A extends Data> void copyData(A data); }\ninterface Data {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements I { public <T extends Object & Data> void copyData(T data) {} }\n\t             ^\nThe type X must implement the inherited abstract method I.copyData(A)\n----------\n");
    }

    public void test086b() {
        this.runConformTest(new String[]{"X.java", "public class X implements I { public <T> G<T> foo(Class<T> stuffClass) { return null; } }\ninterface I { <T extends Object> G<T> foo(Class<T> stuffClass); }\nclass G<T> {}"}, "");
    }

    public void test087() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\n\ninterface Interface1 {\n}\ninterface Interface2 extends Interface1 {\n}\ninterface Interface3 {\n    <P extends Interface1> Collection<P> doStuff();\n}\ninterface Interface4 extends Interface3 {\n    Collection<Interface2> doStuff();\n}\npublic class X {\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\r\n\tCollection<Interface2> doStuff();\r\n\t^^^^^^^^^^\nType safety: The return type Collection<Interface2> for doStuff() from the type Interface4 needs unchecked conversion to conform to Collection<Interface1> from the type Interface3\n----------\n2. ERROR in X.java (at line 14)\r\n\tZork z;\r\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test088() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<T0> extends ArrayList<T0> implements I<T0>,Runnable {\n\t\n\tvoid foo() {\n\t\tthis.add(new Object());\n\t\tthis.add(null);\n\t}\n}\ninterface I<T1> extends Collection<String> {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X<T0> extends ArrayList<T0> implements I<T0>,Runnable {\n\t             ^\nThe interface Collection cannot be implemented more than once with different arguments: Collection<T0> and Collection<String>\n----------\n2. ERROR in X.java (at line 2)\n\tpublic class X<T0> extends ArrayList<T0> implements I<T0>,Runnable {\n\t             ^\nThe type X<T0> must implement the inherited abstract method Runnable.run()\n----------\n3. WARNING in X.java (at line 2)\n\tpublic class X<T0> extends ArrayList<T0> implements I<T0>,Runnable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n4. ERROR in X.java (at line 5)\n\tthis.add(new Object());\n\t     ^^^\nThe method add(T0) in the type ArrayList<T0> is not applicable for the arguments (Object)\n----------\n");
    }

    public void test089() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X extends X2 {}\nabstract class X2 extends X3 implements List<String> {}\nabstract class X3 implements List<Thread> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tabstract class X2 extends X3 implements List<String> {}\n\t               ^^\nThe interface List cannot be implemented more than once with different arguments: List<Thread> and List<String>\n----------\n");
    }

    public void test091() {
        this.runNegativeTest(new String[]{"DataSet.java", "import java.io.Serializable;\nimport java.util.*;\n\nclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t\n\tpublic <S> S[] toArray(S[] s) {\n\t\treturn s;\n\t}\n\n\tpublic boolean add(Object o) { return false; }\n\tpublic void add(int index, Object element) {}\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\tpublic void clear() {}\n\tpublic boolean contains(Object o) {\treturn false; }\n\tpublic boolean containsAll(Collection c) { return false; }\n\tpublic Object get(int index) { return null; }\n\tpublic int indexOf(Object o) { return 0; }\n\tpublic boolean isEmpty() {\treturn false; }\n\tpublic Iterator iterator() {\treturn null; }\n\tpublic int lastIndexOf(Object o) {\treturn 0; }\n\tpublic ListIterator listIterator() {\treturn null; }\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\tpublic boolean remove(Object o) {\treturn false; }\n\tpublic Object remove(int index) {\treturn null; }\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\tpublic Object set(int index, Object element) {\treturn false; }\n\tpublic int size() {\treturn 0; }\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\tpublic Object[] toArray() {\treturn null; }\n\tpublic boolean hasNext() {\treturn false; }\n\tpublic Object next() {\treturn null; }\n\tpublic void remove() {}\n}\n"}, "----------\n1. ERROR in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe type DataSet<T> must implement the inherited abstract method List.toArray(Object[])\n----------\n2. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe serializable class DataSet does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                           ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                                 ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n5. ERROR in DataSet.java (at line 6)\n\tpublic <S> S[] toArray(S[] s) {\n\t               ^^^^^^^^^^^^^^\nName clash: The method toArray(S[]) of type DataSet<T> has the same erasure as toArray(Object[]) of type List but does not override it\n----------\n6. ERROR in DataSet.java (at line 6)\n\tpublic <S> S[] toArray(S[] s) {\n\t               ^^^^^^^^^^^^^^\nName clash: The method toArray(S[]) of type DataSet<T> has the same erasure as toArray(Object[]) of type Collection but does not override it\n----------\n7. WARNING in DataSet.java (at line 12)\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\t                      ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. WARNING in DataSet.java (at line 13)\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\t                                 ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n9. WARNING in DataSet.java (at line 16)\n\tpublic boolean containsAll(Collection c) { return false; }\n\t                           ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n10. WARNING in DataSet.java (at line 20)\n\tpublic Iterator iterator() {\treturn null; }\n\t       ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n11. WARNING in DataSet.java (at line 22)\n\tpublic ListIterator listIterator() {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n12. WARNING in DataSet.java (at line 23)\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n13. WARNING in DataSet.java (at line 26)\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n14. WARNING in DataSet.java (at line 27)\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n15. WARNING in DataSet.java (at line 30)\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test092() {
        this.runNegativeTest(new String[]{"DataSet.java", "import java.io.Serializable;\nimport java.util.*;\n\nclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t\n\tpublic <S extends T> S[] toArray(S[] s) {\n\t\treturn s;\n\t}\n\n\tpublic boolean add(Object o) { return false; }\n\tpublic void add(int index, Object element) {}\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\tpublic void clear() {}\n\tpublic boolean contains(Object o) {\treturn false; }\n\tpublic boolean containsAll(Collection c) { return false; }\n\tpublic Object get(int index) { return null; }\n\tpublic int indexOf(Object o) { return 0; }\n\tpublic boolean isEmpty() {\treturn false; }\n\tpublic Iterator iterator() {\treturn null; }\n\tpublic int lastIndexOf(Object o) {\treturn 0; }\n\tpublic ListIterator listIterator() {\treturn null; }\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\tpublic boolean remove(Object o) {\treturn false; }\n\tpublic Object remove(int index) {\treturn null; }\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\tpublic Object set(int index, Object element) {\treturn false; }\n\tpublic int size() {\treturn 0; }\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\tpublic Object[] toArray() {\treturn null; }\n\tpublic boolean hasNext() {\treturn false; }\n\tpublic Object next() {\treturn null; }\n\tpublic void remove() {}\n}\n"}, "----------\n1. ERROR in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe type DataSet<T> must implement the inherited abstract method List.toArray(Object[])\n----------\n2. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe serializable class DataSet does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                           ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                                 ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n5. WARNING in DataSet.java (at line 12)\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\t                      ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n6. WARNING in DataSet.java (at line 13)\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\t                                 ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n7. WARNING in DataSet.java (at line 16)\n\tpublic boolean containsAll(Collection c) { return false; }\n\t                           ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. WARNING in DataSet.java (at line 20)\n\tpublic Iterator iterator() {\treturn null; }\n\t       ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n9. WARNING in DataSet.java (at line 22)\n\tpublic ListIterator listIterator() {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n10. WARNING in DataSet.java (at line 23)\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n11. WARNING in DataSet.java (at line 26)\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n12. WARNING in DataSet.java (at line 27)\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n13. WARNING in DataSet.java (at line 30)\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test093() {
        this.runNegativeTest(new String[]{"DataSet.java", "import java.io.Serializable;\nimport java.util.*;\n\nclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t\n\tpublic <S> S[] toArray(S[] s) {\n\t\treturn s;\n\t}\n\tpublic Object[] toArray(Object[] o) {\n\t\treturn o;\n\t}\n\tpublic boolean add(Object o) { return false; }\n\tpublic void add(int index, Object element) {}\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\tpublic void clear() {}\n\tpublic boolean contains(Object o) {\treturn false; }\n\tpublic boolean containsAll(Collection c) { return false; }\n\tpublic Object get(int index) { return null; }\n\tpublic int indexOf(Object o) { return 0; }\n\tpublic boolean isEmpty() {\treturn false; }\n\tpublic Iterator iterator() {\treturn null; }\n\tpublic int lastIndexOf(Object o) {\treturn 0; }\n\tpublic ListIterator listIterator() {\treturn null; }\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\tpublic boolean remove(Object o) {\treturn false; }\n\tpublic Object remove(int index) {\treturn null; }\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\tpublic Object set(int index, Object element) {\treturn false; }\n\tpublic int size() {\treturn 0; }\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\tpublic Object[] toArray() {\treturn null; }\n\tpublic boolean hasNext() {\treturn false; }\n\tpublic Object next() {\treturn null; }\n\tpublic void remove() {}\n}\n"}, "----------\n1. ERROR in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe type DataSet<T> must implement the inherited abstract method List.toArray(Object[])\n----------\n2. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe serializable class DataSet does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                           ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                                 ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n5. ERROR in DataSet.java (at line 6)\n\tpublic <S> S[] toArray(S[] s) {\n\t               ^^^^^^^^^^^^^^\nMethod toArray(S[]) has the same erasure toArray(Object[]) as another method in type DataSet<T>\n----------\n6. ERROR in DataSet.java (at line 9)\n\tpublic Object[] toArray(Object[] o) {\n\t                ^^^^^^^^^^^^^^^^^^^\nDuplicate method toArray(Object[]) in type DataSet<T>\n----------\n7. WARNING in DataSet.java (at line 14)\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\t                      ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. WARNING in DataSet.java (at line 15)\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\t                                 ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n9. WARNING in DataSet.java (at line 18)\n\tpublic boolean containsAll(Collection c) { return false; }\n\t                           ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n10. WARNING in DataSet.java (at line 22)\n\tpublic Iterator iterator() {\treturn null; }\n\t       ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n11. WARNING in DataSet.java (at line 24)\n\tpublic ListIterator listIterator() {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n12. WARNING in DataSet.java (at line 25)\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n13. WARNING in DataSet.java (at line 28)\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n14. WARNING in DataSet.java (at line 29)\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n15. WARNING in DataSet.java (at line 32)\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test094() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Arrays;\nclass Y<T> {}\npublic class X\n{\n  private static ArrayList<Y<X>> y = new ArrayList<Y<X>>();\n  void foo(Y[] array)\n  {\n    y.addAll(Arrays.asList(array));\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tvoid foo(Y[] array)\n\t         ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n2. ERROR in X.java (at line 9)\n\ty.addAll(Arrays.asList(array));\n\t  ^^^^^^\nThe method addAll(Collection<? extends Y<X>>) in the type ArrayList<Y<X>> is not applicable for the arguments (List<Y>)\n----------\n");
    }

    public void test096() {
        this.runNegativeTest(new String[]{"ProblemClass.java", "import java.util.Collection;\nimport javax.swing.JLabel;\ninterface SuperInterface {\n   public <A extends JLabel> void doIt(Collection<A> as);\n}\n\npublic class ProblemClass implements SuperInterface {\n   public void doIt(Collection<? extends JLabel> as) {\n   }\n}\n"}, "----------\n1. ERROR in ProblemClass.java (at line 7)\n\tpublic class ProblemClass implements SuperInterface {\n\t             ^^^^^^^^^^^^\nThe type ProblemClass must implement the inherited abstract method SuperInterface.doIt(Collection<A>)\n----------\n2. ERROR in ProblemClass.java (at line 8)\n\tpublic void doIt(Collection<? extends JLabel> as) {\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method doIt(Collection<? extends JLabel>) of type ProblemClass has the same erasure as doIt(Collection<A>) of type SuperInterface but does not override it\n----------\n");
    }

    public void test097() {
        this.runConformTest(new String[]{"ProblemClass.java", "import java.util.Collection;\nimport javax.swing.JLabel;\ninterface SuperInterface {\n   public <A extends JLabel> void doIt(Collection<A> as);\n}\n\npublic class ProblemClass implements SuperInterface {\n   public <B extends JLabel> void doIt(Collection<B> as) {\n   }\n}\n"}, "");
    }

    public void test098() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X<A, B> {\n    public X(List<A> toAdd) {\n    }\n    public <L extends List<? super A>, LF extends Factory<L>> L \n            foo(B b, L l, LF lf) {\n        return l;\n    }\n    public static class ListFactory<T> implements Factory<List<T>> {\n        public List<T> create() {\n            return null;\n        }\n    }\n    public static interface Factory<T> {\n        public T create();\n    }\n    public static void bar() {\n        (new X<Long, Number>(new ArrayList<Long>())).\n            foo(1, (List<Number>) null, new ListFactory<Number>());\n    }\n}"}, "");
    }

    public void test099() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.4");
        this.runConformTest(new String[]{"TestCharset.java", "import java.nio.charset.*;\npublic class TestCharset extends Charset {\n\tprotected TestCharset(String n, String[] a) { super(n, a); }\n\tpublic boolean contains(Charset cs) { return false; }\n\tpublic CharsetDecoder newDecoder() { return null; }\n\tpublic CharsetEncoder newEncoder() { return null; }\n}\n"}, "", null, true, null, customOptions, null);
    }

    public void test100() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\npublic class X<E> {\n  boolean removeAll(Collection<? extends E> c) {\n    return false;\n  }\n}\n", "Y.java", "import java.util.Collection;\npublic class Y<E> extends X<E>\n{\n  <T extends E> boolean removeAll(Collection<T> c) {\n    return false;\n  }\n}"}, "----------\n1. ERROR in Y.java (at line 4)\n\t<T extends E> boolean removeAll(Collection<T> c) {\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method removeAll(Collection<T>) of type Y<E> has the same erasure as removeAll(Collection<? extends E>) of type X<E> but does not override it\n----------\n");
    }

    public void test101() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n    Integer getX(List<Integer> l) {\n        return null;\n    }\n    String getX(List<String> l) {\n        return null;\n    }\n}\nclass Y {\n    Integer getX(List<Integer> l) {\n        return null;\n    }\n    String getX(List<Integer> l) {\n        return null;\n    }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tInteger getX(List<Integer> l) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nDuplicate method getX(List<Integer>) in type Y\n----------\n2. ERROR in X.java (at line 14)\n\tString getX(List<Integer> l) {\n\t       ^^^^^^^^^^^^^^^^^^^^^\nDuplicate method getX(List<Integer>) in type Y\n----------\n");
    }

    public void test102() {
        Map options = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface ReturnLeaf extends ReturnDerived {\n\t}\n\n\tprivate interface Interface {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child extends Implementation implements Interface {\n\t}\n\n\tprivate static class Grandchild extends Child implements Interface {\n\t\t@Override\n\t\tpublic ReturnLeaf bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 26)\n\tpublic ReturnLeaf bar() {\n\t                  ^^^^^\nCannot override the final method from X.Implementation\n----------\n", null, true, options);
    }

    public void test108() {
        Map options = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface ReturnLeaf extends ReturnDerived {\n\t}\n\n\tprivate interface Interface<E> {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation<T> {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child<U> extends Implementation<U> implements Interface<U> {\n\t}\n\n\tprivate static class Grandchild<V> extends Child<V> implements Interface<V> {\n\t\t@Override\n\t\tpublic ReturnLeaf bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild<String>();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 26)\n\tpublic ReturnLeaf bar() {\n\t                  ^^^^^\nCannot override the final method from X.Implementation<V>\n----------\n", null, true, options);
    }

    public void test114() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(new String[]{"X.java", "class Y {\n  void foo() {}\n}\npublic class X extends Y {\n  @Override\n  void foo() {\n  }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tvoid foo() {\n\t     ^^^^^\nThe method X.foo() is overriding a method without making a super invocation\n----------\n", null, true, options);
    }

    public void test115() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runConformTest(new String[]{"X.java", "class Y {\n  void foo() {}\n}\npublic class X extends Y {\n  @Override\n  void foo() {\n    super.foo();\n  }\n}"}, "", null, true, null, options, null);
    }

    public void test116() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        String expectedOutput = new CompilerOptions((Map)options).sourceLevel < 0x320000L ? "----------\n1. ERROR in X.java (at line 2)\n\tZork foo() {}\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tObject foo() {\n\t       ^^^^^\nThe method foo() of type X must override a superclass method\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tZork foo() {}\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tObject foo() {\n\t       ^^^^^\nThe method foo() of type X must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "class Y {\n  Zork foo() {}\n}\npublic class X extends Y {\n  @Override\n  Object foo() {\n     return new Y() {\n         Object foo() {\n            return null;\n         }\n     };  }\n}"}, expectedOutput, null, true, options);
    }

    public void test117() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(new String[]{"X.java", "class Y {\n  Object foo() {\n     return null;\n  }\n}\npublic class X extends Y {\n  @Override\n  Object foo() {\n     return new Y() {\n         @Override\n         Object foo() {\n            return null;\n         }\n     };  }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tObject foo() {\n\t       ^^^^^\nThe method X.foo() is overriding a method without making a super invocation\n----------\n2. ERROR in X.java (at line 11)\n\tObject foo() {\n\t       ^^^^^\nThe method new Y(){}.foo() is overriding a method without making a super invocation\n----------\n", null, true, options);
    }

    public void test118() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(new String[]{"X.java", "class Y<E> {\n\t<U extends E> U foo() {\n\t\treturn null;\n\t}\n}\n\npublic class X<T> extends Y<T> {\n\t@Override\n\t<V extends T> V foo() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t<V extends T> V foo() {\n\t                ^^^^^\nThe method X<T>.foo() is overriding a method without making a super invocation\n----------\n", null, true, options);
    }

    public void test119() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(new String[]{"X.java", "class Y<E> {\n\tE foo() {\n\t\treturn null;\n\t}\n}\n\npublic class X<T> extends Y<T> {\n\t@Override\n\tT foo() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tT foo() {\n\t  ^^^^^\nThe method X<T>.foo() is overriding a method without making a super invocation\n----------\n", null, true, options);
    }

    public void test120() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tabstract class M<T extends CharSequence, S> {\n\t\tabstract void a(T t);\n\t\tabstract void a(S s);\n\t\tvoid a(String s) {}\n\n\t\tabstract void b(T t);\n\t\tprotected void b(String s) {}\n\t\tprotected abstract void b(S s);\n\n\t\tpublic void c(String s) {}\n\t\tprotected abstract void c(T t);\n\t\tabstract void c(S s);\n\n\t\tprotected abstract void d(T t);\n\t\tpublic void d(S s) {}\n\n\t\tvoid e(T t) {}\n\t\tvoid e(S s) {}\n\t}\n\tclass N extends M<String, String> {}\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\tclass N extends M<String, String> {}\n\t      ^\nDuplicate methods named e with the parameters (S) and (T) are defined by the type X.M<String,String>\n----------\n");
    }

    public void test121() {
        this.runConformTest(new String[]{"X.java", "interface Root {\n\tpublic Root someMethod();\n}\n\ninterface Intermediary extends Root {\n\tpublic Leaf someMethod();\n}\n\nclass Leaf implements Intermediary {\n\tpublic Leaf someMethod() {\n\t\tSystem.out.print(\"SUCCESS\");\n\t\treturn null;\n\t}\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tLeaf leafReference = new Leaf();\n\t\tleafReference.someMethod();\n\t\tRoot rootReference = leafReference;\n\t\trootReference.someMethod(); /* throws error */\n\t}\n}"}, "SUCCESSSUCCESS");
    }
}

