/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.contentmodel.internal;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

public class XSDVisitor {
    protected XSDSchema schema;
    protected Stack particleStack = new Stack();

    public void visitSchema(XSDSchema schema) {
        XSDElementDeclaration element;
        this.schema = schema;
        Iterator iterator = schema.getAttributeDeclarations().iterator();
        while (iterator.hasNext()) {
            XSDAttributeDeclaration attr = (XSDAttributeDeclaration)iterator.next();
            this.visitAttributeDeclaration(attr);
        }
        iterator = schema.getTypeDefinitions().iterator();
        while (iterator.hasNext()) {
            XSDTypeDefinition type = (XSDTypeDefinition)iterator.next();
            this.visitTypeDefinition(type);
        }
        iterator = schema.getElementDeclarations().iterator();
        while (iterator.hasNext()) {
            element = (XSDElementDeclaration)iterator.next();
            this.visitElementDeclaration(element);
        }
        iterator = schema.getIdentityConstraintDefinitions().iterator();
        while (iterator.hasNext()) {
            XSDIdentityConstraintDefinition identityConstraint = (XSDIdentityConstraintDefinition)iterator.next();
            this.visitIdentityConstraintDefinition(identityConstraint);
        }
        iterator = schema.getModelGroupDefinitions().iterator();
        while (iterator.hasNext()) {
            XSDModelGroupDefinition modelGroup = (XSDModelGroupDefinition)iterator.next();
            this.visitModelGroupDefinition(modelGroup);
        }
        iterator = schema.getAttributeGroupDefinitions().iterator();
        while (iterator.hasNext()) {
            XSDAttributeGroupDefinition attributeGroup = (XSDAttributeGroupDefinition)iterator.next();
            this.visitAttributeGroupDefinition(attributeGroup);
        }
        iterator = schema.getNotationDeclarations().iterator();
        while (iterator.hasNext()) {
            element = (XSDNotationDeclaration)iterator.next();
            this.visitNotationDeclaration((XSDNotationDeclaration)element);
        }
    }

    public void visitAttributeDeclaration(XSDAttributeDeclaration attr) {
    }

    public void visitTypeDefinition(XSDTypeDefinition type) {
        if (type instanceof XSDSimpleTypeDefinition) {
            this.visitSimpleTypeDefinition((XSDSimpleTypeDefinition)type);
        } else if (type instanceof XSDComplexTypeDefinition) {
            this.visitComplexTypeDefinition((XSDComplexTypeDefinition)type);
        }
    }

    public void visitElementDeclaration(XSDElementDeclaration element) {
        if (!element.isElementDeclarationReference() && element.getAnonymousTypeDefinition() != null) {
            this.visitTypeDefinition(element.getAnonymousTypeDefinition());
        }
    }

    public void visitIdentityConstraintDefinition(XSDIdentityConstraintDefinition identityConstraint) {
    }

    public void visitModelGroupDefinition(XSDModelGroupDefinition modelGroupDef) {
        if (!modelGroupDef.isModelGroupDefinitionReference() && modelGroupDef.getModelGroup() != null) {
            this.visitModelGroup(modelGroupDef.getModelGroup());
        }
    }

    public void visitAttributeGroupDefinition(XSDAttributeGroupDefinition attributeGroup) {
    }

    public void visitNotationDeclaration(XSDNotationDeclaration notation) {
    }

    public void visitSimpleTypeDefinition(XSDSimpleTypeDefinition type) {
    }

    public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
        if (type.getContentType() != null) {
            XSDComplexTypeContent complexContent = type.getContentType();
            if (complexContent instanceof XSDSimpleTypeDefinition) {
                this.visitSimpleTypeDefinition((XSDSimpleTypeDefinition)complexContent);
            } else if (complexContent instanceof XSDParticle) {
                this.visitParticle((XSDParticle)complexContent);
            }
        }
    }

    public void visitParticle(XSDParticle particle) {
        this.visitParticleContent(particle.getContent());
    }

    public void visitParticleContent(XSDParticleContent particleContent) {
        if (particleContent instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition modelGroupDef = (XSDModelGroupDefinition)particleContent;
            if (this.particleStack.contains(modelGroupDef)) {
                return;
            }
            this.particleStack.push(modelGroupDef);
            this.visitModelGroupDefinition(modelGroupDef);
            this.particleStack.pop();
        } else if (particleContent instanceof XSDModelGroup) {
            this.visitModelGroup((XSDModelGroup)particleContent);
        } else if (particleContent instanceof XSDElementDeclaration) {
            this.visitElementDeclaration((XSDElementDeclaration)particleContent);
        } else if (particleContent instanceof XSDWildcard) {
            this.visitWildcard((XSDWildcard)particleContent);
        }
    }

    public void visitModelGroup(XSDModelGroup modelGroup) {
        if (modelGroup.getContents() != null) {
            Iterator iterator = modelGroup.getContents().iterator();
            while (iterator.hasNext()) {
                XSDParticle particle = (XSDParticle)iterator.next();
                this.visitParticle(particle);
            }
        }
    }

    public void visitWildcard(XSDWildcard wildcard) {
    }
}

