/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.tests.support.TestUtils;

public class FacetActionSortTests
extends TestCase {
    private static IProjectFacet f1;
    private static IProjectFacetVersion f1v10;
    private static IProjectFacetVersion f1v12;
    private static IProjectFacetVersion f1v121;
    private static IProjectFacetVersion f1v13;
    private static IProjectFacetVersion f1v20;
    private static IProjectFacet f2;
    private static IProjectFacetVersion f2v35;
    private static IProjectFacetVersion f2v35a;
    private static IProjectFacetVersion f2v47;
    private static IProjectFacetVersion f2v47b;
    private static IProjectFacetVersion f2v47c;
    private static IProjectFacet f2ext;
    private static IProjectFacetVersion f2extv10;
    private static IProjectFacet f3a;
    private static IProjectFacetVersion f3av10;
    private static IProjectFacetVersion f3av20;
    private static IProjectFacet f3b;
    private static IProjectFacetVersion f3bv10;
    private static IProjectFacetVersion f3bv20;
    private static IProjectFacet f3c;
    private static IProjectFacetVersion f3cv10;
    private static IProjectFacetVersion f3cv20;

    static {
        try {
            f1 = ProjectFacetsManager.getProjectFacet((String)"facet1");
            f1v10 = f1.getVersion("1.0");
            f1v12 = f1.getVersion("1.2");
            f1v121 = f1.getVersion("1.2.1");
            f1v13 = f1.getVersion("1.3");
            f1v20 = f1.getVersion("2.0");
            f2 = ProjectFacetsManager.getProjectFacet((String)"facet2");
            f2v35 = f2.getVersion("3.5");
            f2v35a = f2.getVersion("3.5#a");
            f2v47 = f2.getVersion("4.7");
            f2v47b = f2.getVersion("4.7#b");
            f2v47c = f2.getVersion("4.7#c");
            f2ext = ProjectFacetsManager.getProjectFacet((String)"facet2ext");
            f2extv10 = f2ext.getVersion("1.0");
            f3a = ProjectFacetsManager.getProjectFacet((String)"facet3a");
            f3av10 = f3a.getVersion("1.0");
            f3av20 = f3a.getVersion("2.0");
            f3b = ProjectFacetsManager.getProjectFacet((String)"facet3b");
            f3bv10 = f3b.getVersion("1.0");
            f3bv20 = f3b.getVersion("2.0");
            f3c = ProjectFacetsManager.getProjectFacet((String)"facet3c");
            f3cv10 = f3c.getVersion("1.0");
            f3cv20 = f3c.getVersion("2.0");
        }
        catch (Exception exception) {}
    }

    private FacetActionSortTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Facet Action Sort Tests");
        suite.addTest((Test)new FacetActionSortTests("testUninstallComesFirst1"));
        suite.addTest((Test)new FacetActionSortTests("testUninstallComesFirst2"));
        suite.addTest((Test)new FacetActionSortTests("testSortStability1"));
        suite.addTest((Test)new FacetActionSortTests("testSortStability2"));
        return suite;
    }

    public void testUninstallComesFirst1() {
        IFacetedProject.Action a1 = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f1v12, null);
        IFacetedProject.Action a2 = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, f3av10, null);
        ArrayList<IFacetedProject.Action> actions = new ArrayList<IFacetedProject.Action>();
        actions.add(a2);
        actions.add(a1);
        ProjectFacetsManager.sort(TestUtils.asSet(f3av10), actions);
        FacetActionSortTests.assertEquals(actions, Arrays.asList(a2, a1));
    }

    public void testUninstallComesFirst2() {
        IFacetedProject.Action a1 = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f1v12, null);
        IFacetedProject.Action a2 = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, f3av10, null);
        ArrayList<IFacetedProject.Action> actions = new ArrayList<IFacetedProject.Action>();
        actions.add(a1);
        actions.add(a2);
        ProjectFacetsManager.sort(TestUtils.asSet(f3av10), actions);
        FacetActionSortTests.assertEquals(actions, Arrays.asList(a2, a1));
    }

    public void testSortStability1() {
        IFacetedProject.Action a1 = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f1v12, null);
        IFacetedProject.Action a2 = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f3av10, null);
        ArrayList<IFacetedProject.Action> actions = new ArrayList<IFacetedProject.Action>();
        actions.add(a1);
        actions.add(a2);
        ProjectFacetsManager.sort((Set)Collections.EMPTY_SET, actions);
        FacetActionSortTests.assertEquals(actions, Arrays.asList(a1, a2));
    }

    public void testSortStability2() {
        IFacetedProject.Action a1 = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f1v12, null);
        IFacetedProject.Action a2 = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f3av10, null);
        ArrayList<IFacetedProject.Action> actions = new ArrayList<IFacetedProject.Action>();
        actions.add(a2);
        actions.add(a1);
        ProjectFacetsManager.sort((Set)Collections.EMPTY_SET, actions);
        FacetActionSortTests.assertEquals(actions, Arrays.asList(a1, a2));
    }
}

