/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.tests;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.contentassist.tests.BaseTestClass;
import org.eclipse.jst.jsf.contentassist.tests.ContentAssistTestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestIdCompletionStrategy
extends BaseTestClass {
    private static final Set<String> DISPLAY_NAMES;
    private WebProjectTestEnvironment _testEnv;
    private IFile _jspFile;
    private IType _myBeanType;

    static {
        HashSet<String> displayNames = new HashSet<String>();
        displayNames.add("requestScope");
        displayNames.add("cookie");
        displayNames.add("header");
        displayNames.add("headerValues");
        displayNames.add("param");
        displayNames.add("paramValues");
        displayNames.add("facesContext");
        displayNames.add("view");
        displayNames.add("initParam");
        displayNames.add("sessionScope");
        displayNames.add("applicationScope");
        displayNames.add("myBean");
        DISPLAY_NAMES = Collections.unmodifiableSet(displayNames);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._testEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._testEnv.createProject(false);
        TestIdCompletionStrategy.assertNotNull((Object)this._testEnv);
        TestIdCompletionStrategy.assertNotNull((Object)this._testEnv.getTestProject());
        TestIdCompletionStrategy.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
        this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/faces-config_basic.xml.data", "/WEB-INF/faces-config.xml");
        this._jspFile = (IFile)this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/basicELExpressions.jsp.data", "/basicELExpressions.jsp");
        TestIdCompletionStrategy.assertNotNull((Object)this._jspFile);
        TestIdCompletionStrategy.assertTrue((boolean)this._jspFile.isAccessible());
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        TestFileResource resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
        this._myBeanType = JavaCore.create((IProject)this._testEnv.getTestProject()).findType("beans.MyBean");
        TestIdCompletionStrategy.assertNotNull((Object)this._myBeanType);
        TestIdCompletionStrategy.assertTrue((boolean)this._myBeanType.exists());
    }

    public void testSanity() throws Exception {
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)518, (String)"value", (String)"#{}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)547, (String)"value", (String)"#{   }");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)579, (String)"value", (String)"#{myBean}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)614, (String)"value", (String)"#{myBean.property}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)658, (String)"value", (String)"#{paramValues.foo}");
        TestIdCompletionStrategy.assertEquals((int)12, (int)DISPLAY_NAMES.size());
    }

    public void testGetProposals() {
    }

    public void testIdCompletionStrategy() throws Exception {
        this.assertDisplayNamesMatch(DISPLAY_NAMES, this.getProposals(this._jspFile, 518, "", 1));
        this.assertDisplayNamesMatch(DISPLAY_NAMES, this.getProposals(this._jspFile, 547, 1));
        this.assertDisplayNamesMatch(DISPLAY_NAMES, this.getProposals(this._jspFile, 579, 1));
        this.assertDisplayNamesMatch(Collections.singleton("myBean"), this.getProposals(this._jspFile, 579, 2));
        this.assertDisplayNamesMatch(DISPLAY_NAMES, this.getProposals(this._jspFile, 614, 1));
        this.assertDisplayNamesMatch(Collections.singleton("myBean"), this.getProposals(this._jspFile, 614, 2));
        this.assertDisplayNamesMatch(DISPLAY_NAMES, this.getProposals(this._jspFile, 658, 1));
        HashSet<String> paramNames = new HashSet<String>();
        paramNames.add("param");
        paramNames.add("paramValues");
        this.assertDisplayNamesMatch(Collections.unmodifiableSet(paramNames), this.getProposals(this._jspFile, 658, 2));
    }
}

