/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ProjectComponents;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.TestWorkspace;
import org.eclipse.wst.common.tests.SimpleTestSuite;

public class StructureEditAPITest
extends TestCase {
    public static String fileSep = System.getProperty("file.separator");
    public static final String PROJECT_NAME = "TestArtifactEdit";
    public static final String WEB_MODULE_NAME = "WebModule1";
    public static final URI moduleURI = URI.createURI((String)"module:/resource/TestArtifactEdit/WebModule1");
    public static final String EDIT_MODEL_ID = "jst.web";
    public static final String EDITMODEL_STRESS = "stresstest";
    private Path zipFilePath = new Path("TestData" + fileSep + "TestArtifactEdit.zip");
    private IProject project;

    public static Test suite() {
        return new SimpleTestSuite(StructureEditAPITest.class);
    }

    protected void setUp() throws Exception {
        TestWorkspace.init();
        this.project = TestWorkspace.getTargetProject();
    }

    public IProject getTargetProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
    }

    public void testGetStructureEditForRead() throws Exception {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testGetStructureEditForWrite() throws Exception {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testGetModuleCoreNature() throws Exception {
        ModuleCoreNature nature = StructureEdit.getModuleCoreNature((URI)moduleURI);
        StructureEditAPITest.assertNotNull((Object)nature);
    }

    public void testGetContainingProjectWorkbenchComponent() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            IProject aProject = StructureEdit.getContainingProject((WorkbenchComponent)wbComponent);
            StructureEditAPITest.assertNotNull((Object)aProject);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testGetContainingProjectURI() throws Exception {
        IProject aProject = StructureEdit.getContainingProject((URI)moduleURI);
        StructureEditAPITest.assertNotNull((Object)aProject);
    }

    public void testGetDeployedName() throws Exception {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            String deployName = StructureEdit.getDeployedName((URI)moduleURI);
            StructureEditAPITest.assertNotNull((Object)deployName);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testGetComponentType() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            ComponentType type = StructureEdit.getComponentType((IVirtualComponent)ComponentCore.createComponent((IProject)this.project, (String)wbComponent.getName()));
            StructureEditAPITest.assertNotNull((Object)type);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testSave() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            moduleCore.save((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testSaveIfNecessary() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            moduleCore.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testPrepareProjectComponentsIfNecessary() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            moduleCore.prepareProjectComponentsIfNecessary();
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testGetComponentModelRoot() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            ProjectComponents projectComponents = moduleCore.getComponentModelRoot();
            StructureEditAPITest.assertNotNull((Object)projectComponents);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testGetSourceContainers() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            ComponentResource[] containers = moduleCore.getSourceContainers(wbComponent);
            StructureEditAPITest.assertNotNull((Object)containers);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testGetWorkbenchModules() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            WorkbenchComponent[] components = moduleCore.getWorkbenchModules();
            StructureEditAPITest.assertNotNull((Object)components);
            StructureEditAPITest.assertTrue((components.length > 0 ? 1 : 0) != 0);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testCreateWorkbenchModule() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            wbComponent = moduleCore.createWorkbenchModule("test");
            StructureEditAPITest.assertNotNull((Object)wbComponent);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testCreateWorkbenchModuleResource() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            ComponentResource resource = moduleCore.createWorkbenchModuleResource((IResource)this.project.getFile("WebModule1/NewFolder"));
            StructureEditAPITest.assertNotNull((Object)resource);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testCreateModuleType() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            ComponentType type = moduleCore.createModuleType(EDIT_MODEL_ID);
            StructureEditAPITest.assertNotNull((Object)type);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testFindResourcesByRuntimePathURIURI() throws Exception {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            ComponentResource[] resources = moduleCore.findResourcesByRuntimePath(moduleURI);
            StructureEditAPITest.assertNotNull((Object)resources);
            StructureEditAPITest.assertTrue((resources.length > 0 ? 1 : 0) != 0);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testFindResourcesByRuntimePathURI() throws Exception {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
            ComponentResource[] resources = moduleCore.findResourcesByRuntimePath(moduleURI, moduleURI);
            StructureEditAPITest.assertNotNull((Object)resources);
            StructureEditAPITest.assertTrue((resources.length > 0 ? 1 : 0) != 0);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testFindResourcesBySourcePath() throws Exception {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            ComponentResource[] resources = moduleCore.findResourcesBySourcePath(moduleURI);
            StructureEditAPITest.assertNotNull((Object)resources);
            StructureEditAPITest.assertTrue((resources.length > 0 ? 1 : 0) != 0);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testFindComponentByName() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testFindComponentByURI() throws Exception {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.findComponentByURI(moduleURI);
            StructureEditAPITest.assertNotNull((Object)wbComponent);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testIsLocalDependency() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            moduleCore.isLocalDependency(null);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testGetFirstModule() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)this.project);
            StructureEditAPITest.assertNotNull((Object)moduleCore);
            WorkbenchComponent wbComponent = moduleCore.getFirstModule();
            StructureEditAPITest.assertNotNull((Object)wbComponent);
        }
        finally {
            moduleCore.dispose();
        }
    }

    public void testCreateComponentURI() {
        URI uri = StructureEdit.createComponentURI((IProject)this.project, (String)"testComp");
        StructureEditAPITest.assertNotNull((Object)uri);
    }
}

