/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class CreateModelFromXmlTest
extends TestCase {
    private static IFacetedProject facetedProject;
    private EJBJar fixture;

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite();
        CreateModelFromXmlTest.setUpProject();
        suite.addTestSuite(CreateModelFromXmlTest.class);
        return suite;
    }

    public static void setUpProject() throws Exception {
        facetedProject = AbstractTest.createEjbProject(CreateModelFromXmlTest.class.getSimpleName());
        CreateModelFromXmlTest.createProjectContent();
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(CreateModelFromXmlTest.class.getSimpleName());
    }

    private static void createProjectContent() throws Exception {
        CreateModelFromXmlTest.setEjbJarXmlContent();
    }

    private static void setEjbJarXmlContent() throws IOException, CoreException {
        IFile file = facetedProject.getProject().getFile((IPath)new Path("ejbModule/META-INF/ejb-jar.xml"));
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ejb-jar version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd\"><enterprise-beans>\t\t<session>\t\t\t<ejb-name>com.sap.SessionBean</ejb-name>\t\t\t<ejb-class>com.sap.SessionBean</ejb-class>\t\t\t<session-type>Stateless</session-type>\t\t</session>\t</enterprise-beans></ejb-jar>";
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(content.getBytes());
        file.setContents((InputStream)new ByteArrayInputStream(stream.toByteArray()), 1, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setUp() throws Exception {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
        this.fixture = (EJBJar)provider.getModelObject();
    }

    public void testGetBeans() {
        CreateModelFromXmlTest.assertEquals((Object)new Integer(1), (Object)new Integer(this.fixture.getEnterpriseBeans().getSessionBeans().size()));
    }

    public void testSessionBean() {
        SessionBean bean = (SessionBean)this.fixture.getEnterpriseBeans().getSessionBeans().get(0);
        CreateModelFromXmlTest.assertEquals((String)"com.sap.SessionBean", (String)bean.getEjbName());
        CreateModelFromXmlTest.assertEquals((String)"com.sap.SessionBean", (String)bean.getEjbClass());
    }
}

