/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.mergers.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.ejb.ActivationConfig;
import org.eclipse.jst.javaee.ejb.ActivationConfigProperty;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.MethodParams;
import org.eclipse.jst.javaee.ejb.NamedMethodType;
import org.eclipse.jst.javaee.ejb.SecurityIdentityType;
import org.eclipse.jst.javaee.ejb.TransactionType;
import org.eclipse.jst.jee.model.internal.mergers.MessageDrivenBeanMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class MdbMergerTest
extends TestCase {
    public void testActivationConfigPropComplex() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        ActivationConfig base = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean.setActivationConfig(base);
        ActivationConfig merge = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean1.setActivationConfig(merge);
        ActivationConfigProperty property = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property.setActivationConfigPropertyName("n1");
        property.setActivationConfigPropertyValue("v1");
        base.getActivationConfigProperties().add(property);
        ActivationConfigProperty property1 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property1.setActivationConfigPropertyName("n2");
        property1.setActivationConfigPropertyValue("v2");
        base.getActivationConfigProperties().add(property1);
        ActivationConfigProperty property2 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property2.setActivationConfigPropertyName("n3");
        property2.setActivationConfigPropertyValue("v3");
        base.getActivationConfigProperties().add(property2);
        ActivationConfigProperty property3 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property3.setActivationConfigPropertyName("n3");
        property3.setActivationConfigPropertyValue("v1");
        merge.getActivationConfigProperties().add(property3);
        ActivationConfigProperty property4 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property4.setActivationConfigPropertyName("n4");
        property4.setActivationConfigPropertyValue("v4");
        merge.getActivationConfigProperties().add(property4);
        ActivationConfigProperty property5 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property5.setActivationConfigPropertyName("n5");
        property5.setActivationConfigPropertyValue("v6");
        merge.getActivationConfigProperties().add(property5);
        ActivationConfigProperty property6 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property6.setActivationConfigPropertyName("n6");
        property6.setActivationConfigPropertyValue("v6");
        base.getActivationConfigProperties().add(property6);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertEquals((int)mdbBean.getActivationConfig().getActivationConfigProperties().size(), (int)6);
        MdbMergerTest.assertEquals((int)mdbBean1.getActivationConfig().getActivationConfigProperties().size(), (int)3);
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n1", "v1", base.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n2", "v2", base.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n3", "v3", base.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n4", "v4", base.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n5", "v6", base.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n6", "v6", base.getActivationConfigProperties()));
    }

    public void testActivationConfigPropComplex2() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        ActivationConfig base = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean.setActivationConfig(base);
        ActivationConfig merge = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean1.setActivationConfig(merge);
        ActivationConfigProperty property = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property.setActivationConfigPropertyName("n1");
        property.setActivationConfigPropertyValue("v1");
        base.getActivationConfigProperties().add(property);
        ActivationConfigProperty property1 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property1.setActivationConfigPropertyName("n2");
        property1.setActivationConfigPropertyValue("v2");
        base.getActivationConfigProperties().add(property1);
        ActivationConfigProperty property2 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property2.setActivationConfigPropertyName("n3");
        property2.setActivationConfigPropertyValue("v3");
        base.getActivationConfigProperties().add(property2);
        ActivationConfigProperty property3 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property3.setActivationConfigPropertyName("n3");
        property3.setActivationConfigPropertyValue("v1");
        merge.getActivationConfigProperties().add(property3);
        ActivationConfigProperty property4 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property4.setActivationConfigPropertyName("n4");
        property4.setActivationConfigPropertyValue("v4");
        merge.getActivationConfigProperties().add(property4);
        ActivationConfigProperty property5 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property5.setActivationConfigPropertyName("n5");
        property5.setActivationConfigPropertyValue("v6");
        merge.getActivationConfigProperties().add(property5);
        ActivationConfigProperty property6 = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property6.setActivationConfigPropertyName("n6");
        property6.setActivationConfigPropertyValue("v6");
        base.getActivationConfigProperties().add(property6);
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((int)mdbBean.getActivationConfig().getActivationConfigProperties().size(), (int)4);
        MdbMergerTest.assertEquals((int)mdbBean1.getActivationConfig().getActivationConfigProperties().size(), (int)6);
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n1", "v1", merge.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n2", "v2", merge.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n3", "v1", merge.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n4", "v4", merge.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n5", "v6", merge.getActivationConfigProperties()));
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n6", "v6", merge.getActivationConfigProperties()));
    }

    private boolean checkActivationConfProp(String key, String value, List properties) {
        for (Object acProp : properties) {
            ActivationConfigProperty p = (ActivationConfigProperty)acProp;
            if (!p.getActivationConfigPropertyName().equals(key) || !p.getActivationConfigPropertyValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void testActivationConfigPropBase() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        ActivationConfig base = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean.setActivationConfig(base);
        ActivationConfig merge = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean1.setActivationConfig(merge);
        ActivationConfigProperty property = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property.setActivationConfigPropertyName("n1");
        property.setActivationConfigPropertyValue("v1");
        base.getActivationConfigProperties().add(property);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertEquals((int)mdbBean.getActivationConfig().getActivationConfigProperties().size(), (int)1);
        MdbMergerTest.assertEquals((int)mdbBean1.getActivationConfig().getActivationConfigProperties().size(), (int)0);
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n1", "v1", base.getActivationConfigProperties()));
    }

    public void testActivationConfigPropMerge() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        ActivationConfig base = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean.setActivationConfig(base);
        ActivationConfig merge = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean1.setActivationConfig(merge);
        ActivationConfigProperty property = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property.setActivationConfigPropertyName("n1");
        property.setActivationConfigPropertyValue("v1");
        merge.getActivationConfigProperties().add(property);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertEquals((int)mdbBean.getActivationConfig().getActivationConfigProperties().size(), (int)1);
        MdbMergerTest.assertEquals((int)mdbBean1.getActivationConfig().getActivationConfigProperties().size(), (int)1);
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n1", "v1", base.getActivationConfigProperties()));
    }

    public void testActivationConfigPropSameBean() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        ActivationConfig base = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean.setActivationConfig(base);
        ActivationConfig merge = EjbFactory.eINSTANCE.createActivationConfig();
        mdbBean1.setActivationConfig(merge);
        ActivationConfigProperty property = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property.setActivationConfigPropertyName("n1");
        property.setActivationConfigPropertyValue("v1");
        base.getActivationConfigProperties().add(property);
        merge.getActivationConfigProperties().add(property);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertEquals((int)mdbBean.getActivationConfig().getActivationConfigProperties().size(), (int)1);
        MdbMergerTest.assertEquals((int)mdbBean1.getActivationConfig().getActivationConfigProperties().size(), (int)1);
        MdbMergerTest.assertTrue((boolean)this.checkActivationConfProp("n1", "v1", base.getActivationConfigProperties()));
    }

    public void testTimeOutComplexNoParams() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        mdbBean.setTimeoutMethod(base);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod());
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodName().equals(value));
        MdbMergerTest.assertNull((Object)mdbBean.getTimeoutMethod().getMethodParams());
    }

    public void testTimeOutComplexWithParams() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        params.getMethodParams().add("java.lang.String");
        base.setMethodParams(params);
        NamedMethodType merge = EjbFactory.eINSTANCE.createNamedMethodType();
        merge.setMethodName(value);
        mdbBean.setTimeoutMethod(base);
        mdbBean1.setTimeoutMethod(merge);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod());
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodName().equals(value));
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodParams());
        MdbMergerTest.assertEquals((int)1, (int)mdbBean.getTimeoutMethod().getMethodParams().getMethodParams().size());
    }

    public void testTimeOutComplexWithParams2() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        String string = "java.lang.String";
        params.getMethodParams().add(string);
        base.setMethodParams(params);
        NamedMethodType merge = EjbFactory.eINSTANCE.createNamedMethodType();
        merge.setMethodName(value);
        mdbBean.setTimeoutMethod(base);
        mdbBean1.setTimeoutMethod(merge);
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod());
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodName().equals(value));
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodParams());
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodParams().getMethodParams().get(0).equals(string));
    }

    public void testTimeOutBase() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        String string = "java.lang.String";
        params.getMethodParams().add(string);
        base.setMethodParams(params);
        mdbBean.setTimeoutMethod(base);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod());
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodName().equals(value));
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodParams());
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod().getMethodParams().getMethodParams().get(0).equals(string));
    }

    public void testTimeOutMerge() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        String string = "java.lang.String";
        params.getMethodParams().add(string);
        base.setMethodParams(params);
        mdbBean.setTimeoutMethod(base);
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertNotNull((Object)mdbBean.getTimeoutMethod());
        MdbMergerTest.assertNotNull((Object)mdbBean1.getTimeoutMethod());
        MdbMergerTest.assertNotNull((Object)mdbBean1.getTimeoutMethod().getMethodName().equals(value));
        MdbMergerTest.assertNotNull((Object)mdbBean1.getTimeoutMethod().getMethodParams());
        MdbMergerTest.assertNotNull((Object)mdbBean1.getTimeoutMethod().getMethodParams().getMethodParams().get(0).equals(string));
    }

    public void testSecurityIdentityBase() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        SecurityIdentityType type = EjbFactory.eINSTANCE.createSecurityIdentityType();
        type.setUseCallerIdentity(JavaeeFactory.eINSTANCE.createEmptyType());
        mdbBean1.setSecurityIdentity(type);
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertNotNull((Object)mdbBean1.getSecurityIdentity().getUseCallerIdentity());
    }

    public void testSecurityIdentityMerge() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        SecurityIdentityType type = EjbFactory.eINSTANCE.createSecurityIdentityType();
        type.setUseCallerIdentity(JavaeeFactory.eINSTANCE.createEmptyType());
        mdbBean1.setSecurityIdentity(type);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertNotNull((Object)mdbBean.getSecurityIdentity().getUseCallerIdentity());
    }

    public void testSecurityIdentitySame() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        SecurityIdentityType type = EjbFactory.eINSTANCE.createSecurityIdentityType();
        type.setUseCallerIdentity(JavaeeFactory.eINSTANCE.createEmptyType());
        mdbBean1.setSecurityIdentity(type);
        mdbBean.setSecurityIdentity(type);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertNotNull((Object)mdbBean.getSecurityIdentity().getUseCallerIdentity());
    }

    public void testSecurityIdentityComplex() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        SecurityIdentityType type = EjbFactory.eINSTANCE.createSecurityIdentityType();
        type.setUseCallerIdentity(JavaeeFactory.eINSTANCE.createEmptyType());
        SecurityIdentityType type2 = EjbFactory.eINSTANCE.createSecurityIdentityType();
        RunAs createRunAs = JavaeeFactory.eINSTANCE.createRunAs();
        createRunAs.setRoleName("ttt");
        type2.setRunAs(createRunAs);
        mdbBean1.setSecurityIdentity(type);
        mdbBean.setSecurityIdentity(type2);
        new MessageDrivenBeanMerger(mdbBean, mdbBean1, 0).process();
        MdbMergerTest.assertNull((Object)mdbBean.getSecurityIdentity().getUseCallerIdentity());
        MdbMergerTest.assertNotNull((Object)mdbBean.getSecurityIdentity().getRunAs().getRoleName());
    }

    public void testTransactionTypeBase() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        mdbBean1.setTransactionType(TransactionType.BEAN_LITERAL);
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((Object)TransactionType.BEAN_LITERAL, (Object)mdbBean1.getTransactionType());
    }

    public void testTransactionTypeMerge() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        mdbBean.setTransactionType(TransactionType.BEAN_LITERAL);
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((Object)TransactionType.BEAN_LITERAL, (Object)mdbBean1.getTransactionType());
    }

    public void testTransactionTypeSame() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        mdbBean1.setTransactionType(TransactionType.BEAN_LITERAL);
        mdbBean.setTransactionType(TransactionType.BEAN_LITERAL);
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((Object)TransactionType.BEAN_LITERAL, (Object)mdbBean1.getTransactionType());
    }

    public void testTransactionTypeComplex() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        mdbBean1.setTransactionType(TransactionType.CONTAINER_LITERAL);
        mdbBean.setTransactionType(TransactionType.BEAN_LITERAL);
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((Object)TransactionType.CONTAINER_LITERAL, (Object)mdbBean1.getTransactionType());
    }

    public void testMessagingTypeBase() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        mdbBean1.setMessagingType("test");
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((String)"test", (String)mdbBean1.getMessagingType());
    }

    public void testMessagingTypeMerge() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        mdbBean.setMessagingType("test");
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((String)"test", (String)mdbBean1.getMessagingType());
    }

    public void testMessagingTypeSame() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        mdbBean1.setMessagingType("test");
        mdbBean.setMessagingType("test");
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((String)"test", (String)mdbBean1.getMessagingType());
    }

    public void testMessagingTypeComplex() throws ModelException {
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        MessageDrivenBean mdbBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbName("name");
        mdbBean1.setEjbName("name");
        mdbBean1.setMessagingType("zero");
        mdbBean.setMessagingType("test");
        new MessageDrivenBeanMerger(mdbBean1, mdbBean, 0).process();
        MdbMergerTest.assertEquals((String)"zero", (String)mdbBean1.getMessagingType());
    }
}

