/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ear.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.internal.project.facet.EARFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.appclient.operations.AppClientProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JEEProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.jca.operations.JCAProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebProjectCreationOperationTest;

public class EARProjectCreationOperationTest
extends JEEProjectCreationOperationTest {
    private static final String APP_CLIENT_PROJ_12 = "myAppClient_12";
    private static final String APP_CLIENT_PROJ_13 = "myAppClient_13";
    private static final String APP_CLIENT_PROJ_14 = "myAppClient_14";
    private static final String APP_CLIENT_PROJ_5 = "myAppClient_5";
    private static final String EJB_PROJ_11 = "myEJB_11";
    private static final String EJB_PROJ_2 = "myEJB_2";
    private static final String EJB_PROJ_21 = "myEJB_21";
    private static final String EJB_PROJ_3 = "myEJB_3";
    private static final String WEB_PROJ_22 = "myWeb_22";
    private static final String WEB_PROJ_23 = "myWeb_23";
    private static final String WEB_PROJ_24 = "myWeb_24";
    private static final String WEB_PROJ_25 = "myWeb_25";
    private static final String CONNECTOR_PROJ_1 = "myConnector_1";
    private static final String CONNECTOR_PROJ_15 = "myConnector_15";

    public EARProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(EARProjectCreationOperationTest.class);
    }

    public void testEAR12_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("aEAR", null, null, null, JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR13_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("bEAR", null, null, null, JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR14_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("cEAR", null, null, null, JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("dEAR", null, null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR12_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("eEAR", "whosContent", null, null, JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR13_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("fEAR", "myContent", null, null, JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR14_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("gEAR", "yourContent", null, null, JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("hEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR12_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("zEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_12(), EARProjectCreationOperationTest.getJavaDependencyList_12(), JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR13_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("yEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_13(), EARProjectCreationOperationTest.getJavaDependencyList_13(), JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR14_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("xEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_14(), EARProjectCreationOperationTest.getJavaDependencyList_14(), JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("wEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_5(), EARProjectCreationOperationTest.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR12_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("zEAR", "myContent", EARProjectCreationOperationTest.getJ2EEDependencyList_12(), EARProjectCreationOperationTest.getJavaDependencyList_12(), JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR13_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("yEAR", "ourContent", EARProjectCreationOperationTest.getJ2EEDependencyList_13(), EARProjectCreationOperationTest.getJavaDependencyList_13(), JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR14_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("xEAR", "theirContent", EARProjectCreationOperationTest.getJ2EEDependencyList_14(), EARProjectCreationOperationTest.getJavaDependencyList_14(), JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("wEAR", "yourContent", EARProjectCreationOperationTest.getJ2EEDependencyList_5(), EARProjectCreationOperationTest.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_Defaults_WithDD() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("myEAR", null, null, null, JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_ChangedContentDir_WithDD() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("yourEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public static IDataModel getEARDataModel(String projName, String contentDir, List dependenciesJ2EE, List dependenciesJava, IProjectFacetVersion version, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EARFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap factMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = (IDataModel)factMap.get((Object)"jst.ear");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (contentDir != null) {
            facetModel.setStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR", contentDir);
        }
        if (dependenciesJ2EE != null) {
            facetModel.setProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST", (Object)dependenciesJ2EE);
        }
        if (dependenciesJava != null) {
            facetModel.setProperty("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST", (Object)dependenciesJava);
        }
        if (version == JavaEEFacetConstants.EAR_5) {
            facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
        }
        return dm;
    }

    public static List getJ2EEDependencyList_12() throws Exception {
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_12, null, JavaEEFacetConstants.APP_CLIENT_12, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_11, null, null, null, JavaEEFacetConstants.EJB_11, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_22, null, null, null, null, JavaEEFacetConstants.WEB_22, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_12() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_13() throws Exception {
        EARProjectCreationOperationTest.getJ2EEDependencyList_12();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_13, null, JavaEEFacetConstants.APP_CLIENT_13, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_2, null, null, null, JavaEEFacetConstants.EJB_2, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_23, null, null, null, null, JavaEEFacetConstants.WEB_23, true));
        models.add(JCAProjectCreationOperationTest.getConnectorDataModel(CONNECTOR_PROJ_1, null, null, JavaEEFacetConstants.CONNECTOR_1));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_13() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_14() throws Exception {
        EARProjectCreationOperationTest.getJ2EEDependencyList_13();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_14, null, JavaEEFacetConstants.APP_CLIENT_14, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_21, null, null, null, JavaEEFacetConstants.EJB_21, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_24, null, null, null, null, JavaEEFacetConstants.WEB_24, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_14() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_5() throws Exception {
        EARProjectCreationOperationTest.getJ2EEDependencyList_14();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_5, null, JavaEEFacetConstants.APP_CLIENT_5, true, false));
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel("myAppClient_5_WithDD", null, JavaEEFacetConstants.APP_CLIENT_5, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_3, null, null, null, JavaEEFacetConstants.EJB_3, false));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel("myEJB_3_WithDD", null, null, null, JavaEEFacetConstants.EJB_3, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_25, null, null, null, null, JavaEEFacetConstants.WEB_25, false));
        models.add(WebProjectCreationOperationTest.getWebDataModel("myWeb_25_WithDD", null, null, null, null, JavaEEFacetConstants.WEB_25, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_5() {
        return Collections.emptyList();
    }
}

