/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tests.tagcreator.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.ICustomizationData;
import org.eclipse.jst.pagedesigner.tests.PageDesignerTestsPlugin;
import org.eclipse.jst.pagedesigner.tests.tagcreator.base.MockCreateItemCommand;
import org.eclipse.jst.pagedesigner.tests.tagcreator.base.MockItemCreationTool;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

public class BaseTestClass
extends TestCase {
    protected WebProjectTestEnvironment _webProjectTestEnv;
    protected PaletteItemManager _manager;
    protected final String _compareDataSubDir;

    public BaseTestClass(String compareDataSubDir) {
        this._compareDataSubDir = compareDataSubDir;
    }

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._webProjectTestEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._webProjectTestEnv.createProject(false);
        BaseTestClass.assertNotNull((Object)this._webProjectTestEnv);
        BaseTestClass.assertNotNull((Object)this._webProjectTestEnv.getTestProject());
        BaseTestClass.assertTrue((boolean)this._webProjectTestEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacetedTestEnv = new JSFFacetedTestEnvironment(this._webProjectTestEnv);
        jsfFacetedTestEnv.initialize("1.1");
        BaseTestClass.assertTrue((boolean)JSFCoreUtilHelper.addJSFRuntimeJarsToClasspath((JSFVersion)JSFVersion.V1_1, (JSFFacetedTestEnvironment)jsfFacetedTestEnv));
        this._manager = PaletteItemManager.getInstance((IProject)this._webProjectTestEnv.getTestProject());
    }

    protected CreationData getCreationData(String uri, String tagName, String defaultPrefix, IFile file, int offset, ICustomizationData customizationData) throws Exception {
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this._webProjectTestEnv.getTestProject(), (String)uri);
        TagToolPaletteEntry entry = this.createNonNullPaletteEntry(uri, tagName);
        ContextWrapper context = this.getDocumentContext(offset, file);
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context.getContext());
        Node node = resolver.getNode();
        BaseTestClass.assertEquals((short)3, (short)node.getNodeType());
        DOMPosition domPosition = new DOMPosition(node, 0);
        IDOMModel model = (IDOMModel)context.getModel();
        return new CreationData(entry.getTemplate(), model, (IDOMPosition)domPosition, modelContext, (IAdaptable)customizationData);
    }

    private TagToolPaletteEntry createPaletteEntry(String uri, String tagName) {
        TaglibPaletteDrawer drawer = this._manager.getTaglibPalletteDrawer(uri);
        BaseTestClass.assertNotNull((String)String.format("Uri: %s, tagName: %s", uri, tagName), (Object)drawer);
        TagToolPaletteEntry entry = drawer.getTagPaletteEntryByTagName(tagName);
        if (entry == null) {
            entry = drawer.getTagPaletteEntryById(tagName);
        }
        return entry;
    }

    private TagToolPaletteEntry createNonNullPaletteEntry(String uri, String tagName) {
        TagToolPaletteEntry entry = this.createPaletteEntry(uri, tagName);
        BaseTestClass.assertNotNull((Object)entry);
        return entry;
    }

    protected ContextWrapper getDocumentContext(int offset, IFile jspFile) throws Exception {
        BaseTestClass.assertTrue((boolean)jspFile.exists());
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        model = modelManager.getModelForRead(jspFile);
        BaseTestClass.assertTrue((model instanceof DOMModelForJSP || model instanceof DOMStyleModelImpl ? 1 : 0) != 0);
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), offset);
        return new ContextWrapper(context, model);
    }

    protected String getExpectedResult(IPath path) throws IOException {
        return JSFTestUtil.loadFromFile((File)path.toFile()).toString();
    }

    protected String getExpectedResult(String tagName, String outExt) throws Exception {
        String ext = outExt == null ? "" : "." + outExt;
        String fileName = "expectedResult_" + tagName.replaceAll(":", "_") + ext + ".data";
        String pathStr = "/testdata/tagcreator/" + this._compareDataSubDir + "/" + fileName;
        return this.getExpectedResult(pathStr);
    }

    protected final String getExpectedResult(String pathStr) throws Exception {
        IPath expectedPath = JSFTestUtil.getAbsolutePath((Bundle)PageDesignerTestsPlugin.getDefault().getBundle(), (String)pathStr);
        return this.getExpectedResult(expectedPath);
    }

    protected final void assertExpectedResult(IFile file, String tagName, String outExt) throws Exception {
        String expected = this.getExpectedString(file, tagName, outExt);
        String result = this.getResultString(file);
        BaseTestClass.assertEquals((String)expected, (String)result);
    }

    private String getResultString(IFile file) throws Exception {
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        new HTMLFormatProcessorImpl().formatDocument((IDocument)this.getDocumentContext(0, file).getModel().getStructuredDocument());
        this.getDocumentContext(0, file).getModel().save((OutputStream)resultStream);
        return resultStream.toString("ISO-8859-1").trim();
    }

    private final String getExpectedString(IFile file, String tagName, String outExt) throws Exception {
        String expectedUnformatted = this.getExpectedResult(tagName, outExt).trim();
        IPath path = file.getProjectRelativePath().removeLastSegments(1).append("/expected/");
        IFolder folder = file.getProject().getFolder(path);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        BaseTestClass.assertTrue((boolean)folder.isAccessible());
        IFile tempFile = file.getProject().getFile(path.append(file.getName()));
        BaseTestClass.assertFalse((boolean)tempFile.exists());
        tempFile.create((InputStream)new ByteArrayInputStream(expectedUnformatted.getBytes()), true, null);
        BaseTestClass.assertTrue((boolean)tempFile.isAccessible());
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        model = modelManager.getModelForRead(tempFile);
        new HTMLFormatProcessorImpl().formatDocument((IDocument)model.getStructuredDocument());
        ByteArrayOutputStream expectedStream = new ByteArrayOutputStream();
        model.save((OutputStream)expectedStream);
        return expectedStream.toString("ISO-8859-1").trim();
    }

    protected MockItemCreationTool createMockItemCreationTool(IFile file, int offset, TagIdentifier tagId) throws Exception {
        return this.createMockItemCreationTool(file, offset, tagId, 0);
    }

    protected MockItemCreationTool createMockItemCreationTool(IFile file, int offset, TagIdentifier tagId, int expectedResult) throws Exception {
        TagToolPaletteEntry toolEntry = this.createNonNullPaletteEntry(tagId.getUri(), tagId.getTagName());
        MockItemCreationTool tool = new MockItemCreationTool(toolEntry.getTemplate());
        ContextWrapper wrapper = this.getDocumentContext(offset, file);
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(wrapper.getContext());
        IStructuredModel model = wrapper.getModel();
        DOMPosition domPosition = new DOMPosition(resolver.getNode(), 0);
        MockCreateItemCommand command = new MockCreateItemCommand("Test Command", (IDOMModel)model, (IDOMPosition)domPosition, toolEntry.getTemplate());
        tool.setEditDomain(new EditDomain());
        tool.setCurrentCommand((Command)command);
        return tool;
    }

    protected final void forceTagEmpty(ElementImpl element) {
        int i = 0;
        while (i < element.getChildNodes().getLength()) {
            Node node = element.getChildNodes().item(i);
            if (node instanceof ElementImpl) {
                this.forceTagEmpty((ElementImpl)node);
            }
            ++i;
        }
        if (element.getChildNodes().getLength() == 0) {
            element.setEmptyTag(true);
            element.removeChildNodes();
            Node copy = element.cloneNode(false);
            element.getParentNode().replaceChild(copy, (Node)element);
        }
    }

    public static class ContextWrapper {
        private final IStructuredDocumentContext context;
        private final IStructuredModel model;

        public ContextWrapper(IStructuredDocumentContext context, IStructuredModel model) {
            this.context = context;
            this.model = model;
        }

        public IStructuredDocumentContext getContext() {
            return this.context;
        }

        public IStructuredModel getModel() {
            return this.model;
        }

        void dispose() {
            this.model.releaseFromRead();
        }
    }
}

