/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.validation;

import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.XMLViewDefnValidator;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.osgi.framework.Bundle;

public class TestJSPSemanticsValidator_AttributeValues
extends TestCase {
    private WebProjectTestEnvironment _webProject;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        ZipFile zipFile = JSFTestUtil.createZipFile((Bundle)TestsPlugin.getDefault().getBundle(), (String)"/testfiles/testzips/ValidationTestProject1.zip");
        this._webProject = new WebProjectTestEnvironment((TestCase)this, JavaFacetUtils.JAVA_50, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.4"));
        this._webProject.createFromZip(zipFile, true);
    }

    public void testSanity() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestJSPSemanticsValidator_AttributeValues.assertNotNull((Object)project);
        TestJSPSemanticsValidator_AttributeValues.assertTrue((boolean)project.isAccessible());
        IFile jspFile = project.getFile((IPath)new Path("WebContent/NonELValidation.jsp"));
        TestJSPSemanticsValidator_AttributeValues.assertTrue((boolean)jspFile.isAccessible());
        IStructuredModel jspModel = null;
        try {
            jspModel = StructuredModelManager.getModelManager().getModelForRead(jspFile);
            assert (jspModel instanceof DOMModelForJSP);
        }
        finally {
            if (jspModel != null) {
                jspModel.releaseFromRead();
            }
        }
    }

    public void testNonELValidation() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestJSPSemanticsValidator_AttributeValues.assertNotNull((Object)project);
        TestJSPSemanticsValidator_AttributeValues.assertTrue((boolean)project.isAccessible());
        IFile jspFile = project.getFile((IPath)new Path("WebContent/NonELValidation.jsp"));
        TestJSPSemanticsValidator_AttributeValues.assertTrue((boolean)jspFile.isAccessible());
        MockValidationReporter mockReporter = new MockValidationReporter();
        XMLViewDefnValidator validator = new XMLViewDefnValidator();
        validator.validateView(jspFile, (IJSFViewValidator.IValidationReporter)mockReporter);
        TestJSPSemanticsValidator_AttributeValues.assertEquals((int)4, (int)mockReporter.getReportedProblems().size());
        mockReporter.assertExpectedMessage(591, 25, 1);
        mockReporter.assertExpectedMessage(936, 1, 2);
        mockReporter.assertExpectedMessage(969, 9, 2);
    }

    public void testELValidation() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestJSPSemanticsValidator_AttributeValues.assertNotNull((Object)project);
        TestJSPSemanticsValidator_AttributeValues.assertTrue((boolean)project.isAccessible());
        IFile jspFile = project.getFile((IPath)new Path("WebContent/ELValidation.jsp"));
        TestJSPSemanticsValidator_AttributeValues.assertTrue((boolean)jspFile.isAccessible());
        MockValidationReporter mockReporter = new MockValidationReporter();
        XMLViewDefnValidator validator = new XMLViewDefnValidator();
        validator.validateView(jspFile, (IJSFViewValidator.IValidationReporter)mockReporter);
        TestJSPSemanticsValidator_AttributeValues.assertEquals((int)10, (int)mockReporter.getReportedProblems().size());
        mockReporter.assertExpectedMessage(603, 2, 2);
        mockReporter.assertExpectedMessage(648, 4, 2);
        mockReporter.assertExpectedMessage(696, 5, 2);
        mockReporter.assertExpectedMessage(753, 6, 2);
        mockReporter.assertExpectedMessage(802, 4, 1);
        mockReporter.assertExpectedMessage(846, 5, 1);
        mockReporter.assertExpectedMessage(847, 3, 2);
        mockReporter.assertExpectedMessage(946, 24, 2, 5);
        mockReporter.assertExpectedMessage(1015, 40, 1);
    }
}

