/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.performance.contentassist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class ContentAssistTest
extends PerformanceTestCase {
    private final String PLUGIN_ID = "org.eclipse.jst.jsp.ui.tests.performance";
    private final String TEST_FILES_DIRECTORY = "testfiles";
    private final String ID_JSP_EDITOR = "org.eclipse.jst.jsp.core.jspsource.source";
    private final int ITERATIONS = 500;

    public void testReadFiles() throws MalformedURLException, CoreException, FileNotFoundException {
        File dir = new File(this.getTestFilesDirectory());
        if (dir.exists() && dir.isDirectory()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("sp");
            project.create(null);
            project.open(null);
            this.copy(dir, (IContainer)project);
            this.joinBackgroundJobs();
            final ArrayList files = new ArrayList();
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getName().endsWith(".jsp")) {
                        files.add(proxy.requestResource());
                    }
                    return true;
                }
            }, 1);
            this.tagAsSummary("Open JSP Editor", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
            this.startMeasuring();
            IFile file = (IFile)files.get(0);
            this.openEditor(file);
            int i = 0;
            while (i < 500) {
                this.moveCursorRight();
                this.requestContentAssist();
                this.esc();
                ++i;
            }
            this.closeAllEditors();
            this.stopMeasuring();
            this.commitMeasurements();
            this.assertPerformance();
        } else {
            ContentAssistTest.fail((String)dir.toString());
        }
    }

    public String getTestFilesDirectory() {
        Bundle bun = Platform.getBundle((String)"org.eclipse.jst.jsp.ui.tests.performance");
        URL pluginURL = null;
        try {
            pluginURL = FileLocator.toFileURL((URL)bun.getEntry("/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pluginURL != null ? String.valueOf(pluginURL.getPath()) + "/" + "testfiles" : "";
    }

    private void copy(File src, IContainer dest) throws CoreException, FileNotFoundException {
        File[] children = src.listFiles();
        int i = 0;
        while (i < children.length) {
            String name = children[i].getName();
            if (children[i].isDirectory()) {
                IFolder folder = dest.getFolder((IPath)new Path(name));
                folder.create(true, true, null);
                this.copy(children[i], (IContainer)folder);
            } else if (name.endsWith(".jsp")) {
                IFile file = dest.getFile((IPath)new Path(name));
                file.create((InputStream)new FileInputStream(children[i]), true, null);
            }
            ++i;
        }
    }

    private void joinBackgroundJobs() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                }
                catch (InterruptedException interruptedException) {}
                long start = System.currentTimeMillis();
                Display display = Display.getDefault();
                while (System.currentTimeMillis() - start < 5000L) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    private void requestContentAssist() {
        Event e = new Event();
        e.type = 1;
        e.keyCode = 262144;
        Display.getDefault().post(e);
        e = new Event();
        e.type = 1;
        e.character = (char)32;
        Display.getDefault().post(e);
        e = new Event();
        e.type = 2;
        e.character = (char)32;
        Display.getDefault().post(e);
        e = new Event();
        e.type = 2;
        e.keyCode = 262144;
        Display.getDefault().post(e);
        this.readAndDispatch();
    }

    private void esc() {
        Event e = new Event();
        e.type = 1;
        e.character = (char)27;
        Display.getDefault().post(e);
        this.readAndDispatch();
    }

    private void moveCursorRight() {
        Event e = new Event();
        e.type = 1;
        e.keyCode = 0x1000004;
        Display.getDefault().post(e);
        this.readAndDispatch();
    }

    private void readAndDispatch() {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                while (display.readAndDispatch()) {
                }
            }
        });
    }

    private void openEditor(IFile file) throws PartInitException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.jst.jsp.core.jspsource.source", true);
        page.activate((IWorkbenchPart)editor);
        this.esc();
    }

    private void closeAllEditors() throws PartInitException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        workbenchWindow.getActivePage().closeAllEditors(false);
        this.esc();
    }
}

