package oracle.adfdemo.view.faces;

import java.util.Collections;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

/**
 * A proxy class to ask the e-mail demo for preferences information,
 * but only when we're inside the e-mail demo!
 */
public class PreferencesProxy
{
  public Object getProxy()
  {
    // If we're in the e-mail demo, use its preferences
    FacesContext context = FacesContext.getCurrentInstance();
    if ((context.getViewRoot() != null) &&
        (context.getViewRoot().getViewId().indexOf("/email/") >= 0))
    {
      ValueBinding vb =
        context.getApplication().createValueBinding("#{email.preferences}");
      return vb.getValue(context);
    }
    // Otherwise, go to an empty map (blank preferences)
    else
    {
      return Collections.EMPTY_MAP;
    }
  }
}
