/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jst.pagedesigner.commands.PaletteDropInsertCommand;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewLocalDropCommand;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewerDragDropHelper;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditorDropTargetListener;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorDropTargetAdapter;

public class DesignerSourceDropTargetListener
extends ExtendedEditorDropTargetAdapter
implements ITextEditorDropTargetListener {
    private int _location;
    private StructuredTextEditor _textEditor;

    public DesignerSourceDropTargetListener(StructuredTextEditor textEditor) {
        super(false);
        this._textEditor = textEditor;
        this.setTextViewer((ITextViewer)this._textEditor.getTextViewer());
    }

    public Transfer[] getTransfers() {
        return new Transfer[]{TemplateTransfer.getInstance(), TextTransfer.getInstance()};
    }

    public void dragOperationChanged(DropTargetEvent event) {
        super.dragOperationChanged(event);
    }

    public void dragOver(DropTargetEvent event) {
        StyledText text = null;
        if (this._textEditor.getTextViewer() != null) {
            text = this._textEditor.getTextViewer().getTextWidget();
            if (TemplateTransfer.getInstance().isSupportedType(event.currentDataType)) {
                if (this._textEditor.getTextViewer() != null) {
                    Point p = new Point(event.x, event.y);
                    SourceViewerDragDropHelper.getInstance().updateCaret(this._textEditor, p);
                    this._location = text.getCaretOffset();
                    if (TemplateTransfer.getInstance().isSupportedType(event.currentDataType)) {
                        this._location = SourceViewerDragDropHelper.getInstance().getValidLocation(this._textEditor, this._location);
                    }
                    SourceViewerDragDropHelper.getInstance().showCaret(this._textEditor, this._location);
                }
            } else if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                super.dragOver(event);
                this._location = text.getCaretOffset();
            }
        }
    }

    public void drop(DropTargetEvent event) {
        StyledText text = null;
        if (this._textEditor.getTextViewer() != null) {
            text = this._textEditor.getTextViewer().getTextWidget();
        }
        text.setCaretOffset(this._location);
        Command command = this.getCommand(event);
        if (command == null) {
            return;
        }
        command.execute();
    }

    private Command getCommand(DropTargetEvent event) {
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            Object data = event.data;
            if (data instanceof String) {
                SourceViewLocalDropCommand command = new SourceViewLocalDropCommand(this._textEditor, data, this._location);
                return command;
            }
        } else if (TemplateTransfer.getInstance().isSupportedType(event.currentDataType)) {
            Object data = event.data;
            PaletteDropInsertCommand command = null;
            if (data instanceof IDropSourceData) {
                IDropSourceData dropSourceData = (IDropSourceData)data;
                command = new PaletteDropInsertCommand(PageDesignerResources.getInstance().getString("DesignerSourceDropTargetListener.InserCommandLabel"), this._textEditor, dropSourceData, this._location);
            }
            return command;
        }
        return null;
    }
}

