/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.actions.ActionsMessages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class DesignerStyleActionGroup
extends ActionGroup {
    private static HashMap IMAGE_NAMES = new HashMap();
    private static final String VERTICAL = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.V");
    private static final String HORIZONTAL = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.H");
    private static final String DESIGN = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.D");
    private static final String SOURCE = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.S");
    private static final String VERTICAL_TOOLTIP = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.V.Tooltip");
    private static final String HORIZONTAL_TOOLTIP = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.H.Tooltip");
    private static final String DESIGN_TOOLTIP = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.D.Tooltip");
    private static final String SOURCE_TOOLTIP = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.S.Tooltip");
    private HTMLEditor _htmlEditor;
    private final ChangeDesignerStyleAction[] _actions;
    private final List<ActionHandler> _actionHandlers;
    private final List<IHandlerActivation> _handlers;

    static {
        IMAGE_NAMES.put(VERTICAL, "PD_Toolbar_vsplit.gif");
        IMAGE_NAMES.put(HORIZONTAL, "PD_Toolbar_hsplit.gif");
        IMAGE_NAMES.put(DESIGN, "PD_Toolbar_designer.gif");
        IMAGE_NAMES.put(SOURCE, "PD_Toolbar_source.gif");
    }

    public DesignerStyleActionGroup() {
        ChangeDesignerStyleAction verAction = new ChangeDesignerStyleAction("org.eclipse.jst.pagedesigner.vertical", VERTICAL, PDPlugin.getDefault().getImageDescriptor((String)IMAGE_NAMES.get(VERTICAL)), 0);
        verAction.setActionDefinitionId("org.eclipse.jst.pagedesigner.vertical");
        verAction.setToolTipText(VERTICAL_TOOLTIP);
        ChangeDesignerStyleAction horAction = new ChangeDesignerStyleAction("org.eclipse.jst.pagedesigner.horizotal", HORIZONTAL, PDPlugin.getDefault().getImageDescriptor((String)IMAGE_NAMES.get(HORIZONTAL)), 1);
        horAction.setActionDefinitionId("org.eclipse.jst.pagedesigner.horizotal");
        horAction.setToolTipText(HORIZONTAL_TOOLTIP);
        ChangeDesignerStyleAction designAction = new ChangeDesignerStyleAction("org.eclipse.jst.pagedesigner.design", DESIGN, PDPlugin.getDefault().getImageDescriptor((String)IMAGE_NAMES.get(DESIGN)), 2);
        designAction.setActionDefinitionId("org.eclipse.jst.pagedesigner.design");
        designAction.setToolTipText(DESIGN_TOOLTIP);
        ChangeDesignerStyleAction sourceAction = new ChangeDesignerStyleAction("org.eclipse.jst.pagedesigner.source", SOURCE, PDPlugin.getDefault().getImageDescriptor((String)IMAGE_NAMES.get(SOURCE)), 3);
        sourceAction.setActionDefinitionId("org.eclipse.jst.pagedesigner.source");
        sourceAction.setToolTipText(SOURCE_TOOLTIP);
        this._actions = new ChangeDesignerStyleAction[]{verAction, horAction, designAction, sourceAction};
        this._actionHandlers = new ArrayList<ActionHandler>();
        int i = 0;
        while (i < this._actions.length) {
            this._actionHandlers.add(new ActionHandler((IAction)this._actions[i]));
            ++i;
        }
        this._handlers = new ArrayList<IHandlerActivation>();
    }

    public void updateActionBars() {
        if (this._htmlEditor == null) {
            int i = 0;
            while (i < this._actions.length) {
                this._actions[i].setEnabled(false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._actions.length) {
                this._actions[i].setEnabled(true);
                this._actions[i].setChecked(this._actions[i].getMode() == this._htmlEditor.getDesignerMode());
                ++i;
            }
        }
    }

    public void setHTMLEditor(HTMLEditor editor) {
        if (this._htmlEditor != editor) {
            if (this._htmlEditor != null) {
                this.deactivateHandlers();
            }
            this._htmlEditor = editor;
            if (this._htmlEditor != null) {
                this.activateHandlers();
            }
            this.updateActionBars();
        }
    }

    private void deactivateHandlers() {
        IHandlerService service = (IHandlerService)this._htmlEditor.getSite().getService(IHandlerService.class);
        for (IHandlerActivation activation : this._handlers) {
            service.deactivateHandler(activation);
        }
        this._handlers.clear();
    }

    private void activateHandlers() {
        IHandlerService service = (IHandlerService)this._htmlEditor.getSite().getService(IHandlerService.class);
        int i = 0;
        while (i < this._actions.length) {
            this._handlers.add(service.activateHandler(this._actions[i].getId(), (IHandler)this._actionHandlers.get(i)));
            ++i;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolbar = actionBars.getToolBarManager();
        int i = 0;
        while (i < this._actions.length) {
            toolbar.add((IAction)this._actions[i]);
            ++i;
        }
        toolbar.add((IContributionItem)new Separator());
    }

    public void dispose() {
        for (ActionHandler actionHandler : this._actionHandlers) {
            actionHandler.dispose();
        }
    }

    private class ChangeDesignerStyleAction
    extends Action {
        int _mode;

        ChangeDesignerStyleAction(String actionId, String text, ImageDescriptor image, int mode) {
            super(text, 8);
            this.setImageDescriptor(image);
            this._mode = mode;
            this.setId(actionId);
        }

        public int getMode() {
            return this._mode;
        }

        public void run() {
            if (DesignerStyleActionGroup.this._htmlEditor != null) {
                DesignerStyleActionGroup.this._htmlEditor.setDesignerMode(this._mode);
                DesignerStyleActionGroup.this.updateActionBars();
            }
        }
    }
}

