/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;

public class XSGMonthDay
extends CalendarType
implements CmpEq {
    private Calendar _calendar;
    private boolean _timezoned;

    public XSGMonthDay(Calendar cal, boolean tz) {
        this._calendar = cal;
        this._timezoned = tz;
    }

    public XSGMonthDay() {
        this(new GregorianCalendar(), false);
    }

    public String type_name() {
        return "gMonthDay";
    }

    public static XSGMonthDay parse_gMonthDay(String str) {
        String lame = "1983-";
        String lame2 = "T00:00:00.0";
        boolean tz = false;
        int index = str.indexOf(43, 0);
        if (index == -1) {
            index = str.indexOf(45, 0);
            if (index == -1) {
                return null;
            }
            index = str.indexOf(45, index + 1);
        }
        if (index == -1) {
            index = str.indexOf(90, 0);
        }
        if (index != -1) {
            lame = String.valueOf(lame) + str.substring(0, index);
            lame = String.valueOf(lame) + lame2;
            lame = String.valueOf(lame) + str.substring(index, str.length());
            tz = true;
        } else {
            lame = String.valueOf(lame) + str + lame2;
        }
        XSDateTime dt = XSDateTime.parseDateTime(lame);
        if (dt == null) {
            return null;
        }
        return new XSGMonthDay(dt.calendar(), tz);
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        XSGMonthDay val = XSGMonthDay.parse_gMonthDay(aat.string_value());
        if (val == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(val);
        return rs;
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public int day() {
        return this._calendar.get(5);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public String string_value() {
        String ret = "";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.month(), 2);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.day(), 2);
        if (this.timezoned()) {
            ret = String.valueOf(ret) + "Z";
        }
        return ret;
    }

    public String string_type() {
        return "xs:gMonthDay";
    }

    public Calendar calendar() {
        return this._calendar;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        XSGMonthDay val = (XSGMonthDay)NumericType.get_single_type(arg, XSGMonthDay.class);
        return this.calendar().equals(val.calendar());
    }
}

