/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import com.ibm.icu.text.Collator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.DatabaseObject;
import org.eclipse.jpt.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaContainerWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.db.internal.vendor.Vendor;
import org.eclipse.jpt.db.internal.vendor.VendorRepository;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPDatabaseWrapper
extends DTPSchemaContainerWrapper
implements Database {
    private final org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase;
    private final Vendor vendor;
    private DTPCatalogWrapper[] catalogs;

    DTPDatabaseWrapper(DTPConnectionProfileWrapper connectionProfile, org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase) {
        super(connectionProfile, dtpDatabase);
        this.dtpDatabase = dtpDatabase;
        this.vendor = VendorRepository.instance().getVendor(this.getVendorName());
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().databaseChanged(this);
    }

    @Override
    public DTPDatabaseWrapper getDatabase() {
        return this;
    }

    @Override
    List<Schema> getDTPSchemata() {
        return this.vendor.getSchemas(this.dtpDatabase);
    }

    @Override
    DTPSchemaWrapper getSchema(Schema dtpSchema) {
        return this.getSchema_(dtpSchema);
    }

    DTPSchemaWrapper getSchemaFromCatalogs(Schema dtpSchema) {
        return this.getCatalog(dtpSchema.getCatalog()).getSchema_(dtpSchema);
    }

    @Override
    DTPTableWrapper getTable(Table dtpTable) {
        return this.getTable_(dtpTable);
    }

    DTPTableWrapper getTableFromCatalogs(Table dtpTable) {
        return this.getCatalog(dtpTable.getSchema().getCatalog()).getTable_(dtpTable);
    }

    @Override
    DTPColumnWrapper getColumn(Column dtpColumn) {
        return this.getColumn_(dtpColumn);
    }

    DTPColumnWrapper getColumnFromCatalogs(Column dtpColumn) {
        return this.getCatalog(dtpColumn.getTable().getSchema().getCatalog()).getColumn_(dtpColumn);
    }

    @Override
    public String getName() {
        return this.dtpDatabase.getName();
    }

    @Override
    public String getVendorName() {
        return this.dtpDatabase.getVendor();
    }

    @Override
    public String getVersion() {
        return this.dtpDatabase.getVersion();
    }

    @Override
    public <T extends DatabaseObject> T selectDatabaseObjectForIdentifier(T[] databaseObjects, String identifier) {
        return (T)super.selectDatabaseObjectForIdentifier(databaseObjects, identifier);
    }

    @Override
    public boolean supportsCatalogs() {
        return this.vendor.supportsCatalogs(this.dtpDatabase);
    }

    @Override
    public Iterator<Catalog> catalogs() {
        return new ArrayIterator((Object[])this.getCatalogs());
    }

    private Iterator<DTPCatalogWrapper> catalogWrappers() {
        return new ArrayIterator((Object[])this.getCatalogs());
    }

    private synchronized DTPCatalogWrapper[] getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = this.buildCatalogs();
        }
        return this.catalogs;
    }

    private DTPCatalogWrapper[] buildCatalogs() {
        List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs = this.getDTPCatalogs();
        Object[] result = new DTPCatalogWrapper[dtpCatalogs.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPCatalogWrapper(this, dtpCatalogs.get(i));
        }
        return (DTPCatalogWrapper[])CollectionTools.sort((Object[])result);
    }

    private List<org.eclipse.datatools.modelbase.sql.schema.Catalog> getDTPCatalogs() {
        return this.vendor.getCatalogs(this.dtpDatabase);
    }

    @Override
    public int catalogsSize() {
        return this.getCatalogs().length;
    }

    DTPCatalogWrapper getCatalog(org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog) {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.getCatalogs();
        int n = dTPCatalogWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            if (catalog.wraps(dtpCatalog)) {
                return catalog;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP catalog: " + dtpCatalog);
    }

    @Override
    public DTPCatalogWrapper getCatalogNamed(String name) {
        return (DTPCatalogWrapper)this.selectDatabaseObjectNamed(this.getCatalogs(), name);
    }

    @Override
    public Iterator<String> sortedCatalogIdentifiers() {
        return new TransformationIterator<DTPCatalogWrapper, String>(this.catalogWrappers()){

            protected String transform(DTPCatalogWrapper next) {
                return next.getIdentifier();
            }
        };
    }

    @Override
    public DTPCatalogWrapper getCatalogForIdentifier(String identifier) {
        return (DTPCatalogWrapper)this.selectDatabaseObjectForIdentifier(this.getCatalogs(), identifier);
    }

    @Override
    public synchronized DTPCatalogWrapper getDefaultCatalog() {
        return this.getCatalogForIdentifiers(this.getDefaultCatalogIdentifiers());
    }

    private List<String> getDefaultCatalogIdentifiers() {
        return this.vendor.getDefaultCatalogIdentifiers(this.dtpDatabase, this.getConnectionProfile().getUserName());
    }

    private DTPCatalogWrapper getCatalogForIdentifiers(List<String> identifiers) {
        for (String identifier : identifiers) {
            DTPCatalogWrapper catalog = this.getCatalogForIdentifier(identifier);
            if (catalog == null) continue;
            return catalog;
        }
        return null;
    }

    List<String> getDefaultSchemaIdentifiers() {
        return this.vendor.getDefaultSchemaIdentifiers(this.dtpDatabase, this.getConnectionProfile().getUserName());
    }

    String convertNameToIdentifier(String name, String defaultName) {
        return this.vendor.convertNameToIdentifier(name, defaultName);
    }

    @Override
    public String convertNameToIdentifier(String name) {
        return this.vendor.convertNameToIdentifier(name);
    }

    <T extends DatabaseObject> T selectDatabaseObjectForIdentifier_(T[] databaseObjects, String identifier) {
        return (T)this.selectDatabaseObjectNamed((DatabaseObject[])databaseObjects, this.convertIdentifierToName(identifier));
    }

    String convertIdentifierToName(String identifier) {
        return this.vendor.convertIdentifierToName(identifier);
    }

    @Override
    public int compareTo(Database database) {
        return Collator.getInstance().compare(this.getName(), database.getName());
    }

    DatabaseDefinition getDTPDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.dtpDatabase);
    }

    @Override
    synchronized void startListening() {
        if (this.catalogs != null) {
            this.startCatalogs();
        }
        super.startListening();
    }

    private void startCatalogs() {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.catalogs != null) {
            this.stopCatalogs();
        }
        super.stopListening();
    }

    private void stopCatalogs() {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.stopListening();
            ++n2;
        }
    }

    @Override
    void clear() {
        if (this.catalogs != null) {
            this.clearCatalogs();
        }
        super.clear();
    }

    private void clearCatalogs() {
        this.stopCatalogs();
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.clear();
            ++n2;
        }
        this.catalogs = null;
    }
}

