/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.osgi.util.NLS;

public class AsynchronousJpaProjectUpdater
implements JpaProject.Updater {
    protected final UpdateJob job;

    public AsynchronousJpaProjectUpdater(JpaProject jpaProject) {
        this.job = this.buildJob(jpaProject);
    }

    protected UpdateJob buildJob(JpaProject jpaProject) {
        return new UpdateJob(jpaProject);
    }

    public void start() {
        this.job.start();
    }

    public void update() {
        this.job.schedule();
    }

    public void stop() {
        this.job.stop();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)((Object)this.job));
    }

    protected static class UpdateJob
    extends Job {
        protected final JpaProject jpaProject;
        protected boolean shouldSchedule;

        protected UpdateJob(JpaProject jpaProject) {
            super(UpdateJob.buildName(jpaProject));
            this.jpaProject = jpaProject;
            this.shouldSchedule = false;
            this.setRule((ISchedulingRule)jpaProject.getProject());
        }

        protected IStatus run(IProgressMonitor monitor) {
            return this.jpaProject.update(monitor);
        }

        public boolean shouldSchedule() {
            return this.shouldSchedule;
        }

        protected void start() {
            if (this.shouldSchedule) {
                throw new IllegalStateException("The Updater was not stopped.");
            }
            this.shouldSchedule = true;
        }

        protected void stop() {
            this.shouldSchedule = false;
            this.cancel();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }

        protected static String buildName(JpaProject jpaProject) {
            return NLS.bind((String)JptCoreMessages.UPDATE_JOB_NAME, (Object)jpaProject.getName());
        }
    }
}

