/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.TestSuite;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.InjectionTarget;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.RemoveMethodType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.ejb.TransactionType;
import org.eclipse.jst.jee.model.internal.common.Result;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationFactoryTest;
import org.eclipse.jst.jee.model.tests.TestUtils;

public class EjbAnnotationFactoryTest
extends AbstractAnnotationFactoryTest {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite(EjbAnnotationFactoryTest.class);
        return suite;
    }

    public void testNotArrayLocal() throws JavaModelException {
        IType type = this.createCompilationUnit("testNotArrayLocal", "package com.sap; @Stateless @Local(value = java.util.List.class) public class testNotArrayLocal {}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean bean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertTrue((boolean)bean.getBusinessLocals().isEmpty());
    }

    public void testNotArrayRemote() throws JavaModelException {
        IType type = this.createCompilationUnit("testNotArrayRemote", "package com.sap; @Stateless @Remote(value = java.util.List.class) public class testNotArrayRemote {}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean bean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertTrue((boolean)bean.getBusinessRemotes().isEmpty());
    }

    public void testNotArrayEjbs() throws JavaModelException {
        IType type = this.createCompilationUnit("testNotArrayEjbs", "package com.sap; @Stateless @EJBs(value = @EJB()) public class testNotArrayEjbs {}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean bean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertTrue((boolean)bean.getEjbLocalRefs().isEmpty());
    }

    public void testNotArrayResources() throws JavaModelException {
        IType type = this.createCompilationUnit("testNotArrayResources", "package com.sap; @Stateless @Resources(value = @Resource(type = \"java.lang.Comparable\")) public class testNotArrayResources {}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean bean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertTrue((boolean)bean.getResourceRefs().isEmpty());
    }

    public void testNotArrayDeclareRoles() throws JavaModelException {
        IType type = this.createCompilationUnit("testNotArrayDeclareRoles", "package com.sap; @Stateless @DeclareRoles(value = \"role1\") public class testNotArrayDeclareRoles {}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean bean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertTrue((boolean)bean.getSecurityRoleRefs().isEmpty());
    }

    public void testNotArrayActivationConfig() throws JavaModelException {
        IType type = this.createCompilationUnit("testNotArrayActivationConfig", "package com.sap; @MessageDriven(activationConfig = @ActivationConfigProperty(propertyName = \"name1\", propertyValue = \"value1\"),@ActivationConfigProperty(propertyName = \"name2\", propertyValue = \"value2\")) public class testNotArrayActivationConfig {}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        MessageDrivenBean bean = (MessageDrivenBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNull((Object)bean.getActivationConfig());
    }

    public void testTimeout() throws Exception {
        IType type = this.createCompilationUnit("testTimeout", "package com.sap;@Stateless public class testTimeout implements SessionBeanLocal{@Timeout public void timeoutMethod1(javax.ejb.Timer timer) {}@Timeout public void timeoutMethod2(javax.ejb.Timer timer) {}@Timeout public void timeoutMethod3() {}}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean.getTimeoutMethod());
        EjbAnnotationFactoryTest.assertEquals((String)"timeoutMethod2", (String)sessionBean.getTimeoutMethod().getMethodName());
        EjbAnnotationFactoryTest.assertEquals((Object)"javax.ejb.Timer", sessionBean.getTimeoutMethod().getMethodParams().getMethodParams().get(0));
    }

    public void testTimeoutStateful() throws Exception {
        IType type = this.createCompilationUnit("testTimeoutStateful", "package com.sap;@Stateful public class testTimeoutStateful implements SessionBeanLocal{@Timeout public void timeoutMethod(javax.ejb.Timer timer) {}}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean);
        EjbAnnotationFactoryTest.assertNull((Object)sessionBean.getTimeoutMethod());
    }

    public void testTransactionManagementBean() throws Exception {
        IType type = this.createCompilationUnit("testTransactionManagementBean", "package com.sap;@Stateful @TransactionManagement(value = TransactionManagementType.BEAN) public class testTransactionManagementBean implements SessionBeanLocal{}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean);
        EjbAnnotationFactoryTest.assertEquals((Object)TransactionType.BEAN_LITERAL, (Object)sessionBean.getTransactionType());
    }

    public void testTransactionManagementContainer() throws Exception {
        IType type = this.createCompilationUnit("testTransactionManagementContainer", "package com.sap;@Stateful @TransactionManagement(value = TransactionManagementType.CONTAINER) public class testTransactionManagementContainer implements SessionBeanLocal{}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean);
        EjbAnnotationFactoryTest.assertEquals((Object)TransactionType.CONTAINER_LITERAL, (Object)sessionBean.getTransactionType());
    }

    public void testTransactionManagementContainerMDB() throws Exception {
        IType type = this.createCompilationUnit("testTransactionManagementContainerMDB", "package com.sap;@MessageDriven @TransactionManagement(value = TransactionManagementType.CONTAINER) public class testTransactionManagementContainerMDB {}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        MessageDrivenBean messageBean = (MessageDrivenBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)messageBean);
        EjbAnnotationFactoryTest.assertEquals((Object)TransactionType.CONTAINER_LITERAL, (Object)messageBean.getTransactionType());
    }

    public void testTransactionManagementStaticImportContainer() throws Exception {
        IType type = this.createCompilationUnit("testTransactionManagementStaticImportContainer", "package com.sap; import static TransactionManagementType.CONTAINER;@Stateful @TransactionManagement(value = CONTAINER) public class testTransactionManagementStaticImportContainer implements SessionBeanLocal{}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertEquals((Object)TransactionType.CONTAINER_LITERAL, (Object)sessionBean.getTransactionType());
    }

    public void testRemoveMethod() throws Exception {
        IType type = this.createCompilationUnit("testRemoveMethod", "package com.sap@Stateful public class testRemoveMethod implements SessionBeanLocal {@Remove public void removeMethod1() {}@Remove(retainIfException = true) public void removeMethod2() {}@Remove(retainIfException = true) public void removeMethodParam(java.lang.String str) {}}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        RemoveMethodType method1 = TestUtils.findRemoveMethodByName(sessionBean, "removeMethod1");
        RemoveMethodType method2 = TestUtils.findRemoveMethodByName(sessionBean, "removeMethod2");
        EjbAnnotationFactoryTest.assertNotNull((Object)method1);
        EjbAnnotationFactoryTest.assertNotNull((Object)method2);
        EjbAnnotationFactoryTest.assertFalse((boolean)method1.isRetainIfException());
        EjbAnnotationFactoryTest.assertTrue((boolean)method2.isRetainIfException());
        EjbAnnotationFactoryTest.assertEquals((Object)new Integer(2), (Object)new Integer(sessionBean.getRemoveMethods().size()));
    }

    public void testRemoveMethodOnStateless() throws Exception {
        IType type = this.createCompilationUnit("testRemoveMethodOnStateless", "package com.sap;@Stateless public class testRemoveMethodOnStateless implements SessionBeanLocal {@Remove public void removeMethod1() {}}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean);
        EjbAnnotationFactoryTest.assertTrue((boolean)sessionBean.getRemoveMethods().isEmpty());
    }

    public void testDeclareRolesOnMessageDrivenBean() throws Exception {
        IType type = this.createCompilationUnit("testDeclareRolesOnMessageDrivenBean", "package com.sap;@DeclareRoles(value = {\"role1\", \"role2\"}) @MessageDriven public class testDeclareRolesOnMessageDrivenBean implements SessionBeanLocal {}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        MessageDrivenBean bean = (MessageDrivenBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)bean);
    }

    public void testEjbRefName() throws Exception {
        IType type = this.createCompilationUnit("testEjbRefName", "package com.sap;@Stateless public class testEjbRefName implements SessionBeanLocal {@EJB(name=\"refName\") private SessionBeanLocal field;}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean);
        EjbAnnotationFactoryTest.assertEquals((int)1, (int)sessionBean.getEjbLocalRefs().size());
        EjbLocalRef ref = (EjbLocalRef)sessionBean.getEjbLocalRefs().get(0);
        EjbAnnotationFactoryTest.assertEquals((int)1, (int)ref.getInjectionTargets().size());
        this.assertInjectionTarget("refName", "", (InjectionTarget)ref.getInjectionTargets().get(0));
    }

    public void testEjbRefNameWithSlash() throws Exception {
        IType type = this.createCompilationUnit("testEjbRefNameWithSlash", "package com.sap;@Stateless public class testEjbRefNameWithSlash implements SessionBeanLocal {@EJB(name=\"refClass/refName\") private SessionBeanLocal field;}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean);
        EjbAnnotationFactoryTest.assertEquals((int)1, (int)sessionBean.getEjbLocalRefs().size());
        EjbLocalRef ref = (EjbLocalRef)sessionBean.getEjbLocalRefs().get(0);
        EjbAnnotationFactoryTest.assertEquals((int)1, (int)ref.getInjectionTargets().size());
        this.assertInjectionTarget("refName", "refClass", (InjectionTarget)ref.getInjectionTargets().get(0));
    }

    public void testResourceRefName() throws Exception {
        IType type = this.createCompilationUnit("testResourceRefName", "package com.sap;@Stateless public class testResourceRefName implements SessionBeanLocal {@Resource(name=\"refName\") private SessionBeanLocal field;}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean);
        EjbAnnotationFactoryTest.assertEquals((int)1, (int)sessionBean.getResourceRefs().size());
        ResourceRef ref = (ResourceRef)sessionBean.getResourceRefs().get(0);
        EjbAnnotationFactoryTest.assertEquals((int)1, (int)ref.getInjectionTargets().size());
        this.assertInjectionTarget("refName", "", (InjectionTarget)ref.getInjectionTargets().get(0));
    }

    public void testResourceRefNameWithSlash() throws Exception {
        IType type = this.createCompilationUnit("testResourceRefNameWithSlash", "package com.sap;@Stateless public class testResourceRefNameWithSlash implements SessionBeanLocal {@Resource(name=\"refClass/refName\") private SessionBeanLocal field;}").findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        EjbAnnotationFactoryTest.assertNotNull((Object)sessionBean);
        EjbAnnotationFactoryTest.assertEquals((int)1, (int)sessionBean.getResourceRefs().size());
        ResourceRef ref = (ResourceRef)sessionBean.getResourceRefs().get(0);
        EjbAnnotationFactoryTest.assertEquals((int)1, (int)ref.getInjectionTargets().size());
        this.assertInjectionTarget("refName", "refClass", (InjectionTarget)ref.getInjectionTargets().get(0));
    }

    private void assertInjectionTarget(String targetName, String targetClass, InjectionTarget target) {
        EjbAnnotationFactoryTest.assertEquals((String)targetClass, (String)target.getInjectionTargetClass());
        EjbAnnotationFactoryTest.assertEquals((String)targetName, (String)target.getInjectionTargetName());
    }
}

