/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class AbstractAnnotationModelTest
extends TestCase {
    protected static final String localInterfaceContent = "package com.sap;import javax.ejb.Local;@Local public interface SessionBeanLocal {}";
    protected static final String beanContent = "package com.sap;import javax.ejb.Stateless;@Stateless public class SessionBean implements SessionBeanLocal {}";
    protected IFacetedProject facetedProject;
    protected IProject clientProject;
    protected IModelProvider fixture;

    protected void setUp() throws Exception {
        super.setUp();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(((Object)((Object)this)).getClass().getSimpleName());
        this.facetedProject = ProjectFacetsManager.create((IProject)project);
    }

    protected void saveFileAndUpdate(IFile beanFile, String beanContent) throws Exception {
        this.saveFileAndUpdate(beanFile, beanContent, this.getFixture());
    }

    protected void saveFileAndUpdate(IFile beanFile, String beanContent, IModelProvider provider) throws Exception {
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        provider.addListener((IModelProviderListener)listener);
        AbstractTest.saveFile(beanFile, beanContent);
        AbstractAnnotationModelTest.assertTrue((boolean)listener.waitForEvents());
        provider.removeListener((IModelProviderListener)listener);
    }

    protected void deleteFileAndUpdate(IFile beanFile) throws Exception, InterruptedException {
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.getFixture().addListener((IModelProviderListener)listener);
        AbstractTest.deleteFile(beanFile);
        AbstractAnnotationModelTest.assertTrue((boolean)listener.waitForEvents());
        this.getFixture().removeListener((IModelProviderListener)listener);
    }

    protected static void createSessionBeanLocal(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("SessionBeanLocal.java"));
        AbstractTest.saveFile(file, localInterfaceContent);
    }

    protected static void createSessionBean(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("SessionBean.java"));
        AbstractTest.saveFile(file, beanContent);
    }

    protected IModelProvider getFixture() {
        return this.fixture;
    }

    protected EJBJar getEJBJar() {
        return (EJBJar)this.getFixture().getModelObject();
    }
}

