/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.fwk;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.IOperationRunnable;
import org.eclipse.jst.validation.test.fwk.TestOpConstrInputOperation;
import org.eclipse.jst.validation.test.fwk.validator.JDTUtility;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.jst.validation.test.internal.util.BVTRunner;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;

public final class VALFWK02Operation
implements IOperationRunnable {
    private IProject _project = null;
    private IBuffer _buffer = null;
    private String _testCaseName = null;
    public static String NEWLINE = System.getProperty("line.separator");

    public VALFWK02Operation() {
    }

    public VALFWK02Operation(IBuffer buffer, IProject project, String testCaseName) {
        this.setProject(project);
        this.setBuffer(buffer);
        this.setName(testCaseName);
    }

    public IBuffer getBuffer() {
        return this._buffer;
    }

    public void setBuffer(IBuffer b) {
        this._buffer = b;
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject p) {
        this._project = p;
    }

    public String getName() {
        return this._testCaseName;
    }

    public void setName(String name) {
        this._testCaseName = name;
    }

    public void run(IProgressMonitor monitor) {
        block18: {
            IProject project = this.getProject();
            if (project == null) {
                throw new IllegalArgumentException("Run VALFWK02 on an existing open IProject.");
            }
            ValidatorManager.addProjectBuildValidationSupport((IProject)project);
            try {
                GlobalConfiguration gconf = ConfigurationManager.getManager().getGlobalConfiguration();
                ProjectConfiguration pconf = ConfigurationManager.getManager().getProjectConfiguration(project);
                GlobalConfiguration origGconf = new GlobalConfiguration(gconf);
                ProjectConfiguration origPconf = new ProjectConfiguration(pconf);
                boolean autoBuildEnabled = ResourcesPlugin.getWorkspace().isAutoBuilding();
                ValidatorMetaData[] configuredValidators = pconf.getValidators();
                if (configuredValidators.length < 2) {
                    monitor.subTask("Run VALFWK02 on an existing open project that has at least two validators configured: one to enable, and one to disable.");
                    return;
                }
                ValidatorMetaData vfTestValidator = ValidationRegistryReader.getReader().getValidatorMetaData("org.eclipse.jst.validation.test.fwk.validator.FwkNoBuildTestValidator");
                ValidatorMetaData vfNoBuildTestValidator = ValidationRegistryReader.getReader().getValidatorMetaData("org.eclipse.jst.validation.test.fwk.validator.FwkTestValidator");
                ValidatorMetaData propertiesValidator = ValidationRegistryReader.getReader().getValidatorMetaData("org.eclipse.wst.validation.sample.PropertiesValidator");
                ValidatorMetaData[] enabledPropValidators = new ValidatorMetaData[]{vfTestValidator, vfNoBuildTestValidator};
                pconf.setEnabledValidators(enabledPropValidators);
                pconf.passivate();
                ValidatorMetaData[] enabledPrefValidators = new ValidatorMetaData[]{propertiesValidator};
                gconf.setEnabledValidators(enabledPrefValidators);
                gconf.passivate();
                ValidatorTestcase[] tmds = JDTUtility.getVFTests(monitor, this.getProject());
                if (tmds == null || tmds.length == 0) {
                    monitor.subTask("Cannot run VALFWK02 because there are no test cases registered for JavaProject.");
                    return;
                }
                ValidatorTestcase fwkNobuildTestTMD = null;
                ValidatorTestcase fwkTestTMD = null;
                ValidatorTestcase propTMD = null;
                int i = 0;
                while (i < tmds.length) {
                    ValidatorTestcase tmd = tmds[i];
                    if (tmd.getValidatorClass().equals("org.eclipse.jst.validation.test.fwk.validator.FwkTestValidator")) {
                        fwkTestTMD = tmd;
                    } else if (tmd.getValidatorClass().equals("org.eclipse.wst.validation.sample.PropertiesValidator")) {
                        propTMD = tmd;
                    } else if (tmd.getValidatorClass().equals("org.eclipse.jst.validation.test.fwk.validator.FwkNoBuildTestValidator")) {
                        fwkNobuildTestTMD = tmd;
                    }
                    if (fwkTestTMD != null && propTMD != null && fwkNobuildTestTMD != null) break;
                    ++i;
                }
                if (fwkTestTMD == null || propTMD == null || fwkNobuildTestTMD == null) {
                    monitor.subTask("Cannot run VALFWK02 because the test case is missing for either the VF Test Validator, Properties Validator, or both.");
                    return;
                }
                try {
                    Tracing.setForceLogging((boolean)true);
                    this.getBuffer().write("testPropNotOverride");
                    int allowPass = this.testPropNotOverride(monitor, project, gconf, pconf, propTMD);
                    this.getBuffer().write(NEWLINE);
                    this.getBuffer().write("testPropOverride");
                    int propPass = this.testPropOverride(monitor, project, gconf, pconf, fwkTestTMD);
                    this.getBuffer().write(NEWLINE);
                    this.getBuffer().write("testPrefNotAllowOverride");
                    int notAllowPass = this.testPrefNotAllowOverride(monitor, project, gconf, pconf, propTMD);
                    StringBuffer result = new StringBuffer(NEWLINE);
                    result.append("Properties Doesn't Override: ");
                    result.append(allowPass);
                    result.append(" of 7 pass.");
                    result.append(NEWLINE);
                    result.append("Properites Overrides: ");
                    result.append(propPass);
                    result.append(" of 7 pass.");
                    result.append(NEWLINE);
                    result.append("Preference Doesn't Allow Override: ");
                    result.append(notAllowPass);
                    result.append(" of 7 pass.");
                    result.append(NEWLINE);
                    monitor.subTask(result.toString());
                    this.getBuffer().write(NEWLINE);
                    this.getBuffer().write(result.toString());
                }
                finally {
                    gconf = origGconf;
                    gconf.passivate();
                    pconf = origPconf;
                    pconf.passivate();
                    JDTUtility.setAutoBuild(autoBuildEnabled);
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)exc);
                    if (exc.getTargetException() != null) {
                        logger.write(Level.SEVERE, exc.getTargetException());
                    }
                }
            }
            catch (Throwable exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block18;
                logger.write(Level.SEVERE, exc);
            }
        }
    }

    private static void debug(IBuffer buffer, String title, ValidatorMetaData[] enabledValidators) {
        buffer.write("Contents of " + title);
        int i = 0;
        while (i < enabledValidators.length) {
            ValidatorMetaData vmd = enabledValidators[i];
            buffer.write("\t" + vmd.getValidatorDisplayName());
            ++i;
        }
        buffer.write("End contents of " + title);
        buffer.write(NEWLINE);
    }

    private int testPropNotOverride(IProgressMonitor monitor, IProject project, GlobalConfiguration gconf, ProjectConfiguration pconf, ValidatorTestcase tmd) {
        int numPass = 0;
        try {
            gconf.setCanProjectsOverride(true);
            gconf.passivate();
            pconf.setDoesProjectOverride(false);
            pconf.passivate();
            ValidatorManager.getManager().updateTaskList(project);
            VALFWK02Operation.debug(this.getBuffer(), "Enabled Properties Validators", pconf.getEnabledValidators());
            VALFWK02Operation.debug(this.getBuffer(), "Enabled Preference Validators", gconf.getEnabledValidators());
            numPass = this.validate(monitor, project, (ValidationConfiguration)gconf, tmd, "testPropNotOverride");
        }
        catch (InvocationTargetException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)exc);
                if (exc.getTargetException() != null) {
                    logger.write(Level.SEVERE, exc.getTargetException());
                }
            }
            numPass = 0;
        }
        catch (Throwable exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, exc);
            }
            numPass = 0;
        }
        return numPass;
    }

    private int testPropOverride(IProgressMonitor monitor, IProject project, GlobalConfiguration gconf, ProjectConfiguration pconf, ValidatorTestcase tmd) {
        int numPass;
        block5: {
            numPass = 0;
            try {
                gconf.setCanProjectsOverride(true);
                gconf.passivate();
                pconf.setDoesProjectOverride(true);
                pconf.passivate();
                ValidatorManager.getManager().updateTaskList(project);
                VALFWK02Operation.debug(this.getBuffer(), "Enabled Properties Validators", pconf.getEnabledValidators());
                VALFWK02Operation.debug(this.getBuffer(), "Enabled Preference Validators", gconf.getEnabledValidators());
                numPass = this.validate(monitor, project, (ValidationConfiguration)pconf, tmd, "testPropOverride");
            }
            catch (InvocationTargetException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)exc);
                    if (exc.getTargetException() != null) {
                        logger.write(Level.SEVERE, exc.getTargetException());
                    }
                }
            }
            catch (Throwable exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block5;
                logger.write(Level.SEVERE, exc);
            }
        }
        return numPass;
    }

    private int testPrefNotAllowOverride(IProgressMonitor monitor, IProject project, GlobalConfiguration gconf, ProjectConfiguration pconf, ValidatorTestcase tmd) {
        int numPass;
        block5: {
            numPass = 0;
            try {
                gconf.setCanProjectsOverride(false);
                gconf.passivate();
                pconf.setDoesProjectOverride(true);
                pconf.passivate();
                ValidatorManager.getManager().updateTaskList(project);
                VALFWK02Operation.debug(this.getBuffer(), "Enabled Properties Validators", pconf.getEnabledValidators());
                VALFWK02Operation.debug(this.getBuffer(), "Enabled Preference Validators", gconf.getEnabledValidators());
                numPass = this.validate(monitor, project, (ValidationConfiguration)gconf, tmd, "testPrefNotAllowOverride");
            }
            catch (InvocationTargetException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)exc);
                    if (exc.getTargetException() != null) {
                        logger.write(Level.SEVERE, exc.getTargetException());
                    }
                }
            }
            catch (Throwable exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block5;
                logger.write(Level.SEVERE, exc);
            }
        }
        return numPass;
    }

    private int validate(IProgressMonitor monitor, IProject project, ValidationConfiguration vconf, ValidatorTestcase tmd, String testName) {
        int numPass = 0;
        boolean successful = true;
        try {
            try {
                vconf.passivate();
                boolean pass = this.runValidation(monitor, project, vconf);
                if (!pass) {
                    successful = false;
                } else {
                    ++numPass;
                }
                this.getBuffer().addExecutionStatus(this.getName(), "::" + testName + "runValidation", pass);
                pass = this.fullBuildValidate(monitor, project, vconf, tmd);
                if (!pass) {
                    successful = false;
                } else {
                    ++numPass;
                }
                this.getBuffer().addExecutionStatus(this.getName(), "::" + testName + "fullBuildValidation", pass);
                pass = this.autoValidateEnabled(monitor, project, vconf, tmd);
                if (!pass) {
                    successful = false;
                } else {
                    ++numPass;
                }
                this.getBuffer().addExecutionStatus(this.getName(), "::" + testName + "autoValidateEnabled", pass);
                pass = this.autoValidateDisabled(monitor, project, vconf, tmd);
                if (!pass) {
                    successful = false;
                } else {
                    ++numPass;
                }
                this.getBuffer().addExecutionStatus(this.getName(), "::" + testName + "autoValidateDisabled", pass);
                pass = this.buildValidateEnabled(monitor, project, vconf, tmd);
                if (!pass) {
                    successful = false;
                } else {
                    ++numPass;
                }
                this.getBuffer().addExecutionStatus(this.getName(), "::" + testName + "buildValidateEnabled", pass);
                pass = this.buildValidateDisabled(monitor, project, vconf, tmd);
                if (!pass) {
                    successful = false;
                } else {
                    ++numPass;
                }
                this.getBuffer().addExecutionStatus(this.getName(), "::" + testName + "buildValidateDisabled", pass);
                vconf.passivate();
                pass = this.maxMessagesReported(monitor, project, vconf);
                if (!pass) {
                    successful = false;
                } else {
                    ++numPass;
                }
                this.getBuffer().addExecutionStatus(this.getName(), "::" + testName + "maxMessagesReported", pass);
            }
            catch (InvocationTargetException exc) {
                successful = false;
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)exc);
                    if (exc.getTargetException() != null) {
                        logger.write(Level.SEVERE, exc.getTargetException());
                    }
                }
                this.getBuffer().addExecutionStatus(this.getName(), testName, successful);
            }
        }
        finally {
            this.getBuffer().addExecutionStatus(this.getName(), testName, successful);
        }
        return numPass;
    }

    private boolean runValidation(IProgressMonitor monitor, IProject project, ValidationConfiguration vconf) {
        boolean passed;
        block9: {
            passed = true;
            try {
                EnabledValidatorsOperation validOp = new EnabledValidatorsOperation(project, false);
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)validOp, monitor);
                Set launchedValidators = validOp.getLaunchedValidators();
                ValidatorMetaData[] enabledValidators = vconf.getEnabledValidators();
                int i = 0;
                while (i < enabledValidators.length) {
                    ValidatorMetaData vmd = enabledValidators[i];
                    if (!launchedValidators.contains(vmd)) {
                        this.getBuffer().write("ERROR: Expected validator " + vmd.getValidatorDisplayName() + " was not run on project " + project.getName() + ". Failing test.");
                        passed = false;
                    } else {
                        this.getBuffer().write("INFO: Expected validator " + vmd.getValidatorDisplayName() + " ran as expected on project " + project.getName() + ".");
                    }
                    ++i;
                }
                if (!passed) {
                    this.getBuffer().write("launched validators are the following:");
                    for (ValidatorMetaData vmd : launchedValidators) {
                        this.getBuffer().write("\t" + vmd.getValidatorDisplayName());
                    }
                    this.getBuffer().write("end of launched validators");
                }
            }
            catch (CoreException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)((Object)exc));
                }
                passed = false;
            }
            catch (InvocationTargetException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block9;
                logger.write(Level.SEVERE, (Exception)exc);
                if (exc.getTargetException() == null) break block9;
                logger.write(Level.SEVERE, exc.getTargetException());
            }
        }
        return passed;
    }

    private boolean fullBuildValidate(IProgressMonitor monitor, IProject project, ValidationConfiguration vconf, ValidatorTestcase tmd) {
        try {
            vconf.passivate();
            TaskListUtility.removeAllTasks((IResource)project);
            IResource[] changedResources = tmd.getResources(project);
            TestOpConstrInputOperation.touch(project, changedResources);
            project.build(6, monitor);
            IMarker[] messagesAfterBuild = TaskListUtility.getValidationTasks((IResource)project, (int)7);
            return BVTRunner.singleton().compare(this.getBuffer(), this.getName(), tmd.getName(), tmd.getMessages(6), messagesAfterBuild);
        }
        catch (CoreException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
            return false;
        }
        catch (InvocationTargetException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)exc);
                if (exc.getTargetException() != null) {
                    logger.write(Level.SEVERE, exc.getTargetException());
                }
            }
            return false;
        }
    }

    private boolean autoValidateEnabled(IProgressMonitor monitor, IProject project, ValidationConfiguration vconf, ValidatorTestcase tmd) {
        JDTUtility.setAutoBuild(true);
        try {
            vconf.passivate();
            TaskListUtility.removeAllTasks((IResource)project);
            IResource[] changedResources = tmd.getResources(project);
            TestOpConstrInputOperation.touch(project, changedResources);
            project.build(9, monitor);
            IMarker[] messagesAfterBuild = TaskListUtility.getValidationTasks((IResource)project, (int)7);
            return BVTRunner.singleton().compare(this.getBuffer(), this.getName(), tmd.getName(), tmd.getMessages(9), messagesAfterBuild);
        }
        catch (CoreException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
            return false;
        }
        catch (InvocationTargetException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)exc);
                if (exc.getTargetException() != null) {
                    logger.write(Level.SEVERE, exc.getTargetException());
                }
            }
            return false;
        }
    }

    private boolean autoValidateDisabled(IProgressMonitor monitor, IProject project, ValidationConfiguration vconf, ValidatorTestcase tmd) {
        JDTUtility.setAutoBuild(true);
        try {
            vconf.passivate();
            TaskListUtility.removeAllTasks((IResource)project);
            IResource[] changedResources = tmd.getResources(project);
            TestOpConstrInputOperation.touch(project, changedResources);
            project.build(9, monitor);
            IMarker[] messagesAfterBuild = TaskListUtility.getValidationTasks((IResource)project, (int)7);
            return BVTRunner.singleton().compare(this.getBuffer(), this.getName(), tmd.getName(), Collections.EMPTY_LIST, messagesAfterBuild);
        }
        catch (CoreException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
            return false;
        }
        catch (InvocationTargetException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)exc);
                if (exc.getTargetException() != null) {
                    logger.write(Level.SEVERE, exc.getTargetException());
                }
            }
            return false;
        }
    }

    private boolean buildValidateEnabled(IProgressMonitor monitor, IProject project, ValidationConfiguration vconf, ValidatorTestcase tmd) {
        try {
            vconf.passivate();
            JDTUtility.setAutoBuild(false);
            TaskListUtility.removeAllTasks((IResource)project);
            IResource[] changedResources = tmd.getResources(project);
            TestOpConstrInputOperation.touch(project, changedResources);
            try {
                project.build(10, monitor);
            }
            catch (CoreException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)((Object)exc));
                }
                return false;
            }
        }
        catch (InvocationTargetException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)exc);
                if (exc.getTargetException() != null) {
                    logger.write(Level.SEVERE, exc.getTargetException());
                }
            }
            return false;
        }
        IMarker[] messagesAfterBuild = TaskListUtility.getValidationTasks((IResource)project, (int)7);
        return BVTRunner.singleton().compare(this.getBuffer(), this.getName(), tmd.getName(), tmd.getMessages(10), messagesAfterBuild);
    }

    private boolean buildValidateDisabled(IProgressMonitor monitor, IProject project, ValidationConfiguration vconf, ValidatorTestcase tmd) {
        try {
            vconf.passivate();
            JDTUtility.setAutoBuild(false);
            TaskListUtility.removeAllTasks((IResource)project);
            IResource[] changedResources = tmd.getResources(project);
            TestOpConstrInputOperation.touch(project, changedResources);
            try {
                project.build(10, monitor);
                IMarker[] messagesAfterBuild = TaskListUtility.getValidationTasks((IResource)project, (int)7);
                return BVTRunner.singleton().compare(this.getBuffer(), this.getName(), tmd.getName(), Collections.EMPTY_LIST, messagesAfterBuild);
            }
            catch (CoreException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)((Object)exc));
                }
                return false;
            }
        }
        catch (InvocationTargetException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)exc);
                if (exc.getTargetException() != null) {
                    logger.write(Level.SEVERE, exc.getTargetException());
                }
            }
            return false;
        }
    }

    private boolean maxMessagesReported(IProgressMonitor monitor, IProject project, ValidationConfiguration vconf) {
        EnabledValidatorsOperation validOp = null;
        try {
            validOp = new EnabledValidatorsOperation(project, false);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)validOp, monitor);
        }
        catch (CoreException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
            return false;
        }
        return false;
    }
}

