/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.tests;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsf.contentassist.tests.BaseTestClass;
import org.eclipse.jst.jsf.contentassist.tests.ContentAssistTestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestFunctionCompletionStrategy
extends BaseTestClass {
    private WebProjectTestEnvironment _testEnv;
    private IFile _jspFile;
    private IType _myBeanType;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._testEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._testEnv.createProject(false);
        TestFunctionCompletionStrategy.assertNotNull((Object)this._testEnv);
        TestFunctionCompletionStrategy.assertNotNull((Object)this._testEnv.getTestProject());
        TestFunctionCompletionStrategy.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
        this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/faces-config_basic.xml.data", "/WEB-INF/faces-config.xml");
        this._jspFile = (IFile)this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/basicELExpressions.jsp.data", "/basicELExpressions.jsp");
        TestFunctionCompletionStrategy.assertNotNull((Object)this._jspFile);
        TestFunctionCompletionStrategy.assertTrue((boolean)this._jspFile.isAccessible());
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        TestFileResource resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
        this._myBeanType = JavaCore.create((IProject)this._testEnv.getTestProject()).findType("beans.MyBean");
        TestFunctionCompletionStrategy.assertNotNull((Object)this._myBeanType);
        TestFunctionCompletionStrategy.assertTrue((boolean)this._myBeanType.exists());
    }

    public void testSanity() throws Exception {
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)614, (String)"value", (String)"#{myBean.property}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)658, (String)"value", (String)"#{paramValues.foo}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)706, (String)"action", (String)"#{myBean.actionMethod}");
        JSFCoreUtilHelper.assertELVariableSanity((IFile)this._jspFile, (String)"myBean");
    }

    public void testFunctionCompletionStrategy() throws Exception {
        List<ICompletionProposal> proposals = this.getProposals(this._jspFile, 614, 8);
        HashSet<String> propNames = new HashSet<String>();
        propNames.add("property");
        propNames.add("class");
        this.assertDisplayNamesMatch(propNames, proposals);
        proposals = this.getProposals(this._jspFile, 706, 8);
        propNames = new HashSet();
        propNames.add("property");
        propNames.add("class");
        propNames.add("getProperty");
        propNames.add("actionMethod");
        propNames.add("equals");
        propNames.add("getClass");
        propNames.add("hashCode");
        propNames.add("notify");
        propNames.add("notifyAll");
        propNames.add("toString");
        propNames.add("wait");
        propNames.add("wait");
        propNames.add("wait");
        TestFunctionCompletionStrategy.assertEquals((int)13, (int)proposals.size());
        for (ICompletionProposal prop : proposals) {
            TestFunctionCompletionStrategy.assertTrue((boolean)propNames.contains(prop.getDisplayString()));
        }
    }
}

