/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.beaninfo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.ImplicitItem;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.tests.JavaProjectUtil;

public abstract class AbstractBeanInfoTestCase
extends TestCase {
    protected BeaninfoNature nature;
    protected ResourceSet rset;
    public static final String TEST_BEANINFO_PROJECT = "Test BeanInfo";
    public static final String TEST_BEANINFO_BEANINFOS_PROJECT = "Test BeanInfo BeanInfos";
    public static final String TEST_BEANINFO_PREREQ_PROJECT = "Test BeanInfo Prereq";
    protected int objFeatures;
    protected int objNonProperties;
    protected Set objFeaturesSet;

    public AbstractBeanInfoTestCase() {
    }

    public AbstractBeanInfoTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IProject biProject = JavaProjectUtil.getProject(TEST_BEANINFO_PROJECT);
        AbstractBeanInfoTestCase.assertNotNull((Object)biProject);
        this.nature = BeaninfoNature.getRuntime((IProject)biProject);
        AbstractBeanInfoTestCase.assertNotNull((Object)this.nature);
        this.rset = this.nature.getResourceSet();
        AbstractBeanInfoTestCase.assertNotNull((Object)this.rset);
        ProxyFactoryRegistry registry = this.nature.getRegistry();
        IArrayBeanProxy sp = Utilities.getBeanInfoSearchPath((ProxyFactoryRegistry)registry);
        int len = sp.getLength();
        int i = 0;
        while (i < len) {
            String path = ((IStringBeanProxy)sp.get(i)).stringValue();
            if (!path.startsWith("org.eclipse.jem.tests")) {
                Utilities.removeBeanInfoPath((ProxyFactoryRegistry)registry, (String)path);
            }
            ++i;
        }
    }

    protected void objFeaturesSetup() {
        JavaClass objClass = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/java.lang#Object"), true);
        this.objFeaturesSet = new HashSet();
        this.objFeatures = objClass.getProperties().size();
        this.objNonProperties = 0;
        Iterator itr0 = objClass.getProperties().iterator();
        while (itr0.hasNext()) {
            EStructuralFeature p = (EStructuralFeature)itr0.next();
            this.objFeaturesSet.add(p);
            PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)p);
            if (pd != null && (pd.getImplicitDecoratorFlag() != ImplicitItem.NOT_IMPLICIT_LITERAL || pd.isMergeIntrospection())) continue;
            ++this.objNonProperties;
        }
    }
}

