/*
** Copyright (c) Oracle Corporation 2004. All Rights Reserved.
**
**345678901234567890123456789012345678901234567890123456789012345678901234567890
*/
package oracle.adfdemo.view.faces;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.faces.event.ActionEvent;

import oracle.adf.view.faces.model.BoundedRangeModel;
import oracle.adf.view.faces.model.DefaultBoundedRangeModel;

/**
 * Bean for progress component demos.
 *
 * @version $Name:  $ ($Revision: 1.5 $) $Date: 2004/07/30 20:41:51 $
 */
public class ProgressBean 
{
  public BoundedRangeModel getProgressModel()
  {
    if (null == __model)
    {
      prepare();
    }
    return __model;
  }
  
  public void cancelProcess(ActionEvent event)
  {
    endProcess();
  }
  
  protected void prepare()
  {
    __model = new DefaultBoundedRangeModel(-1, 125);
    //pu: simulate asynchronous model updates on a different thread
    __processThread = new ProcessThread(500, 0);
    __processThread.start();
  }
  
  protected void endProcess()
  {
    __processThread = null;
    __model = null;
  }
  
  protected class ProcessThread extends Thread
  {
    /**
     * @param updateIntervalFactor - controls the speed of the thread
     * @param updateValueFactor - The value by which the 'value' from the 
     *    model should be incremented for every cycle. Randomizes the increment
     *    if updateValueFactor supplied is '0'.
     */
    ProcessThread(long updateIntervalFactor, long updateValueFactor)
    {
      _updateIntervalFactor = updateIntervalFactor;
      _updateValueFactor = updateValueFactor;
    }
    
    public void run()
    {
      try
      {
        //pu: Be in indeterminate mode for some time to start with
        this.sleep(3000);
        //pu: Take care to get out if we are the discarded thread upon endProcess()
        while ( (__processThread == Thread.currentThread()) &&
                (__model != null) &&
                (__model.getValue() < __model.getMaximum()) 
              )
        {
          long sleepFactor = Math.round(Math.random()*10);
          long updatedValue = __model.getValue() + 
            ((_updateValueFactor == 0) ? sleepFactor:_updateValueFactor);
          long maximum = __model.getMaximum();
          if (updatedValue > maximum)
          {
            updatedValue = maximum;
          }
          __model.setValue(updatedValue);
          this.sleep(sleepFactor * _updateIntervalFactor);
        }
      }
      catch (InterruptedException ie)
      {
        _LOG.log(Level.WARNING, "Background task thread interrupted", ie);
      }
      __model = null;
    }
    private long _updateIntervalFactor;
    private long _updateValueFactor;
  }
  
  protected volatile DefaultBoundedRangeModel __model;
  protected volatile ProcessThread __processThread;

  static private final Logger _LOG = Logger.getLogger(
    ProgressBean.class.getName());

}