/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.dialogs.SelectSingleFileDialog;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;

public class ImportSelectionDialog
extends SelectSingleFileDialog {
    private IFile currentWSDLFile;

    public ImportSelectionDialog(Shell parentShell, IStructuredSelection selection, boolean isFileMandatory) {
        super(parentShell, selection, isFileMandatory);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        IEditorInput editorInput = editor.getEditorInput();
        String[] filters = new String[]{"xsd", "wsdl"};
        if (editorInput instanceof IFileEditorInput) {
            this.currentWSDLFile = ((IFileEditorInput)editorInput).getFile();
            IFile[] excludedFiles = new IFile[]{this.currentWSDLFile};
            this.addFilterExtensions(filters, excludedFiles);
        } else {
            IFile[] excludedFiles = new IFile[]{};
            this.addFilterExtensions(filters, excludedFiles);
        }
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages._UI_TITLE_SELECT);
        this.setTitle(Messages._UI_TITLE_SELECT_FILE);
        this.setMessage(Messages._UI_DESCRIPTION_SELECT_WSDL_OR_XSD);
    }

    public String getImportLocation() {
        IFile selectedFile = this.getFile();
        String location = ComponentReferenceUtil.computeRelativeURI(selectedFile, this.currentWSDLFile, true);
        return location;
    }

    public String getImportNamespace() {
        IFile selectedFile = this.getFile();
        IPath fullPath = selectedFile.getFullPath();
        URI uri = URI.createPlatformResourceURI((String)fullPath.toString(), (boolean)false);
        String importTargetNamespace = WSDLEditorUtil.getTargetNamespaceURIForSchema(uri.toString());
        return importTargetNamespace;
    }
}

