/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.java.JavaOwnableRelationshipReference;
import org.eclipse.jpt.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.OwnableRelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaMappedByJoiningStrategy
extends AbstractJavaJpaContextNode
implements JavaMappedByJoiningStrategy {
    protected OwnableRelationshipMappingAnnotation mappingAnnotation;
    protected String mappedByAttribute;

    public GenericJavaMappedByJoiningStrategy(JavaOwnableRelationshipReference parent) {
        super(parent);
    }

    @Override
    public JavaOwnableRelationshipReference getParent() {
        return (JavaOwnableRelationshipReference)super.getParent();
    }

    @Override
    public JavaOwnableRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public JavaRelationshipMapping getRelationshipMapping() {
        return this.getParent().getRelationshipMapping();
    }

    @Override
    public boolean relationshipIsOwnedBy(RelationshipMapping otherMapping) {
        String targetEntity;
        String thisEntity = this.getRelationshipMapping().getEntity() == null ? null : this.getRelationshipMapping().getEntity().getName();
        String string = targetEntity = this.getRelationshipMapping().getResolvedTargetEntity() == null ? null : this.getRelationshipMapping().getResolvedTargetEntity().getName();
        return StringTools.stringsAreEqual((String)thisEntity, (String)targetEntity) && StringTools.stringsAreEqual((String)this.getMappedByAttribute(), (String)otherMapping.getName());
    }

    @Override
    public String getMappedByAttribute() {
        return this.mappedByAttribute;
    }

    @Override
    public void setMappedByAttribute(String newMappedByAttribute) {
        String oldMappedByAttribute = this.mappedByAttribute;
        this.mappedByAttribute = newMappedByAttribute;
        this.mappingAnnotation.setMappedBy(newMappedByAttribute);
        this.firePropertyChanged("mappedByAttribute", oldMappedByAttribute, newMappedByAttribute);
    }

    protected void setMappedByAttribute_(String newMappedByAttribute) {
        String oldMappedByAttribute = this.mappedByAttribute;
        this.mappedByAttribute = newMappedByAttribute;
        this.firePropertyChanged("mappedByAttribute", oldMappedByAttribute, newMappedByAttribute);
    }

    @Override
    public void addStrategy() {
        if (this.mappedByAttribute == null) {
            this.setMappedByAttribute("");
        }
    }

    @Override
    public void removeStrategy() {
        if (this.mappedByAttribute != null) {
            this.setMappedByAttribute(null);
        }
    }

    @Override
    public void initialize() {
        this.mappingAnnotation = this.getRelationshipReference().getMappingAnnotation();
        this.mappedByAttribute = this.mappingAnnotation.getMappedBy();
    }

    @Override
    public void update() {
        this.mappingAnnotation = this.getRelationshipReference().getMappingAnnotation();
        this.setMappedByAttribute_(this.mappingAnnotation.getMappedBy());
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.mappingAnnotation.mappedByTouches(pos, astRoot)) {
            result = this.javaCandidateMappedByAttributeNames(filter);
        }
        return result;
    }

    @Override
    public Iterator<String> candidateMappedByAttributeNames() {
        return this.getRelationshipMapping().allTargetEntityAttributeNames();
    }

    public Iterator<String> candidateMappedByAttributeNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateMappedByAttributeNames(), filter);
    }

    protected Iterator<String> javaCandidateMappedByAttributeNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateMappedByAttributeNames(filter));
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.getMappedByAttribute() == null) {
            return;
        }
        Entity targetEntity = this.getRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(this.mappedByAttribute);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{this.mappedByAttribute}, this, this.getValidationTextRange(astRoot)));
            return;
        }
        AttributeMapping mappedByMapping = attribute.getMapping();
        if (!this.getRelationshipReference().mayBeMappedBy(mappedByMapping)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{this.mappedByAttribute}, this, this.getValidationTextRange(astRoot)));
            return;
        }
        if (!((RelationshipMapping)mappedByMapping).isRelationshipOwner()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.mappingAnnotation.getMappedByTextRange(astRoot);
    }
}

