/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceGeneratorAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceUniqueConstraintAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraintAnnotation;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceTableGeneratorAnnotation
extends SourceGeneratorAnnotation
implements TableGeneratorAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.TableGenerator");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("name");
    private static final DeclarationAnnotationElementAdapter<Integer> INITIAL_VALUE_ADAPTER = SourceTableGeneratorAnnotation.buildIntegerAdapter("initialValue");
    private static final DeclarationAnnotationElementAdapter<Integer> ALLOCATION_SIZE_ADAPTER = SourceTableGeneratorAnnotation.buildIntegerAdapter("allocationSize");
    private static final DeclarationAnnotationElementAdapter<String> TABLE_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("table");
    private final AnnotationElementAdapter<String> tableAdapter;
    private String table;
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("schema");
    private final AnnotationElementAdapter<String> schemaAdapter;
    private String schema;
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("catalog");
    private final AnnotationElementAdapter<String> catalogAdapter;
    private String catalog;
    private static final DeclarationAnnotationElementAdapter<String> PK_COLUMN_NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("pkColumnName");
    private final AnnotationElementAdapter<String> pkColumnNameAdapter;
    private String pkColumnName;
    private static final DeclarationAnnotationElementAdapter<String> VALUE_COLUMN_NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("valueColumnName");
    private final AnnotationElementAdapter<String> valueColumnNameAdapter;
    private String valueColumnName;
    private static final DeclarationAnnotationElementAdapter<String> PK_COLUMN_VALUE_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("pkColumnValue");
    private final AnnotationElementAdapter<String> pkColumnValueAdapter;
    private String pkColumnValue;
    private final Vector<NestableUniqueConstraintAnnotation> uniqueConstraints = new Vector();
    private final UniqueConstraintsAnnotationContainer uniqueConstraintsContainer = new UniqueConstraintsAnnotationContainer();

    public SourceTableGeneratorAnnotation(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.tableAdapter = this.buildAdapter(TABLE_ADAPTER);
        this.catalogAdapter = this.buildAdapter(CATALOG_ADAPTER);
        this.schemaAdapter = this.buildAdapter(SCHEMA_ADAPTER);
        this.pkColumnNameAdapter = this.buildAdapter(PK_COLUMN_NAME_ADAPTER);
        this.valueColumnNameAdapter = this.buildAdapter(VALUE_COLUMN_NAME_ADAPTER);
        this.pkColumnValueAdapter = this.buildAdapter(PK_COLUMN_VALUE_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.TableGenerator";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.table = this.buildTable(astRoot);
        this.schema = this.buildSchema(astRoot);
        this.catalog = this.buildCatalog(astRoot);
        this.pkColumnName = this.buildPkColumnName(astRoot);
        this.valueColumnName = this.buildValueColumnName(astRoot);
        this.pkColumnValue = this.buildPkColumnValue(astRoot);
        AnnotationContainerTools.initialize(this.uniqueConstraintsContainer, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setTable(this.buildTable(astRoot));
        this.setSchema(this.buildSchema(astRoot));
        this.setCatalog(this.buildCatalog(astRoot));
        this.setPkColumnName(this.buildPkColumnName(astRoot));
        this.setValueColumnName(this.buildValueColumnName(astRoot));
        this.setPkColumnValue(this.buildPkColumnValue(astRoot));
        AnnotationContainerTools.update(this.uniqueConstraintsContainer, astRoot);
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getNameAdapter() {
        return NAME_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter() {
        return INITIAL_VALUE_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter() {
        return ALLOCATION_SIZE_ADAPTER;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public void setTable(String table) {
        if (this.attributeValueHasNotChanged(this.table, table)) {
            return;
        }
        String old = this.table;
        this.table = table;
        this.tableAdapter.setValue(table);
        this.firePropertyChanged("table", old, table);
    }

    private String buildTable(CompilationUnit astRoot) {
        return this.tableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TABLE_ADAPTER, astRoot);
    }

    @Override
    public boolean tableTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(TABLE_ADAPTER, pos, astRoot);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        if (this.attributeValueHasNotChanged(this.schema, schema)) {
            return;
        }
        String old = this.schema;
        this.schema = schema;
        this.schemaAdapter.setValue(schema);
        this.firePropertyChanged("schema", old, schema);
    }

    private String buildSchema(CompilationUnit astRoot) {
        return this.schemaAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SCHEMA_ADAPTER, astRoot);
    }

    @Override
    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(SCHEMA_ADAPTER, pos, astRoot);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        if (this.attributeValueHasNotChanged(this.catalog, catalog)) {
            return;
        }
        String old = this.catalog;
        this.catalog = catalog;
        this.catalogAdapter.setValue(catalog);
        this.firePropertyChanged("catalog", old, catalog);
    }

    private String buildCatalog(CompilationUnit astRoot) {
        return this.catalogAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CATALOG_ADAPTER, astRoot);
    }

    @Override
    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(CATALOG_ADAPTER, pos, astRoot);
    }

    @Override
    public String getPkColumnName() {
        return this.pkColumnName;
    }

    @Override
    public void setPkColumnName(String pkColumnName) {
        if (this.attributeValueHasNotChanged(this.pkColumnName, pkColumnName)) {
            return;
        }
        String old = this.pkColumnName;
        this.pkColumnName = pkColumnName;
        this.pkColumnNameAdapter.setValue(pkColumnName);
        this.firePropertyChanged("pkColumnName", old, pkColumnName);
    }

    private String buildPkColumnName(CompilationUnit astRoot) {
        return this.pkColumnNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getPkColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(PK_COLUMN_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean pkColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(PK_COLUMN_NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public String getValueColumnName() {
        return this.valueColumnName;
    }

    @Override
    public void setValueColumnName(String valueColumnName) {
        if (this.attributeValueHasNotChanged(this.valueColumnName, valueColumnName)) {
            return;
        }
        String old = this.valueColumnName;
        this.valueColumnName = valueColumnName;
        this.valueColumnNameAdapter.setValue(valueColumnName);
        this.firePropertyChanged("valueColumnName", old, valueColumnName);
    }

    private String buildValueColumnName(CompilationUnit astRoot) {
        return this.valueColumnNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_COLUMN_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean valueColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(VALUE_COLUMN_NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    @Override
    public void setPkColumnValue(String pkColumnValue) {
        if (this.attributeValueHasNotChanged(this.pkColumnValue, pkColumnValue)) {
            return;
        }
        String old = this.pkColumnValue;
        this.pkColumnValue = pkColumnValue;
        this.pkColumnValueAdapter.setValue(pkColumnValue);
        this.firePropertyChanged("pkColumnValue", old, pkColumnValue);
    }

    private String buildPkColumnValue(CompilationUnit astRoot) {
        return this.pkColumnValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getPkColumnValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(PK_COLUMN_VALUE_ADAPTER, astRoot);
    }

    @Override
    public boolean pkColumnValueTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(PK_COLUMN_VALUE_ADAPTER, pos, astRoot);
    }

    @Override
    public ListIterator<UniqueConstraintAnnotation> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    ListIterator<NestableUniqueConstraintAnnotation> nestableUniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public NestableUniqueConstraintAnnotation uniqueConstraintAt(int index) {
        return this.uniqueConstraints.get(index);
    }

    @Override
    public int indexOfUniqueConstraint(UniqueConstraintAnnotation uniqueConstraint) {
        return this.uniqueConstraints.indexOf(uniqueConstraint);
    }

    @Override
    public NestableUniqueConstraintAnnotation addUniqueConstraint(int index) {
        return (NestableUniqueConstraintAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation addUniqueConstraintInternal() {
        NestableUniqueConstraintAnnotation uniqueConstraint = this.buildUniqueConstraint(this.uniqueConstraints.size());
        this.uniqueConstraints.add(uniqueConstraint);
        return uniqueConstraint;
    }

    private NestableUniqueConstraintAnnotation buildUniqueConstraint(int index) {
        return SourceUniqueConstraintAnnotation.createTableGeneratorUniqueConstraint(this, this.member, index);
    }

    void uniqueConstraintAdded(int index, NestableUniqueConstraintAnnotation constraint) {
        this.fireItemAdded("uniqueConstraints", index, constraint);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation moveUniqueConstraintInternal(int targetIndex, int sourceIndex) {
        return (NestableUniqueConstraintAnnotation)CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void uniqueConstraintMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("uniqueConstraints", targetIndex, sourceIndex);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation removeUniqueConstraintInternal(int index) {
        return this.uniqueConstraints.remove(index);
    }

    void uniqueConstraintRemoved(int index, NestableUniqueConstraintAnnotation constraint) {
        this.fireItemRemoved("uniqueConstraints", index, constraint);
    }

    private static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SourceTableGeneratorAnnotation.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(String elementName) {
        return SourceTableGeneratorAnnotation.buildIntegerAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UniqueConstraintsAnnotationContainer
    implements AnnotationContainer<NestableUniqueConstraintAnnotation> {
        UniqueConstraintsAnnotationContainer() {
        }

        @Override
        public String getContainerAnnotationName() {
            return SourceTableGeneratorAnnotation.this.getAnnotationName();
        }

        @Override
        public Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
            return SourceTableGeneratorAnnotation.this.getJdtAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return "uniqueConstraints";
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.UniqueConstraint";
        }

        @Override
        public ListIterator<NestableUniqueConstraintAnnotation> nestedAnnotations() {
            return SourceTableGeneratorAnnotation.this.nestableUniqueConstraints();
        }

        @Override
        public int nestedAnnotationsSize() {
            return SourceTableGeneratorAnnotation.this.uniqueConstraintsSize();
        }

        @Override
        public NestableUniqueConstraintAnnotation addNestedAnnotationInternal() {
            return SourceTableGeneratorAnnotation.this.addUniqueConstraintInternal();
        }

        @Override
        public void nestedAnnotationAdded(int index, NestableUniqueConstraintAnnotation nestedAnnotation) {
            SourceTableGeneratorAnnotation.this.uniqueConstraintAdded(index, nestedAnnotation);
        }

        @Override
        public NestableUniqueConstraintAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return SourceTableGeneratorAnnotation.this.moveUniqueConstraintInternal(targetIndex, sourceIndex);
        }

        @Override
        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            SourceTableGeneratorAnnotation.this.uniqueConstraintMoved(targetIndex, sourceIndex);
        }

        @Override
        public NestableUniqueConstraintAnnotation removeNestedAnnotationInternal(int index) {
            return SourceTableGeneratorAnnotation.this.removeUniqueConstraintInternal(index);
        }

        @Override
        public void nestedAnnotationRemoved(int index, NestableUniqueConstraintAnnotation nestedAnnotation) {
            SourceTableGeneratorAnnotation.this.uniqueConstraintRemoved(index, nestedAnnotation);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

