/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaJoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinTable
extends AbstractJavaTable
implements JavaJoinTable {
    protected JavaResourcePersistentAttribute resourceAttribute;
    protected JavaJoinColumn defaultJoinColumn;
    protected final List<JavaJoinColumn> specifiedJoinColumns = new ArrayList<JavaJoinColumn>();
    protected JavaJoinColumn defaultInverseJoinColumn;
    protected final List<JavaJoinColumn> specifiedInverseJoinColumns = new ArrayList<JavaJoinColumn>();

    public GenericJavaJoinTable(JavaJoinTableJoiningStrategy parent) {
        super(parent);
    }

    @Override
    public JavaJoinTableJoiningStrategy getParent() {
        return (JavaJoinTableJoiningStrategy)super.getParent();
    }

    @Override
    public JavaRelationshipMapping getRelationshipMapping() {
        return this.getParent().getRelationshipReference().getRelationshipMapping();
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    protected String buildDefaultName() {
        return this.getRelationshipMapping().getJoinTableDefaultName();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected JoinTableAnnotation getResourceTable() {
        return (JoinTableAnnotation)this.resourceAttribute.getNonNullSupportingAnnotation("javax.persistence.JoinTable");
    }

    protected JoinTableAnnotation getResourceTableOrNull() {
        return (JoinTableAnnotation)this.resourceAttribute.getSupportingAnnotation("javax.persistence.JoinTable");
    }

    protected void addResourceJoinTable() {
        this.resourceAttribute.addSupportingAnnotation("javax.persistence.JoinTable");
    }

    @Override
    public boolean isResourceSpecified() {
        return this.getResourceTableOrNull() != null;
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn newJoinColumn) {
        JavaJoinColumn oldJoinColumn = this.defaultJoinColumn;
        this.defaultJoinColumn = newJoinColumn;
        this.firePropertyChanged("defaultJoinColumn", oldJoinColumn, newJoinColumn);
    }

    protected ListIterator<JavaJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JavaJoinColumn oldDefaultJoinColumn = this.getDefaultJoinColumn();
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        if (this.getResourceTableOrNull() == null) {
            this.addResourceJoinTable();
        }
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        this.specifiedJoinColumns.add(index, joinColumn);
        JoinColumnAnnotation joinColumnResource = this.getResourceTable().addJoinColumn(index);
        joinColumn.initialize(joinColumnResource);
        this.fireItemAdded("specifiedJoinColumns", index, joinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, JavaJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void addSpecifiedJoinColumn(JavaJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (!this.containsSpecifiedJoinColumns()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumnAnnotation(this.getResourceTable()));
        }
        this.getResourceTable().removeJoinColumn(index);
        this.fireItemRemoved("specifiedJoinColumns", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourceTable().moveJoinColumn(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaJoinColumn> inverseJoinColumns() {
        return this.containsSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumns() : this.defaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.containsSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.defaultInverseJoinColumnsSize();
    }

    @Override
    public JavaJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(JavaJoinColumn newInverseJoinColumn) {
        JavaJoinColumn oldInverseJoinColumn = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = newInverseJoinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", oldInverseJoinColumn, newInverseJoinColumn);
    }

    protected ListIterator<JavaJoinColumn> defaultInverseJoinColumns() {
        if (this.defaultInverseJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultInverseJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedInverseJoinColumns() {
        return new CloneListIterator(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    @Override
    public boolean containsSpecifiedInverseJoinColumns() {
        return !this.specifiedInverseJoinColumns.isEmpty();
    }

    @Override
    public JavaJoinColumn addSpecifiedInverseJoinColumn(int index) {
        JavaJoinColumn oldDefaultInverseJoinColumn = this.getDefaultInverseJoinColumn();
        if (oldDefaultInverseJoinColumn != null) {
            this.defaultInverseJoinColumn = null;
        }
        if (this.getResourceTableOrNull() == null) {
            this.addResourceJoinTable();
        }
        JavaJoinColumn inverseJoinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createInverseJoinColumnOwner());
        this.specifiedInverseJoinColumns.add(index, inverseJoinColumn);
        JoinColumnAnnotation joinColumnResource = this.getResourceTable().addInverseJoinColumn(index);
        inverseJoinColumn.initialize(joinColumnResource);
        this.fireItemAdded("specifiedInverseJoinColumns", index, inverseJoinColumn);
        if (oldDefaultInverseJoinColumn != null) {
            this.firePropertyChanged("defaultInverseJoinColumn", oldDefaultInverseJoinColumn, null);
        }
        return inverseJoinColumn;
    }

    protected void addSpecifiedInverseJoinColumn(int index, JavaJoinColumn inverseJoinColumn) {
        this.addItemToList(index, inverseJoinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    protected void addSpecifiedInverseJoinColumn(JavaJoinColumn inverseJoinColumn) {
        this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.size(), inverseJoinColumn);
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn inverseJoinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.indexOf(inverseJoinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedInverseJoinColumns.remove(index);
        if (!this.containsSpecifiedInverseJoinColumns()) {
            this.defaultInverseJoinColumn = this.buildInverseJoinColumn(new NullJoinColumnAnnotation(this.getResourceTable()));
        }
        this.getResourceTable().removeInverseJoinColumn(index);
        this.fireItemRemoved("specifiedInverseJoinColumns", index, removedJoinColumn);
        if (this.defaultInverseJoinColumn != null) {
            this.firePropertyChanged("defaultInverseJoinColumn", null, this.defaultInverseJoinColumn);
        }
    }

    protected void removeSpecifiedInverseJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedInverseJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourceTable().moveInverseJoinColumn(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedInverseJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.inverseJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected JavaJoinColumn.Owner createJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected JavaJoinColumn.Owner createInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    @Override
    public void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourceAttribute = jrpa;
        JoinTableAnnotation joinTable = this.getResourceTable();
        this.initialize(joinTable);
        this.initializeSpecifiedJoinColumns(joinTable);
        this.initializeDefaultJoinColumn(joinTable);
        this.initializeSpecifiedInverseJoinColumns(joinTable);
        this.initializeDefaultInverseJoinColumn(joinTable);
    }

    protected void initializeSpecifiedJoinColumns(JoinTableAnnotation joinTableResource) {
        ListIterator<JoinColumnAnnotation> annotations = joinTableResource.joinColumns();
        while (annotations.hasNext()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(annotations.next()));
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.containsSpecifiedJoinColumns();
    }

    protected void initializeDefaultJoinColumn(JoinTableAnnotation joinTable) {
        if (!this.shouldBuildDefaultJoinColumn()) {
            return;
        }
        this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumnAnnotation(joinTable));
    }

    protected void initializeSpecifiedInverseJoinColumns(JoinTableAnnotation joinTableResource) {
        ListIterator<JoinColumnAnnotation> annotations = joinTableResource.inverseJoinColumns();
        while (annotations.hasNext()) {
            this.specifiedInverseJoinColumns.add(this.buildInverseJoinColumn(annotations.next()));
        }
    }

    protected boolean shouldBuildDefaultInverseJoinColumn() {
        return !this.containsSpecifiedInverseJoinColumns();
    }

    protected void initializeDefaultInverseJoinColumn(JoinTableAnnotation joinTable) {
        if (!this.shouldBuildDefaultInverseJoinColumn()) {
            return;
        }
        this.defaultInverseJoinColumn = this.buildInverseJoinColumn(new NullJoinColumnAnnotation(joinTable));
    }

    @Override
    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourceAttribute = jrpa;
        JoinTableAnnotation joinTable = this.getResourceTable();
        this.update(joinTable);
        this.updateSpecifiedJoinColumns(joinTable);
        this.updateDefaultJoinColumn(joinTable);
        this.updateSpecifiedInverseJoinColumns(joinTable);
        this.updateDefaultInverseJoinColumn(joinTable);
    }

    protected void updateSpecifiedJoinColumns(JoinTableAnnotation joinTableResource) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator<JoinColumnAnnotation> resourceJoinColumns = joinTableResource.joinColumns();
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update(resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn(resourceJoinColumns.next()));
        }
    }

    protected void updateDefaultJoinColumn(JoinTableAnnotation joinTable) {
        if (!this.shouldBuildDefaultJoinColumn()) {
            this.setDefaultJoinColumn(null);
            return;
        }
        if (this.getDefaultJoinColumn() == null) {
            this.setDefaultJoinColumn(this.buildJoinColumn(new NullJoinColumnAnnotation(joinTable)));
        } else {
            this.defaultJoinColumn.update(new NullJoinColumnAnnotation(joinTable));
        }
    }

    protected void updateSpecifiedInverseJoinColumns(JoinTableAnnotation joinTableResource) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedInverseJoinColumns();
        ListIterator<JoinColumnAnnotation> resourceJoinColumns = joinTableResource.inverseJoinColumns();
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update(resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedInverseJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedInverseJoinColumn(this.buildInverseJoinColumn(resourceJoinColumns.next()));
        }
    }

    protected void updateDefaultInverseJoinColumn(JoinTableAnnotation joinTable) {
        if (!this.shouldBuildDefaultInverseJoinColumn()) {
            this.setDefaultInverseJoinColumn(null);
            return;
        }
        if (this.getDefaultInverseJoinColumn() == null) {
            this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(new NullJoinColumnAnnotation(joinTable)));
        } else {
            this.defaultInverseJoinColumn.update(new NullJoinColumnAnnotation(joinTable));
        }
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        joinColumn.initialize(joinColumnResource);
        return joinColumn;
    }

    protected JavaJoinColumn buildInverseJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createInverseJoinColumnOwner());
        joinColumn.initialize(joinColumnResource);
        return joinColumn;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.getRelationshipMapping().shouldValidateAgainstDatabase()) {
            this.validateAgainstDatabase(messages, reporter, astRoot);
        }
    }

    protected void validateAgainstDatabase(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (!this.hasResolvedCatalog()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_CATALOG", new String[]{this.getCatalog(), this.getName()}, this, this.getCatalogTextRange(astRoot)));
            return;
        }
        if (!this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{this.getSchema(), this.getName()}, this, this.getSchemaTextRange(astRoot)));
            return;
        }
        if (!this.isResolved()) {
            if (this.getName() != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange(astRoot)));
            }
            return;
        }
        this.validateJoinColumns(this.joinColumns(), messages, reporter, astRoot);
        this.validateJoinColumns(this.inverseJoinColumns(), messages, reporter, astRoot);
    }

    protected void validateJoinColumns(Iterator<JavaJoinColumn> joinColumns, List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        while (joinColumns.hasNext()) {
            joinColumns.next().validate(messages, reporter, astRoot);
        }
    }

    protected abstract class AbstractJoinColumnOwner
    implements JavaJoinColumn.Owner {
        AbstractJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationshipMapping().getTypeMapping();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericJavaJoinTable.this.getRelationshipMapping();
        }

        public boolean tableNameIsInvalid(String tableName) {
            return false;
        }

        public boolean tableIsAllowed() {
            return false;
        }

        public Table getDbTable(String tableName) {
            if (GenericJavaJoinTable.this.getName() == null) {
                return null;
            }
            return GenericJavaJoinTable.this.getName().equals(tableName) ? GenericJavaJoinTable.this.getDbTable() : null;
        }

        public String getDefaultTableName() {
            return GenericJavaJoinTable.this.getName();
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaJoinTable.this.getValidationTextRange(astRoot);
        }
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        public Entity getTargetEntity() {
            return GenericJavaJoinTable.this.getRelationshipMapping().getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return GenericJavaJoinTable.this.getRelationshipMapping().getName();
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericJavaJoinTable.this.inverseJoinColumnsSize();
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        public Entity getTargetEntity() {
            return GenericJavaJoinTable.this.getRelationshipMapping().getEntity();
        }

        public String getAttributeName() {
            Entity targetEntity = GenericJavaJoinTable.this.getRelationshipMapping().getResolvedTargetEntity();
            if (targetEntity == null) {
                return null;
            }
            for (PersistentAttribute each : CollectionTools.iterable(targetEntity.getPersistentType().allAttributes())) {
                if (!each.getMapping().isOwnedBy(this.getRelationshipMapping())) continue;
                return each.getName();
            }
            return null;
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            return dbTable != null ? dbTable : this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericJavaJoinTable.this.joinColumnsSize();
        }
    }
}

