/***************************************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM Corporation - initial API and implementation
 *   Oracle Corporation - revision
 **************************************************************************************************/
package org.eclipse.jst.jsf.facesconfig.emf;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Icon Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.jst.jsf.facesconfig.emf.IconType#getSmallIcon <em>Small Icon</em>}</li>
 *   <li>{@link org.eclipse.jst.jsf.facesconfig.emf.IconType#getLargeIcon <em>Large Icon</em>}</li>
 *   <li>{@link org.eclipse.jst.jsf.facesconfig.emf.IconType#getLang <em>Lang</em>}</li>
 *   <li>{@link org.eclipse.jst.jsf.facesconfig.emf.IconType#getId <em>Id</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage#getIconType()
 * @model extendedMetaData="name='icon_._type' kind='empty'"
 * @generated
 */
public interface IconType extends EObject {
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String copyright = "Copyright (c) 2005, 2006 IBM Corporation and others"; //$NON-NLS-1$

    /**
     * Returns the value of the '<em><b>Small Icon</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Small Icon</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Small Icon</em>' containment reference.
     * @see #setSmallIcon(SmallIconType)
     * @see org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage#getIconType_SmallIcon()
     * @model containment="true"
     *        extendedMetaData="kind='element' name='small-icon' namespace='##targetNamespace'"
     * @generated
     */
	SmallIconType getSmallIcon();

    /**
     * Sets the value of the '{@link org.eclipse.jst.jsf.facesconfig.emf.IconType#getSmallIcon <em>Small Icon</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Small Icon</em>' containment reference.
     * @see #getSmallIcon()
     * @generated
     */
	void setSmallIcon(SmallIconType value);

    /**
     * Returns the value of the '<em><b>Large Icon</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Large Icon</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Large Icon</em>' containment reference.
     * @see #setLargeIcon(LargeIconType)
     * @see org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage#getIconType_LargeIcon()
     * @model containment="true"
     *        extendedMetaData="kind='element' name='large-icon' namespace='##targetNamespace'"
     * @generated
     */
	LargeIconType getLargeIcon();

    /**
     * Sets the value of the '{@link org.eclipse.jst.jsf.facesconfig.emf.IconType#getLargeIcon <em>Large Icon</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Large Icon</em>' containment reference.
     * @see #getLargeIcon()
     * @generated
     */
	void setLargeIcon(LargeIconType value);

    /**
     * Returns the value of the '<em><b>Lang</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lang</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Lang</em>' attribute.
     * @see #setLang(String)
     * @see org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage#getIconType_Lang()
     * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.Language"
     *        extendedMetaData="kind='attribute' name='lang' namespace='http://www.w3.org/XML/1998/namespace'"
     * @generated
     */
	String getLang();

    /**
     * Sets the value of the '{@link org.eclipse.jst.jsf.facesconfig.emf.IconType#getLang <em>Lang</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Lang</em>' attribute.
     * @see #getLang()
     * @generated
     */
	void setLang(String value);

    /**
     * Returns the value of the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Id</em>' attribute.
     * @see #setId(String)
     * @see org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage#getIconType_Id()
     * @model unique="false" id="true" dataType="org.eclipse.emf.ecore.xml.type.ID"
     *        extendedMetaData="kind='attribute' name='id' namespace='##targetNamespace'"
     * @generated
     */
	String getId();

    /**
     * Sets the value of the '{@link org.eclipse.jst.jsf.facesconfig.emf.IconType#getId <em>Id</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Id</em>' attribute.
     * @see #getId()
     * @generated
     */
	void setId(String value);

} // IconType
