/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.text.StructuredTextPartitionerForJSP;
import org.eclipse.jst.jsp.ui.internal.autoedit.AutoEditStrategyForTabs;
import org.eclipse.jst.jsp.ui.internal.autoedit.StructuredAutoEditStrategyJSP;
import org.eclipse.jst.jsp.ui.internal.autoedit.StructuredAutoEditStrategyJSPJava;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPContentAssistProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPELContentAssistProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPJavaContentAssistProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.NoRegionContentAssistProcessorForJSP;
import org.eclipse.jst.jsp.ui.internal.format.FormattingStrategyJSPJava;
import org.eclipse.jst.jsp.ui.internal.style.LineStyleProviderForJSP;
import org.eclipse.jst.jsp.ui.internal.style.java.LineStyleProviderForJava;
import org.eclipse.jst.jsp.ui.internal.style.jspel.LineStyleProviderForJSPEL;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class StructuredTextViewerConfigurationJSP
extends StructuredTextViewerConfiguration {
    private String[] fConfiguredContentTypes;
    private LineStyleProvider fLineStyleProviderForJava;
    private LineStyleProvider fLineStyleProviderForJSP;
    private LineStyleProvider fLineStyleProviderForJSPEL;
    private StructuredTextViewerConfiguration fHTMLSourceViewerConfiguration;
    private JavaSourceViewerConfiguration fJavaSourceViewerConfiguration;
    private StructuredTextViewerConfiguration fXMLSourceViewerConfiguration;
    private ILabelProvider fStatusLineLabelProvider;

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] strategies = null;
        if (contentType == "org.eclipse.wst.xml.XML_DEFAULT") {
            strategies = this.getXMLSourceViewerConfiguration().getAutoEditStrategies(sourceViewer, contentType);
        } else if (contentType == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
            allStrategies.add(new StructuredAutoEditStrategyJSPJava());
            IAutoEditStrategy[] javaStrategies = this.getJavaSourceViewerConfiguration().getAutoEditStrategies(sourceViewer, "___java_partitioning");
            int i = 0;
            while (i < javaStrategies.length) {
                allStrategies.add(javaStrategies[i]);
                ++i;
            }
            allStrategies.add(new AutoEditStrategyForTabs());
            strategies = allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
        } else if (contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.HTML_DECLARATION") {
            ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
            allStrategies.add(new StructuredAutoEditStrategyJSP());
            IAutoEditStrategy[] htmlStrategies = this.getHTMLSourceViewerConfiguration().getAutoEditStrategies(sourceViewer, contentType);
            int i = 0;
            while (i < htmlStrategies.length) {
                allStrategies.add(htmlStrategies[i]);
                ++i;
            }
            strategies = allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
        } else {
            ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
            IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
            int i = 0;
            while (i < superStrategies.length) {
                allStrategies.add(superStrategies[i]);
                ++i;
            }
            allStrategies.add(new AutoEditStrategyForTabs());
            strategies = allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
        }
        return strategies;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.fConfiguredContentTypes == null) {
            String[] htmlTypes = this.getHTMLSourceViewerConfiguration().getConfiguredContentTypes(sourceViewer);
            String[] jspTypes = StructuredTextPartitionerForJSP.getConfiguredContentTypes();
            this.fConfiguredContentTypes = new String[htmlTypes.length + jspTypes.length];
            int index = 0;
            System.arraycopy(htmlTypes, 0, this.fConfiguredContentTypes, index, htmlTypes.length);
            System.arraycopy(jspTypes, 0, this.fConfiguredContentTypes, index += htmlTypes.length, jspTypes.length);
        }
        return this.fConfiguredContentTypes;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (partitionType == "org.eclipse.wst.html.SCRIPT") {
            IContentAssistant htmlContentAssistant = this.getHTMLSourceViewerConfiguration().getContentAssistant(sourceViewer);
            IContentAssistProcessor processor = htmlContentAssistant.getContentAssistProcessor("org.eclipse.wst.html.SCRIPT");
            processors = new IContentAssistProcessor[]{processor};
        } else if (partitionType == "org.eclipse.wst.css.STYLE") {
            IContentAssistant htmlContentAssistant = this.getHTMLSourceViewerConfiguration().getContentAssistant(sourceViewer);
            IContentAssistProcessor processor = htmlContentAssistant.getContentAssistProcessor("org.eclipse.wst.css.STYLE");
            processors = new IContentAssistProcessor[]{processor};
        } else if (partitionType == "org.eclipse.wst.xml.XML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_COMMENT" || partitionType == "org.eclipse.jst.jsp.DEFAULT_JSP" || partitionType == "org.eclipse.jst.jsp.JSP_DIRECTIVE" || partitionType == "org.eclipse.jst.jsp.SCRIPT.DELIMITER" || partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT" || partitionType == "org.eclipse.jst.jsp.JSP_COMMENT") {
            processors = new IContentAssistProcessor[]{new JSPContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.xml.XML_CDATA" || partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            processors = new IContentAssistProcessor[]{new JSPJavaContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.jst.jsp.SCRIPT.JSP_EL") {
            processors = new IContentAssistProcessor[]{new JSPELContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE") {
            processors = new IContentAssistProcessor[]{new NoRegionContentAssistProcessorForJSP()};
        }
        return processors;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IContentFormatter formatter = super.getContentFormatter(sourceViewer);
        if (!(formatter instanceof MultiPassContentFormatter)) {
            formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.xml.XML_DEFAULT");
        }
        MultiPassContentFormatter multiFormatter = (MultiPassContentFormatter)formatter;
        multiFormatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new HTMLFormatProcessorImpl()));
        multiFormatter.setSlaveStrategy((IFormattingStrategy)new FormattingStrategyJSPJava(), "org.eclipse.jst.jsp.SCRIPT.JAVA");
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        ITextDoubleClickStrategy strategy = null;
        strategy = contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.SCRIPT" ? this.getHTMLSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, contentType) : (contentType == "org.eclipse.jst.jsp.SCRIPT.JAVA" || contentType == "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT" ? this.getJavaSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, contentType) : (contentType == "org.eclipse.jst.jsp.DEFAULT_JSP" ? this.getHTMLSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, "org.eclipse.wst.html.HTML_DEFAULT") : super.getDoubleClickStrategy(sourceViewer, contentType)));
        return strategy;
    }

    private StructuredTextViewerConfiguration getHTMLSourceViewerConfiguration() {
        if (this.fHTMLSourceViewerConfiguration == null) {
            this.fHTMLSourceViewerConfiguration = new StructuredTextViewerConfigurationHTML();
        }
        return this.fHTMLSourceViewerConfiguration;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        String[] indentations = null;
        indentations = contentType == "org.eclipse.wst.xml.XML_DEFAULT" ? this.getXMLSourceViewerConfiguration().getIndentPrefixes(sourceViewer, contentType) : this.getHTMLSourceViewerConfiguration().getIndentPrefixes(sourceViewer, contentType);
        return indentations;
    }

    private JavaSourceViewerConfiguration getJavaSourceViewerConfiguration() {
        if (this.fJavaSourceViewerConfiguration == null) {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            this.fJavaSourceViewerConfiguration = new JavaSourceViewerConfiguration(JavaUI.getColorManager(), store, null, "___java_partitioning");
        }
        return this.fJavaSourceViewerConfiguration;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        if (partitionType == "org.eclipse.wst.html.HTML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_COMMENT" || partitionType == "org.eclipse.wst.html.HTML_DECLARATION") {
            providers = this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.html.HTML_DEFAULT");
        } else if (partitionType == "org.eclipse.wst.html.SCRIPT" || partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT") {
            providers = this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.html.SCRIPT");
        } else if (partitionType == "org.eclipse.wst.css.STYLE") {
            providers = this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.css.STYLE");
        } else if (partitionType == "org.eclipse.wst.xml.XML_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_CDATA" || partitionType == "org.eclipse.wst.xml.XML_COMMENT" || partitionType == "org.eclipse.wst.xml.XML_DECL" || partitionType == "org.eclipse.wst.xml.XML_PI") {
            providers = this.getXMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.xml.XML_DEFAULT");
        } else if (partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForJava()};
        } else if (partitionType == "org.eclipse.jst.jsp.SCRIPT.JSP_EL") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForJSPEL()};
        } else if (partitionType == "org.eclipse.jst.jsp.JSP_COMMENT" || partitionType == "org.eclipse.jst.jsp.SCRIPT.DELIMITER" || partitionType == "org.eclipse.jst.jsp.DEFAULT_JSP" || partitionType == "org.eclipse.jst.jsp.JSP_DIRECTIVE") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForJSP()};
        }
        return providers;
    }

    private LineStyleProvider getLineStyleProviderForJava() {
        if (this.fLineStyleProviderForJava == null) {
            this.fLineStyleProviderForJava = new LineStyleProviderForJava();
        }
        return this.fLineStyleProviderForJava;
    }

    private LineStyleProvider getLineStyleProviderForJSP() {
        if (this.fLineStyleProviderForJSP == null) {
            this.fLineStyleProviderForJSP = new LineStyleProviderForJSP();
        }
        return this.fLineStyleProviderForJSP;
    }

    private LineStyleProvider getLineStyleProviderForJSPEL() {
        if (this.fLineStyleProviderForJSPEL == null) {
            this.fLineStyleProviderForJSPEL = new LineStyleProviderForJSPEL();
        }
        return this.fLineStyleProviderForJSPEL;
    }

    public ILabelProvider getStatusLineLabelProvider(ISourceViewer sourceViewer) {
        if (this.fStatusLineLabelProvider == null) {
            this.fStatusLineLabelProvider = new JFaceNodeLabelProvider(){

                public String getText(Object element) {
                    if (element == null) {
                        return null;
                    }
                    StringBuffer s = new StringBuffer();
                    Node node = (Node)element;
                    while (node != null) {
                        if (node.getNodeType() != 9) {
                            s.insert(0, super.getText((Object)node));
                        }
                        if ((node = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode()) == null || node.getNodeType() == 9) continue;
                        s.insert(0, '/');
                    }
                    return s.toString();
                }
            };
        }
        return this.fStatusLineLabelProvider;
    }

    private StructuredTextViewerConfiguration getXMLSourceViewerConfiguration() {
        if (this.fXMLSourceViewerConfiguration == null) {
            this.fXMLSourceViewerConfiguration = new StructuredTextViewerConfigurationXML();
        }
        return this.fXMLSourceViewerConfiguration;
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put(ContentTypeIdForJSP.ContentTypeID_JSP, null);
        targets.put(ContentTypeIdForHTML.ContentTypeID_HTML, null);
        targets.put(ContentTypeIdForXML.ContentTypeID_XML, null);
        return targets;
    }
}

