/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaResourceModel;
import org.eclipse.jpt.core.JpaResourceModelListener;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.core.internal.SynchronousJpaProjectUpdater;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryPersistentTypeCache;
import org.eclipse.jpt.core.internal.resource.java.source.SourceCompilationUnit;
import org.eclipse.jpt.core.internal.utility.PlatformTools;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentTypeCache;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.internal.BitTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.ThreadLocalCommandExecutor;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaProject
extends AbstractJpaNode
implements JpaProject {
    protected final IProject project;
    protected final JpaPlatform jpaPlatform;
    protected final Vector<JpaFile> jpaFiles = new Vector();
    protected final Vector<JavaResourceCompilationUnit> externalJavaResourceCompilationUnits = new Vector();
    protected final JavaResourcePersistentTypeCache externalJavaResourcePersistentTypeCache;
    protected final JpaResourceModelListener resourceModelListener;
    protected final JpaRootContextNode rootContextNode;
    protected JpaProject.Updater updater;
    protected final JpaDataSource dataSource;
    protected String userOverrideDefaultCatalog;
    protected String userOverrideDefaultSchema;
    protected boolean discoversAnnotatedClasses;
    protected final ThreadLocalCommandExecutor modifySharedDocumentCommandExecutor;

    public AbstractJpaProject(JpaProject.Config config) throws CoreException {
        super(null);
        if (config.getProject() == null || config.getJpaPlatform() == null) {
            throw new NullPointerException();
        }
        this.project = config.getProject();
        this.jpaPlatform = config.getJpaPlatform();
        this.dataSource = this.getJpaFactory().buildJpaDataSource(this, config.getConnectionProfileName());
        this.userOverrideDefaultCatalog = config.getUserOverrideDefaultCatalog();
        this.userOverrideDefaultSchema = config.getUserOverrideDefaultSchema();
        this.discoversAnnotatedClasses = config.discoverAnnotatedClasses();
        this.modifySharedDocumentCommandExecutor = this.buildModifySharedDocumentCommandExecutor();
        this.resourceModelListener = this.buildResourceModelListener();
        this.project.accept(this.buildInitialResourceProxyVisitor(), 0);
        this.externalJavaResourcePersistentTypeCache = this.buildExternalJavaResourcePersistentTypeCache();
        this.rootContextNode = this.buildRootContextNode();
        this.setUpdater_(new SynchronousJpaProjectUpdater(this));
        this.externalJavaResourcePersistentTypeCache.addResourceModelListener(this.resourceModelListener);
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    protected ThreadLocalCommandExecutor buildModifySharedDocumentCommandExecutor() {
        return new ThreadLocalCommandExecutor();
    }

    protected JpaResourceModelListener buildResourceModelListener() {
        return new DefaultResourceModelListener();
    }

    protected IResourceProxyVisitor buildInitialResourceProxyVisitor() {
        return new InitialResourceProxyVisitor();
    }

    protected JavaResourcePersistentTypeCache buildExternalJavaResourcePersistentTypeCache() {
        return new BinaryPersistentTypeCache(this.jpaPlatform.getAnnotationProvider());
    }

    protected JpaRootContextNode buildRootContextNode() {
        return this.getJpaFactory().buildRootContextNode(this);
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("externalJavaResourceCompilationUnits");
    }

    @Override
    public JpaProject getJpaProject() {
        return this;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @Override
    public JpaPlatform getJpaPlatform() {
        return this.jpaPlatform;
    }

    protected Iterable<JavaResourceCompilationUnit> getCombinedJavaResourceCompilationUnits() {
        return new CompositeIterable(new Iterable[]{this.getInternalJavaResourceCompilationUnits(), this.getExternalJavaResourceCompilationUnits()});
    }

    @Override
    public JpaDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.dataSource.getConnectionProfile();
    }

    @Override
    public Catalog getDefaultDbCatalog() {
        String catalog = this.getDefaultCatalog();
        return catalog == null ? null : this.getDbCatalog(catalog);
    }

    @Override
    public String getDefaultCatalog() {
        String catalog = this.getUserOverrideDefaultCatalog();
        return catalog != null ? catalog : this.getDatabaseDefaultCatalog();
    }

    protected String getDatabaseDefaultCatalog() {
        Catalog dbCatalog = this.getDatabaseDefaultDbCatalog();
        return dbCatalog == null ? null : dbCatalog.getIdentifier();
    }

    protected Catalog getDatabaseDefaultDbCatalog() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultCatalog();
    }

    @Override
    public SchemaContainer getDefaultDbSchemaContainer() {
        String catalog = this.getDefaultCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Schema getDefaultDbSchema() {
        SchemaContainer sc = this.getDefaultDbSchemaContainer();
        return sc == null ? null : sc.getSchemaForIdentifier(this.getDefaultSchema());
    }

    @Override
    public String getDefaultSchema() {
        Schema dbSchema;
        Catalog dbCatalog;
        String schema = this.getUserOverrideDefaultSchema();
        if (schema != null) {
            return schema;
        }
        String catalog = this.getDefaultCatalog();
        if (catalog != null && (dbCatalog = this.getDbCatalog(catalog)) != null && (dbSchema = dbCatalog.getDefaultSchema()) != null) {
            return dbSchema.getIdentifier();
        }
        return this.getDatabaseDefaultSchema();
    }

    protected String getDatabaseDefaultSchema() {
        Schema schema = this.getDatabaseDefaultDbSchema();
        return schema == null ? null : schema.getIdentifier();
    }

    protected Schema getDatabaseDefaultDbSchema() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultSchema();
    }

    @Override
    public String getUserOverrideDefaultCatalog() {
        return this.userOverrideDefaultCatalog;
    }

    @Override
    public void setUserOverrideDefaultCatalog(String catalog) {
        String old = this.userOverrideDefaultCatalog;
        this.userOverrideDefaultCatalog = catalog;
        JptCorePlugin.setUserOverrideDefaultCatalogName(this.project, catalog);
        this.firePropertyChanged("userOverrideDefaultCatalog", old, catalog);
    }

    @Override
    public String getUserOverrideDefaultSchema() {
        return this.userOverrideDefaultSchema;
    }

    @Override
    public void setUserOverrideDefaultSchema(String schema) {
        String old = this.userOverrideDefaultSchema;
        this.userOverrideDefaultSchema = schema;
        JptCorePlugin.setUserOverrideDefaultSchemaName(this.project, schema);
        this.firePropertyChanged("userOverrideDefaultSchema", old, schema);
    }

    @Override
    public boolean discoversAnnotatedClasses() {
        return this.discoversAnnotatedClasses;
    }

    @Override
    public void setDiscoversAnnotatedClasses(boolean discoversAnnotatedClasses) {
        boolean old = this.discoversAnnotatedClasses;
        this.discoversAnnotatedClasses = discoversAnnotatedClasses;
        JptCorePlugin.setDiscoverAnnotatedClasses(this.project, discoversAnnotatedClasses);
        this.firePropertyChanged("discoversAnnotatedClasses", old, discoversAnnotatedClasses);
    }

    @Override
    public Iterator<JpaFile> jpaFiles() {
        return this.getJpaFiles().iterator();
    }

    protected Iterable<JpaFile> getJpaFiles() {
        return new CloneIterable(this.jpaFiles);
    }

    @Override
    public int jpaFilesSize() {
        return this.jpaFiles.size();
    }

    protected Iterable<JpaFile> getJpaFiles(final IContentType contentType) {
        return new FilteringIterable<JpaFile, JpaFile>(this.getJpaFiles()){

            protected boolean accept(JpaFile jpaFile) {
                return jpaFile.getContentType().isKindOf(contentType);
            }
        };
    }

    @Override
    public JpaFile getJpaFile(IFile file) {
        for (JpaFile jpaFile : this.getJpaFiles()) {
            if (!jpaFile.getFile().equals((Object)file)) continue;
            return jpaFile;
        }
        return null;
    }

    protected boolean addJpaFile(IFile file) {
        JpaFile jpaFile = this.addJpaFile_(file);
        if (jpaFile != null) {
            this.fireItemAdded("jpaFiles", jpaFile);
            return true;
        }
        return false;
    }

    protected JpaFile addJpaFile_(IFile file) {
        if (!this.getJavaProject().isOnClasspath((IResource)file)) {
            return null;
        }
        JpaFile jpaFile = this.getJpaPlatform().buildJpaFile(this, file);
        if (jpaFile == null) {
            return null;
        }
        jpaFile.getResourceModel().addResourceModelListener(this.resourceModelListener);
        this.jpaFiles.add(jpaFile);
        return jpaFile;
    }

    protected boolean removeJpaFile(IFile file) {
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile != null) {
            this.removeJpaFile(jpaFile);
            return true;
        }
        return false;
    }

    protected void removeJpaFile(JpaFile jpaFile) {
        jpaFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        if (!this.removeItemFromCollection(jpaFile, this.jpaFiles, "jpaFiles")) {
            throw new IllegalArgumentException(jpaFile.toString());
        }
    }

    protected JavaResourcePersistentType buildPersistableExternalJavaResourcePersistentType(String typeName) {
        IType jdtType = this.findType(typeName);
        return jdtType == null ? null : this.buildPersistableExternalJavaResourcePersistentType(jdtType);
    }

    protected IType findType(String typeName) {
        try {
            return this.getJavaProject().findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected JavaResourcePersistentType buildPersistableExternalJavaResourcePersistentType(IType jdtType) {
        JavaResourcePersistentType jrpt = this.buildExternalJavaResourcePersistentType(jdtType);
        return jrpt != null && jrpt.isPersistable() ? jrpt : null;
    }

    protected JavaResourcePersistentType buildExternalJavaResourcePersistentType(IType jdtType) {
        return jdtType.isBinary() ? this.buildBinaryExternalJavaResourcePersistentType(jdtType) : this.buildSourceExternalJavaResourcePersistentType(jdtType);
    }

    protected JavaResourcePersistentType buildBinaryExternalJavaResourcePersistentType(IType jdtType) {
        return this.externalJavaResourcePersistentTypeCache.addPersistentType(jdtType);
    }

    protected JavaResourcePersistentType buildSourceExternalJavaResourcePersistentType(IType jdtType) {
        String jdtTypeName = jdtType.getFullyQualifiedName('.');
        JavaResourceCompilationUnit jrcu = this.addExternalJavaResourceCompilationUnit(jdtType.getCompilationUnit());
        Iterator<JavaResourcePersistentType> stream = jrcu.persistentTypes();
        while (stream.hasNext()) {
            JavaResourcePersistentType jrpt = stream.next();
            if (!jrpt.getQualifiedName().equals(jdtTypeName)) continue;
            return jrpt;
        }
        JptCorePlugin.log("missing type: " + jdtTypeName);
        return null;
    }

    @Override
    public JavaResourcePersistentTypeCache getExternalJavaResourcePersistentTypeCache() {
        return this.externalJavaResourcePersistentTypeCache;
    }

    @Override
    public Iterator<JavaResourceCompilationUnit> externalJavaResourceCompilationUnits() {
        return this.getExternalJavaResourceCompilationUnits().iterator();
    }

    protected Iterable<JavaResourceCompilationUnit> getExternalJavaResourceCompilationUnits() {
        return new CloneIterable(this.externalJavaResourceCompilationUnits);
    }

    @Override
    public int externalJavaResourceCompilationUnitsSize() {
        return this.externalJavaResourceCompilationUnits.size();
    }

    protected JavaResourceCompilationUnit addExternalJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        JavaResourceCompilationUnit jrcu = this.buildJavaResourceCompilationUnit(jdtCompilationUnit);
        this.addItemToCollection(jrcu, this.externalJavaResourceCompilationUnits, "externalJavaResourceCompilationUnits");
        jrcu.addResourceModelListener(this.resourceModelListener);
        return jrcu;
    }

    protected JavaResourceCompilationUnit buildJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        return new SourceCompilationUnit(jdtCompilationUnit, this.jpaPlatform.getAnnotationProvider(), this.jpaPlatform.getAnnotationEditFormatter(), (CommandExecutor)this.modifySharedDocumentCommandExecutor);
    }

    protected boolean removeExternalJavaResourceCompilationUnit(IFile file) {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            if (!jrcu.getFile().equals((Object)file)) continue;
            this.removeExternalJavaResourceCompilationUnit(jrcu);
            return true;
        }
        return false;
    }

    protected void removeExternalJavaResourceCompilationUnit(JavaResourceCompilationUnit jrcu) {
        jrcu.removeResourceModelListener(this.resourceModelListener);
        this.removeItemFromCollection(jrcu, this.externalJavaResourceCompilationUnits, "externalJavaResourceCompilationUnits");
    }

    @Override
    public JpaRootContextNode getRootContextNode() {
        return this.rootContextNode;
    }

    @Override
    public IFile convertToPlatformFile(String fileName) {
        return JptCorePlugin.getPlatformFile(this.project, fileName);
    }

    @Override
    public JpaXmlResource getPersistenceXmlResource() {
        return (JpaXmlResource)this.getResourceModel("META-INF/persistence.xml", JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE);
    }

    @Override
    public JpaXmlResource getDefaultOrmXmlResource() {
        return this.getMappingFileXmlResource("META-INF/orm.xml");
    }

    @Override
    public JpaXmlResource getMappingFileXmlResource(String fileName) {
        return (JpaXmlResource)this.getResourceModel(fileName, JptCorePlugin.MAPPING_FILE_CONTENT_TYPE);
    }

    protected JpaResourceModel getResourceModel(String fileName, IContentType contentType) {
        IFile file = this.convertToPlatformFile(fileName);
        return file.exists() ? this.getResourceModel(file, contentType) : null;
    }

    protected JpaResourceModel getResourceModel(IFile file, IContentType contentType) {
        JpaFile jpaFile = this.getJpaFile(file);
        return jpaFile == null ? null : jpaFile.getResourceModel(contentType);
    }

    @Override
    public Iterator<String> annotatedClassNames() {
        return this.getAnnotatedClassNames().iterator();
    }

    protected Iterable<String> getAnnotatedClassNames() {
        return new TransformationIterable<JavaResourcePersistentType, String>(this.getPersistedInternalSourceJavaResourcePersistentTypes()){

            protected String transform(JavaResourcePersistentType jrpType) {
                return jrpType.getQualifiedName();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType> getPersistedInternalSourceJavaResourcePersistentTypes() {
        return new FilteringIterable<JavaResourcePersistentType, JavaResourcePersistentType>(this.getInternalSourceJavaResourcePersistentTypes()){

            protected boolean accept(JavaResourcePersistentType jrpType) {
                return jrpType.isPersistable() && jrpType.isPersisted();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType> getInternalSourceJavaResourcePersistentTypes() {
        return new CompositeIterable(this.getInternalSourceJavaResourcePersistentTypeSets());
    }

    protected Iterable<Iterable<JavaResourcePersistentType>> getInternalSourceJavaResourcePersistentTypeSets() {
        return new TransformationIterable<JavaResourceCompilationUnit, Iterable<JavaResourcePersistentType>>(this.getInternalJavaResourceCompilationUnits()){

            protected Iterable<JavaResourcePersistentType> transform(final JavaResourceCompilationUnit compilationUnit) {
                return new Iterable<JavaResourcePersistentType>(){

                    @Override
                    public Iterator<JavaResourcePersistentType> iterator() {
                        return compilationUnit.persistentTypes();
                    }
                };
            }
        };
    }

    protected Iterable<JavaResourceCompilationUnit> getInternalJavaResourceCompilationUnits() {
        return new TransformationIterable<JpaFile, JavaResourceCompilationUnit>(this.getJavaSourceJpaFiles()){

            protected JavaResourceCompilationUnit transform(JpaFile jpaFile) {
                return (JavaResourceCompilationUnit)jpaFile.getResourceModel();
            }
        };
    }

    protected Iterable<JpaFile> getJavaSourceJpaFiles() {
        return this.getJpaFiles(JptCorePlugin.JAVA_SOURCE_CONTENT_TYPE);
    }

    @Override
    public JavaResourcePersistentType getJavaResourcePersistentType(String typeName) {
        for (JavaResourcePersistentType jrpType : this.getPersistableJavaResourcePersistentTypes()) {
            if (!jrpType.getQualifiedName().equals(typeName)) continue;
            return jrpType;
        }
        return this.buildPersistableExternalJavaResourcePersistentType(typeName);
    }

    protected Iterable<JavaResourcePersistentType> getPersistableJavaResourcePersistentTypes() {
        return new FilteringIterable<JavaResourcePersistentType, JavaResourcePersistentType>(this.getJavaResourcePersistentTypes()){

            protected boolean accept(JavaResourcePersistentType jrpType) {
                return jrpType.isPersistable();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType> getJavaResourcePersistentTypes() {
        return new CompositeIterable(this.getJavaResourcePersistentTypeSets());
    }

    protected Iterable<Iterable<JavaResourcePersistentType>> getJavaResourcePersistentTypeSets() {
        return new TransformationIterable<JavaResourceNode.Root, Iterable<JavaResourcePersistentType>>(this.getJavaResourceNodeRoots()){

            protected Iterable<JavaResourcePersistentType> transform(final JavaResourceNode.Root root) {
                return new Iterable<JavaResourcePersistentType>(){

                    @Override
                    public Iterator<JavaResourcePersistentType> iterator() {
                        return root.persistentTypes();
                    }
                };
            }
        };
    }

    protected Iterable<JavaResourceNode.Root> getJavaResourceNodeRoots() {
        return new CompositeIterable(new Iterable[]{this.getInternalJavaResourceCompilationUnits(), this.getInternalJavaResourcePackageFragmentRoots(), this.getExternalJavaResourceCompilationUnits(), Collections.singleton(this.externalJavaResourcePersistentTypeCache)});
    }

    @Override
    public JavaResourcePackageFragmentRoot getJavaResourcePackageFragmentRoot(String jarFileName) {
        return this.getJavaResourcePackageFragmentRoot(this.getProject().getFile(jarFileName));
    }

    protected JavaResourcePackageFragmentRoot getJavaResourcePackageFragmentRoot(IFile jarFile) {
        for (JavaResourcePackageFragmentRoot pfr : this.getInternalJavaResourcePackageFragmentRoots()) {
            if (!pfr.getFile().equals((Object)jarFile)) continue;
            return pfr;
        }
        return null;
    }

    protected Iterable<JavaResourcePackageFragmentRoot> getInternalJavaResourcePackageFragmentRoots() {
        return new TransformationIterable<JpaFile, JavaResourcePackageFragmentRoot>(this.getJarJpaFiles()){

            protected JavaResourcePackageFragmentRoot transform(JpaFile jpaFile) {
                return (JavaResourcePackageFragmentRoot)jpaFile.getResourceModel();
            }
        };
    }

    protected Iterable<JpaFile> getJarJpaFiles() {
        return this.getJpaFiles(JptCorePlugin.JAR_CONTENT_TYPE);
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        this.synchWithJavaDelta(event.getDelta());
    }

    protected void synchWithJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: {
                this.javaModelChanged(delta);
                break;
            }
            case 2: {
                this.javaProjectChanged(delta);
                break;
            }
            case 3: {
                this.javaPackageFragmentRootChanged(delta);
                break;
            }
            case 4: {
                this.javaPackageFragmentChanged(delta);
                break;
            }
            case 5: {
                this.javaCompilationUnitChanged(delta);
                break;
            }
        }
    }

    protected void synchWithJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.synchWithJavaDelta(child);
            ++n2;
        }
    }

    protected void javaModelChanged(IJavaElementDelta delta) {
        this.synchWithJavaDeltaChildren(delta);
    }

    protected void javaProjectChanged(IJavaElementDelta delta) {
        this.synchWithJavaDeltaChildren(delta);
        if (this.classpathHasChanged(delta)) {
            if (delta.getElement().equals(this.getJavaProject())) {
                this.update(this.getInternalJavaResourceCompilationUnits());
            } else {
                this.update(this.getExternalJavaResourceCompilationUnits());
            }
        }
    }

    protected boolean classpathHasChanged(IJavaElementDelta delta) {
        return BitTools.flagIsSet((int)delta.getFlags(), (int)0x200000);
    }

    protected void update(Iterable<JavaResourceCompilationUnit> javaResourceCompilationUnits) {
        for (JavaResourceCompilationUnit javaResourceCompilationUnit : javaResourceCompilationUnits) {
            javaResourceCompilationUnit.update();
        }
    }

    protected void javaPackageFragmentRootChanged(IJavaElementDelta delta) {
        this.synchWithJavaDeltaChildren(delta);
        if (!this.classpathEntryHasBeenAdded(delta)) {
            this.classpathEntryHasBeenRemoved(delta);
        }
    }

    protected boolean classpathEntryHasBeenAdded(IJavaElementDelta delta) {
        return BitTools.flagIsSet((int)delta.getFlags(), (int)64);
    }

    protected boolean classpathEntryHasBeenRemoved(IJavaElementDelta delta) {
        return BitTools.flagIsSet((int)delta.getFlags(), (int)128);
    }

    protected void javaPackageFragmentChanged(IJavaElementDelta delta) {
        this.synchWithJavaDeltaChildren(delta);
    }

    protected void javaCompilationUnitChanged(IJavaElementDelta delta) {
        if (this.javaCompilationUnitDeltaIsRelevant(delta)) {
            ICompilationUnit compilationUnit = (ICompilationUnit)delta.getElement();
            for (JavaResourceCompilationUnit jrcu : this.getCombinedJavaResourceCompilationUnits()) {
                if (!jrcu.getCompilationUnit().equals(compilationUnit)) continue;
                jrcu.update();
                break;
            }
        }
    }

    protected boolean javaCompilationUnitDeltaIsRelevant(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        return delta.getKind() == 4;
    }

    @Override
    public Iterator<IMessage> validationMessages(IReporter reporter) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.validate(messages, reporter);
        return messages.iterator();
    }

    protected void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        this.validateConnection(messages);
        this.rootContextNode.validate(messages, reporter);
    }

    protected void validateConnection(List<IMessage> messages) {
        String cpName = this.dataSource.getConnectionProfileName();
        if (StringTools.stringIsEmpty((String)cpName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_NO_CONNECTION", this));
            return;
        }
        ConnectionProfile cp = this.dataSource.getConnectionProfile();
        if (cp == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INVALID_CONNECTION", new String[]{cpName}, this));
            return;
        }
        if (cp.isInactive()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INACTIVE_CONNECTION", new String[]{cpName}, this));
        }
    }

    @Override
    public void dispose() {
        this.updater.stop();
        this.dataSource.dispose();
    }

    @Override
    public void projectChanged(IResourceDelta delta) throws CoreException {
        if (delta.getResource().equals((Object)this.getProject())) {
            this.internalProjectChanged(delta);
        } else {
            this.externalProjectChanged(delta);
        }
    }

    protected void internalProjectChanged(IResourceDelta delta) throws CoreException {
        ResourceDeltaVisitor resourceDeltaVisitor = this.buildInternalResourceDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
        if (resourceDeltaVisitor.encounteredSignificantChange()) {
            this.resolveInternalJavaTypes();
        }
    }

    protected ResourceDeltaVisitor buildInternalResourceDeltaVisitor() {
        return new ResourceDeltaVisitor(){

            public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
                return AbstractJpaProject.this.synchronizeJpaFiles(file, deltaKind);
            }
        };
    }

    protected boolean synchronizeJpaFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.addJpaFile(file);
            }
            case 2: {
                return this.removeJpaFile(file);
            }
            case 4: {
                return this.checkForChangedFileContent(file);
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean checkForChangedFileContent(IFile file) {
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile == null) {
            return this.addJpaFile(file);
        }
        if (jpaFile.getContentType().equals(PlatformTools.getContentType(file))) {
            return false;
        }
        this.removeJpaFile(jpaFile);
        this.addJpaFile(file);
        return true;
    }

    protected void resolveInternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getInternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    protected void externalProjectChanged(IResourceDelta delta) throws CoreException {
        if (this.getJavaProject().isOnClasspath(delta.getResource())) {
            ResourceDeltaVisitor resourceDeltaVisitor = this.buildExternalResourceDeltaVisitor();
            delta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
            if (resourceDeltaVisitor.encounteredSignificantChange()) {
                this.update();
                this.resolveExternalJavaTypes();
                this.resolveInternalJavaTypes();
            }
        }
    }

    protected ResourceDeltaVisitor buildExternalResourceDeltaVisitor() {
        return new ResourceDeltaVisitor(){

            public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
                return AbstractJpaProject.this.synchronizeExternalFiles(file, deltaKind);
            }
        };
    }

    protected boolean synchronizeExternalFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.externalFileAdded(file);
            }
            case 2: {
                return this.externalFileRemoved(file);
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean externalFileAdded(IFile file) {
        IContentType contentType = PlatformTools.getContentType(file);
        if (contentType == null) {
            return false;
        }
        if (contentType.equals(JptCorePlugin.JAVA_SOURCE_CONTENT_TYPE)) {
            return true;
        }
        return contentType.equals(JptCorePlugin.JAR_CONTENT_TYPE);
    }

    protected boolean externalFileRemoved(IFile file) {
        IContentType contentType = PlatformTools.getContentType(file);
        if (contentType == null) {
            return false;
        }
        if (contentType.equals(JptCorePlugin.JAVA_SOURCE_CONTENT_TYPE)) {
            return this.removeExternalJavaResourceCompilationUnit(file);
        }
        if (contentType.equals(JptCorePlugin.JAR_CONTENT_TYPE)) {
            return this.externalJavaResourcePersistentTypeCache.removePersistentTypes(file);
        }
        return false;
    }

    protected void resolveExternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    @Override
    public void setThreadLocalModifySharedDocumentCommandExecutor(CommandExecutor commandExecutor) {
        this.modifySharedDocumentCommandExecutor.set(commandExecutor);
    }

    @Override
    public CommandExecutor getModifySharedDocumentCommandExecutor() {
        return this.modifySharedDocumentCommandExecutor;
    }

    @Override
    public JpaProject.Updater getUpdater() {
        return this.updater;
    }

    @Override
    public void setUpdater(JpaProject.Updater updater) {
        if (updater == null) {
            throw new NullPointerException();
        }
        this.updater.stop();
        this.setUpdater_(updater);
    }

    protected void setUpdater_(JpaProject.Updater updater) {
        this.updater = updater;
        this.updater.start();
    }

    @Override
    public void update() {
        this.updater.update();
    }

    @Override
    public IStatus update(IProgressMonitor monitor) {
        try {
            this.rootContextNode.update(monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Throwable ex) {
            JptCorePlugin.log(ex);
        }
        this.rootContextNode.postUpdate();
        return Status.OK_STATUS;
    }

    protected class DefaultResourceModelListener
    implements JpaResourceModelListener {
        protected DefaultResourceModelListener() {
        }

        public void resourceModelChanged() {
            AbstractJpaProject.this.update();
        }
    }

    protected class InitialResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected InitialResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resource) throws CoreException {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    AbstractJpaProject.this.addJpaFile_((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    protected abstract class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        protected boolean encounteredSignificantChange = false;

        protected ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    this.fileChanged((IFile)res, delta.getKind());
                    return false;
                }
            }
            return false;
        }

        protected void fileChanged(IFile file, int deltaKind) {
            if (this.fileChangeIsSignificant(file, deltaKind)) {
                this.encounteredSignificantChange = true;
            }
        }

        protected abstract boolean fileChangeIsSignificant(IFile var1, int var2);

        protected boolean encounteredSignificantChange() {
            return this.encounteredSignificantChange;
        }
    }
}

