/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.tests;

import junit.framework.TestCase;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IRequestListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

public class MonitorTestCase
extends TestCase {
    private static IMonitor monitor;

    public void test00GetMonitors() throws Exception {
        MonitorTestCase.assertNotNull((Object)MonitorCore.getMonitors());
    }

    public void test01CreateMonitor() throws Exception {
        IMonitorWorkingCopy wc = MonitorCore.createMonitor();
        wc.setLocalPort(22150);
        wc.setRemoteHost("www.eclipse.org");
        wc.setRemotePort(80);
        monitor = wc.save();
        MonitorTestCase.assertTrue((monitor != null ? 1 : 0) != 0);
        MonitorTestCase.assertTrue((MonitorCore.getMonitors().length == 1 ? 1 : 0) != 0);
        MonitorTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
        MonitorTestCase.assertTrue((!monitor.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void test02GetMonitor() throws Exception {
        IMonitor[] monitors;
        int count = 0;
        IMonitor[] iMonitorArray = monitors = MonitorCore.getMonitors();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitor m = iMonitorArray[n2];
            if (monitor.equals(m)) {
                ++count;
            }
            ++n2;
        }
        MonitorTestCase.assertTrue((count == 1 ? 1 : 0) != 0);
    }

    public void test03StartMonitor() throws Exception {
        MonitorTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
        monitor.start();
        MonitorTestCase.assertTrue((boolean)monitor.isRunning());
    }

    public void test04StartMonitor() throws Exception {
        MonitorTestCase.assertTrue((boolean)monitor.isRunning());
        monitor.start();
        MonitorTestCase.assertTrue((boolean)monitor.isRunning());
    }

    public void test05StartMonitor() throws Exception {
        try {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            wc.start();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test06StartMonitor() throws Exception {
        try {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            IMonitor m = wc.save();
            m.delete();
            m.start();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test07StopMonitor() throws Exception {
        MonitorTestCase.assertTrue((boolean)monitor.isRunning());
        monitor.stop();
        MonitorTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
    }

    public void test08StopMonitor() throws Exception {
        MonitorTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
        monitor.stop();
        MonitorTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
    }

    public void test09RestartMonitor() throws Exception {
        MonitorTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
        monitor.start();
        MonitorTestCase.assertTrue((boolean)monitor.isRunning());
        monitor.stop();
        MonitorTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
    }

    public void test10StopMonitor() throws Exception {
        try {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            wc.stop();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test11StopMonitor() throws Exception {
        try {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            IMonitor m = wc.save();
            m.delete();
            m.stop();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
    }

    public void test12ValidateMonitor() throws Exception {
        MonitorTestCase.assertTrue((boolean)monitor.validate().isOK());
    }

    public void test13ModifyMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(1);
        wc.setRemoteHost("a");
        wc.setRemotePort(2);
        IMonitor monitor2 = wc.save();
        MonitorTestCase.assertTrue((monitor2 == monitor ? 1 : 0) != 0);
        MonitorTestCase.assertTrue((monitor.getLocalPort() == 1 ? 1 : 0) != 0);
        MonitorTestCase.assertTrue((boolean)monitor.getRemoteHost().equals("a"));
        MonitorTestCase.assertTrue((monitor.getRemotePort() == 2 ? 1 : 0) != 0);
    }

    public void test14DeleteMonitor() throws Exception {
        monitor.delete();
        MonitorTestCase.assertTrue((MonitorCore.getMonitors().length == 0 ? 1 : 0) != 0);
    }

    public void test15DeleteMonitor() throws Exception {
        monitor.delete();
    }

    public void test16DeleteMonitor() throws Exception {
        IMonitorWorkingCopy wc = MonitorCore.createMonitor();
        wc.delete();
    }

    public void test17GetMonitor() throws Exception {
        IMonitor[] monitors;
        int count = 0;
        IMonitor[] iMonitorArray = monitors = MonitorCore.getMonitors();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitor m = iMonitorArray[n2];
            if (monitor.equals(m)) {
                ++count;
            }
            ++n2;
        }
        MonitorTestCase.assertTrue((count == 0 ? 1 : 0) != 0);
    }

    public void test18CreateMonitor() throws Exception {
        int num = MonitorCore.getMonitors().length;
        MonitorCore.createMonitor();
        MonitorTestCase.assertTrue((MonitorCore.getMonitors().length == num ? 1 : 0) != 0);
    }

    public void test19CreateMonitor() {
        IMonitorWorkingCopy wc = MonitorCore.createMonitor();
        wc.setProtocol(null);
        MonitorTestCase.assertNull((Object)wc.getOriginal());
    }

    public void test20ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(-1);
        wc.setRemoteHost("www.eclipse.org");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void test21ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(80);
        wc.setRemoteHost("www.eclipse.org");
        wc.setRemotePort(-1);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void test22ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost(null);
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void test23ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost("");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void test24ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost("  ");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void test25ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost("hi&bye");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void test26ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(8080);
        wc.setRemoteHost("xyz:");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void test27ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(80);
        wc.setRemoteHost("www.eclipse.org");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((boolean)wc.validate().isOK());
    }

    public void test28ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(80);
        wc.setRemoteHost("localhost");
        wc.setRemotePort(80);
        MonitorTestCase.assertTrue((!wc.validate().isOK() ? 1 : 0) != 0);
    }

    public void test29ValidateMonitor() throws Exception {
        IMonitorWorkingCopy wc = monitor.createWorkingCopy();
        wc.setLocalPort(80);
        wc.setRemoteHost("localhost");
        wc.setRemotePort(80);
        IMonitor monitor2 = wc.save();
        try {
            monitor2.start();
            MonitorTestCase.assertTrue((String)"Should throw exception", (boolean)false);
        }
        catch (Exception exception) {}
        monitor2.delete();
    }

    public void test30GetId() {
        monitor.getId();
    }

    public void test31GetProtocol() {
        MonitorTestCase.assertNotNull((Object)monitor.getProtocol());
    }

    public void test32CheckListener() throws Exception {
        IRequestListener listener2 = new IRequestListener(){

            public void requestAdded(IMonitor monitor2, Request request) {
            }

            public void requestChanged(IMonitor monitor2, Request request) {
            }
        };
        listener2.requestAdded(null, null);
        listener2.requestChanged(null, null);
    }
}

