/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IExtendedStorageEditorInput;
import org.eclipse.wst.sse.ui.tests.SSETestsPlugin;

public class ExtendedStorageEditorInputView
extends ViewPart {
    public static final boolean provideIStorageFullPath = true;
    private List actions = null;
    TableViewer fInputList = null;
    List fInputs = new ArrayList(0);
    Object fSelectedElement = null;

    public static void openError(Shell parent, String title, String message, PartInitException exception) {
        CoreException nestedException = null;
        IStatus status = exception.getStatus();
        if (status != null && status.getException() instanceof CoreException) {
            nestedException = (CoreException)status.getException();
        }
        if (nestedException != null) {
            ErrorDialog.openError((Shell)parent, (String)title, (String)message, (IStatus)nestedException.getStatus());
        } else {
            MessageDialog.openError((Shell)parent, (String)title, (String)message);
        }
    }

    public ExtendedStorageEditorInputView() {
        this.actions = new ArrayList();
    }

    public void createPartControl(Composite parent) {
        this.fInputList = new TableViewer(parent, 66306);
        this.fInputList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fInputList.setLabelProvider((IBaseLabelProvider)new EditorInputLabelProvider());
        this.fInputList.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        this.fInputList.getTable().setHeaderVisible(true);
        this.fInputList.getTable().setLinesVisible(true);
        String[] columns = new String[]{"Path", "Type"};
        this.fInputList.setLabelProvider((IBaseLabelProvider)new EditorInputLabelProvider());
        TableLayout tlayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[5];
        int i = 0;
        while (i < columns.length) {
            tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
            TableColumn tc = new TableColumn(this.fInputList.getTable(), 0);
            tc.setText(columns[i]);
            tc.setResizable(true);
            tc.setWidth(Display.getCurrent().getBounds().width / 14);
            ++i;
        }
        this.fInputList.setCellEditors(cellEditors);
        this.fInputList.setColumnProperties(columns);
        GridData gd = new GridData(4, 4, true, true);
        this.fInputList.getTable().setLayoutData((Object)gd);
        MenuManager menuManager = new MenuManager("#popup");
        menuManager.setRemoveAllWhenShown(false);
        menuManager.add((IAction)new InputOpenAction());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new InputMoveAction());
        menuManager.add((IAction)new InputChangeDirtyStateAction());
        menuManager.add((IAction)new InputDeleteAction());
        menuManager.add((IAction)new InputReplaceContentsAction());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new RemoveInputAction());
        Menu menu = menuManager.createContextMenu(this.fInputList.getControl());
        this.fInputList.getControl().setMenu(menu);
        SSETestsPlugin.getDefault().getPluginPreferences().setDefault(this.getInputsPreferenceName(), "");
        String[] paths = StringUtils.unpack((String)SSETestsPlugin.getDefault().getPluginPreferences().getString(this.getInputsPreferenceName()));
        int i2 = 0;
        while (i2 < paths.length) {
            if (paths[i2].startsWith("S!")) {
                this.fInputs.add(new FileBasedStorageEditorInput(new File(paths[i2].substring(2))));
                menuManager.add((IContributionItem)new OpenWithMenu(this.getSite().getPage(), null));
            } else if (paths[i2].startsWith("F!")) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(paths[i2].substring(2)));
                this.fInputs.add(new FileEditorInput(file));
                menuManager.add((IContributionItem)new OpenWithMenu(this.getSite().getPage(), (IAdaptable)file));
            }
            ++i2;
        }
        this.fInputList.setInput((Object)this.fInputs);
        this.fInputList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                ExtendedStorageEditorInputView.this.fSelectedElement = sel.getFirstElement();
            }
        });
    }

    public void dispose() {
        ArrayList<String> paths = new ArrayList<String>(0);
        int i = 0;
        while (i < this.fInputs.size()) {
            try {
                Object input = this.fInputs.get(i);
                String path = null;
                if (input instanceof FileBasedStorageEditorInput) {
                    path = "S!" + ((FileBasedStorageEditorInput)input).getFile().getCanonicalPath();
                } else if (input instanceof IFileEditorInput) {
                    path = "F!" + ((IFileEditorInput)input).getFile().getFullPath().toString();
                }
                if (path != null) {
                    paths.add(path);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        SSETestsPlugin.getDefault().getPluginPreferences().setValue(this.getInputsPreferenceName(), StringUtils.pack((String[])paths.toArray(new String[0])));
        SSETestsPlugin.getDefault().savePluginPreferences();
    }

    String getEditorId(IEditorInput input) {
        IEditorDescriptor descriptor;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IContentType[] types = null;
        String editorID = null;
        if (input instanceof IStorageEditorInput) {
            InputStream inputStream = null;
            try {
                inputStream = ((IStorageEditorInput)input).getStorage().getContents();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            try {
                types = Platform.getContentTypeManager().findContentTypesFor(inputStream, input.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((descriptor = editorRegistry.getDefaultEditor(input.getName(), types[0])) != null) {
            editorID = descriptor.getId();
        }
        if (editorID == null) {
            editorID = "org.eclipse.ui.DefaultTextEditor";
        }
        return editorID;
    }

    String getInputsPreferenceName() {
        return "ExtendedStorageEditorInputView:inputs";
    }

    IEditorInput[] getSelectedInputs() {
        ISelection selection = this.fInputList.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.isEmpty()) {
                return new IEditorInput[0];
            }
            Object[] arr = sel.toArray();
            IEditorInput[] inputs = new IEditorInput[arr.length];
            System.arraycopy(arr, 0, inputs, 0, inputs.length);
            return inputs;
        }
        return new IEditorInput[0];
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getActionBars().getToolBarManager().add(this.rememberAction((IAction)new AddStorageInputAction()));
        site.getActionBars().getToolBarManager().add(this.rememberAction((IAction)new AddFileInputAction()));
        site.getActionBars().getToolBarManager().add(this.rememberAction((IAction)new ReuseEditorAction()));
        site.getActionBars().getToolBarManager().add(this.rememberAction((IAction)new RemoveInputAction()));
        site.getActionBars().getMenuManager().add(this.rememberAction((IAction)new InputOpenAction()));
        site.getActionBars().getMenuManager().add(this.rememberAction((IAction)new ReuseEditorAction()));
        site.getActionBars().getMenuManager().add((IContributionItem)new Separator());
        site.getActionBars().getMenuManager().add(this.rememberAction((IAction)new InputMoveAction()));
        site.getActionBars().getMenuManager().add(this.rememberAction((IAction)new InputChangeDirtyStateAction()));
        site.getActionBars().getMenuManager().add(this.rememberAction((IAction)new InputDeleteAction()));
        site.getActionBars().getMenuManager().add(this.rememberAction((IAction)new InputReplaceContentsAction()));
    }

    IAction rememberAction(IAction action) {
        this.actions.add(action);
        return action;
    }

    public void setFocus() {
        this.fInputList.getControl().setFocus();
    }

    protected void updateEnablement() {
        int i = 0;
        while (i < this.actions.size()) {
            Object action = this.actions.get(i);
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            ++i;
        }
    }

    class AddFileInputAction
    extends Action {
        public AddFileInputAction() {
            super("Add FileEditorInput");
        }

        public void run() {
            super.run();
            ResourceSelectionDialog dlg = new ResourceSelectionDialog(ExtendedStorageEditorInputView.this.fInputList.getControl().getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Choose");
            int retval = dlg.open();
            if (retval == 0) {
                Object[] files = dlg.getResult();
                int i = 0;
                while (i < files.length) {
                    ExtendedStorageEditorInputView.this.fInputs.add(new FileEditorInput((IFile)files[i]));
                    ++i;
                }
                ExtendedStorageEditorInputView.this.fInputList.refresh(true);
            }
        }
    }

    class AddStorageInputAction
    extends Action {
        public AddStorageInputAction() {
            super("Add StorageEditorInput");
        }

        public void run() {
            super.run();
            FileDialog dlg = new FileDialog(ExtendedStorageEditorInputView.this.fInputList.getControl().getShell());
            String fileName = dlg.open();
            if (fileName != null) {
                ExtendedStorageEditorInputView.this.fInputs.add(new FileBasedStorageEditorInput(new File(fileName)));
                ExtendedStorageEditorInputView.this.fInputList.refresh(true);
            }
        }
    }

    class DoubleClickListener
    implements IDoubleClickListener {
        DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            new InputOpenAction().run();
        }
    }

    class EditorInputLabelProvider
    implements ITableLabelProvider {
        ILabelProvider baseProvider = new WorkbenchLabelProvider();

        EditorInputLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IFileEditorInput && columnIndex == 0) {
                return this.baseProvider.getImage((Object)((IFileEditorInput)element).getFile());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IEditorInput input = (IEditorInput)element;
            String text = null;
            switch (columnIndex) {
                case 0: {
                    try {
                        if (element instanceof FileBasedStorageEditorInput) {
                            IPath fullpath = ((FileBasedStorageEditorInput)element).getStorage().getFullPath();
                            String string = text = fullpath != null ? fullpath.toString() : ((FileBasedStorageEditorInput)element).getName();
                            if (!((FileBasedStorageEditorInput)element).isDirty()) break;
                            text = "*" + text;
                            break;
                        }
                        if (!(element instanceof IFileEditorInput)) break;
                        text = ((IFileEditorInput)element).getFile().getFullPath().toString();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    text = element instanceof FileBasedStorageEditorInput ? "FileBasedStorageEditorInput" : (element instanceof IFileEditorInput ? "FileEditorInput" : input.getClass().getName());
                }
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class FileBackedStorage
    implements IStorage {
        File fFile = null;

        FileBackedStorage(File file) {
            this.fFile = file;
        }

        boolean exists() {
            return this.fFile.exists();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            InputStream contents = null;
            try {
                contents = new FileInputStream(this.fFile);
                ByteBuffer buffer = ByteBuffer.allocate((int)this.fFile.length());
                byte[] bytes = new byte[2048];
                while (contents.available() > 0) {
                    int count = contents.read(bytes);
                    buffer.put(bytes, 0, count);
                }
                contents.close();
                contents = new ByteArrayInputStream(buffer.array());
            }
            catch (FileNotFoundException fileNotFoundException) {
                contents = new ByteArrayInputStream(new byte[0]);
            }
            catch (IOException iOException) {
                contents = new ByteArrayInputStream(new byte[0]);
            }
            return contents;
        }

        public IPath getFullPath() {
            return new Path(this.fFile.getAbsolutePath());
        }

        public String getName() {
            return this.fFile.getName();
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    class FileBasedStorageEditorInput
    implements IExtendedStorageEditorInput {
        List fElementStateListeners = new Vector(0);
        boolean fIsDirty = false;
        FileBackedStorage fStorage = null;

        FileBasedStorageEditorInput(File file) {
            this.fStorage = new FileBackedStorage(file);
        }

        public void addElementStateListener(IElementStateListener listener) {
            this.fElementStateListeners.add(listener);
        }

        void elementContentAboutToBeReplaced() {
            int i = 0;
            while (i < this.fElementStateListeners.size()) {
                ((IElementStateListener)this.fElementStateListeners.get(i)).elementContentAboutToBeReplaced((Object)this);
                ++i;
            }
        }

        void elementContentReplaced() {
            int i = 0;
            while (i < this.fElementStateListeners.size()) {
                ((IElementStateListener)this.fElementStateListeners.get(i)).elementContentReplaced((Object)this);
                ++i;
            }
        }

        void elementDeleted() {
            int i = 0;
            while (i < this.fElementStateListeners.size()) {
                ((IElementStateListener)this.fElementStateListeners.get(i)).elementDeleted((Object)this);
                ++i;
            }
        }

        void elementDirtyStateChanged(boolean dirty) {
            this.setDirty(dirty);
            int i = 0;
            while (i < this.fElementStateListeners.size()) {
                ((IElementStateListener)this.fElementStateListeners.get(i)).elementDirtyStateChanged((Object)this, dirty);
                ++i;
            }
        }

        void elementMoved(Object oldElement, Object newElement) {
            int i = 0;
            while (i < this.fElementStateListeners.size()) {
                ((IElementStateListener)this.fElementStateListeners.get(i)).elementMoved((Object)this, (Object)this);
                ++i;
            }
        }

        public boolean exists() {
            return this.fStorage.exists();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        File getFile() {
            return this.fStorage.fFile;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.fStorage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public IStorage getStorage() throws CoreException {
            return this.fStorage;
        }

        public String getToolTipText() {
            return this.fStorage.getFullPath() != null ? this.fStorage.getFullPath().toString() : this.fStorage.getName();
        }

        boolean isDirty() {
            return this.fIsDirty;
        }

        public void removeElementStateListener(IElementStateListener listener) {
            this.fElementStateListeners.remove(listener);
        }

        void setDirty(boolean dirty) {
            this.fIsDirty = dirty;
        }
    }

    class InputChangeDirtyStateAction
    extends Action
    implements IUpdate {
        public InputChangeDirtyStateAction() {
            super("Toggle dirty flag");
        }

        public void run() {
            super.run();
            IEditorInput[] inputs = ExtendedStorageEditorInputView.this.getSelectedInputs();
            int i = 0;
            while (i < inputs.length) {
                if (inputs[i] instanceof FileBasedStorageEditorInput) {
                    ((FileBasedStorageEditorInput)inputs[i]).elementDirtyStateChanged(!((FileBasedStorageEditorInput)inputs[i]).isDirty());
                }
                ++i;
            }
            ExtendedStorageEditorInputView.this.fInputList.refresh(true);
        }

        public void update() {
            this.setEnabled(ExtendedStorageEditorInputView.this.fSelectedElement != null && ExtendedStorageEditorInputView.this.fSelectedElement instanceof FileBasedStorageEditorInput);
        }
    }

    class InputDeleteAction
    extends Action
    implements IUpdate {
        public InputDeleteAction() {
            super("Delete Input");
        }

        public void run() {
            super.run();
            IEditorInput[] inputs = ExtendedStorageEditorInputView.this.getSelectedInputs();
            int i = 0;
            while (i < inputs.length) {
                if (inputs[i] instanceof FileBasedStorageEditorInput) {
                    ((FileBasedStorageEditorInput)inputs[i]).elementDeleted();
                }
                ++i;
            }
            i = 0;
            while (i < inputs.length) {
                ExtendedStorageEditorInputView.this.fInputs.remove(inputs[i]);
                ++i;
            }
            ExtendedStorageEditorInputView.this.fInputList.refresh();
        }

        public void update() {
            this.setEnabled(ExtendedStorageEditorInputView.this.fSelectedElement != null && ExtendedStorageEditorInputView.this.fSelectedElement instanceof FileBasedStorageEditorInput);
        }
    }

    class InputMoveAction
    extends Action
    implements IUpdate {
        public InputMoveAction() {
            super("Move Input");
        }

        public void run() {
            super.run();
            IEditorInput[] inputs = ExtendedStorageEditorInputView.this.getSelectedInputs();
            int i = 0;
            while (i < inputs.length) {
                if (inputs[i] instanceof FileBasedStorageEditorInput) {
                    ((FileBasedStorageEditorInput)inputs[i]).elementMoved(inputs[i], inputs[i]);
                }
                ++i;
            }
        }

        public void update() {
            this.setEnabled(ExtendedStorageEditorInputView.this.fSelectedElement != null && ExtendedStorageEditorInputView.this.fSelectedElement instanceof FileBasedStorageEditorInput);
        }
    }

    class InputOpenAction
    extends Action {
        public InputOpenAction() {
            super("Open");
        }

        public void run() {
            super.run();
            IEditorInput[] inputs = ExtendedStorageEditorInputView.this.getSelectedInputs();
            int i = 0;
            while (i < inputs.length) {
                try {
                    ExtendedStorageEditorInputView.this.getSite().getWorkbenchWindow().getActivePage().openEditor(inputs[i], ExtendedStorageEditorInputView.this.getEditorId(inputs[i]));
                }
                catch (PartInitException e) {
                    ExtendedStorageEditorInputView.openError(ExtendedStorageEditorInputView.this.getSite().getWorkbenchWindow().getActivePage().getWorkbenchWindow().getShell(), "OpenSystemEditorAction.dialogTitle", e.getMessage(), e);
                }
                ++i;
            }
        }
    }

    class InputReplaceContentsAction
    extends Action
    implements IUpdate {
        public InputReplaceContentsAction() {
            super("Replace Input's Contents");
        }

        public void run() {
            super.run();
            IEditorInput[] inputs = ExtendedStorageEditorInputView.this.getSelectedInputs();
            int i = 0;
            while (i < inputs.length) {
                ((FileBasedStorageEditorInput)inputs[i]).elementContentAboutToBeReplaced();
                ((FileBasedStorageEditorInput)inputs[i]).elementContentReplaced();
                ++i;
            }
        }

        public void update() {
            this.setEnabled(ExtendedStorageEditorInputView.this.fSelectedElement != null && ExtendedStorageEditorInputView.this.fSelectedElement instanceof FileBasedStorageEditorInput);
        }
    }

    class RemoveInputAction
    extends Action {
        public RemoveInputAction() {
            super("Remove");
        }

        public void run() {
            super.run();
            IEditorInput[] inputs = ExtendedStorageEditorInputView.this.getSelectedInputs();
            int i = 0;
            while (i < inputs.length) {
                ExtendedStorageEditorInputView.this.fInputs.remove(inputs[i]);
                ++i;
            }
            ExtendedStorageEditorInputView.this.fInputList.refresh();
        }
    }

    class ReuseEditorAction
    extends Action
    implements IUpdate {
        public ReuseEditorAction() {
            super("Reuse Editor");
        }

        public void run() {
            super.run();
            IEditorInput[] inputs = ExtendedStorageEditorInputView.this.getSelectedInputs();
            int i = 0;
            while (i < inputs.length) {
                IEditorPart editor = ExtendedStorageEditorInputView.this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
                if (editor instanceof IReusableEditor) {
                    ExtendedStorageEditorInputView.this.getSite().getWorkbenchWindow().getActivePage().reuseEditor((IReusableEditor)editor, inputs[i]);
                } else {
                    SSEUIPlugin.getDefault().getWorkbench().getDisplay().beep();
                }
                ++i;
            }
        }

        public void update() {
            boolean enable = true;
            try {
                enable = ExtendedStorageEditorInputView.this.fSelectedElement != null && ExtendedStorageEditorInputView.this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor() instanceof IReusableEditor;
            }
            catch (Exception exception) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }
}

