/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.tests.plugin;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestPluginXMLRequirements
extends TestCase {
    private static final String PLUGIN_XML = "plugin.xml";
    Document pluginDoc = null;
    XPath xpath = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.loadPluginXML();
        this.initXPath();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.pluginDoc = null;
        this.xpath = null;
    }

    private void initXPath() {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        this.xpath = xpathFactory.newXPath();
    }

    private void loadPluginXML() throws Exception {
        URL url = this.getTestFile(PLUGIN_XML);
        url.openStream();
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        this.pluginDoc = domBuilder.parse(url.openStream());
    }

    protected URL getInstallLocation(String path) {
        URL installLocation = DTDUIPlugin.getDefault().getBundle().getEntry(path);
        URL resolvedLocation = null;
        try {
            resolvedLocation = FileLocator.resolve((URL)installLocation);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return resolvedLocation;
    }

    protected URL getTestFile(String filepath) {
        URL installURL = this.getInstallLocation("/" + filepath);
        return installURL;
    }

    public void testDTDToolTipExists() throws Exception {
        String xpathString = "//menuContribution[@locationURI = 'toolbar:org.eclipse.wst.xml.ui.perspective.NewFileToolBar']/command[@id = 'org.eclipse.wst.dtd.ui.newDTDFile']";
        XPathExpression xpathExpr = this.xpath.compile(xpathString);
        Element element = (Element)xpathExpr.evaluate(this.pluginDoc.getDocumentElement(), XPathConstants.NODE);
        String toolTip = element.getAttribute("tooltip");
        TestPluginXMLRequirements.assertEquals((String)"Unexpected value for DTD tooltip", (String)"%DTD_New_context_type_Extension_Element.name", (String)toolTip);
    }
}

