/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests.util;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.eclipse.wst.server.core.util.PublishUtil;

public class PublishUtilTestCase
extends TestCase {
    private static IProject testProject;
    private static IModuleResource[] testResources;
    private static IModuleResource[] testResources2;
    private static IPath[] preservePaths;
    private static IPath destination;

    private static void setFileContents(IFile file, String contents, boolean touch) throws CoreException {
        ByteArrayInputStream is = new ByteArrayInputStream(contents.getBytes());
        if (file.exists()) {
            if (touch) {
                file.setContents((InputStream)is, 1, null);
            } else {
                long ts = file.getLocation().toFile().lastModified();
                file.setContents((InputStream)is, 1, null);
                file.getLocation().toFile().setLastModified(ts);
            }
            file.refreshLocal(0, null);
        } else {
            file.create((InputStream)is, true, null);
        }
    }

    private static IProject getTestProject() throws CoreException {
        if (testProject == null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PublishTest");
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            testResources = new IModuleResource[4];
            testResources2 = new IModuleResource[3];
            preservePaths = new IPath[3];
            IFile rootFileA = project.getFile("rootFileA.txt");
            PublishUtilTestCase.setFileContents(rootFileA, "rootFileA contents", true);
            PublishUtilTestCase.testResources[0] = new ModuleFile(rootFileA, "rootFileA.txt", rootFileA.getProjectRelativePath());
            PublishUtilTestCase.testResources2[0] = testResources[0];
            IFile rootFileB = project.getFile("rootFileB.txt");
            PublishUtilTestCase.setFileContents(rootFileB, "rootFileB contents", true);
            PublishUtilTestCase.testResources[1] = new ModuleFile(rootFileB, "rootFileB.txt", rootFileB.getProjectRelativePath());
            PublishUtilTestCase.preservePaths[0] = rootFileB.getProjectRelativePath();
            IFolder folderA = project.getFolder("FolderA");
            if (!folderA.exists()) {
                folderA.create(true, true, null);
            }
            ModuleFolder moduleFolder = new ModuleFolder((IContainer)folderA, "FolderA", folderA.getProjectRelativePath());
            IModuleResource[] folderFiles = new IModuleResource[2];
            moduleFolder.setMembers(folderFiles);
            PublishUtilTestCase.testResources[2] = moduleFolder;
            IFile folderAFileA = folderA.getFile("folderAFileA.txt");
            PublishUtilTestCase.setFileContents(folderAFileA, "folderAFileA contents", true);
            folderFiles[0] = new ModuleFile(folderAFileA, "folderAFileA.txt", folderAFileA.getProjectRelativePath());
            IFile folderAFileB = folderA.getFile("folderAFileB.txt");
            PublishUtilTestCase.setFileContents(folderAFileB, "folderAFileB contents", true);
            folderFiles[1] = new ModuleFile(folderAFileB, "folderAFileB.txt", folderAFileB.getProjectRelativePath());
            PublishUtilTestCase.preservePaths[1] = folderAFileB.getProjectRelativePath();
            moduleFolder = new ModuleFolder((IContainer)folderA, "FolderA", folderA.getProjectRelativePath());
            moduleFolder.setMembers(new IModuleResource[]{folderFiles[0]});
            PublishUtilTestCase.testResources2[1] = moduleFolder;
            IFolder folderB = project.getFolder("FolderB");
            if (!folderB.exists()) {
                folderB.create(true, true, null);
            }
            moduleFolder = new ModuleFolder((IContainer)folderB, "FolderB", folderB.getProjectRelativePath());
            folderFiles = new IModuleResource[2];
            moduleFolder.setMembers(folderFiles);
            PublishUtilTestCase.testResources[3] = moduleFolder;
            IFile folderBFileA = folderB.getFile("folderBFileA.txt");
            PublishUtilTestCase.setFileContents(folderBFileA, "folderBFileA contents", true);
            folderFiles[0] = new ModuleFile(folderBFileA, "folderBFileA.txt", folderBFileA.getProjectRelativePath());
            IFile folderBFileB = folderB.getFile("folderBFileB.txt");
            PublishUtilTestCase.setFileContents(folderBFileB, "folderBFileB contents", true);
            folderFiles[1] = new ModuleFile(folderBFileB, "folderBFileB.txt", folderBFileB.getProjectRelativePath());
            PublishUtilTestCase.preservePaths[2] = folderBFileB.getProjectRelativePath();
            moduleFolder = new ModuleFolder((IContainer)folderB, "FolderB", folderB.getProjectRelativePath());
            moduleFolder.setMembers(new IModuleResource[]{folderFiles[0]});
            PublishUtilTestCase.testResources2[2] = moduleFolder;
            testProject = project;
        }
        return testProject;
    }

    private static IPath getDestination() {
        if (destination == null) {
            destination = ServerPlugin.getInstance().getTempDirectory("publish-destination");
        }
        return destination;
    }

    private static IModuleResource[] getModuleResources() {
        return testResources;
    }

    private static IModuleResource[] getModuleResources2() {
        return testResources2;
    }

    private static IPath[] getPreservePaths() {
        return preservePaths;
    }

    private static String getContents(IPath file) {
        char[] cBuffer = new char[1024];
        try {
            FileReader fr = new FileReader(file.toFile());
            int count = fr.read(cBuffer);
            fr.close();
            return new String(cBuffer, 0, count);
        }
        catch (FileNotFoundException e) {
            return e.getMessage();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private String getResultMessage(IStatus[] result) {
        if (result.length > 0) {
            return "Result contained " + result.length + " errors. First error: " + result[0].getMessage();
        }
        return "No error";
    }

    public void test00FullCopy() throws Exception {
        IProject project = PublishUtilTestCase.getTestProject();
        PublishUtilTestCase.assertNotNull((Object)project);
        IPath dest = PublishUtilTestCase.getDestination();
        PublishUtilTestCase.assertNotNull((Object)dest);
        IModuleResource[] resources = PublishUtilTestCase.getModuleResources();
        IStatus[] result = PublishUtil.publishSmart((IModuleResource[])resources, (IPath)dest, null, null);
        PublishUtilTestCase.assertNotNull((Object)result);
        PublishUtilTestCase.assertTrue((String)this.getResultMessage(result), (result.length == 0 ? 1 : 0) != 0);
        String contents = PublishUtilTestCase.getContents(dest.append(resources[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(resources[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileB contents", (String)contents);
        IModuleFolder mf = (IModuleFolder)resources[2];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileB contents", (String)contents);
        mf = (IModuleFolder)resources[3];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileB contents", (String)contents);
    }

    public void test01FullCopy() throws Exception {
        Thread.sleep(1000L);
        IProject project = PublishUtilTestCase.getTestProject();
        IFile rootFileA = project.getFile("rootFileA.txt");
        PublishUtilTestCase.setFileContents(rootFileA, "rootFileA contents 2", true);
        IFile rootFileB = project.getFile("rootFileB.txt");
        PublishUtilTestCase.setFileContents(rootFileB, "rootFileB contents 2", true);
        IFile folderAFileA = project.getFile("FolderA/folderAFileA.txt");
        PublishUtilTestCase.setFileContents(folderAFileA, "folderAFileA contents 2", true);
        IFile folderAFileB = project.getFile("FolderA/folderAFileB.txt");
        PublishUtilTestCase.setFileContents(folderAFileB, "folderAFileB contents 2", true);
        IFile folderBFileA = project.getFile("FolderB/folderBFileA.txt");
        PublishUtilTestCase.setFileContents(folderBFileA, "folderBFileA contents 2", true);
        IFile folderBFileB = project.getFile("FolderB/folderBFileB.txt");
        PublishUtilTestCase.setFileContents(folderBFileB, "folderBFileB contents 2", true);
        IPath dest = PublishUtilTestCase.getDestination();
        PublishUtilTestCase.assertNotNull((Object)dest);
        IModuleResource[] resources = PublishUtilTestCase.getModuleResources();
        IStatus[] result = PublishUtil.publishSmart((IModuleResource[])resources, (IPath)dest, null, null);
        PublishUtilTestCase.assertNotNull((Object)result);
        PublishUtilTestCase.assertTrue((String)this.getResultMessage(result), (result.length == 0 ? 1 : 0) != 0);
        String contents = PublishUtilTestCase.getContents(dest.append(resources[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileA contents 2", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(resources[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileB contents 2", (String)contents);
        IModuleFolder mf = (IModuleFolder)resources[2];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileA contents 2", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileB contents 2", (String)contents);
        mf = (IModuleFolder)resources[3];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileA contents 2", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileB contents 2", (String)contents);
    }

    public void test02PartialCopy() throws Exception {
        Thread.sleep(1000L);
        IProject project = PublishUtilTestCase.getTestProject();
        IFile rootFileA = project.getFile("rootFileA.txt");
        PublishUtilTestCase.setFileContents(rootFileA, "rootFileA contents", true);
        IFile rootFileB = project.getFile("rootFileB.txt");
        PublishUtilTestCase.setFileContents(rootFileB, "rootFileB contents", false);
        IFile folderAFileA = project.getFile("FolderA/folderAFileA.txt");
        PublishUtilTestCase.setFileContents(folderAFileA, "folderAFileA contents", true);
        IFile folderAFileB = project.getFile("FolderA/folderAFileB.txt");
        PublishUtilTestCase.setFileContents(folderAFileB, "folderAFileB contents", false);
        IFile folderBFileA = project.getFile("FolderB/folderBFileA.txt");
        PublishUtilTestCase.setFileContents(folderBFileA, "folderBFileA contents", true);
        IFile folderBFileB = project.getFile("FolderB/folderBFileB.txt");
        PublishUtilTestCase.setFileContents(folderBFileB, "folderBFileB contents", false);
        IPath dest = PublishUtilTestCase.getDestination();
        PublishUtilTestCase.assertNotNull((Object)dest);
        IModuleResource[] resources = PublishUtilTestCase.getModuleResources();
        IStatus[] result = PublishUtil.publishSmart((IModuleResource[])resources, (IPath)dest, null, null);
        PublishUtilTestCase.assertNotNull((Object)result);
        PublishUtilTestCase.assertTrue((String)this.getResultMessage(result), (result.length == 0 ? 1 : 0) != 0);
        String contents = PublishUtilTestCase.getContents(dest.append(resources[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(resources[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileB contents 2", (String)contents);
        IModuleFolder mf = (IModuleFolder)resources[2];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileB contents 2", (String)contents);
        mf = (IModuleFolder)resources[3];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileB contents 2", (String)contents);
    }

    public void test03PreserveFiles() throws Exception {
        IModuleResource[] resources = PublishUtilTestCase.getModuleResources();
        IModuleResource[] resources2 = PublishUtilTestCase.getModuleResources2();
        IPath dest = PublishUtilTestCase.getDestination();
        PublishUtilTestCase.assertNotNull((Object)dest);
        IStatus[] result = PublishUtil.publishSmart((IModuleResource[])resources2, (IPath)dest, (IPath[])PublishUtilTestCase.getPreservePaths(), null);
        PublishUtilTestCase.assertNotNull((Object)result);
        PublishUtilTestCase.assertTrue((String)this.getResultMessage(result), (result.length == 0 ? 1 : 0) != 0);
        String contents = PublishUtilTestCase.getContents(dest.append(resources[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(resources[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileB contents 2", (String)contents);
        IModuleFolder mf = (IModuleFolder)resources[2];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileB contents 2", (String)contents);
        mf = (IModuleFolder)resources[3];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileB contents 2", (String)contents);
    }

    public void test04PreserveFolder() throws Exception {
        IModuleResource[] resources = PublishUtilTestCase.getModuleResources();
        IModuleResource[] resources2 = new IModuleResource[3];
        System.arraycopy(resources, 0, resources2, 0, 3);
        IPath[] paths = new IPath[]{resources[3].getModuleRelativePath()};
        IPath dest = PublishUtilTestCase.getDestination();
        PublishUtilTestCase.assertNotNull((Object)dest);
        IStatus[] result = PublishUtil.publishSmart((IModuleResource[])resources2, (IPath)dest, (IPath[])paths, null);
        PublishUtilTestCase.assertNotNull((Object)result);
        PublishUtilTestCase.assertTrue((String)this.getResultMessage(result), (result.length == 0 ? 1 : 0) != 0);
        String contents = PublishUtilTestCase.getContents(dest.append(resources[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(resources[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileB contents 2", (String)contents);
        IModuleFolder mf = (IModuleFolder)resources[2];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileB contents 2", (String)contents);
        mf = (IModuleFolder)resources[3];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileA contents", (String)contents);
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[1].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderBFileB contents 2", (String)contents);
    }

    public void test05DeleteFiles() throws Exception {
        IModuleResource[] resources = PublishUtilTestCase.getModuleResources();
        IModuleResource[] resources2 = PublishUtilTestCase.getModuleResources2();
        IModuleResource[] resources3 = new IModuleResource[2];
        System.arraycopy(resources2, 0, resources3, 0, 2);
        IPath dest = PublishUtilTestCase.getDestination();
        PublishUtilTestCase.assertNotNull((Object)dest);
        IStatus[] result = PublishUtil.publishSmart((IModuleResource[])resources3, (IPath)dest, null, null);
        PublishUtilTestCase.assertNotNull((Object)result);
        PublishUtilTestCase.assertTrue((String)this.getResultMessage(result), (result.length == 0 ? 1 : 0) != 0);
        IPath[] paths = PublishUtilTestCase.getPreservePaths();
        String contents = PublishUtilTestCase.getContents(dest.append(resources[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"rootFileA contents", (String)contents);
        PublishUtilTestCase.assertFalse((boolean)dest.append(paths[0]).toFile().exists());
        IModuleFolder mf = (IModuleFolder)resources[2];
        contents = PublishUtilTestCase.getContents(dest.append(mf.members()[0].getModuleRelativePath()));
        PublishUtilTestCase.assertEquals((String)"folderAFileA contents", (String)contents);
        PublishUtilTestCase.assertFalse((boolean)dest.append(paths[1]).toFile().exists());
        mf = (IModuleFolder)resources[3];
        PublishUtilTestCase.assertFalse((boolean)dest.append(mf.getModuleRelativePath()).toFile().exists());
    }

    public void test06DeleteProject() throws Exception {
        IProject project = PublishUtilTestCase.getTestProject();
        project.delete(true, null);
        ServerPlugin.getInstance().removeTempDirectory("publish-destination");
    }
}

