/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceEmbeddableAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceEntityAnnotation;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.EmbeddableAnnotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.MappedSuperclassAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaResourcePersistentTypeTests
extends JavaResourceModelTestCase {
    public JavaResourcePersistentTypeTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestInvalidAnnotations() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Foo"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Foo");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Foo");
            }
        });
    }

    private ICompilationUnit createTestEntityWithMemberEmbeddable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embeddable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendMemberTypeTo(StringBuilder sb) {
                sb.append("     @Embeddable");
                sb.append(CR);
                sb.append("     public static class Foo { }").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityDuplicates() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity(name = \"FirstEntity\")").append(CR);
                sb.append("@Entity(name = \"SecondEntity\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEmbeddable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embeddable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@Embeddable");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedMethod() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldAndMethod() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedNonPersistableMethod() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetNameMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedPersistableMethodNonPersistableField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column");
                sb.append("    private transient int notPersistable;").append(CR);
                sb.append(CR);
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Column");
            }
        });
    }

    private ICompilationUnit createTestEntityNoPersistableFields() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendMemberTypeTo(StringBuilder sb) {
                sb.delete(sb.indexOf("private int id;"), sb.indexOf("private int id;") + "private int id;".length());
                sb.delete(sb.indexOf("private String name;"), sb.indexOf("private String name;") + "private String name;".length());
            }
        });
    }

    private ICompilationUnit createTestEntityWithTable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@Table(name = \"FOO\", schema = \"BAR\")");
            }
        });
    }

    private ICompilationUnit createTestEntityMultipleTables() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@Table(name = \"FOO\")");
                sb.append(CR);
                sb.append("@Table(name = \"BAR\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTable(name = \"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEmptySecondaryTables() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTables()");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTables() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTables(@SecondaryTable(name = \"FOO\"))");
            }
        });
    }

    private ICompilationUnit createTestEntityWith2SecondaryTables() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\")})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTableAndSecondaryTables() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTable(name = \"FOO\")");
                sb.append(CR);
                sb.append("@SecondaryTables({@SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\")})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithMemberTypes() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendMemberTypeTo(StringBuilder sb) {
                sb.append("     static class FooStatic {}").append(CR);
                sb.append(CR);
                sb.append("     class FooNotStatic {}").append(CR);
                sb.append(CR);
                sb.append("     @interface MyAnnotation {}").append(CR);
                sb.append(CR);
                sb.append("     enum MyEnum {}").append(CR);
            }
        });
    }

    public void testJavaTypeAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((int)1, (int)typeResource.supportingAnnotationsSize());
    }

    public void testJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.Table"));
    }

    public void testJavaTypeAnnotationNull() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.Table"));
    }

    public void testDuplicateAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityMultipleTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation tableResource = (TableAnnotation)typeResource.getSupportingAnnotation("javax.persistence.Table");
        JavaResourcePersistentTypeTests.assertEquals((String)"FOO", (String)tableResource.getName());
    }

    public void testRemoveTable() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        typeResource.removeSupportingAnnotation("javax.persistence.Table");
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testRemoveTableName() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourcePersistentType jrpt = this.buildJavaTypeResource(cu);
        TableAnnotation tableAnnotation = (TableAnnotation)jrpt.getSupportingAnnotation("javax.persistence.Table");
        tableAnnotation.setSchema(null);
        this.assertSourceContains("@Table(name = \"FOO\")", cu);
        tableAnnotation.setName(null);
        this.assertSourceDoesNotContain("@Table", cu);
        JavaResourcePersistentTypeTests.assertNull((Object)jrpt.getSupportingAnnotation("javax.persistence.Table"));
    }

    public void testMultipleTypeMappings() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithEmbeddable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((int)2, (int)typeResource.mappingAnnotationsSize());
        JavaResourcePersistentTypeTests.assertEquals((int)0, (int)typeResource.supportingAnnotationsSize());
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getMappingAnnotation("javax.persistence.Embeddable"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getMappingAnnotation("javax.persistence.Entity"));
        Annotation javaTypeMappingAnnotation = typeResource.getMappingAnnotation();
        JavaResourcePersistentTypeTests.assertTrue((boolean)(javaTypeMappingAnnotation instanceof EmbeddableAnnotation));
        this.assertSourceContains("@Entity", cu);
        this.assertSourceContains("@Embeddable", cu);
        typeResource.setMappingAnnotation("javax.persistence.MappedSuperclass");
        JavaResourcePersistentTypeTests.assertEquals((int)1, (int)typeResource.mappingAnnotationsSize());
        javaTypeMappingAnnotation = typeResource.getMappingAnnotation();
        JavaResourcePersistentTypeTests.assertTrue((boolean)(javaTypeMappingAnnotation instanceof MappedSuperclassAnnotation));
        this.assertSourceDoesNotContain("@Entity", cu);
        this.assertSourceContains("@MappedSuperclass", cu);
        this.assertSourceDoesNotContain("@Embeddable", cu);
    }

    public void testSetJavaTypeMappingAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((int)0, (int)typeResource.mappingAnnotationsSize());
        typeResource.setMappingAnnotation("javax.persistence.Entity");
        JavaResourcePersistentTypeTests.assertTrue((boolean)(typeResource.getMappingAnnotation() instanceof EntityAnnotation));
        this.assertSourceContains("@Entity", cu);
    }

    public void testSetJavaTypeMappingAnnotation2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertTrue((boolean)(typeResource.getMappingAnnotation() instanceof EntityAnnotation));
        typeResource.setMappingAnnotation("javax.persistence.Embeddable");
        JavaResourcePersistentTypeTests.assertTrue((boolean)(typeResource.getMappingAnnotation() instanceof EmbeddableAnnotation));
        this.assertSourceDoesNotContain("@Entity", cu);
        this.assertSourceContains("@Table", cu);
    }

    public void testAddJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        this.assertSourceDoesNotContain("@Table", cu);
        typeResource.addSupportingAnnotation("javax.persistence.Table");
        this.assertSourceContains("@Table", cu);
    }

    public void testRemoveJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        this.assertSourceContains("@Table", cu);
        typeResource.removeSupportingAnnotation("javax.persistence.Table");
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testChangeTypeMappingInSource() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        this.testType(cu).edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SourceEntityAnnotation.DECLARATION_ANNOTATION_ADAPTER.removeAnnotation(declaration);
            }
        });
        cu.createImport("javax.persistence.Embeddable", null, (IProgressMonitor)new NullProgressMonitor());
        this.testType(cu).edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SourceEmbeddableAnnotation.DECLARATION_ANNOTATION_ADAPTER.newMarkerAnnotation(declaration);
            }
        });
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.Table"));
        JavaResourcePersistentTypeTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Entity"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getMappingAnnotation("javax.persistence.Embeddable"));
        this.assertSourceContains("@Table", cu);
    }

    public void testJavaTypeAnnotationsNestable() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables").next();
        JavaResourcePersistentTypeTests.assertEquals((String)"FOO", (String)secondaryTableResource.getName());
    }

    public void testJavaTypeAnnotationsNoNestable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
    }

    public void testJavaTypeAnnotationsContainerNoNestable() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithEmptySecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
    }

    public void testJavaTypeAnnotationsNestableAndContainer() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTableAndSecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTable"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTables"));
        JavaResourcePersistentTypeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables").next();
        JavaResourcePersistentTypeTests.assertEquals((String)"BAR", (String)secondaryTableResource.getName());
    }

    public void testAddJavaTypeAnnotationNestableContainer() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTableResource.setName("FOO");
        this.assertSourceContains("@SecondaryTable(name = \"FOO\")", cu);
    }

    public void testAddJavaTypeAnnotationNestableContainer2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTableResource.setName("BAR");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"),@SecondaryTable(name = \"BAR\")})", cu);
        JavaResourcePersistentTypeTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTable"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTables"));
        JavaResourcePersistentTypeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
    }

    public void testAddJavaTypeAnnotationNestableContainer3() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTableResource.setName("BAR");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"),@SecondaryTable(name = \"BAR\")})", cu);
        JavaResourcePersistentTypeTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTable"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTables"));
        JavaResourcePersistentTypeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
    }

    public void testAddJavaTypeAnnotationNestableContainer5() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTableResource.setName("BAR");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAR\"),@SecondaryTable(name = \"FOO\")})", cu);
        JavaResourcePersistentTypeTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTable"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTables"));
        JavaResourcePersistentTypeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
    }

    public void testAddJavaTypeAnnotationNestableContainer6() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTableResource.setName("BAR");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAR\"),@SecondaryTable(name = \"FOO\")})", cu);
        JavaResourcePersistentTypeTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTable"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTables"));
        JavaResourcePersistentTypeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
        secondaryTableResource = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTableResource.setName("BAZ");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAZ\"),@SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"FOO\")})", cu);
        JavaResourcePersistentTypeTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
    }

    public void testAddJavaTypeAnnotationNestableContainer4() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTableAndSecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTable"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTables"));
        JavaResourcePersistentTypeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\"), @SecondaryTable})", cu);
        secondaryTableResource.setName("BOO");
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTable"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.SecondaryTables"));
        JavaResourcePersistentTypeTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables")));
        ListIterator secondaryTableAnnotations = typeResource.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTableResource = (SecondaryTableAnnotation)secondaryTableAnnotations.next();
        JavaResourcePersistentTypeTests.assertEquals((String)"BAR", (String)secondaryTableResource.getName());
        secondaryTableResource = (SecondaryTableAnnotation)secondaryTableAnnotations.next();
        JavaResourcePersistentTypeTests.assertEquals((String)"BAZ", (String)secondaryTableResource.getName());
        secondaryTableResource = (SecondaryTableAnnotation)secondaryTableAnnotations.next();
        JavaResourcePersistentTypeTests.assertEquals((String)"BOO", (String)secondaryTableResource.getName());
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\"), @SecondaryTable(name = \"BOO\")})", cu);
    }

    public void testRemoveJavaTypeAnnotationNestableContainer() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        typeResource.removeSupportingAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.assertSourceDoesNotContain("@SecondaryTable", cu);
    }

    public void testRemoveJavaTypeAnnotationNestableContainer2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        typeResource.removeSupportingAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.assertSourceDoesNotContain("@SecondaryTable", cu);
        this.assertSourceDoesNotContain("@SecondaryTables", cu);
    }

    public void testRemoveJavaTypeAnnotationIndex() throws Exception {
        ICompilationUnit cu = this.createTestEntityWith2SecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        typeResource.removeSupportingAnnotation(0, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.assertSourceDoesNotContain("@SecondaryTable(name = \"FOO\"", cu);
        this.assertSourceContains("@SecondaryTable(name = \"BAR\"", cu);
        this.assertSourceDoesNotContain("@SecondaryTables", cu);
    }

    public void testRemoveJavaTypeAnnotationIndex2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWith2SecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        SecondaryTableAnnotation newAnnotation = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ", cu);
        typeResource.removeSupportingAnnotation(1, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAZ\")})", cu);
    }

    public void testMoveJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityWith2SecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        SecondaryTableAnnotation newAnnotation = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\")})", cu);
        typeResource.moveSupportingAnnotation(0, 2, "javax.persistence.SecondaryTables");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAZ\"), @SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\")})", cu);
    }

    public void testMoveJavaTypeAnnotation2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWith2SecondaryTables();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        SecondaryTableAnnotation newAnnotation = (SecondaryTableAnnotation)typeResource.addSupportingAnnotation(2, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\")})", cu);
        typeResource.moveSupportingAnnotation(2, 0, "javax.persistence.SecondaryTables");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\"), @SecondaryTable(name = \"FOO\")})", cu);
    }

    public void testNestedTypes() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithMemberTypes();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((String)"only persistable types should be returned by #persistableTypes()", (int)1, (int)CollectionTools.size((Iterator)persistentType.persistableTypes()));
        JavaResourcePersistentTypeTests.assertEquals((String)"enums and interfaces should be ignored", (int)2, (int)CollectionTools.size((Iterator)persistentType.types()));
    }

    public void testDuplicateEntityAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityDuplicates();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        EntityAnnotation javaTypeMappingAnnotation = (EntityAnnotation)persistentType.getMappingAnnotation("javax.persistence.Entity");
        JavaResourcePersistentTypeTests.assertEquals((String)"FirstEntity", (String)javaTypeMappingAnnotation.getName());
        JavaResourcePersistentTypeTests.assertEquals((int)1, (int)persistentType.mappingAnnotationsSize());
        javaTypeMappingAnnotation = (EntityAnnotation)persistentType.getMappingAnnotation();
        JavaResourcePersistentTypeTests.assertEquals((String)"FirstEntity", (String)javaTypeMappingAnnotation.getName());
    }

    public void testAttributes() throws Exception {
    }

    public void testFields() throws Exception {
    }

    public void testProperties() throws Exception {
    }

    public void testGetAccessNoAttributesAnnotated() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertNull((Object)persistentType.getAccess());
    }

    public void testGetAccessFieldsAnnotated() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedField();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)persistentType.getAccess());
    }

    public void testGetAccessMethodsAnnotated() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedMethod();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentType.getAccess());
    }

    public void testGetAccessFieldsAndMethodsAnnotated() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedFieldAndMethod();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)persistentType.getAccess());
    }

    public void testGetAccessNonPersistableMethodAnnotated() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedNonPersistableMethod();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertNull((Object)persistentType.getAccess());
    }

    public void testGetAccessPersistableMethodAndNonPersistableFieldAnnotated() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedPersistableMethodNonPersistableField();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentType.getAccess());
    }

    public void testGetAccessNoPersistableFieldsAnnotated() throws Exception {
        ICompilationUnit cu = this.createTestEntityNoPersistableFields();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentType.getAccess());
    }

    public void testGetSuperclassQualifiedName() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((String)"java.lang.Object", (String)persistentType.getSuperclassQualifiedName());
    }

    public void testIsPersistable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType persistentType = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertTrue((boolean)persistentType.isPersistable());
    }

    public void testAnnotatedMemberType() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithMemberEmbeddable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertNotNull((Object)typeResource.getMappingAnnotation("javax.persistence.Entity"));
        JavaResourcePersistentTypeTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Embeddable"));
        JavaResourcePersistentType nestedType = (JavaResourcePersistentType)typeResource.persistableTypes().next();
        JavaResourcePersistentTypeTests.assertNull((Object)nestedType.getMappingAnnotation("javax.persistence.Entity"));
        JavaResourcePersistentTypeTests.assertNotNull((Object)nestedType.getMappingAnnotation("javax.persistence.Embeddable"));
    }

    public void testInvalidAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestInvalidAnnotations();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentTypeTests.assertEquals((int)0, (int)typeResource.mappingAnnotationsSize());
        JavaResourcePersistentTypeTests.assertEquals((int)0, (int)typeResource.supportingAnnotationsSize());
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentTypeTests.assertEquals((int)0, (int)attributeResource.mappingAnnotationsSize());
        JavaResourcePersistentTypeTests.assertEquals((int)0, (int)attributeResource.supportingAnnotationsSize());
    }
}

