/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeAdapter;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.listener.TreeChangeAdapter;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSupportTests
extends TestCase
implements StateChangeListener,
PropertyChangeListener,
CollectionChangeListener,
ListChangeListener,
TreeChangeListener {
    private TestModel testModel;
    private static final String TEST_TO_STRING = "this is a test";
    private StateChangeEvent stateChangeEvent;
    private boolean stateChangedCalled = false;
    private PropertyChangeEvent propertyChangeEvent;
    private boolean propertyChangeCalled = false;
    private static final String PROPERTY_NAME = "propertyName";
    static final Object OLD_OBJECT_VALUE = new Object();
    static final Object NEW_OBJECT_VALUE = new Object();
    static final Integer OLD_INT_VALUE = new Integer(27);
    static final Boolean OLD_BOOLEAN_VALUE = Boolean.TRUE;
    static final Integer NEW_INT_VALUE = new Integer(42);
    static final Boolean NEW_BOOLEAN_VALUE = Boolean.FALSE;
    private CollectionChangeEvent collectionChangeEvent;
    private boolean itemsAddedCollectionCalled = false;
    private boolean itemsRemovedCollectionCalled = false;
    private boolean collectionChangedCalled = false;
    private boolean collectionClearedCalled = false;
    private static final String COLLECTION_NAME = "collectionName";
    static final Object ADDED_OBJECT_VALUE = new Object();
    static final Object ADDED_OBJECT_VALUE_2 = new Object();
    static final Object REMOVED_OBJECT_VALUE = new Object();
    static final int TARGET_INDEX = 7;
    static final int SOURCE_INDEX = 22;
    private ListChangeEvent listChangeEvent;
    private boolean itemsAddedListCalled = false;
    private boolean itemsRemovedListCalled = false;
    private boolean itemsReplacedListCalled = false;
    private boolean itemsMovedListCalled = false;
    private boolean listChangedCalled = false;
    private boolean listClearedCalled = false;
    private static final String LIST_NAME = "listName";
    private static final int ADD_INDEX = 3;
    private static final int REMOVE_INDEX = 5;
    private static final int REPLACE_INDEX = 2;
    private TreeChangeEvent treeChangeEvent;
    private boolean nodeAddedCalled = false;
    private boolean nodeRemovedCalled = false;
    private boolean treeChangedCalled = false;
    private boolean treeClearedCalled = false;
    private static final String TREE_NAME = "treeName";
    static final Object[] OBJECT_ARRAY_PATH = new Object[]{new Object(), new Object(), new String()};
    static final Object[] EMPTY_PATH = new Object[0];
    private static final String ISE_MESSAGE = "this object is no longer listening to localA";

    public ChangeSupportTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testModel = new TestModel();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testNullSource() {
        boolean exCaught = false;
        try {
            ChangeSupport cs = new ChangeSupport(null);
            ChangeSupportTests.fail((String)("bogus change support: " + cs));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testFireStateChange() {
        this.stateChangeEvent = null;
        this.stateChangedCalled = false;
        this.testModel.addStateChangeListener(this);
        this.testModel.testFireStateChange();
        ChangeSupportTests.assertNotNull((Object)this.stateChangeEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.stateChangeEvent.getSource());
        ChangeSupportTests.assertTrue((boolean)this.stateChangedCalled);
    }

    public void testHasAnyStateChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
        this.testModel.addStateChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyStateChangeListeners());
        this.testModel.removeStateChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
    }

    public void testHasAnyStateChangeListenersDuplicate() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
        this.testModel.addStateChangeListener(this);
        this.testModel.addStateChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyStateChangeListeners());
        this.testModel.removeStateChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyStateChangeListeners());
        this.testModel.removeStateChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
    }

    public void testAddNullStateListener() {
        boolean exCaught = false;
        try {
            this.testModel.addStateChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusStateListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeStateChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeStateChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addStateChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeStateChangeListener(new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeStateChangeListener((StateChangeListener)new StateChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testFirePropertyChangedEvent() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedEvent();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedEvent();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedEvent();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedEvent();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedEventNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedEventNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedEventNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedEventNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedEventNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedObjectObject() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedObjectObject();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedObjectObject();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedObjectObjectNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedObjectObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedObjectObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedObjectObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedObjectObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedObject() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedObject();
        this.verifyPropertyChangeEvent(null, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedObject();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedObject();
        this.verifyPropertyChangeEvent(null, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedObject();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedObjectNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedIntInt() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedIntInt();
        this.verifyPropertyChangeEvent(OLD_INT_VALUE, NEW_INT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedIntInt();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedIntInt();
        this.verifyPropertyChangeEvent(OLD_INT_VALUE, NEW_INT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedIntInt();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedIntIntNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedIntIntNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedIntIntNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedIntIntNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedIntIntNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedBooleanBoolean() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedBooleanBoolean();
        this.verifyPropertyChangeEvent(OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedBooleanBoolean();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedBooleanBoolean();
        this.verifyPropertyChangeEvent(OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedBooleanBoolean();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedBooleanBooleanNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangedBooleanBooleanNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangedBooleanBooleanNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedBooleanBooleanNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangedBooleanBooleanNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testHasAnyPropertyChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addPropertyChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.removePropertyChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoPropertyChangeListeners(PROPERTY_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoPropertyChangeListeners(PROPERTY_NAME));
    }

    public void testAddNullPropertyListener() {
        boolean exCaught = false;
        try {
            this.testModel.addPropertyChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullPropertyListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addPropertyChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusPropertyListener() {
        boolean exCaught = false;
        try {
            this.testModel.removePropertyChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener(new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener((PropertyChangeListener)new PropertyChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusPropertyListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", (PropertyChangeListener)new PropertyChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    private void verifyPropertyChangeEvent(Object oldValue, Object newValue) {
        this.verifyPropertyChangeEvent(this.testModel, oldValue, newValue);
    }

    private void verifyPropertyChangeEvent(Object source, Object oldValue, Object newValue) {
        ChangeSupportTests.assertNotNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertEquals((Object)source, (Object)this.propertyChangeEvent.getSource());
        ChangeSupportTests.assertEquals((String)PROPERTY_NAME, (String)this.propertyChangeEvent.getPropertyName());
        ChangeSupportTests.assertEquals((Object)oldValue, (Object)this.propertyChangeEvent.getOldValue());
        ChangeSupportTests.assertEquals((Object)newValue, (Object)this.propertyChangeEvent.getNewValue());
    }

    public void testFireItemsAddedCollectionEvent() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemsAddedCollectionEvent();
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemsAddedCollectionEvent();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsAddedCollectionEvent();
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsAddedCollectionEvent();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemsAddedCollectionEventNoChange() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemsAddedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemsAddedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsAddedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsAddedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemsAddedCollection() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemsAddedCollection();
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemsAddedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsAddedCollection();
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsAddedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemsAddedCollectionNoChange() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemsAddedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemsAddedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsAddedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsAddedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemAddedCollection() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemAddedCollection();
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemAddedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemAddedCollection();
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemAddedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemsRemovedCollectionEvent() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemsRemovedCollectionEvent();
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemsRemovedCollectionEvent();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsRemovedCollectionEvent();
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsRemovedCollectionEvent();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireItemsRemovedCollectionEventNoChange() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemsRemovedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemsRemovedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsRemovedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsRemovedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireItemsRemovedCollection() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemsRemovedCollection();
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemsRemovedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsRemovedCollection();
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsRemovedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireItemsRemovedCollectionNoChange() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemsRemovedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemsRemovedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsRemovedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemsRemovedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireItemRemovedCollection() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemRemovedCollection();
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemRemovedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemRemovedCollection();
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemRemovedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireCollectionCleared() {
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireCollectionCleared();
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireCollectionCleared();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionCleared();
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionCleared();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testFireCollectionChangedEvent() {
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireCollectionChangedEvent();
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireCollectionChangedEvent();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionChangedEvent();
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionChangedEvent();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionChangedCalled);
    }

    public void testFireCollectionChanged() {
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireCollectionChanged();
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireCollectionChanged();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionChanged();
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionChanged();
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionChangedCalled);
    }

    public void testAddItemToCollection() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemToCollection());
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemToCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemToCollection());
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemToCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testAddItemToCollectionNoChange() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testAddItemsToCollection() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollection());
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollection());
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testAddItemsToCollectionNoChange() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemsToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemsToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemsToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemsToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testAddItemsToCollectionMixed() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollectionMixed());
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE_2);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollectionMixed());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollectionMixed());
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE_2);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollectionMixed());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testRemoveItemFromCollection() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemFromCollection());
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemFromCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemFromCollection());
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemFromCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemFromCollectionNoChange() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemFromCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemFromCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemFromCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemFromCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemsFromCollection() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemsFromCollection());
        this.verifyCollectionChangeEvent2(REMOVED_OBJECT_VALUE, "foo", "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemsFromCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemsFromCollection());
        this.verifyCollectionChangeEvent2(REMOVED_OBJECT_VALUE, "foo", "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemsFromCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemsFromCollectionNoChange1() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemsFromCollectionNoChange2() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemsFromCollectionNoChange3() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange3());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange3());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange3());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange3());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRetainItemsInCollection1() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection1());
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection1());
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRetainItemsInCollection2() {
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection2());
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection2());
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testRetainItemsInCollectionNoChange1() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRetainItemsInCollectionNoChange2() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testClearCollection() {
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testClearCollection());
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testClearCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testClearCollection());
        this.verifyCollectionChangeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testClearCollection());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testClearCollectionNoChange() {
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testClearCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testClearCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testClearCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testClearCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testSynchronizeCollection1() {
        CollectionSynchListener csl = new CollectionSynchListener();
        this.testModel.addCollectionChangeListener(csl);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testSynchronizeCollection1());
        ChangeSupportTests.assertTrue((boolean)csl.itemsAdded);
        ChangeSupportTests.assertTrue((boolean)csl.itemsRemoved);
        ChangeSupportTests.assertFalse((boolean)csl.collectionChanged);
        ChangeSupportTests.assertFalse((boolean)csl.collectionCleared);
        ChangeSupportTests.assertEquals((int)2, (int)csl.addedItems.size());
        ChangeSupportTests.assertTrue((boolean)CollectionTools.containsAll(csl.addedItems, (Object[])new Object[]{"joo", "jar"}));
        ChangeSupportTests.assertEquals((int)2, (int)csl.removedItems.size());
        ChangeSupportTests.assertTrue((boolean)CollectionTools.containsAll(csl.removedItems, (Object[])new Object[]{"foo", "bar"}));
    }

    public void testSynchronizeCollection2() {
        CollectionSynchListener csl = new CollectionSynchListener();
        this.testModel.addCollectionChangeListener(csl);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testSynchronizeCollection2());
        ChangeSupportTests.assertFalse((boolean)csl.itemsAdded);
        ChangeSupportTests.assertFalse((boolean)csl.itemsRemoved);
        ChangeSupportTests.assertFalse((boolean)csl.collectionChanged);
        ChangeSupportTests.assertTrue((boolean)csl.collectionCleared);
        ChangeSupportTests.assertTrue((boolean)csl.addedItems.isEmpty());
        ChangeSupportTests.assertTrue((boolean)csl.removedItems.isEmpty());
    }

    public void testSynchronizeCollection3() {
        CollectionSynchListener csl = new CollectionSynchListener();
        this.testModel.addCollectionChangeListener(csl);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testSynchronizeCollection3());
        ChangeSupportTests.assertTrue((boolean)csl.itemsAdded);
        ChangeSupportTests.assertFalse((boolean)csl.itemsRemoved);
        ChangeSupportTests.assertFalse((boolean)csl.collectionChanged);
        ChangeSupportTests.assertFalse((boolean)csl.collectionCleared);
        ChangeSupportTests.assertEquals((int)3, (int)csl.addedItems.size());
        ChangeSupportTests.assertTrue((boolean)CollectionTools.containsAll(csl.addedItems, (Object[])new Object[]{"joo", "jar", "baz"}));
        ChangeSupportTests.assertTrue((boolean)csl.removedItems.isEmpty());
    }

    public void testHasAnyCollectionChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.addCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.removeCollectionChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoCollectionChangeListeners(COLLECTION_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoCollectionChangeListeners(COLLECTION_NAME));
    }

    public void testAddNullCollectionListener() {
        boolean exCaught = false;
        try {
            this.testModel.addCollectionChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullCollectionListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addCollectionChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusCollectionListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener(new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener((CollectionChangeListener)new CollectionChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusCollectionListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", (CollectionChangeListener)new CollectionChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    private void verifyCollectionChangeEvent(Object item) {
        ChangeSupportTests.assertNotNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.collectionChangeEvent.getSource());
        ChangeSupportTests.assertEquals((String)COLLECTION_NAME, (String)this.collectionChangeEvent.getCollectionName());
        if (item == null) {
            ChangeSupportTests.assertFalse((boolean)this.collectionChangeEvent.items().hasNext());
        } else {
            ChangeSupportTests.assertEquals((Object)item, this.collectionChangeEvent.items().next());
        }
    }

    private void verifyCollectionChangeEvent2(Object ... items) {
        ChangeSupportTests.assertNotNull((Object)this.collectionChangeEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.collectionChangeEvent.getSource());
        ChangeSupportTests.assertEquals((String)COLLECTION_NAME, (String)this.collectionChangeEvent.getCollectionName());
        ChangeSupportTests.assertEquals((int)items.length, (int)this.collectionChangeEvent.itemsSize());
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            ChangeSupportTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.collectionChangeEvent.items(), (Object)item));
            ++n2;
        }
    }

    public void testFireItemsAddedListEvent() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsAddedListEvent();
        this.verifyListChangeEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsAddedListEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsAddedListEvent();
        this.verifyListChangeEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsAddedListEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemsAddedListEventNoChange() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsAddedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsAddedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsAddedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsAddedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemsAddedList() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsAddedList();
        this.verifyListChangeEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsAddedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsAddedList();
        this.verifyListChangeEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsAddedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemsAddedListNoChange() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsAddedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsAddedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsAddedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsAddedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemAddedList() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemAddedList();
        this.verifyListChangeEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemAddedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemAddedList();
        this.verifyListChangeEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemAddedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemsRemovedListEvent() {
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsRemovedListEvent();
        this.verifyListChangeEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsRemovedListEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsRemovedListEvent();
        this.verifyListChangeEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsRemovedListEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemsRemovedListEventNoChange() {
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsRemovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsRemovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsRemovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsRemovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemsRemovedList() {
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsRemovedList();
        this.verifyListChangeEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsRemovedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsRemovedList();
        this.verifyListChangeEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsRemovedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemsRemovedListNoChange() {
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsRemovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsRemovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsRemovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsRemovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemRemovedList() {
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemRemovedList();
        this.verifyListChangeEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemRemovedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemRemovedList();
        this.verifyListChangeEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemRemovedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemsReplacedListEvent() {
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsReplacedListEvent();
        this.verifyListChangeEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsReplacedListEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsReplacedListEvent();
        this.verifyListChangeEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsReplacedListEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemsReplacedListEventNoChange() {
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsReplacedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsReplacedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsReplacedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsReplacedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemsReplacedList() {
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsReplacedList();
        this.verifyListChangeEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsReplacedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsReplacedList();
        this.verifyListChangeEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsReplacedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemsReplacedListNoChange() {
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsReplacedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsReplacedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsReplacedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsReplacedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemReplacedList() {
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemReplacedList();
        this.verifyListChangeEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemReplacedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemReplacedList();
        this.verifyListChangeEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemReplacedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemsMovedListEvent() {
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsMovedListEvent();
        this.verifyListChangeEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsMovedListEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsMovedListEvent();
        this.verifyListChangeEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsMovedListEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireItemsMovedListEventNoChange() {
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsMovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsMovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsMovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsMovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireItemsMovedList() {
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsMovedList();
        this.verifyListChangeEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsMovedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsMovedList();
        this.verifyListChangeEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsMovedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireItemsMovedListNoChange() {
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemsMovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemsMovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsMovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemsMovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireItemMovedList() {
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemMovedList();
        this.verifyListChangeEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemMovedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemMovedList();
        this.verifyListChangeEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemMovedList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireListClearedEvent() {
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireListClearedEvent();
        this.verifyListChangeEvent(-1, null);
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireListClearedEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireListClearedEvent();
        this.verifyListChangeEvent(-1, null);
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireListClearedEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
    }

    public void testFireListCleared() {
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireListCleared();
        this.verifyListChangeEvent(-1, null);
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireListCleared();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireListCleared();
        this.verifyListChangeEvent(-1, null);
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireListCleared();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
    }

    public void testFireListChangedEvent() {
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireListChangedEvent();
        this.verifyListChangeEvent(-1, null);
        ChangeSupportTests.assertTrue((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireListChangedEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireListChangedEvent();
        this.verifyListChangeEvent(-1, null);
        ChangeSupportTests.assertTrue((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireListChangedEvent();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.listChangedCalled);
    }

    public void testFireListChanged() {
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireListChanged();
        this.verifyListChangeEvent(-1, null);
        ChangeSupportTests.assertTrue((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireListChanged();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireListChanged();
        this.verifyListChangeEvent(-1, null);
        ChangeSupportTests.assertTrue((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireListChanged();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.listChangedCalled);
    }

    public void testAddItemToListIndex() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testAddItemToListIndex();
        this.verifyListChangeEvent(2, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testAddItemToListIndex();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemToListIndex();
        this.verifyListChangeEvent(2, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemToListIndex();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemToList() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testAddItemToList();
        this.verifyListChangeEvent(3, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testAddItemToList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemToList();
        this.verifyListChangeEvent(3, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemToList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemsToListIndex() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testAddItemsToListIndex();
        this.verifyListChangeEvent(2, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testAddItemsToListIndex();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemsToListIndex();
        this.verifyListChangeEvent(2, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemsToListIndex();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemsToListIndexNoChange() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testAddItemsToListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testAddItemsToListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemsToListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemsToListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemsToList() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testAddItemsToList();
        this.verifyListChangeEvent(3, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testAddItemsToList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemsToList();
        this.verifyListChangeEvent(3, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemsToList();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemsToListNoChange() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testAddItemsToListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testAddItemsToListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemsToListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testAddItemsToListNoChange();
        ChangeSupportTests.assertNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testHasAnyListChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoListChangeListeners(LIST_NAME));
        this.testModel.addListChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyListChangeListeners(LIST_NAME));
        this.testModel.removeListChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoListChangeListeners(LIST_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoListChangeListeners(LIST_NAME));
        this.testModel.addListChangeListener(LIST_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyListChangeListeners(LIST_NAME));
        this.testModel.removeListChangeListener(LIST_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoListChangeListeners(LIST_NAME));
    }

    public void testAddNullListListener() {
        boolean exCaught = false;
        try {
            this.testModel.addListChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullListListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addListChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusListListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeListChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addListChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener(new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener((ListChangeListener)new ListChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusListListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addListChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", (ListChangeListener)new ListChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    private void verifyListChangeEvent(int index, Object item) {
        this.verifyListChangeEvent(index, item, null);
    }

    private void verifyListChangeEvent(int targetIndex, int sourceIndex) {
        ChangeSupportTests.assertNotNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.listChangeEvent.getSource());
        ChangeSupportTests.assertEquals((String)LIST_NAME, (String)this.listChangeEvent.getListName());
        ChangeSupportTests.assertEquals((int)targetIndex, (int)this.listChangeEvent.getTargetIndex());
        ChangeSupportTests.assertEquals((int)sourceIndex, (int)this.listChangeEvent.getSourceIndex());
    }

    private void verifyListChangeEvent(int index, Object item, Object replacedItem) {
        ChangeSupportTests.assertNotNull((Object)this.listChangeEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.listChangeEvent.getSource());
        ChangeSupportTests.assertEquals((String)LIST_NAME, (String)this.listChangeEvent.getListName());
        ChangeSupportTests.assertEquals((int)index, (int)this.listChangeEvent.getIndex());
        if (item == null) {
            ChangeSupportTests.assertFalse((boolean)this.listChangeEvent.items().hasNext());
        } else {
            ChangeSupportTests.assertEquals((Object)item, this.listChangeEvent.items().next());
        }
        if (replacedItem == null) {
            ChangeSupportTests.assertFalse((boolean)this.listChangeEvent.replacedItems().hasNext());
        } else {
            ChangeSupportTests.assertEquals((Object)replacedItem, this.listChangeEvent.replacedItems().next());
        }
    }

    public void testFireNodeAddedTree() {
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireNodeAddedTree();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireNodeAddedTree();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeAddedTree();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeAddedTree();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeAddedCalled);
    }

    public void testFireNodeAddedTreeEvent() {
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireNodeAddedTreeEvent();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireNodeAddedTreeEvent();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeAddedTreeEvent();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeAddedTreeEvent();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeAddedCalled);
    }

    public void testFireNodeRemovedTreeEvent() {
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireNodeRemovedTreeEvent();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireNodeRemovedTreeEvent();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeRemovedTreeEvent();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeRemovedTreeEvent();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeRemovedCalled);
    }

    public void testFireNodeRemovedTree() {
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireNodeRemovedTree();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireNodeRemovedTree();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeRemovedTree();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeRemovedTree();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeRemovedCalled);
    }

    public void testFireTreeClearedEvent() {
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireTreeClearedEvent();
        this.verifyTreeChangeEvent(EMPTY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireTreeClearedEvent();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeClearedEvent();
        this.verifyTreeChangeEvent(EMPTY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeClearedEvent();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeClearedCalled);
    }

    public void testFireTreeCleared() {
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireTreeCleared();
        this.verifyTreeChangeEvent(EMPTY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireTreeCleared();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeCleared();
        this.verifyTreeChangeEvent(EMPTY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeCleared();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeClearedCalled);
    }

    public void testFireTreeChangedEvent() {
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireTreeChangedEvent();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireTreeChangedEvent();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeChangedEvent();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeChangedEvent();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeChangedCalled);
    }

    public void testFireTreeChanged() {
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireTreeChanged();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireTreeChanged();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeChanged();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        ChangeSupportTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeChanged();
        ChangeSupportTests.assertNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeChangedCalled);
    }

    public void testHasAnyTreeChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoTreeChangeListeners(TREE_NAME));
        this.testModel.addTreeChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyTreeChangeListeners(TREE_NAME));
        this.testModel.removeTreeChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoTreeChangeListeners(TREE_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoTreeChangeListeners(TREE_NAME));
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyTreeChangeListeners(TREE_NAME));
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoTreeChangeListeners(TREE_NAME));
    }

    public void testAddNullTreeListener() {
        boolean exCaught = false;
        try {
            this.testModel.addTreeChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullTreeListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addTreeChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusTreeListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeTreeChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addTreeChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener(new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener((TreeChangeListener)new TreeChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusTreeListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addTreeChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", new ChangeSupportTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", (TreeChangeListener)new TreeChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    private void verifyTreeChangeEvent(Object[] path) {
        ChangeSupportTests.assertNotNull((Object)this.treeChangeEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.treeChangeEvent.getSource());
        ChangeSupportTests.assertEquals((String)TREE_NAME, (String)this.treeChangeEvent.getTreeName());
        ChangeSupportTests.assertTrue((boolean)Arrays.equals(path, this.treeChangeEvent.getPath()));
    }

    public void testElementsAreEqual() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("foo");
        c1.add("bar");
        c1.add("baz");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("foo");
        c2.add("bar");
        c2.add("baz");
        ChangeSupportTests.assertTrue((boolean)this.testModel.testElementsAreEqual(c1.iterator(), c2.iterator()));
    }

    public void testElementsAreDifferent() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("foo");
        c1.add("bar");
        c1.add("baz");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("baz");
        c2.add("bar");
        c2.add("foo");
        ChangeSupportTests.assertTrue((boolean)this.testModel.testElementsAreDifferent(c1.iterator(), c2.iterator()));
    }

    public void testAbstractModelValuesAreEqual1() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreEqual(null, null));
    }

    public void testAbstractModelValuesAreEqual2() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreEqual("foo", "foo"));
    }

    public void testAbstractModelValuesAreEqual3() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreEqual("foo", null));
    }

    public void testAbstractModelValuesAreEqual4() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreEqual(null, "foo"));
    }

    public void testAbstractModelValuesAreEqual5() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreEqual("bar", "foo"));
    }

    public void testAbstractModelValuesAreDifferent1() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreDifferent(null, null));
    }

    public void testAbstractModelValuesAreDifferent2() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreDifferent("foo", "foo"));
    }

    public void testAbstractModelValuesAreDifferent3() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreDifferent("foo", null));
    }

    public void testAbstractModelValuesAreDifferent4() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreDifferent(null, "foo"));
    }

    public void testAbstractModelValuesAreDifferent5() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreDifferent("bar", "foo"));
    }

    public void testAbstractModelAttributeValueHasChanged1() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasChanged(null, null));
    }

    public void testAbstractModelAttributeValueHasChanged2() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasChanged("foo", "foo"));
    }

    public void testAbstractModelAttributeValueHasChanged3() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasChanged("foo", null));
    }

    public void testAbstractModelAttributeValueHasChanged4() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasChanged(null, "foo"));
    }

    public void testAbstractModelAttributeValueHasChanged5() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasChanged("bar", "foo"));
    }

    public void testAbstractModelAttributeValueHasNotChanged1() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasNotChanged(null, null));
    }

    public void testAbstractModelAttributeValueHasNotChanged2() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasNotChanged("foo", "foo"));
    }

    public void testAbstractModelAttributeValueHasNotChanged3() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasNotChanged("foo", null));
    }

    public void testAbstractModelAttributeValueHasNotChanged4() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasNotChanged(null, "foo"));
    }

    public void testAbstractModelAttributeValueHasNotChanged5() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasNotChanged("bar", "foo"));
    }

    public void testAbstractModelClone() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addPropertyChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        TestModel clone = this.testModel.clone();
        ChangeSupportTests.assertFalse((boolean)clone.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        clone.addPropertyChangeListener(this);
        ChangeSupportTests.assertTrue((boolean)clone.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.testFirePropertyChangedObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        clone.testFirePropertyChangedObjectObject();
        this.verifyPropertyChangeEvent(clone, OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
    }

    public void testAbstractModelToString() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.toString().contains("(this is a test)"));
    }

    public void stateChanged(StateChangeEvent e) {
        this.stateChangedCalled = true;
        this.stateChangeEvent = e;
    }

    public void propertyChanged(PropertyChangeEvent e) {
        this.propertyChangeCalled = true;
        this.propertyChangeEvent = e;
    }

    public void itemsAdded(CollectionChangeEvent e) {
        this.itemsAddedCollectionCalled = true;
        this.collectionChangeEvent = e;
    }

    public void itemsRemoved(CollectionChangeEvent e) {
        this.itemsRemovedCollectionCalled = true;
        this.collectionChangeEvent = e;
    }

    public void collectionCleared(CollectionChangeEvent e) {
        this.collectionClearedCalled = true;
        this.collectionChangeEvent = e;
    }

    public void collectionChanged(CollectionChangeEvent e) {
        this.collectionChangedCalled = true;
        this.collectionChangeEvent = e;
    }

    public void itemsAdded(ListChangeEvent e) {
        this.itemsAddedListCalled = true;
        this.listChangeEvent = e;
    }

    public void itemsRemoved(ListChangeEvent e) {
        this.itemsRemovedListCalled = true;
        this.listChangeEvent = e;
    }

    public void itemsReplaced(ListChangeEvent e) {
        this.itemsReplacedListCalled = true;
        this.listChangeEvent = e;
    }

    public void itemsMoved(ListChangeEvent e) {
        this.itemsMovedListCalled = true;
        this.listChangeEvent = e;
    }

    public void listCleared(ListChangeEvent e) {
        this.listClearedCalled = true;
        this.listChangeEvent = e;
    }

    public void listChanged(ListChangeEvent e) {
        this.listChangedCalled = true;
        this.listChangeEvent = e;
    }

    public void nodeAdded(TreeChangeEvent e) {
        this.nodeAddedCalled = true;
        this.treeChangeEvent = e;
    }

    public void nodeRemoved(TreeChangeEvent e) {
        this.nodeRemovedCalled = true;
        this.treeChangeEvent = e;
    }

    public void treeCleared(TreeChangeEvent e) {
        this.treeClearedCalled = true;
        this.treeChangeEvent = e;
    }

    public void treeChanged(TreeChangeEvent e) {
        this.treeChangedCalled = true;
        this.treeChangeEvent = e;
    }

    private ChangeListener[] listeners(LocalModel model, Class<? extends ChangeListener> listenerClass) {
        ChangeSupport changeSupport = (ChangeSupport)ClassTools.fieldValue((Object)((Object)model), (String)"changeSupport");
        return (ChangeListener[])ClassTools.executeMethod((Object)changeSupport, (String)"getListeners", Class.class, listenerClass);
    }

    public void testIndirectRemoveStateListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyStateListeners();
            }
        });
    }

    public void testIndirectRemovePropertyListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyPropertyListeners();
            }
        });
    }

    public void testIndirectRemoveCollectionListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyCollectionListeners();
            }
        });
    }

    public void testIndirectRemoveListListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyListListeners();
            }
        });
    }

    public void testIndirectRemoveTreeListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyTreeListeners();
            }
        });
    }

    public void verifyIndirectRemoveListener(NotifyCommand command) {
        LocalA localA = new LocalA();
        LocalB localB = new LocalB(localA);
        LocalC[] localCs = new LocalC[1000];
        int i = localCs.length;
        while (i-- > 0) {
            localCs[i] = new LocalC(localA, localB);
        }
        boolean exCaught = false;
        try {
            command.notifyListeners(localA);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() == ISE_MESSAGE) {
                exCaught = true;
            }
            throw ex;
        }
        ChangeSupportTests.assertFalse((boolean)exCaught);
        int i2 = localCs.length;
        while (i2-- > 0) {
            ChangeSupportTests.assertFalse((boolean)localCs[i2].isListeningToLocalA());
        }
    }

    private static class Bar
    implements StateChangeListener {
        Bar() {
        }

        public void stateChanged(StateChangeEvent event) {
        }
    }

    class CollectionSynchListener
    implements CollectionChangeListener {
        boolean itemsAdded = false;
        boolean itemsRemoved = false;
        boolean collectionChanged = false;
        boolean collectionCleared = false;
        Collection<Object> addedItems = new ArrayList<Object>();
        Collection<Object> removedItems = new ArrayList<Object>();

        CollectionSynchListener() {
        }

        public void collectionChanged(CollectionChangeEvent event) {
            this.collectionChanged = true;
        }

        public void collectionCleared(CollectionChangeEvent event) {
            this.collectionCleared = true;
        }

        public void itemsAdded(CollectionChangeEvent event) {
            this.itemsAdded = true;
            CollectionTools.addAll(this.addedItems, (Iterator)event.items());
        }

        public void itemsRemoved(CollectionChangeEvent event) {
            this.itemsRemoved = true;
            CollectionTools.addAll(this.removedItems, (Iterator)event.items());
        }
    }

    private static class Foo
    implements Serializable,
    StateChangeListener {
        Foo() {
        }

        public void stateChanged(StateChangeEvent event) {
        }
    }

    private static class Jar
    extends ListChangeAdapter {
        Jar() {
        }
    }

    private static class Joo
    extends ListChangeAdapter
    implements Serializable {
        Joo() {
        }
    }

    private static class LocalA
    extends AbstractModel {
        LocalA() {
        }

        void notifyStateListeners() {
            this.fireStateChanged();
        }

        void notifyPropertyListeners() {
            this.firePropertyChanged("foo", 1, 2);
        }

        void notifyCollectionListeners() {
            this.fireCollectionChanged("foo");
        }

        void notifyListListeners() {
            this.fireListChanged("foo");
        }

        void notifyTreeListeners() {
            this.fireTreeChanged("foo");
        }
    }

    private static class LocalB
    extends AbstractModel
    implements StateChangeListener,
    PropertyChangeListener,
    CollectionChangeListener,
    ListChangeListener,
    TreeChangeListener {
        LocalB(LocalA localA) {
            localA.addStateChangeListener(this);
            localA.addPropertyChangeListener(this);
            localA.addCollectionChangeListener(this);
            localA.addListChangeListener(this);
            localA.addTreeChangeListener(this);
        }

        public void stateChanged(StateChangeEvent e) {
            this.fireStateChanged();
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            this.firePropertyChanged("bar", 1, 2);
        }

        public void collectionChanged(CollectionChangeEvent e) {
            this.fireCollectionChanged("bar");
        }

        public void collectionCleared(CollectionChangeEvent e) {
        }

        public void itemsAdded(CollectionChangeEvent e) {
        }

        public void itemsRemoved(CollectionChangeEvent e) {
        }

        public void listChanged(ListChangeEvent e) {
            this.fireListChanged("bar");
        }

        public void listCleared(ListChangeEvent e) {
        }

        public void itemsAdded(ListChangeEvent e) {
        }

        public void itemsRemoved(ListChangeEvent e) {
        }

        public void itemsReplaced(ListChangeEvent e) {
        }

        public void itemsMoved(ListChangeEvent e) {
        }

        public void treeChanged(TreeChangeEvent e) {
            this.fireTreeChanged("bar");
        }

        public void treeCleared(TreeChangeEvent e) {
        }

        public void nodeAdded(TreeChangeEvent e) {
        }

        public void nodeRemoved(TreeChangeEvent e) {
        }
    }

    private static class LocalC
    extends AbstractModel
    implements StateChangeListener,
    PropertyChangeListener,
    CollectionChangeListener,
    ListChangeListener,
    TreeChangeListener {
        private LocalA localA;
        private LocalB localB;
        private boolean listeningToLocalA;

        LocalC(LocalA localA, LocalB localB) {
            this.localA = localA;
            this.localB = localB;
            localA.addStateChangeListener(this);
            localA.addPropertyChangeListener(this);
            localA.addCollectionChangeListener(this);
            localA.addListChangeListener(this);
            localA.addTreeChangeListener(this);
            this.listeningToLocalA = true;
            localB.addStateChangeListener(this);
            localB.addPropertyChangeListener(this);
            localB.addCollectionChangeListener(this);
            localB.addListChangeListener(this);
            localB.addTreeChangeListener(this);
        }

        boolean isListeningToLocalA() {
            return this.listeningToLocalA;
        }

        public void stateChanged(StateChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeStateChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void propertyChanged(PropertyChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removePropertyChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void collectionChanged(CollectionChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeCollectionChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void collectionCleared(CollectionChangeEvent e) {
        }

        public void itemsAdded(CollectionChangeEvent e) {
        }

        public void itemsRemoved(CollectionChangeEvent e) {
        }

        public void listChanged(ListChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeListChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void listCleared(ListChangeEvent e) {
        }

        public void itemsAdded(ListChangeEvent e) {
        }

        public void itemsRemoved(ListChangeEvent e) {
        }

        public void itemsReplaced(ListChangeEvent e) {
        }

        public void itemsMoved(ListChangeEvent e) {
        }

        public void treeChanged(TreeChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeTreeChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void treeCleared(TreeChangeEvent e) {
        }

        public void nodeAdded(TreeChangeEvent e) {
        }

        public void nodeRemoved(TreeChangeEvent e) {
        }
    }

    private static class LocalModel
    extends AbstractModel {
        LocalModel() {
        }
    }

    private static interface NotifyCommand {
        public void notifyListeners(LocalA var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestModel
    extends AbstractModel
    implements Cloneable {
        TestModel() {
        }

        public void testFireStateChange() {
            this.fireStateChanged();
        }

        public void testFirePropertyChangedEvent() {
            this.firePropertyChanged(new PropertyChangeEvent((Model)this, ChangeSupportTests.PROPERTY_NAME, OLD_OBJECT_VALUE, NEW_OBJECT_VALUE));
        }

        public void testFirePropertyChangedEventNoChange() {
            this.firePropertyChanged(new PropertyChangeEvent((Model)this, ChangeSupportTests.PROPERTY_NAME, OLD_OBJECT_VALUE, OLD_OBJECT_VALUE));
        }

        public void testFirePropertyChangedObjectObject() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        }

        public void testFirePropertyChangedObjectObjectNoChange() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_OBJECT_VALUE, OLD_OBJECT_VALUE);
        }

        public void testFirePropertyChangedObject() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, NEW_OBJECT_VALUE);
        }

        public void testFirePropertyChangedObjectNoChange() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, null);
        }

        public void testFirePropertyChangedIntInt() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_INT_VALUE, NEW_INT_VALUE);
        }

        public void testFirePropertyChangedIntIntNoChange() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_INT_VALUE, OLD_INT_VALUE);
        }

        public void testFirePropertyChangedBooleanBoolean() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        }

        public void testFirePropertyChangedBooleanBooleanNoChange() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_BOOLEAN_VALUE, OLD_BOOLEAN_VALUE);
        }

        public void testFireItemsAddedCollectionEvent() {
            this.fireItemsAdded(new CollectionChangeEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, Collections.singleton(ADDED_OBJECT_VALUE)));
        }

        public void testFireItemsAddedCollectionEventNoChange() {
            this.fireItemsAdded(new CollectionChangeEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, Collections.emptySet()));
        }

        public void testFireItemsAddedCollection() {
            this.fireItemsAdded(ChangeSupportTests.COLLECTION_NAME, Collections.singleton(ADDED_OBJECT_VALUE));
        }

        public void testFireItemsAddedCollectionNoChange() {
            this.fireItemsAdded(ChangeSupportTests.COLLECTION_NAME, Collections.emptySet());
        }

        public void testFireItemAddedCollection() {
            this.fireItemAdded(ChangeSupportTests.COLLECTION_NAME, ADDED_OBJECT_VALUE);
        }

        public void testFireItemsRemovedCollectionEvent() {
            this.fireItemsRemoved(new CollectionChangeEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, Collections.singleton(REMOVED_OBJECT_VALUE)));
        }

        public void testFireItemsRemovedCollectionEventNoChange() {
            this.fireItemsRemoved(new CollectionChangeEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, Collections.emptySet()));
        }

        public void testFireItemsRemovedCollection() {
            this.fireItemsRemoved(ChangeSupportTests.COLLECTION_NAME, Collections.singleton(REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsRemovedCollectionNoChange() {
            this.fireItemsRemoved(ChangeSupportTests.COLLECTION_NAME, Collections.emptySet());
        }

        public void testFireItemRemovedCollection() {
            this.fireItemRemoved(ChangeSupportTests.COLLECTION_NAME, REMOVED_OBJECT_VALUE);
        }

        public void testFireCollectionCleared() {
            this.fireCollectionCleared(ChangeSupportTests.COLLECTION_NAME);
        }

        public void testFireCollectionChangedEvent() {
            this.fireCollectionChanged(new CollectionChangeEvent((Model)this, ChangeSupportTests.COLLECTION_NAME));
        }

        public void testFireCollectionChanged() {
            this.fireCollectionChanged(ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemToCollection() {
            return this.addItemToCollection(ADDED_OBJECT_VALUE, new ArrayList(), ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemToCollectionNoChange() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(ADDED_OBJECT_VALUE);
            return this.addItemToCollection(ADDED_OBJECT_VALUE, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemsToCollection() {
            return this.addItemsToCollection(Collections.singleton(ADDED_OBJECT_VALUE), new ArrayList(), ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemsToCollectionNoChange() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(ADDED_OBJECT_VALUE);
            return this.addItemsToCollection(Collections.singleton(ADDED_OBJECT_VALUE), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemsToCollectionMixed() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(ADDED_OBJECT_VALUE);
            return this.addItemsToCollection(new Object[]{ADDED_OBJECT_VALUE, ADDED_OBJECT_VALUE_2}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemFromCollection() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            return this.removeItemFromCollection(REMOVED_OBJECT_VALUE, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemFromCollectionNoChange() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            return this.removeItemFromCollection("foo", collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemsFromCollection() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.removeItemsFromCollection(new Object[]{"foo", "bar", REMOVED_OBJECT_VALUE}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemsFromCollectionNoChange1() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            return this.removeItemsFromCollection(Collections.emptySet(), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemsFromCollectionNoChange2() {
            HashSet collection = new HashSet();
            return this.removeItemsFromCollection(Collections.singleton("foo"), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemsFromCollectionNoChange3() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            return this.removeItemsFromCollection(Collections.singleton("foo"), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRetainItemsInCollection1() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.retainItemsInCollection(new Object[]{"foo", "bar"}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRetainItemsInCollection2() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.retainItemsInCollection(Collections.emptySet(), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRetainItemsInCollectionNoChange1() {
            HashSet collection = new HashSet();
            return this.retainItemsInCollection(new Object[]{"foo", "bar"}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRetainItemsInCollectionNoChange2() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.retainItemsInCollection(new Object[]{"foo", "bar", REMOVED_OBJECT_VALUE}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testClearCollection() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.clearCollection(collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testClearCollectionNoChange() {
            HashSet collection = new HashSet();
            return this.clearCollection(collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testSynchronizeCollection1() {
            HashSet<String> collection = new HashSet<String>();
            collection.add("foo");
            collection.add("bar");
            collection.add("baz");
            HashSet<String> newCollection = new HashSet<String>();
            newCollection.add("joo");
            newCollection.add("jar");
            newCollection.add("baz");
            boolean result = this.synchronizeCollection(newCollection, collection, ChangeSupportTests.COLLECTION_NAME);
            ChangeSupportTests.assertEquals(newCollection, collection);
            return result;
        }

        public boolean testSynchronizeCollection2() {
            HashSet<String> collection = new HashSet<String>();
            collection.add("foo");
            collection.add("bar");
            collection.add("baz");
            HashSet newCollection = new HashSet();
            boolean result = this.synchronizeCollection(newCollection, collection, ChangeSupportTests.COLLECTION_NAME);
            ChangeSupportTests.assertEquals(newCollection, collection);
            return result;
        }

        public boolean testSynchronizeCollection3() {
            HashSet collection = new HashSet();
            HashSet<String> newCollection = new HashSet<String>();
            newCollection.add("joo");
            newCollection.add("jar");
            newCollection.add("baz");
            boolean result = this.synchronizeCollection(newCollection, collection, ChangeSupportTests.COLLECTION_NAME);
            ChangeSupportTests.assertEquals(newCollection, collection);
            return result;
        }

        public void testFireItemsAddedListEvent() {
            this.fireItemsAdded(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, 3, Collections.singletonList(ADDED_OBJECT_VALUE)));
        }

        public void testFireItemsAddedListEventNoChange() {
            this.fireItemsAdded(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, 3, Collections.emptyList()));
        }

        public void testFireItemsAddedList() {
            this.fireItemsAdded(ChangeSupportTests.LIST_NAME, 3, Collections.singletonList(ADDED_OBJECT_VALUE));
        }

        public void testFireItemsAddedListNoChange() {
            this.fireItemsAdded(ChangeSupportTests.LIST_NAME, 3, Collections.emptyList());
        }

        public void testFireItemAddedList() {
            this.fireItemAdded(ChangeSupportTests.LIST_NAME, 3, ADDED_OBJECT_VALUE);
        }

        public void testFireItemsRemovedListEvent() {
            this.fireItemsRemoved(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, 5, Collections.singletonList(REMOVED_OBJECT_VALUE)));
        }

        public void testFireItemsRemovedListEventNoChange() {
            this.fireItemsRemoved(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, 5, Collections.emptyList()));
        }

        public void testFireItemsRemovedList() {
            this.fireItemsRemoved(ChangeSupportTests.LIST_NAME, 5, Collections.singletonList(REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsRemovedListNoChange() {
            this.fireItemsRemoved(ChangeSupportTests.LIST_NAME, 5, Collections.emptyList());
        }

        public void testFireItemRemovedList() {
            this.fireItemRemoved(ChangeSupportTests.LIST_NAME, 5, REMOVED_OBJECT_VALUE);
        }

        public void testFireItemsReplacedListEvent() {
            this.fireItemsReplaced(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, 2, Collections.singletonList(ADDED_OBJECT_VALUE), Collections.singletonList(REMOVED_OBJECT_VALUE)));
        }

        public void testFireItemsReplacedListEventNoChange() {
            this.fireItemsReplaced(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, 2, Collections.emptyList(), Collections.emptyList()));
        }

        public void testFireItemsReplacedList() {
            this.fireItemsReplaced(ChangeSupportTests.LIST_NAME, 2, Collections.singletonList(ADDED_OBJECT_VALUE), Collections.singletonList(REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsReplacedListNoChange() {
            this.fireItemsReplaced(ChangeSupportTests.LIST_NAME, 2, Collections.emptyList(), Collections.emptyList());
        }

        public void testFireItemReplacedList() {
            this.fireItemReplaced(ChangeSupportTests.LIST_NAME, 2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        }

        public void testFireItemsMovedListEvent() {
            this.fireItemsMoved(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, 7, 22, 1));
        }

        public void testFireItemsMovedListEventNoChange() {
            this.fireItemsMoved(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, 22, 22, 1));
        }

        public void testFireItemsMovedList() {
            this.fireItemsMoved(ChangeSupportTests.LIST_NAME, 7, 22, 1);
        }

        public void testFireItemsMovedListNoChange() {
            this.fireItemsMoved(ChangeSupportTests.LIST_NAME, 22, 22, 1);
        }

        public void testFireItemMovedList() {
            this.fireItemMoved(ChangeSupportTests.LIST_NAME, 7, 22);
        }

        public void testFireListClearedEvent() {
            this.fireListCleared(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME));
        }

        public void testFireListCleared() {
            this.fireListCleared(ChangeSupportTests.LIST_NAME);
        }

        public void testFireListChangedEvent() {
            this.fireListChanged(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME));
        }

        public void testFireListChanged() {
            this.fireListChanged(ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemToListIndex() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemToList(2, "joo", list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemToList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemToList("joo", list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemsToListIndex() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(2, Collections.singletonList("joo"), list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemsToListIndexNoChange() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(2, Collections.emptyList(), list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemsToList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(Collections.singletonList("joo"), list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemsToListNoChange() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(Collections.emptyList(), list, ChangeSupportTests.LIST_NAME);
        }

        public void testFireNodeAddedTreeEvent() {
            this.fireNodeAdded(new TreeChangeEvent((Model)this, ChangeSupportTests.TREE_NAME, OBJECT_ARRAY_PATH));
        }

        public void testFireNodeAddedTree() {
            this.fireNodeAdded(ChangeSupportTests.TREE_NAME, OBJECT_ARRAY_PATH);
        }

        public void testFireNodeRemovedTreeEvent() {
            this.fireNodeRemoved(new TreeChangeEvent((Model)this, ChangeSupportTests.TREE_NAME, OBJECT_ARRAY_PATH));
        }

        public void testFireNodeRemovedTree() {
            this.fireNodeRemoved(ChangeSupportTests.TREE_NAME, OBJECT_ARRAY_PATH);
        }

        public void testFireTreeClearedEvent() {
            this.fireTreeCleared(new TreeChangeEvent((Model)this, ChangeSupportTests.TREE_NAME));
        }

        public void testFireTreeCleared() {
            this.fireTreeCleared(ChangeSupportTests.TREE_NAME);
        }

        public void testFireTreeChangedEvent() {
            this.fireTreeChanged(new TreeChangeEvent((Model)this, ChangeSupportTests.TREE_NAME, OBJECT_ARRAY_PATH));
        }

        public void testFireTreeChanged() {
            this.fireTreeChanged(ChangeSupportTests.TREE_NAME, OBJECT_ARRAY_PATH);
        }

        public boolean testAttributeValueHasChanged(Object value1, Object value2) {
            return this.attributeValueHasChanged(value1, value2);
        }

        public boolean testAttributeValueHasNotChanged(Object value1, Object value2) {
            return this.attributeValueHasNotChanged(value1, value2);
        }

        public TestModel clone() {
            try {
                return (TestModel)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public boolean testValuesAreDifferent(Object value1, Object value2) {
            return this.valuesAreDifferent(value1, value2);
        }

        public boolean testValuesAreEqual(Object value1, Object value2) {
            return this.valuesAreEqual(value1, value2);
        }

        public boolean testElementsAreDifferent(Iterator<?> iterator1, Iterator<?> iterator2) {
            return this.getChangeSupport().elementsAreDifferent(iterator1, iterator2);
        }

        public boolean testElementsAreEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
            return this.getChangeSupport().elementsAreEqual(iterator1, iterator2);
        }

        public void toString(StringBuilder sb) {
            sb.append(ChangeSupportTests.TEST_TO_STRING);
        }
    }
}

