/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.core.internal.platform.JpaPlatformRegistry;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ConnectionProfileFactory;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.DatabaseFinder;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaFacetDataModelProvider
extends FacetInstallDataModelProvider
implements JpaFacetDataModelProperties {
    private LibraryInstallDelegate defaultLibraryProvider;
    private ConnectionProfile connectionProfile;
    private static final String EJB_FACET_ID = "jst.ejb";
    private static final IStatus PLATFORM_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_PLATFORM_NOT_SPECIFIED);
    private static final IStatus CONNECTION_NOT_CONNECTED_STATUS = JpaFacetDataModelProvider.buildInfoStatus(JptCoreMessages.VALIDATE_CONNECTION_NOT_CONNECTED);
    private static final IStatus USER_OVERRIDE_DEFAULT_CATALOG_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_CATALOG_NOT_SPECIFIED);
    private static final IStatus USER_OVERRIDE_DEFAULT_SCHEMA_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_SCHEMA_NOT_SPECIFIED);
    private static final DataModelPropertyDescriptor[] EMPTY_DMPD_ARRAY = new DataModelPropertyDescriptor[0];

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("JpaFacetDataModelProperties.RUNTIME");
        propertyNames.add("JpaFacetDataModelProperties.PLATFORM_ID");
        propertyNames.add("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        propertyNames.add("JpaFacetDataModelProperties.CONNECTION");
        propertyNames.add("JpaFacetDataModelProperties.CONNECTION_ACTIVE");
        propertyNames.add("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH");
        propertyNames.add("JpaFacetDataModelProperties.DB_DRIVER_NAME");
        propertyNames.add("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG");
        propertyNames.add("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG");
        propertyNames.add("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA");
        propertyNames.add("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA");
        propertyNames.add("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
        propertyNames.add("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES");
        propertyNames.add("JpaFacetDataModelProperties.CREATE_ORM_XML");
        return propertyNames;
    }

    private String getPlatformId() {
        return (String)this.getProperty("JpaFacetDataModelProperties.PLATFORM_ID");
    }

    private String getConnectionName() {
        return (String)this.getProperty("JpaFacetDataModelProperties.CONNECTION");
    }

    private boolean userWantsToAddDbDriverJarsToClasspath() {
        return this.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH");
    }

    private String getDriverName() {
        return (String)this.getProperty("JpaFacetDataModelProperties.DB_DRIVER_NAME");
    }

    private boolean userWantsToOverrideDefaultCatalog() {
        return this.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG");
    }

    private String getUserOverrideDefaultCatalog() {
        return (String)this.getProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG");
    }

    private boolean userWantsToOverrideDefaultSchema() {
        return this.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA");
    }

    private String getUserOverrideDefaultSchema() {
        return (String)this.getProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA");
    }

    private boolean discoverAnnotatedClasses() {
        return this.getBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
    }

    private IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    private IProjectFacetVersion getProjectFacetVersion() {
        return (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
    }

    private IRuntime getRuntime() {
        return (IRuntime)this.getProperty("JpaFacetDataModelProperties.RUNTIME");
    }

    private LibraryInstallDelegate getLibraryInstallDelegate() {
        return (LibraryInstallDelegate)this.getProperty("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
            return this.getConnectionProfile() != null;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DB_DRIVER_NAME")) {
            return this.userWantsToAddDbDriverJarsToClasspath();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
            return this.connectionIsActive() && this.databaseSupportsCatalogs();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
            return this.userWantsToOverrideDefaultCatalog();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.connectionIsActive();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.userWantsToOverrideDefaultSchema();
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.RUNTIME")) {
            return null;
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jpt.jpa";
        }
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
            return JptCorePlugin.getDefaultJpaPlatformId();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE")) {
            return this.getDefaultLibraryProvider();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return null;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION_ACTIVE")) {
            return this.connectionIsActive();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DB_DRIVER_NAME")) {
            return this.getDefaultDriverName();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
            return this.getDefaultCatalogName();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.getDefaultSchemaName();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            return this.runtimeSupportsEjb30();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES")) {
            return !this.discoverAnnotatedClasses();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CREATE_ORM_XML")) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private LibraryInstallDelegate getDefaultLibraryProvider() {
        if (this.defaultLibraryProvider == null) {
            this.defaultLibraryProvider = this.buildDefaultLibraryProvider();
        }
        return this.defaultLibraryProvider;
    }

    private LibraryInstallDelegate buildDefaultLibraryProvider() {
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        if (fpjwc == null) {
            return null;
        }
        IProjectFacetVersion pfv = this.getProjectFacetVersion();
        if (pfv == null) {
            return null;
        }
        LibraryInstallDelegate lp = new LibraryInstallDelegate((IFacetedProjectBase)fpjwc, pfv, this.buildEnablementVariables());
        lp.addListener(this.buildLibraryProviderListener(), new String[0]);
        return lp;
    }

    private Map<String, Object> buildEnablementVariables() {
        HashMap<String, Object> enablementVariables = new HashMap<String, Object>();
        enablementVariables.put("jpaPlatform", this.getPlatformId());
        return enablementVariables;
    }

    private IPropertyChangeListener buildLibraryProviderListener() {
        return new IPropertyChangeListener(){

            public void propertyChanged(String property, Object oldValue, Object newValue) {
                JpaFacetDataModelProvider.this.getDataModel().notifyPropertyChange("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE", 1);
            }
        };
    }

    private String getDefaultDriverName() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp == null ? null : cp.getDriverName();
    }

    private String getDefaultCatalogName() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultCatalogIdentifier();
    }

    private String getDefaultSchemaName() {
        SchemaContainer sc = this.getSchemaContainer();
        return sc == null ? null : sc.getDefaultSchemaIdentifier();
    }

    private boolean runtimeSupportsEjb30() {
        IRuntime runtime = this.getRuntime();
        return runtime != null && runtime.supports(this.getEJB30());
    }

    private IProjectFacetVersion getEJB30() {
        return ProjectFacetsManager.getProjectFacet((String)EJB_FACET_ID).getVersion("3.0");
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (!propertyName.equals("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY")) {
            if (propertyName.equals("IFacetDataModelPropeties.FACET_VERSION")) {
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE", 2);
            } else if (propertyName.equals("JpaFacetDataModelProperties.RUNTIME")) {
                LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
                if (lid != null) {
                    lid.refresh();
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES", 2);
            } else if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
                LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
                if (lid != null) {
                    lid.setEnablementContextVariable("jpaPlatform", propertyValue);
                }
            } else if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
                this.setBooleanProperty("JpaFacetDataModelProperties.CONNECTION_ACTIVE", this.connectionIsActive());
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.CONNECTION", 4);
                if (propertyValue == null) {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH", false);
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_NAME", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_NAME", 4);
                if (propertyValue != null && this.databaseSupportsCatalogs()) {
                    this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", this.getDefaultCatalogName());
                } else {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", false);
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 4);
                if (propertyValue == null) {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", false);
                } else {
                    this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", this.getDefaultSchemaName());
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 4);
            } else if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION_ACTIVE")) {
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", false);
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 4);
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", false);
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 4);
            } else if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_NAME", 3);
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setProperty("JpaFacetDataModelProperties.DB_DRIVER_NAME", null);
                }
            } else if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 3);
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", null);
                }
            } else if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
                this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", this.getDefaultSchemaName());
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 4);
            } else if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 3);
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", null);
                }
            } else if (propertyName.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
                this.setBooleanProperty("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES", this.propertyValueIsFalse(propertyValue));
            } else if (propertyName.equals("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES")) {
                this.setBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", this.propertyValueIsFalse(propertyValue));
            }
        }
        return ok;
    }

    private boolean propertyValueIsFalse(Object propertyValue) {
        return !this.propertyValueIsTrue(propertyValue);
    }

    private boolean propertyValueIsTrue(Object propertyValue) {
        return (Boolean)propertyValue;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
            return this.buildValidPlatformDescriptors();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.buildValidConnectionDescriptors();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DB_DRIVER_NAME")) {
            return this.buildValidDriverDescriptors();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
            return this.buildValidCatalogDescriptors();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.buildValidSchemaDescriptors();
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    private DataModelPropertyDescriptor[] buildValidPlatformDescriptors() {
        ArrayList platformIDs = CollectionTools.list(JpaPlatformRegistry.instance().jpaPlatformIds());
        Object[] descriptors = new DataModelPropertyDescriptor[platformIDs.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = this.buildPlatformIdDescriptor((String)platformIDs.get(i));
            ++i;
        }
        return (DataModelPropertyDescriptor[])CollectionTools.sort((Object[])descriptors, this.buildDescriptorComparator());
    }

    private Comparator<DataModelPropertyDescriptor> buildDescriptorComparator() {
        return new Comparator<DataModelPropertyDescriptor>(){

            @Override
            public int compare(DataModelPropertyDescriptor o1, DataModelPropertyDescriptor o2) {
                return o1.getPropertyDescription().compareTo(o2.getPropertyDescription());
            }
        };
    }

    private DataModelPropertyDescriptor[] buildValidConnectionDescriptors() {
        List<String> connectionNames = this.buildValidConnectionNames();
        DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[connectionNames.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = this.buildConnectionDescriptor(connectionNames.get(i));
            ++i;
        }
        return descriptors;
    }

    private List<String> buildValidConnectionNames() {
        List connectionNames = CollectionTools.sort((List)CollectionTools.list(this.connectionProfileNames()));
        connectionNames.add(0, null);
        return connectionNames;
    }

    private DataModelPropertyDescriptor[] buildValidDriverDescriptors() {
        return new DataModelPropertyDescriptor[]{new DataModelPropertyDescriptor((Object)this.getDriverName())};
    }

    private DataModelPropertyDescriptor[] buildValidCatalogDescriptors() {
        Database db = this.getDatabase();
        return db == null ? EMPTY_DMPD_ARRAY : this.buildDescriptors(this.buildValidCatalogNames(db));
    }

    private List<String> buildValidCatalogNames(Database db) {
        return this.buildValidStrings(db.sortedCatalogIdentifiers(), this.getDefaultCatalogName());
    }

    private DataModelPropertyDescriptor[] buildValidSchemaDescriptors() {
        Database db = this.getDatabase();
        return db == null ? EMPTY_DMPD_ARRAY : this.buildDescriptors(this.buildValidSchemaNames());
    }

    private List<String> buildValidSchemaNames() {
        return this.buildValidStrings(this.schemaNames(), this.getDefaultSchemaName());
    }

    private Iterator<String> schemaNames() {
        SchemaContainer sc = this.getSchemaContainer();
        return sc == null ? EmptyIterator.instance() : sc.sortedSchemaIdentifiers();
    }

    private List<String> buildValidStrings(Iterator<String> stream, String defaultString) {
        ArrayList strings = CollectionTools.list(stream);
        if (defaultString != null && !strings.contains(defaultString)) {
            strings.add(0, defaultString);
        }
        return strings;
    }

    private DataModelPropertyDescriptor[] buildDescriptors(List<String> strings) {
        DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[strings.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = new DataModelPropertyDescriptor((Object)strings.get(i));
            ++i;
        }
        return descriptors;
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
            return this.buildPlatformIdDescriptor(this.getPlatformId());
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.buildConnectionDescriptor(this.getConnectionName());
        }
        return super.getPropertyDescriptor(propertyName);
    }

    DataModelPropertyDescriptor buildPlatformIdDescriptor(String platformId) {
        return new DataModelPropertyDescriptor((Object)platformId, this.getPlatformLabel(platformId));
    }

    private String getPlatformLabel(String platformId) {
        return JpaPlatformRegistry.instance().getJpaPlatformLabel(platformId);
    }

    private DataModelPropertyDescriptor buildConnectionDescriptor(String connectionName) {
        String description = connectionName == null ? JptCoreMessages.NONE : null;
        return new DataModelPropertyDescriptor((Object)connectionName, description);
    }

    private SchemaContainer getSchemaContainer() {
        return this.databaseSupportsCatalogs() ? this.getCatalog() : this.getDatabase();
    }

    private Catalog getCatalog() {
        String name = this.getUserOverrideDefaultCatalog();
        return name == null ? null : this.getCatalog(name);
    }

    private Catalog getCatalog(String name) {
        Database db = this.getDatabase();
        return db == null ? null : db.getCatalogForIdentifier(name);
    }

    private boolean databaseSupportsCatalogs() {
        Database db = this.getDatabase();
        return db != null && db.supportsCatalogs();
    }

    private Database getDatabase() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp == null ? null : cp.getDatabase();
    }

    private boolean connectionIsActive() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp != null && cp.isActive();
    }

    private ConnectionProfile getConnectionProfile() {
        String name = this.getConnectionName();
        return name == null ? null : this.getConnectionProfile(name);
    }

    private ConnectionProfile getConnectionProfile(String name) {
        if (this.cachedConnectionProfileIsStale(name)) {
            this.connectionProfile = this.buildConnectionProfile(name);
        }
        return this.connectionProfile;
    }

    private boolean cachedConnectionProfileIsStale(String name) {
        return this.connectionProfile == null || !this.connectionProfile.getName().equals(name);
    }

    private ConnectionProfile buildConnectionProfile(String name) {
        return this.getConnectionProfileFactory().buildConnectionProfile(name, DatabaseFinder.Default.instance());
    }

    private Iterator<String> connectionProfileNames() {
        return this.getConnectionProfileFactory().connectionProfileNames();
    }

    private ConnectionProfileFactory getConnectionProfileFactory() {
        return JptDbPlugin.instance().getConnectionProfileFactory();
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
            return this.validatePlatformId();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE")) {
            return this.getLibraryInstallDelegate().validate();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.validateConnection();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH") || propertyName.equals("JpaFacetDataModelProperties.DB_DRIVER_NAME")) {
            return this.validateDbDriverName();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG") || propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
            return this.validateUserOverrideDefaultCatalog();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA") || propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.validateUserOverrideDefaultSchema();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            return this.validatePersistentClassManagement();
        }
        return super.validate(propertyName);
    }

    private IStatus validatePlatformId() {
        return this.getPlatformId() == null ? PLATFORM_NOT_SPECIFIED_STATUS : OK_STATUS;
    }

    private IStatus validateConnection() {
        String connectionName = this.getConnectionName();
        return connectionName == null ? OK_STATUS : this.validateNonNullConnection(connectionName);
    }

    private IStatus validateNonNullConnection(String connectionName) {
        ConnectionProfile cp = this.getConnectionProfile(connectionName);
        if (cp == null) {
            return JpaFacetDataModelProvider.buildErrorStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_INVALID, (Object)connectionName));
        }
        if (!cp.isActive()) {
            return CONNECTION_NOT_CONNECTED_STATUS;
        }
        return OK_STATUS;
    }

    private IStatus validateDbDriverName() {
        return OK_STATUS;
    }

    private IStatus validateUserOverrideDefaultCatalog() {
        if (this.userWantsToOverrideDefaultCatalog() && this.getUserOverrideDefaultCatalog() == null) {
            return USER_OVERRIDE_DEFAULT_CATALOG_NOT_SPECIFIED_STATUS;
        }
        return OK_STATUS;
    }

    private IStatus validateUserOverrideDefaultSchema() {
        if (this.userWantsToOverrideDefaultSchema() && this.getUserOverrideDefaultSchema() == null) {
            return USER_OVERRIDE_DEFAULT_SCHEMA_NOT_SPECIFIED_STATUS;
        }
        return OK_STATUS;
    }

    private IStatus validatePersistentClassManagement() {
        this.discoverAnnotatedClasses();
        return OK_STATUS;
    }

    private static IStatus buildInfoStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(1, message);
    }

    private static IStatus buildErrorStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(4, message);
    }

    private static IStatus buildStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.jpt.core", message);
    }
}

