/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationContainerTools {
    public static <T extends NestableAnnotation> NestableAnnotation addNestedAnnotation(int index, AnnotationContainer<T> annotationContainer) {
        int sourceIndex = annotationContainer.nestedAnnotationsSize();
        T nestedAnnotation = annotationContainer.addNestedAnnotationInternal();
        nestedAnnotation.newAnnotation();
        annotationContainer.moveNestedAnnotationInternal(index, sourceIndex);
        AnnotationContainerTools.synchJavaAnnotationsAfterMove(index, sourceIndex, annotationContainer, nestedAnnotation);
        annotationContainer.nestedAnnotationAdded(index, nestedAnnotation);
        return nestedAnnotation;
    }

    public static <T extends NestableAnnotation> void moveNestedAnnotation(int targetIndex, int sourceIndex, AnnotationContainer<T> annotationContainer) {
        T nestedAnnotation = annotationContainer.moveNestedAnnotationInternal(targetIndex, sourceIndex);
        AnnotationContainerTools.synchJavaAnnotationsAfterMove(targetIndex, sourceIndex, annotationContainer, nestedAnnotation);
        annotationContainer.nestedAnnotationMoved(targetIndex, sourceIndex);
    }

    private static <T extends NestableAnnotation> void synchJavaAnnotationsAfterMove(int targetIndex, int sourceIndex, AnnotationContainer<T> annotationContainer, NestableAnnotation nestedAnnotationAnnotation) {
        nestedAnnotationAnnotation.moveAnnotation(annotationContainer.nestedAnnotationsSize());
        ArrayList nestableAnnotations = CollectionTools.list(annotationContainer.nestedAnnotations());
        if (sourceIndex < targetIndex) {
            int i = sourceIndex;
            while (i < targetIndex) {
                ((NestableAnnotation)nestableAnnotations.get(i)).moveAnnotation(i);
                ++i;
            }
        } else {
            int i = sourceIndex;
            while (i > targetIndex) {
                ((NestableAnnotation)nestableAnnotations.get(i)).moveAnnotation(i);
                --i;
            }
        }
        nestedAnnotationAnnotation.moveAnnotation(targetIndex);
    }

    public static <T extends NestableAnnotation> void removeNestedAnnotation(int index, AnnotationContainer<T> annotationContainer) {
        T nestedAnnotation = annotationContainer.removeNestedAnnotationInternal(index);
        nestedAnnotation.removeAnnotation();
        AnnotationContainerTools.synchJavaAnnotationsAfterRemove(index, annotationContainer);
        annotationContainer.nestedAnnotationRemoved(index, nestedAnnotation);
    }

    private static <T extends NestableAnnotation> void synchJavaAnnotationsAfterRemove(int index, AnnotationContainer<T> annotationContainer) {
        ArrayList nestableAnnotations = CollectionTools.list(annotationContainer.nestedAnnotations());
        int i = index;
        while (i < nestableAnnotations.size()) {
            ((NestableAnnotation)nestableAnnotations.get(i)).moveAnnotation(i);
            ++i;
        }
    }

    public static <T extends NestableAnnotation> void initialize(AnnotationContainer<T> annotationContainer, CompilationUnit astRoot) {
        int size = AnnotationContainerTools.getNestedJdtAnnotations(astRoot, annotationContainer).size();
        int i = 0;
        while (i < size) {
            T nestedAnnotation = annotationContainer.addNestedAnnotationInternal();
            nestedAnnotation.initialize(astRoot);
            ++i;
        }
    }

    private static <T extends NestableAnnotation> ArrayList<Annotation> getNestedJdtAnnotations(CompilationUnit astRoot, AnnotationContainer<T> annotationContainer) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Annotation containerJdtAnnotation = annotationContainer.getContainerJdtAnnotation(astRoot);
        if (!containerJdtAnnotation.isMarkerAnnotation()) {
            MemberValuePair pair;
            if (containerJdtAnnotation.isSingleMemberAnnotation()) {
                if (annotationContainer.getElementName().equals("value")) {
                    Expression ex = ((SingleMemberAnnotation)containerJdtAnnotation).getValue();
                    AnnotationContainerTools.addJdtAnnotationsTo(ex, annotationContainer.getNestableAnnotationName(), result);
                }
            } else if (containerJdtAnnotation.isNormalAnnotation() && (pair = AnnotationContainerTools.getMemberValuePair((NormalAnnotation)containerJdtAnnotation, annotationContainer.getElementName())) != null) {
                AnnotationContainerTools.addJdtAnnotationsTo(pair.getValue(), annotationContainer.getNestableAnnotationName(), result);
            }
        }
        return result;
    }

    private static void addJdtAnnotationsTo(Expression expression, String annotationName, ArrayList<Annotation> jdtAnnotations) {
        if (expression == null) {
            jdtAnnotations.add(null);
        } else if (expression.getNodeType() == 4) {
            AnnotationContainerTools.addJdtAnnotationsTo((ArrayInitializer)expression, annotationName, jdtAnnotations);
        } else {
            jdtAnnotations.add(AnnotationContainerTools.getJdtAnnotation_(expression, annotationName));
        }
    }

    private static void addJdtAnnotationsTo(ArrayInitializer arrayInitializer, String annotationName, ArrayList<Annotation> jdtAnnotations) {
        List expressions = arrayInitializer.expressions();
        for (Expression expression : expressions) {
            jdtAnnotations.add(AnnotationContainerTools.getJdtAnnotation(expression, annotationName));
        }
    }

    private static Annotation getJdtAnnotation(Expression expression, String annotationName) {
        return expression == null ? null : AnnotationContainerTools.getJdtAnnotation_(expression, annotationName);
    }

    private static Annotation getJdtAnnotation_(Expression expression, String annotationName) {
        switch (expression.getNodeType()) {
            case 77: 
            case 78: 
            case 79: {
                Annotation jdtAnnotation = (Annotation)expression;
                if (AnnotationContainerTools.getQualifiedName(jdtAnnotation).equals(annotationName)) {
                    return jdtAnnotation;
                }
                return null;
            }
        }
        return null;
    }

    private static String getQualifiedName(Annotation jdtAnnotation) {
        String resolvedName;
        ITypeBinding typeBinding = jdtAnnotation.resolveTypeBinding();
        if (typeBinding != null && (resolvedName = typeBinding.getQualifiedName()) != null) {
            return resolvedName;
        }
        return jdtAnnotation.getTypeName().getFullyQualifiedName();
    }

    private static MemberValuePair getMemberValuePair(NormalAnnotation annotation, String elementName) {
        List pairs = annotation.values();
        for (MemberValuePair pair : pairs) {
            if (!pair.getName().getFullyQualifiedName().equals(elementName)) continue;
            return pair;
        }
        return null;
    }

    public static <T extends NestableAnnotation> void update(AnnotationContainer<T> annotationContainer, CompilationUnit astRoot) {
        NestableAnnotation nestedAnnotation;
        ListIterator<Annotation> jdtAnnotations = AnnotationContainerTools.getNestedJdtAnnotations(astRoot, annotationContainer).listIterator();
        ListIterator<T> nestedAnnotations = annotationContainer.nestedAnnotations();
        while (nestedAnnotations.hasNext()) {
            nestedAnnotation = (NestableAnnotation)nestedAnnotations.next();
            if (jdtAnnotations.hasNext()) {
                jdtAnnotations.next();
                nestedAnnotation.update(astRoot);
                continue;
            }
            int last = annotationContainer.nestedAnnotationsSize() - 1;
            T remove = annotationContainer.removeNestedAnnotationInternal(last);
            annotationContainer.nestedAnnotationRemoved(last, (NestableAnnotation)remove);
        }
        int i = annotationContainer.nestedAnnotationsSize();
        while (jdtAnnotations.hasNext()) {
            jdtAnnotations.next();
            nestedAnnotation = annotationContainer.addNestedAnnotationInternal();
            nestedAnnotation.initialize(astRoot);
            annotationContainer.nestedAnnotationAdded(i++, nestedAnnotation);
        }
    }

    private AnnotationContainerTools() {
        throw new UnsupportedOperationException();
    }
}

