/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringCollectionValueModel<E>
extends CollectionValueModelWrapper<E>
implements CollectionValueModel<E> {
    private Filter<E> filter;
    private final Collection<E> filteredItems;

    public FilteringCollectionValueModel(CollectionValueModel<? extends E> collectionHolder) {
        this(collectionHolder, Filter.Null.instance());
    }

    public FilteringCollectionValueModel(CollectionValueModel<? extends E> collectionHolder, Filter<E> filter) {
        super(collectionHolder);
        this.filter = filter;
        this.filteredItems = new ArrayList();
    }

    public FilteringCollectionValueModel(ListValueModel<E> listHolder) {
        this(new ListCollectionValueModelAdapter<E>(listHolder));
    }

    public FilteringCollectionValueModel(ListValueModel<E> listHolder, Filter<E> filter) {
        this(new ListCollectionValueModelAdapter<E>(listHolder), filter);
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.filteredItems);
    }

    @Override
    public int size() {
        return this.filteredItems.size();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionHolder.iterator()));
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.filteredItems.clear();
    }

    @Override
    protected void itemsAdded(CollectionChangeEvent event) {
        this.addItemsToCollection(this.filter(this.items(event)), this.filteredItems, "values");
    }

    @Override
    protected void itemsRemoved(CollectionChangeEvent event) {
        this.removeItemsFromCollection(event.items(), this.filteredItems, "values");
    }

    @Override
    protected void collectionCleared(CollectionChangeEvent event) {
        this.clearCollection(this.filteredItems, "values");
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.rebuildFilteredItems();
    }

    public void setFilter(Filter<E> filter) {
        this.filter = filter;
        this.rebuildFilteredItems();
    }

    protected Iterator<E> filter(Iterator<? extends E> items) {
        return new FilteringIterator(items, this.filter);
    }

    protected void rebuildFilteredItems() {
        this.filteredItems.clear();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionHolder.iterator()));
        this.fireCollectionChanged("values");
    }
}

