/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListValueModelWrapper<E>
extends AbstractModel {
    protected final ListValueModel<? extends E> listHolder;
    protected final ListChangeListener listChangeListener;

    protected ListValueModelWrapper(ListValueModel<? extends E> listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.listChangeListener = this.buildListChangeListener();
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, ListChangeListener.class, "list values");
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                ListValueModelWrapper.this.itemsAdded(event);
            }

            public void itemsRemoved(ListChangeEvent event) {
                ListValueModelWrapper.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListChangeEvent event) {
                ListValueModelWrapper.this.itemsReplaced(event);
            }

            public void itemsMoved(ListChangeEvent event) {
                ListValueModelWrapper.this.itemsMoved(event);
            }

            public void listCleared(ListChangeEvent event) {
                ListValueModelWrapper.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListValueModelWrapper.this.listChanged(event);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    @Override
    public synchronized void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoListChangeListeners("list values")) {
            this.engageModel();
        }
        super.addListChangeListener(listener);
    }

    @Override
    public synchronized void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName == "list values" && this.hasNoListChangeListeners("list values")) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    @Override
    public synchronized void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoListChangeListeners("list values")) {
            this.disengageModel();
        }
    }

    @Override
    public synchronized void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName == "list values" && this.hasNoListChangeListeners("list values")) {
            this.disengageModel();
        }
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.listHolder);
    }

    protected ListIterator<E> items(ListChangeEvent event) {
        return event.items();
    }

    protected ListIterator<E> replacedItems(ListChangeEvent event) {
        return event.replacedItems();
    }

    protected abstract void itemsAdded(ListChangeEvent var1);

    protected abstract void itemsRemoved(ListChangeEvent var1);

    protected abstract void itemsReplaced(ListChangeEvent var1);

    protected abstract void itemsMoved(ListChangeEvent var1);

    protected abstract void listCleared(ListChangeEvent var1);

    protected abstract void listChanged(ListChangeEvent var1);
}

