/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleButtonModelAdapter
extends JToggleButton.ToggleButtonModel {
    protected final boolean defaultValue;
    protected final WritablePropertyValueModel<Boolean> booleanHolder;
    protected final PropertyChangeListener booleanChangeListener;

    public ToggleButtonModelAdapter(WritablePropertyValueModel<Boolean> booleanHolder, boolean defaultValue) {
        if (booleanHolder == null) {
            throw new NullPointerException();
        }
        this.booleanHolder = booleanHolder;
        this.booleanChangeListener = this.buildBooleanChangeListener();
        this.defaultValue = defaultValue;
    }

    public ToggleButtonModelAdapter(WritablePropertyValueModel<Boolean> booleanHolder) {
        this(booleanHolder, false);
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildBooleanChangeListener_());
    }

    protected PropertyChangeListener buildBooleanChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                ToggleButtonModelAdapter.this.booleanChanged(event);
            }

            public String toString() {
                return "boolean listener";
            }
        };
    }

    @Override
    public void setSelected(boolean b) {
        if (this.isSelected() != b) {
            super.setSelected(b);
            this.booleanHolder.setValue(b);
        }
    }

    @Override
    public void addActionListener(ActionListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addItemListener(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        super.removeItemListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        super.removeChangeListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasNoListeners() {
        return this.listenerList.getListenerCount() == 0;
    }

    protected boolean getDefaultValue() {
        return this.defaultValue;
    }

    protected void setSelected(Boolean value) {
        if (value == null) {
            this.setSelected(this.getDefaultValue());
        } else {
            this.setSelected((boolean)value);
        }
    }

    protected void booleanChanged(PropertyChangeEvent event) {
        this.setSelected((Boolean)event.getNewValue());
    }

    protected void engageModel() {
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.setSelected((Boolean)this.booleanHolder.getValue());
    }

    protected void disengageModel() {
        this.booleanHolder.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.booleanHolder);
    }
}

