/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.internal.deployables;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class JEEFlexProjDeployable
extends J2EEFlexProjDeployable {
    public JEEFlexProjDeployable(IProject project, IVirtualComponent aComponent) {
        super(project, aComponent);
    }

    public JEEFlexProjDeployable(IProject project) {
        super(project);
    }

    protected boolean shouldIncludeUtilityComponent(IVirtualComponent virtualComp, IVirtualReference[] references, IEARModelProvider model) {
        if (JavaEEProjectUtilities.isEARProject((IProject)this.component.getProject())) {
            return virtualComp != null && virtualComp.isBinary() && !this.isNestedJ2EEModule(virtualComp, references, model);
        }
        return super.shouldIncludeUtilityComponent(virtualComp, references, ArtifactEdit.class.isInstance(model) ? (ArtifactEdit)model : null);
    }

    public String getJNDIName(String ejbName, String interfaceName) {
        if (!JavaEEProjectUtilities.isEJBProject((IProject)this.component.getProject())) {
            return null;
        }
        EjbModuleExtensionHelper modHelper = null;
        EJBJar jar = null;
        IModelProvider model = ModelProviderManager.getModelProvider((IProject)this.component.getProject());
        if (model != null) {
            jar = (EJBJar)model.getModelObject();
            SessionBean bean = this.getSessionBeanNamed(jar, ejbName);
            modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
            return modHelper == null ? null : modHelper.getJavaEEJNDIName(jar, bean, interfaceName);
        }
        return null;
    }

    public SessionBean getSessionBeanNamed(EJBJar jar, String beanName) {
        EnterpriseBeans allBeans = jar.getEnterpriseBeans();
        for (SessionBean bean : allBeans.getSessionBeans()) {
            if (!bean.getEjbName().equals(beanName)) continue;
            return bean;
        }
        return null;
    }

    protected IModule gatherModuleReference(IVirtualComponent component, IVirtualComponent targetComponent) {
        IModule module = super.gatherModuleReference(component, targetComponent);
        if (targetComponent instanceof J2EEModuleVirtualArchiveComponent && (JavaEEProjectUtilities.isEARProject((IProject)component.getProject()) || targetComponent.getProject() != component.getProject())) {
            module = ServerUtil.getModule((String)("org.eclipse.jst.jee.server:" + targetComponent.getName()));
        }
        return module;
    }

    protected boolean shouldIncludeUtilityComponent(IVirtualComponent virtualComp, IVirtualReference[] references, ArtifactEdit edit) {
        if (edit instanceof IEARModelProvider && JavaEEProjectUtilities.isEARProject((IProject)this.component.getProject())) {
            return virtualComp != null && virtualComp.isBinary() && !this.isNestedJ2EEModule(virtualComp, references, (IEARModelProvider)edit);
        }
        return super.shouldIncludeUtilityComponent(virtualComp, references, edit);
    }

    private boolean isNestedJ2EEModule(IVirtualComponent aComponent, IVirtualReference[] references, IEARModelProvider model) {
        boolean knownType;
        if (model == null) {
            return false;
        }
        int version = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IVirtualComponent)aComponent).getJavaEEVersion();
        boolean bl = knownType = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IVirtualComponent)aComponent).getType() != -1;
        return version >= 50 && knownType;
    }
}

