/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodelimpl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Stack;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMSelector;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfileRegistry;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMMCategoryImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMMFunctionImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMMKeywordImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMMNodeImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMMPseudoClassImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMMPseudoElementImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMMUnitImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMetaModelImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.NodePool;
import org.eclipse.wst.css.core.internal.metamodelimpl.ProfileLoader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ProfileHandler
extends DefaultHandler {
    private CSSMetaModelImpl fMetaModel = null;
    private NodePool fNodePool = null;
    private Stack fNodeStack = new Stack();
    boolean fLogging = false;
    private ResourceBundle fResourceBundle = null;
    private static final String ATTR_NAME_DEFINITION = "name";
    private static final String ATTR_NAME_REFERENCE = "name";
    private static final String ATTR_OVERWRITE = "overwrite";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_VALUE_OVERWRITE_FALSE = "false";
    private static final String ATTR_VALUE_ENABLED_FALSE = "false";

    public ProfileHandler(CSSMetaModelImpl metamodel, ResourceBundle resourceBundle, boolean logging) {
        this.fMetaModel = metamodel;
        this.fNodePool = metamodel.getNodePool();
        this.fResourceBundle = resourceBundle;
        this.fLogging = logging;
    }

    public ProfileHandler(CSSMetaModelImpl metamodel, ResourceBundle resourceBundle) {
        this.fMetaModel = metamodel;
        this.fNodePool = metamodel.getNodePool();
        this.fResourceBundle = resourceBundle;
        this.fLogging = false;
    }

    private String getResourceString(String key) {
        if (key.equals("%")) {
            return key;
        }
        if (!key.startsWith("%")) {
            return key;
        }
        if (key.startsWith("%%")) {
            return key.substring(1);
        }
        if (this.fResourceBundle != null) {
            return this.fResourceBundle.getString(key.substring(1));
        }
        return key;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        new ErrorCorrector().doCorrect(this.fMetaModel);
        if (this.fLogging) {
            Iterator i = this.fNodePool.getStrayNodes();
            while (i.hasNext()) {
                CSSMMNode node = (CSSMMNode)i.next();
                String str = "[CSSProfile Warning] " + node.getName();
                str = String.valueOf(str) + "(" + node.getType() + ") is not referred by any node.";
                Logger.log(2, str);
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String nodeName;
        TagNode tagNode = null;
        CSSMMNodeImpl parentNode = null;
        if (this.fNodeStack.size() > 0) {
            tagNode = (TagNode)this.fNodeStack.peek();
            parentNode = tagNode.node;
        }
        CSSMMNodeImpl node = null;
        if (qName.equals("profile-import")) {
            String profileName = attributes.getValue("name");
            this.importProfile(profileName);
        } else if (this.isDefinition(qName)) {
            nodeName = attributes.getValue("name");
            node = this.fNodePool.getNode(qName, nodeName);
            if (node != null) {
                String overwrite = attributes.getValue(ATTR_OVERWRITE);
                if (overwrite == null || overwrite.equals("false")) {
                    node.removeAllChildNodes();
                }
                HashMap<String, String> attrMap = new HashMap<String, String>();
                int i = 0;
                while (i < attributes.getLength()) {
                    attrMap.put(attributes.getQName(i), attributes.getValue(i));
                    ++i;
                }
                try {
                    node.initializeAttribute(attrMap);
                }
                catch (IllegalArgumentException e) {
                    Logger.logException(e);
                }
            }
        } else if (node == null) {
            nodeName = attributes.getValue("name");
            node = this.fNodePool.getNode(qName, nodeName);
        }
        if (node != null) {
            if (parentNode != null && parentNode.canContain(node)) {
                String enabled = attributes.getValue(ATTR_ENABLED);
                if (enabled != null && enabled.equals("false")) {
                    parentNode.removeChild(node);
                } else {
                    parentNode.appendChild(node);
                }
            } else if (node.getType() == "CSSMM.StyleSheet" || node.getType() == "CSSMM.Category") {
                this.fMetaModel.appendChild(node);
            } else if (this.fLogging && parentNode != null) {
                Logger.log(4, String.valueOf(parentNode.getType()) + " cannot contain " + node.getType() + " (" + qName + ")");
            }
        }
        this.fNodeStack.push(new TagNode(qName, node != null ? node : parentNode));
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.fNodeStack.pop();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        TagNode tagNode = (TagNode)this.fNodeStack.peek();
        String tagName = tagNode.tag;
        if (tagName.equals("keyword-value") || tagName.equals("unit-value") || tagName.equals("function-value") || tagName.equals("selector-value") || tagName.equals("description") || tagName.equals("caption")) {
            StringBuffer buf = new StringBuffer(length);
            int i = 0;
            while (i < length) {
                buf.append(ch[start + i]);
                ++i;
            }
            String value = this.getResourceString(buf.toString().trim());
            CSSMMNodeImpl node = tagNode.node;
            if (node != null) {
                if (node.getType() == "CSSMM.Keyword" && tagName.equals("keyword-value")) {
                    ((CSSMMKeywordImpl)node).setKeywordString(value);
                } else if (node.getType() == "CSSMM.Unit" && tagName.equals("unit-value")) {
                    ((CSSMMUnitImpl)node).setUnitString(value);
                } else if (node.getType() == "CSSMM.Function" && tagName.equals("function-value")) {
                    ((CSSMMFunctionImpl)node).setFunctionString(value);
                } else if (node.getType() == "CSSMM.Selector" && ((CSSMMSelector)((Object)node)).getSelectorType() == "PseudoElement") {
                    ((CSSMMPseudoElementImpl)node).setSelectorString(value);
                } else if (node.getType() == "CSSMM.Selector" && ((CSSMMSelector)((Object)node)).getSelectorType() == "PseudoClass") {
                    ((CSSMMPseudoClassImpl)node).setSelectorString(value);
                } else if (node.getType() == "CSSMM.Category" && tagName.equals("caption")) {
                    ((CSSMMCategoryImpl)node).setCaption(value);
                } else if (tagName.equals("description")) {
                    node.setDescription(value);
                }
            }
        }
    }

    private boolean isDefinition(String tagName) {
        return tagName.equals("stylesheet-def") || tagName.equals("charset-rule-def") || tagName.equals("import-rule-def") || tagName.equals("page-rule-def") || tagName.equals("media-rule-def") || tagName.equals("fontface-rule-def") || tagName.equals("style-rule-def") || tagName.equals("keyword-def") || tagName.equals("number-def") || tagName.equals("property-def") || tagName.equals("descriptor-def") || tagName.equals("container-def") || tagName.equals("unit-def") || tagName.equals("function-def") || tagName.equals("string") || tagName.equals("category-def") || tagName.equals("pseudo-class-def") || tagName.equals("pseudo-element-def") || tagName.equals("selector-expression") || tagName.equals("separator");
    }

    private void importProfile(String profileName) {
        URL profileURL = null;
        CSSProfileRegistry reg = CSSProfileRegistry.getInstance();
        CSSProfile profile = reg.getProfile(profileName);
        if (profile != null) {
            profileURL = profile.getProfileURL();
        } else {
            Iterator i = reg.getProfiles();
            while (i.hasNext()) {
                profile = (CSSProfile)i.next();
                URL url = profile.getProfileURL();
                if (!url.getFile().endsWith(profileName)) continue;
                profileURL = url;
                break;
            }
        }
        if (profileURL == null) {
            try {
                profileURL = new URL(profileName);
            }
            catch (MalformedURLException e) {
                Logger.logException(e);
            }
        }
        if (profileURL != null) {
            try {
                ProfileLoader.loadProfile(this.fMetaModel, profileURL.openStream(), this.fResourceBundle, this.fLogging);
            }
            catch (IOException e) {
                Logger.logException("Cannot open stream for profile", e);
            }
        }
    }

    class ErrorCorrector {
        ErrorCorrector() {
        }

        void doCorrect(CSSMMNodeImpl node) {
            Iterator i = node.getChildNodes();
            ArrayList<CSSMMNodeImpl> errorNodes = new ArrayList<CSSMMNodeImpl>();
            while (i.hasNext()) {
                CSSMMNodeImpl child = (CSSMMNodeImpl)i.next();
                this.doCorrect(child);
                short error = child.getError();
                if (error == 0) continue;
                errorNodes.add(child);
                String str = "[CSSProfile Error] " + node.getName();
                str = String.valueOf(str) + "(" + node.getType() + ") contains error node: ";
                str = String.valueOf(str) + child.getName() + "(" + child.getType() + ")";
                str = String.valueOf(str) + " - error code = " + error;
                if (!ProfileHandler.this.fLogging) continue;
                Logger.log(4, str);
            }
            int errorSize = errorNodes.size();
            if (errorSize > 0) {
                int j = 0;
                while (j < errorSize) {
                    CSSMMNodeImpl errorNode = (CSSMMNodeImpl)errorNodes.get(j);
                    node.removeChild(errorNode);
                    ++j;
                }
            }
        }
    }

    class TagNode {
        String tag = null;
        CSSMMNodeImpl node = null;

        TagNode(String tag, CSSMMNodeImpl node) {
            this.tag = tag;
            this.node = node;
        }
    }
}

