/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadNavigationRuleTestCase
extends BaseReadTestCase {
    public ReadNavigationRuleTestCase(String name) {
        super(name);
    }

    public void testSingleNavigationRule() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadNavigationRuleTestCase.assertNotNull((Object)edit.getFacesConfig());
            EList navRules = edit.getFacesConfig().getNavigationRule();
            ReadNavigationRuleTestCase.assertTrue((!navRules.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadNavigationRuleTestCase.assertNotNull((Object)edit);
            EList navRules = edit.getFacesConfig().getNavigationRule();
            ReadNavigationRuleTestCase.assertTrue((!navRules.isEmpty() ? 1 : 0) != 0);
            NavigationRuleType navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDisplayName((List)navRules, "display name 1");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDescriptionText((List)navRules, "A navigation rule with lang attributes");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            DisplayNameType displayNameType = FacesConfigModelUtil.findDisplayNameType((List)navRule.getDisplayName(), "English Display Name");
            ReadNavigationRuleTestCase.assertNotNull((Object)displayNameType);
            ReadNavigationRuleTestCase.assertEquals((String)"en", (String)displayNameType.getLang());
            displayNameType = FacesConfigModelUtil.findDisplayNameType((List)navRule.getDisplayName(), "Nom D'Affichage De Fran\u00e7ais");
            ReadNavigationRuleTestCase.assertNotNull((Object)displayNameType);
            ReadNavigationRuleTestCase.assertEquals((String)"fr", (String)displayNameType.getLang());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testNonEmptyDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadNavigationRuleTestCase.assertNotNull((Object)edit);
            EList navRules = edit.getFacesConfig().getNavigationRule();
            ReadNavigationRuleTestCase.assertTrue((!navRules.isEmpty() ? 1 : 0) != 0);
            NavigationRuleType navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDescriptionText((List)navRules, "Descri 1");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDescriptionText((List)navRules, "A navigation rule with lang attributes");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            DescriptionType descType = FacesConfigModelUtil.findDescriptionType((List)navRule.getDescription(), "A navigation rule with lang attributes");
            ReadNavigationRuleTestCase.assertNotNull((Object)descType);
            ReadNavigationRuleTestCase.assertEquals((String)"en", (String)descType.getLang());
            descType = FacesConfigModelUtil.findDescriptionType((List)navRule.getDescription(), "What color is it?");
            ReadNavigationRuleTestCase.assertNotNull((Object)descType);
            ReadNavigationRuleTestCase.assertEquals((String)"en-US", (String)descType.getLang());
            descType = FacesConfigModelUtil.findDescriptionType((List)navRule.getDescription(), "What colour is it?");
            ReadNavigationRuleTestCase.assertNotNull((Object)descType);
            ReadNavigationRuleTestCase.assertEquals((String)"en-GB", (String)descType.getLang());
            descType = FacesConfigModelUtil.findDescriptionType((List)navRule.getDescription(), "Quelle couleur est lui?");
            ReadNavigationRuleTestCase.assertNotNull((Object)descType);
            ReadNavigationRuleTestCase.assertEquals((String)"fr", (String)descType.getLang());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testNonEmptyNavigationCases() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadNavigationRuleTestCase.assertNotNull((Object)edit.getFacesConfig());
            EList navRules = edit.getFacesConfig().getNavigationRule();
            ReadNavigationRuleTestCase.assertTrue((!navRules.isEmpty() ? 1 : 0) != 0);
            NavigationRuleType navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDisplayName((List)navRules, "display name 1");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            ReadNavigationRuleTestCase.assertEquals((int)2, (int)navRule.getNavigationCase().size());
            NavigationCaseType navCase = FacesConfigModelUtil.findNavigationCaseByDisplayName((List)navRule.getNavigationCase(), "what display name");
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase);
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getFromAction());
            ReadNavigationRuleTestCase.assertEquals((String)"#{from-action}", (String)navCase.getFromAction().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getFromOutcome());
            ReadNavigationRuleTestCase.assertEquals((String)"drilldown", (String)navCase.getFromOutcome().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getToViewId());
            ReadNavigationRuleTestCase.assertEquals((String)"/edit.jsp", (String)navCase.getToViewId().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getRedirect());
            navCase = FacesConfigModelUtil.findNavigationCaseByDisplayName((List)navRule.getNavigationCase(), "second navigation case");
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase);
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getFromAction());
            ReadNavigationRuleTestCase.assertEquals((String)"#{action2}", (String)navCase.getFromAction().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getFromOutcome());
            ReadNavigationRuleTestCase.assertEquals((String)"outcome2", (String)navCase.getFromOutcome().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getToViewId());
            ReadNavigationRuleTestCase.assertEquals((String)"/edit2.jsp", (String)navCase.getToViewId().getTextContent());
            ReadNavigationRuleTestCase.assertNull((Object)navCase.getRedirect());
            navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDisplayName((List)navRules, "English Display Name");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            navCase = FacesConfigModelUtil.findNavigationCaseByDisplayName((List)navRule.getNavigationCase(), "second navigation rule navcase");
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase);
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getFromAction());
            ReadNavigationRuleTestCase.assertEquals((String)"#{action3}", (String)navCase.getFromAction().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getFromOutcome());
            ReadNavigationRuleTestCase.assertEquals((String)"outcome3", (String)navCase.getFromOutcome().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)navCase.getToViewId());
            ReadNavigationRuleTestCase.assertEquals((String)"/edit3.jsp", (String)navCase.getToViewId().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testNonEmptyIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadNavigationRuleTestCase.assertNotNull((Object)edit.getFacesConfig());
            EList navRules = edit.getFacesConfig().getNavigationRule();
            ReadNavigationRuleTestCase.assertTrue((!navRules.isEmpty() ? 1 : 0) != 0);
            NavigationRuleType navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDisplayName((List)navRules, "display name 1");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            EList icons = navRule.getIcon();
            ReadNavigationRuleTestCase.assertEquals((int)1, (int)icons.size());
            IconType iconType = (IconType)icons.get(0);
            ReadNavigationRuleTestCase.assertNotNull((Object)iconType.getSmallIcon());
            ReadNavigationRuleTestCase.assertEquals((String)"myicon", (String)iconType.getSmallIcon().getTextContent());
            ReadNavigationRuleTestCase.assertNull((Object)iconType.getLargeIcon());
            navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDisplayName((List)navRules, "English Display Name");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            icons = navRule.getIcon();
            ReadNavigationRuleTestCase.assertEquals((int)2, (int)icons.size());
            IconType icon = FacesConfigModelUtil.findIconTypeByLang((List)icons, null);
            ReadNavigationRuleTestCase.assertNotNull((Object)icon);
            ReadNavigationRuleTestCase.assertNotNull((Object)icon.getSmallIcon());
            ReadNavigationRuleTestCase.assertEquals((String)"small-icon", (String)icon.getSmallIcon().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)icon.getLargeIcon());
            ReadNavigationRuleTestCase.assertEquals((String)"large-icon", (String)icon.getLargeIcon().getTextContent());
            icon = FacesConfigModelUtil.findIconTypeByLang((List)icons, "en");
            ReadNavigationRuleTestCase.assertNotNull((Object)icon);
            ReadNavigationRuleTestCase.assertNotNull((Object)icon.getSmallIcon());
            ReadNavigationRuleTestCase.assertEquals((String)"en_small-icon", (String)icon.getSmallIcon().getTextContent());
            ReadNavigationRuleTestCase.assertNotNull((Object)icon.getLargeIcon());
            ReadNavigationRuleTestCase.assertEquals((String)"en_large-icon", (String)icon.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testFromViewIdType() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadNavigationRuleTestCase.assertNotNull((Object)edit.getFacesConfig());
            EList navRules = edit.getFacesConfig().getNavigationRule();
            ReadNavigationRuleTestCase.assertTrue((!navRules.isEmpty() ? 1 : 0) != 0);
            NavigationRuleType navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDisplayName((List)navRules, "display name 1");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            ReadNavigationRuleTestCase.assertEquals((String)"/Page1.jsp", (String)navRule.getFromViewId().getTextContent());
            navRule = FacesConfigModelUtil.findNavigationHandlerRuleByDisplayName((List)navRules, "English Display Name");
            ReadNavigationRuleTestCase.assertNotNull((Object)navRule);
            ReadNavigationRuleTestCase.assertEquals((String)"/Page1.jsp", (String)navRule.getFromViewId().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

